/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DTree;
import water.Iced;

public class TreeStats
extends Iced {
    public int _min_depth = 0;
    public int _max_depth = 0;
    public float _mean_depth;
    public int _min_leaves = 0;
    public int _max_leaves = 0;
    public float _mean_leaves;
    public long _byte_size;
    public int _num_trees = 0;
    long _sum_depth = 0L;
    long _sum_leaves = 0L;

    public boolean isValid() {
        return this._min_depth <= this._max_depth;
    }

    public void updateBy(DTree tree) {
        if (tree == null) {
            return;
        }
        if (this._min_depth == 0 || this._min_depth > tree._depth) {
            this._min_depth = tree._depth;
        }
        if (this._max_depth == 0 || this._max_depth < tree._depth) {
            this._max_depth = tree._depth;
        }
        if (this._min_leaves == 0 || this._min_leaves > tree._leaves) {
            this._min_leaves = tree._leaves;
        }
        if (this._max_leaves == 0 || this._max_leaves < tree._leaves) {
            this._max_leaves = tree._leaves;
        }
        this._sum_depth += (long)tree._depth;
        this._sum_leaves += (long)tree._leaves;
        ++this._num_trees;
        this.updateMeans();
    }

    public void setNumTrees(int i) {
        this._num_trees = i;
    }

    public String toString() {
        return "TreeStats{_min_depth=" + this._min_depth + ", _max_depth=" + this._max_depth + ", _mean_depth=" + this._mean_depth + '}';
    }

    private void updateMeans() {
        this._mean_depth = (float)this._sum_depth / (float)this._num_trees;
        this._mean_leaves = (float)this._sum_leaves / (float)this._num_trees;
    }

    public void mergeWith(TreeStats otherTreeStats) {
        if (otherTreeStats._min_depth < this._min_depth) {
            this._min_depth = otherTreeStats._min_depth;
        }
        if (otherTreeStats._max_depth > this._max_depth) {
            this._max_depth = otherTreeStats._max_depth;
        }
        if (otherTreeStats._min_leaves < this._min_leaves) {
            this._min_leaves = otherTreeStats._min_leaves;
        }
        if (otherTreeStats._max_leaves > this._max_leaves) {
            this._max_leaves = otherTreeStats._max_leaves;
        }
        this._byte_size += otherTreeStats._byte_size;
        this._num_trees += otherTreeStats._num_trees;
        this._sum_depth += otherTreeStats._sum_depth;
        this._sum_leaves += otherTreeStats._sum_leaves;
        this.updateMeans();
    }
}

