/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt;

import hex.tree.dt.AbstractFeatureLimits;
import java.util.Arrays;
import java.util.stream.IntStream;

public class CategoricalFeatureLimits
extends AbstractFeatureLimits {
    public boolean[] _mask;

    public CategoricalFeatureLimits(boolean[] mask) {
        this._mask = Arrays.copyOf(mask, mask.length);
    }

    public CategoricalFeatureLimits(double[] doubleMask) {
        this._mask = new boolean[doubleMask.length];
        for (int i = 0; i < doubleMask.length; ++i) {
            if (doubleMask[i] != 1.0) continue;
            this._mask[i] = true;
        }
    }

    public CategoricalFeatureLimits(int cardinality) {
        this._mask = new boolean[cardinality];
        Arrays.fill(this._mask, true);
    }

    public void setNewMask(boolean[] mask) {
        this._mask = Arrays.copyOf(mask, mask.length);
    }

    public void setNewMaskExcluded(boolean[] maskToExclude) {
        this._mask = Arrays.copyOf(this._mask, this._mask.length);
        assert (this._mask.length == maskToExclude.length);
        for (int i = 0; i < maskToExclude.length; ++i) {
            if (!maskToExclude[i]) continue;
            this._mask[i] = false;
        }
    }

    @Override
    public CategoricalFeatureLimits clone() {
        return new CategoricalFeatureLimits(Arrays.copyOf(this._mask, this._mask.length));
    }

    @Override
    public double[] toDoubles() {
        return IntStream.range(0, this._mask.length).mapToDouble(idx -> this._mask[idx] ? 1.0 : 0.0).toArray();
    }

    @Override
    public boolean equals(AbstractFeatureLimits other) {
        return Arrays.equals(this._mask, ((CategoricalFeatureLimits)other)._mask);
    }
}

