/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt;

import hex.tree.dt.AbstractCompressedNode;
import hex.tree.dt.AbstractSplittingRule;
import hex.tree.dt.CompressedLeaf;
import hex.tree.dt.CompressedNode;
import hex.tree.dt.DTPrediction;
import java.util.Arrays;
import java.util.stream.Collectors;
import water.Key;
import water.Keyed;

public class CompressedDT
extends Keyed<CompressedDT> {
    private final AbstractCompressedNode[] _nodes;
    private final String[] _listOfRules;

    public CompressedDT(AbstractCompressedNode[] nodes, int leavesCount) {
        this._key = Key.make((String)("CompressedDT" + Key.rand()));
        this._nodes = nodes;
        this._listOfRules = new String[leavesCount];
        this.extractRulesStartingWithNode(0, "", 0);
    }

    public DTPrediction predictRowStartingFromNode(double[] rowValues, int actualNodeIndex, String ruleExplanation) {
        AbstractSplittingRule splittingRule;
        boolean isALeaf = this._nodes[actualNodeIndex] instanceof CompressedLeaf;
        if (isALeaf) {
            double decisionValue = ((CompressedLeaf)this._nodes[actualNodeIndex]).getDecisionValue();
            double probability = ((CompressedLeaf)this._nodes[actualNodeIndex]).getProbabilities();
            return new DTPrediction((int)decisionValue, probability, ruleExplanation + " -> (" + decisionValue + ", probabilities: " + probability + ", " + (1.0 - probability) + ")");
        }
        if (!ruleExplanation.isEmpty()) {
            ruleExplanation = ruleExplanation + " and ";
        }
        if ((splittingRule = ((CompressedNode)this._nodes[actualNodeIndex]).getSplittingRule()).routeSample(rowValues)) {
            return this.predictRowStartingFromNode(rowValues, 2 * actualNodeIndex + 1, ruleExplanation + splittingRule.toString());
        }
        return this.predictRowStartingFromNode(rowValues, 2 * actualNodeIndex + 2, ruleExplanation + "not " + splittingRule.toString());
    }

    public String toString() {
        return Arrays.stream(this._nodes).map(AbstractCompressedNode::toString).collect(Collectors.joining(";"));
    }

    public int extractRulesStartingWithNode(int nodeIndex, String actualRule, int nextFreeSpot) {
        if (this._nodes[nodeIndex] instanceof CompressedLeaf) {
            this._listOfRules[nextFreeSpot] = actualRule + " -> (" + ((CompressedLeaf)this._nodes[nodeIndex]).getDecisionValue() + ", " + ((CompressedLeaf)this._nodes[nodeIndex]).getProbabilities() + ")";
            return ++nextFreeSpot;
        }
        actualRule = actualRule.isEmpty() ? actualRule : actualRule + " and ";
        nextFreeSpot = this.extractRulesStartingWithNode(2 * nodeIndex + 1, actualRule + ((CompressedNode)this._nodes[nodeIndex]).getSplittingRule().toString(), nextFreeSpot);
        nextFreeSpot = this.extractRulesStartingWithNode(2 * nodeIndex + 2, actualRule + " not (" + ((CompressedNode)this._nodes[nodeIndex]).getSplittingRule().toString() + ")", nextFreeSpot);
        return nextFreeSpot;
    }

    public String[] getListOfRules() {
        return this._listOfRules;
    }

    public AbstractCompressedNode[] getNodes() {
        return this._nodes;
    }
}

