/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt;

import hex.tree.dt.AbstractFeatureLimits;
import hex.tree.dt.CategoricalFeatureLimits;
import hex.tree.dt.NumericFeatureLimits;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DataFeaturesLimits {
    private final List<AbstractFeatureLimits> _featuresLimits;

    public DataFeaturesLimits(List<AbstractFeatureLimits> featureLimits) {
        this._featuresLimits = featureLimits;
    }

    public DataFeaturesLimits(double[][] featureLimits) {
        this._featuresLimits = Arrays.stream(featureLimits).map(dd -> dd[0] == -1.0 ? new NumericFeatureLimits(dd[1], dd[2]) : new CategoricalFeatureLimits((double[])dd)).collect(Collectors.toList());
    }

    public DataFeaturesLimits clone() {
        return new DataFeaturesLimits(this._featuresLimits.stream().map(AbstractFeatureLimits::clone).collect(Collectors.toList()));
    }

    public DataFeaturesLimits updateMin(int selectedFeature, double newMin) {
        DataFeaturesLimits clone = new DataFeaturesLimits(this._featuresLimits.stream().map(AbstractFeatureLimits::clone).collect(Collectors.toList()));
        ((NumericFeatureLimits)clone._featuresLimits.get(selectedFeature)).setNewMin(newMin);
        return clone;
    }

    public DataFeaturesLimits updateMax(int selectedFeature, double newMax) {
        DataFeaturesLimits clone = new DataFeaturesLimits(this._featuresLimits.stream().map(AbstractFeatureLimits::clone).collect(Collectors.toList()));
        ((NumericFeatureLimits)clone._featuresLimits.get(selectedFeature)).setNewMax(newMax);
        return clone;
    }

    public DataFeaturesLimits updateMask(int selectedFeature, boolean[] newMask) {
        DataFeaturesLimits clone = new DataFeaturesLimits(this._featuresLimits.stream().map(AbstractFeatureLimits::clone).collect(Collectors.toList()));
        ((CategoricalFeatureLimits)clone._featuresLimits.get(selectedFeature)).setNewMask(newMask);
        return clone;
    }

    public DataFeaturesLimits updateMaskExcluded(int selectedFeature, boolean[] maskToExclude) {
        DataFeaturesLimits clone = new DataFeaturesLimits(this._featuresLimits.stream().map(AbstractFeatureLimits::clone).collect(Collectors.toList()));
        ((CategoricalFeatureLimits)clone._featuresLimits.get(selectedFeature)).setNewMaskExcluded(maskToExclude);
        return clone;
    }

    public AbstractFeatureLimits getFeatureLimits(int featureIndex) {
        return this._featuresLimits.get(featureIndex);
    }

    public double[][] toDoubles() {
        return (double[][])this._featuresLimits.stream().map(AbstractFeatureLimits::toDoubles).toArray(x$0 -> new double[x$0][]);
    }

    public int featuresCount() {
        return this._featuresLimits.size();
    }

    public boolean equals(DataFeaturesLimits other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.featuresCount() != this.featuresCount()) {
            return false;
        }
        for (int i = 0; i < this._featuresLimits.size(); ++i) {
            if (this._featuresLimits.get(i).equals(other._featuresLimits.get(i))) continue;
            return false;
        }
        return true;
    }
}

