/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt.mrtasks;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class FeaturesLimitsMRTask
extends MRTask<FeaturesLimitsMRTask> {
    double[][] _featuresLimits;
    public double[][] _realFeatureLimits;

    public FeaturesLimitsMRTask(double[][] featuresLimits) {
        this._featuresLimits = featuresLimits;
        this._realFeatureLimits = null;
    }

    private void tryUpdatingMin(int feature, double candidateValue) {
        if (this._realFeatureLimits[feature][1] > candidateValue) {
            this._realFeatureLimits[feature][1] = candidateValue - 1.0E-6;
        }
    }

    private void tryUpdatingMax(int feature, double candidateValue) {
        if (this._realFeatureLimits[feature][2] < candidateValue) {
            this._realFeatureLimits[feature][2] = candidateValue;
        }
    }

    private void tryAddingCategory(int feature, double category) {
        this._realFeatureLimits[feature][(int)category] = 1.0;
    }

    private void updateCategories(int feature, double[] categoriesMask) {
        for (int i = 0; i < categoriesMask.length; ++i) {
            if (categoriesMask[i] != 1.0) continue;
            this._realFeatureLimits[feature][i] = 1.0;
        }
    }

    public void map(Chunk[] cs, NewChunk[] nc) {
        this._realFeatureLimits = (double[][])Arrays.stream(this._featuresLimits).map(f -> {
            double[] dArray;
            if (f[0] == -1.0) {
                double[] dArray2 = new double[3];
                dArray2[0] = -1.0;
                dArray2[1] = Double.MAX_VALUE;
                dArray = dArray2;
                dArray2[2] = -1.7976931348623157E308;
            } else {
                dArray = new double[((double[])f).length];
            }
            return dArray;
        }).toArray(x$0 -> new double[x$0][]);
        int numCols = cs.length - 1;
        int numRows = cs[0]._len;
        for (int row = 0; row < numRows; ++row) {
            int column;
            boolean conditionsFailed = false;
            for (column = 0; column < cs.length - 1; ++column) {
                if (this.verifyLimits(cs[column].atd(row), column)) continue;
                conditionsFailed = true;
                break;
            }
            if (conditionsFailed) continue;
            for (column = 0; column < numCols; ++column) {
                if (this._featuresLimits[column][0] == -1.0) {
                    this.tryUpdatingMin(column, cs[column].atd(row));
                    this.tryUpdatingMax(column, cs[column].atd(row));
                    continue;
                }
                this.tryAddingCategory(column, cs[column].atd(row));
            }
        }
    }

    private boolean isNumerical(int feature) {
        return this._featuresLimits[feature][0] == -1.0;
    }

    private boolean verifyLimits(double featureValue, int column) {
        if (this.isNumerical(column)) {
            return featureValue > this._featuresLimits[column][1] && featureValue <= this._featuresLimits[column][2];
        }
        return this._featuresLimits[column][(int)featureValue] == 1.0;
    }

    public void reduce(FeaturesLimitsMRTask mrt) {
        for (int column = 0; column < this._featuresLimits.length; ++column) {
            if (this._realFeatureLimits[column][0] == -1.0) {
                this.tryUpdatingMin(column, mrt._realFeatureLimits[column][1]);
                this.tryUpdatingMax(column, mrt._realFeatureLimits[column][2]);
                continue;
            }
            this.updateCategories(column, mrt._realFeatureLimits[column]);
        }
    }
}

