/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended.isolationtree;

import hex.genmodel.algos.isoforextended.ExtendedIsolationForestMojoModel;
import hex.tree.isoforextended.isolationtree.AbstractCompressedNode;
import hex.tree.isoforextended.isolationtree.CompressedLeaf;
import hex.tree.isoforextended.isolationtree.CompressedNode;
import water.AutoBuffer;
import water.Key;
import water.Keyed;
import water.util.ArrayUtils;

public class CompressedIsolationTree
extends Keyed<CompressedIsolationTree> {
    private final AbstractCompressedNode[] _nodes;

    public CompressedIsolationTree(int heightLimit) {
        this._key = Key.make((String)("CompressedIsolationTree" + Key.rand()));
        this._nodes = new AbstractCompressedNode[(int)Math.pow(2.0, heightLimit + 1) - 1];
    }

    public AbstractCompressedNode[] getNodes() {
        return this._nodes;
    }

    private CompressedNode compressedNode(AbstractCompressedNode node) {
        assert (node instanceof CompressedNode) : "AbstractCompressedNode cannot be cast to CompressedNode";
        return (CompressedNode)node;
    }

    private CompressedLeaf compressedLeaf(AbstractCompressedNode node) {
        assert (node instanceof CompressedLeaf) : "AbstractCompressedNode cannot be cast to CompressedLeaf";
        return (CompressedLeaf)node;
    }

    private boolean isLeaf(AbstractCompressedNode node) {
        return node instanceof CompressedLeaf;
    }

    public double computePathLength(double[] row) {
        CompressedNode compressedNode;
        double mul;
        int position = 0;
        AbstractCompressedNode node = this._nodes[0];
        while (!this.isLeaf(node) && (position = (mul = ArrayUtils.subAndMul((double[])row, (double[])(compressedNode = this.compressedNode(node)).getP(), (double[])compressedNode.getN())) <= 0.0 ? ExtendedIsolationForestMojoModel.leftChildIndex((int)position) : ExtendedIsolationForestMojoModel.rightChildIndex((int)position)) < this._nodes.length) {
            node = this._nodes[position];
        }
        return (double)node.getHeight() + ExtendedIsolationForestMojoModel.averagePathLengthOfUnsuccessfulSearch((long)this.compressedLeaf(node).getNumRows());
    }

    public byte[] toBytes() {
        AutoBuffer ab = new AutoBuffer();
        assert (this._nodes[0] != null) : "Tree is empty, there are zero nodes in the tree";
        ab.put4(this.compressedNode(this._nodes[0]).getN().length);
        for (int i = 0; i < this._nodes.length; ++i) {
            if (this._nodes[i] == null) continue;
            ab.put4(i);
            this._nodes[i].toBytes(ab);
        }
        return ab.bufClose();
    }
}

