/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.Model;
import hex.ModelBuilder;
import hex.ensemble.StackedEnsembleModel;
import water.DKV;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.util.Log;

public abstract class Metalearner<B extends ModelBuilder<M, P, ?>, M extends Model<M, P, ?>, P extends Model.Parameters> {
    protected Frame _levelOneTrainingFrame;
    protected Frame _levelOneValidationFrame;
    protected StackedEnsembleModel _model;
    protected StackedEnsembleModel.StackedEnsembleParameters _parms;
    protected Job _job;
    protected Key<Model> _metalearnerKey;
    protected Job _metalearnerJob;
    protected P _metalearner_parameters;
    protected boolean _hasMetalearnerParams;
    protected long _metalearnerSeed;
    protected long _maxRuntimeSecs;

    void init(Frame levelOneTrainingFrame, Frame levelOneValidationFrame, P metalearner_parameters, StackedEnsembleModel model, Job StackedEnsembleJob, Key<Model> metalearnerKey, Job metalearnerJob, StackedEnsembleModel.StackedEnsembleParameters parms, boolean hasMetalearnerParams, long metalearnerSeed, long maxRuntimeSecs) {
        this._levelOneTrainingFrame = levelOneTrainingFrame;
        this._levelOneValidationFrame = levelOneValidationFrame;
        this._metalearner_parameters = metalearner_parameters;
        this._model = model;
        this._job = StackedEnsembleJob;
        this._metalearnerKey = metalearnerKey;
        this._metalearnerJob = metalearnerJob;
        this._parms = parms;
        this._hasMetalearnerParams = hasMetalearnerParams;
        this._metalearnerSeed = metalearnerSeed;
        this._maxRuntimeSecs = maxRuntimeSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compute() {
        try {
            this._model.write_lock(this._job);
            B builder = this.createBuilder();
            if (this._hasMetalearnerParams) {
                ((ModelBuilder)builder)._parms = this._metalearner_parameters;
            }
            this.setCommonParams(((ModelBuilder)builder)._parms);
            this.setCrossValidationParams(((ModelBuilder)builder)._parms);
            this.setCustomParams(((ModelBuilder)builder)._parms);
            this.validateParams(((ModelBuilder)builder)._parms);
            builder.init(false);
            Job j = builder.trainModel();
            while (j.isRunning()) {
                try {
                    this._job.update(j.getWork(), "training metalearner(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")");
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Log.info((Object[])new Object[]{"Finished training metalearner model(" + (Object)((Object)((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_algorithm) + ")."});
            ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner = builder.get();
            this._model._dist = ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._metalearner._dist;
            this._model.doScoreOrCopyMetrics(this._job);
            if (this._parms._keep_levelone_frame) {
                ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output)._levelone_frame_id = this._levelOneTrainingFrame;
            }
        }
        finally {
            this.cleanup();
            this._model.update(this._job);
            this._model.unlock(this._job);
        }
    }

    abstract B createBuilder();

    protected void setCommonParams(P parms) {
        if (((Model.Parameters)parms)._seed == -1L) {
            ((Model.Parameters)parms)._seed = this._metalearnerSeed;
        }
        ((Model.Parameters)parms)._train = this._levelOneTrainingFrame._key;
        ((Model.Parameters)parms)._valid = this._levelOneValidationFrame == null ? null : this._levelOneValidationFrame._key;
        ((Model.Parameters)parms)._response_column = this._model.responseColumn;
        ((Model.Parameters)parms)._max_runtime_secs = this._maxRuntimeSecs;
        ((Model.Parameters)parms)._weights_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._weights_column;
        ((Model.Parameters)parms)._offset_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._offset_column;
        ((Model.Parameters)parms)._main_model_time_budget_factor = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._main_model_time_budget_factor;
        ((Model.Parameters)parms)._custom_metric_func = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._custom_metric_func;
        ((Model.Parameters)parms)._gainslift_bins = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._gainslift_bins;
    }

    protected void setCrossValidationParams(P parms) {
        if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column == null) {
            ((Model.Parameters)parms)._nfolds = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds;
            if (((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_nfolds > 1) {
                ((Model.Parameters)parms)._fold_assignment = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment == null ? Model.Parameters.FoldAssignmentScheme.AUTO : ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_assignment;
            }
        } else {
            ((Model.Parameters)parms)._fold_column = ((StackedEnsembleModel.StackedEnsembleParameters)this._model._parms)._metalearner_fold_column;
        }
    }

    protected void setCustomParams(P parms) {
    }

    protected void validateParams(P parms) {
    }

    protected void cleanup() {
        if (!this._parms._keep_base_model_predictions) {
            this._model.deleteBaseModelPredictions();
        }
        if (!this._parms._keep_levelone_frame) {
            DKV.remove((Key)this._levelOneTrainingFrame._key);
        }
        if (null != this._levelOneValidationFrame) {
            DKV.remove((Key)this._levelOneValidationFrame._key);
        }
    }

    public static enum Algorithm {
        AUTO,
        deeplearning,
        drf,
        gbm,
        glm,
        naivebayes,
        xgboost;

    }
}

