/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.AUC2;
import hex.AUUC;
import hex.CustomMetric;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomialGLMGeneric;
import hex.ModelMetricsBinomialGeneric;
import hex.ModelMetricsBinomialUpliftGeneric;
import hex.ModelMetricsMultinomialGLMGeneric;
import hex.ModelMetricsMultinomialGeneric;
import hex.ModelMetricsOrdinalGLMGeneric;
import hex.ModelMetricsOrdinalGeneric;
import hex.ModelMetricsRegressionCoxPH;
import hex.ModelMetricsRegressionGLMGeneric;
import hex.ModelMetricsRegressionGeneric;
import hex.MultinomialAucType;
import hex.genmodel.attributes.DeepLearningModelAttributes;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.ModelAttributesGLM;
import hex.genmodel.attributes.SharedTreeModelAttributes;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.VariableImportances;
import hex.genmodel.attributes.metrics.MojoModelMetrics;
import hex.genmodel.attributes.metrics.MojoModelMetricsAnomaly;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomialGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomialUplift;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomialGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsOrdinal;
import hex.genmodel.attributes.metrics.MojoModelMetricsOrdinalGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegression;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegressionCoxPH;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegressionGLM;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.tree.isofor.ModelMetricsAnomaly;
import java.lang.reflect.Field;
import java.util.HashMap;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.TwoDimTable;

public class GenericModelOutput
extends Model.Output {
    public final String _original_model_identifier;
    public final String _original_model_full_name;
    public final ModelCategory _modelCategory;
    public final int _nfeatures;
    public final double _defaultThreshold;
    public TwoDimTable _variable_importances;

    public GenericModelOutput(ModelDescriptor modelDescriptor) {
        this._isSupervised = modelDescriptor.isSupervised();
        this._domains = modelDescriptor.scoringDomains();
        this._origDomains = modelDescriptor.getOrigDomains();
        this._hasOffset = modelDescriptor.offsetColumn() != null;
        this._hasWeights = modelDescriptor.weightsColumn() != null;
        this._hasFold = modelDescriptor.foldColumn() != null;
        this._hasTreatment = modelDescriptor.treatmentColumn() != null;
        this._modelClassDist = modelDescriptor.modelClassDist();
        this._priorClassDist = modelDescriptor.priorClassDist();
        this._names = modelDescriptor.columnNames();
        this._origNames = modelDescriptor.getOrigNames();
        this._modelCategory = modelDescriptor.getModelCategory();
        this._nfeatures = modelDescriptor.nfeatures();
        this._defaultThreshold = modelDescriptor.defaultThreshold();
        this._original_model_identifier = modelDescriptor.algoName();
        this._original_model_full_name = modelDescriptor.algoFullName();
    }

    public GenericModelOutput(ModelDescriptor modelDescriptor, ModelAttributes modelAttributes, Table[] reproducibilityInformation) {
        this(modelDescriptor);
        if (modelAttributes != null) {
            this._model_summary = GenericModelOutput.convertTable(modelAttributes.getModelSummary());
            this._cross_validation_metrics_summary = GenericModelOutput.convertTable(modelAttributes.getCrossValidationMetricsSummary());
            this._variable_importances = modelAttributes instanceof SharedTreeModelAttributes ? GenericModelOutput.convertVariableImportances(((SharedTreeModelAttributes)modelAttributes).getVariableImportances()) : (modelAttributes instanceof DeepLearningModelAttributes ? GenericModelOutput.convertVariableImportances(((DeepLearningModelAttributes)modelAttributes).getVariableImportances()) : (modelAttributes instanceof ModelAttributesGLM ? GenericModelOutput.convertVariableImportances(((ModelAttributesGLM)modelAttributes).getVariableImportances()) : null));
            this.convertMetrics(modelAttributes, modelDescriptor);
            this._scoring_history = GenericModelOutput.convertTable(modelAttributes.getScoringHistory());
        }
        if (reproducibilityInformation != null) {
            this._reproducibility_information_table = GenericModelOutput.convertTables(reproducibilityInformation);
        }
    }

    private void convertMetrics(ModelAttributes modelAttributes, ModelDescriptor modelDescriptor) {
        if (modelAttributes.getTrainingMetrics() != null) {
            this._training_metrics = this.convertModelMetrics(modelAttributes.getTrainingMetrics(), modelDescriptor, modelAttributes);
        }
        if (modelAttributes.getValidationMetrics() != null) {
            this._validation_metrics = (ModelMetrics)GenericModelOutput.convertObjects(modelAttributes.getValidationMetrics(), this.convertModelMetrics(modelAttributes.getValidationMetrics(), modelDescriptor, modelAttributes));
        }
        if (modelAttributes.getCrossValidationMetrics() != null) {
            this._cross_validation_metrics = (ModelMetrics)GenericModelOutput.convertObjects(modelAttributes.getCrossValidationMetrics(), this.convertModelMetrics(modelAttributes.getCrossValidationMetrics(), modelDescriptor, modelAttributes));
        }
    }

    private ModelMetrics convertModelMetrics(MojoModelMetrics mojoMetrics, ModelDescriptor modelDescriptor, ModelAttributes modelAttributes) {
        ModelCategory modelCategory = modelDescriptor.getModelCategory();
        switch (modelCategory) {
            case Binomial: {
                assert (mojoMetrics instanceof MojoModelMetricsBinomial);
                MojoModelMetricsBinomial binomial = (MojoModelMetricsBinomial)mojoMetrics;
                AUC2 auc = AUC2.emptyAUC();
                auc._auc = binomial._auc;
                auc._pr_auc = binomial._pr_auc;
                auc._gini = binomial._gini;
                if (mojoMetrics instanceof MojoModelMetricsBinomialGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsBinomialGLM glmBinomial = (MojoModelMetricsBinomialGLM)binomial;
                    return new ModelMetricsBinomialGLMGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], glmBinomial._sigma, auc, binomial._logloss, GenericModelOutput.convertTable(binomial._gains_lift_table), GenericModelOutput.customMetric(mojoMetrics), binomial._mean_per_class_error, GenericModelOutput.convertTable(binomial._thresholds_and_metric_scores), GenericModelOutput.convertTable(binomial._max_criteria_and_metric_scores), GenericModelOutput.convertTable(binomial._confusion_matrix), glmBinomial._nullDegreesOfFreedom, glmBinomial._residualDegreesOfFreedom, glmBinomial._resDev, glmBinomial._nullDev, glmBinomial._AIC, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table), glmBinomial._r2, glmBinomial._description, glmBinomial._loglikelihood);
                }
                return new ModelMetricsBinomialGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], binomial._sigma, auc, binomial._logloss, GenericModelOutput.convertTable(binomial._gains_lift_table), GenericModelOutput.customMetric(mojoMetrics), binomial._mean_per_class_error, GenericModelOutput.convertTable(binomial._thresholds_and_metric_scores), GenericModelOutput.convertTable(binomial._max_criteria_and_metric_scores), GenericModelOutput.convertTable(binomial._confusion_matrix), binomial._r2, binomial._description);
            }
            case Multinomial: {
                assert (mojoMetrics instanceof MojoModelMetricsMultinomial);
                if (mojoMetrics instanceof MojoModelMetricsMultinomialGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    modelAttributesGLM.getModelParameters();
                    MojoModelMetricsMultinomialGLM glmMultinomial = (MojoModelMetricsMultinomialGLM)mojoMetrics;
                    return new ModelMetricsMultinomialGLMGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], glmMultinomial._sigma, GenericModelOutput.convertTable(glmMultinomial._confusion_matrix), GenericModelOutput.convertTable(glmMultinomial._hit_ratios), glmMultinomial._logloss, GenericModelOutput.customMetric(mojoMetrics), glmMultinomial._mean_per_class_error, glmMultinomial._nullDegreesOfFreedom, glmMultinomial._residualDegreesOfFreedom, glmMultinomial._resDev, glmMultinomial._nullDev, glmMultinomial._AIC, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table), glmMultinomial._r2, GenericModelOutput.convertTable(glmMultinomial._multinomial_auc), GenericModelOutput.convertTable(glmMultinomial._multinomial_aucpr), MultinomialAucType.valueOf((String)((String)modelAttributes.getParameterValueByName("auc_type"))), glmMultinomial._description, glmMultinomial._loglikelihood);
                }
                MojoModelMetricsMultinomial multinomial = (MojoModelMetricsMultinomial)mojoMetrics;
                return new ModelMetricsMultinomialGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], multinomial._sigma, GenericModelOutput.convertTable(multinomial._confusion_matrix), GenericModelOutput.convertTable(multinomial._hit_ratios), multinomial._logloss, GenericModelOutput.customMetric(mojoMetrics), multinomial._mean_per_class_error, multinomial._r2, GenericModelOutput.convertTable(multinomial._multinomial_auc), GenericModelOutput.convertTable(multinomial._multinomial_aucpr), MultinomialAucType.valueOf((String)((String)modelAttributes.getParameterValueByName("auc_type"))), multinomial._description);
            }
            case Regression: {
                assert (mojoMetrics instanceof MojoModelMetricsRegression);
                if (mojoMetrics instanceof MojoModelMetricsRegressionGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsRegressionGLM regressionGLM = (MojoModelMetricsRegressionGLM)mojoMetrics;
                    return new ModelMetricsRegressionGLMGeneric(null, null, regressionGLM._nobs, regressionGLM._MSE, regressionGLM._sigma, regressionGLM._mae, regressionGLM._root_mean_squared_log_error, regressionGLM._mean_residual_deviance, GenericModelOutput.customMetric((MojoModelMetrics)regressionGLM), regressionGLM._r2, regressionGLM._nullDegreesOfFreedom, regressionGLM._residualDegreesOfFreedom, regressionGLM._resDev, regressionGLM._nullDev, regressionGLM._AIC, regressionGLM._loglikelihood, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table));
                }
                MojoModelMetricsRegression metricsRegression = (MojoModelMetricsRegression)mojoMetrics;
                return new ModelMetricsRegressionGeneric(null, null, metricsRegression._nobs, metricsRegression._MSE, metricsRegression._sigma, metricsRegression._mae, metricsRegression._root_mean_squared_log_error, metricsRegression._mean_residual_deviance, GenericModelOutput.customMetric(mojoMetrics), mojoMetrics._description);
            }
            case AnomalyDetection: {
                assert (mojoMetrics instanceof MojoModelMetricsAnomaly);
                MojoModelMetricsAnomaly metricsAnomaly = (MojoModelMetricsAnomaly)mojoMetrics;
                return new ModelMetricsAnomaly(null, null, GenericModelOutput.customMetric(mojoMetrics), mojoMetrics._nobs, metricsAnomaly._mean_score * (double)metricsAnomaly._nobs, metricsAnomaly._mean_normalized_score * (double)metricsAnomaly._nobs, metricsAnomaly._description);
            }
            case Ordinal: {
                assert (mojoMetrics instanceof MojoModelMetricsOrdinal);
                if (mojoMetrics instanceof MojoModelMetricsOrdinalGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsOrdinalGLM ordinalMetrics = (MojoModelMetricsOrdinalGLM)mojoMetrics;
                    return new ModelMetricsOrdinalGLMGeneric(null, null, ordinalMetrics._nobs, ordinalMetrics._MSE, ordinalMetrics._domain, ordinalMetrics._sigma, GenericModelOutput.convertTable(ordinalMetrics._cm), ordinalMetrics._hit_ratios, ordinalMetrics._logloss, GenericModelOutput.customMetric((MojoModelMetrics)ordinalMetrics), ordinalMetrics._r2, ordinalMetrics._nullDegreesOfFreedom, ordinalMetrics._residualDegreesOfFreedom, ordinalMetrics._resDev, ordinalMetrics._nullDev, ordinalMetrics._AIC, ordinalMetrics._loglikelihood, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table), GenericModelOutput.convertTable(ordinalMetrics._hit_ratio_table), ordinalMetrics._mean_per_class_error, ordinalMetrics._description);
                }
                MojoModelMetricsOrdinal ordinalMetrics = (MojoModelMetricsOrdinal)mojoMetrics;
                return new ModelMetricsOrdinalGeneric(null, null, ordinalMetrics._nobs, ordinalMetrics._MSE, ordinalMetrics._domain, ordinalMetrics._sigma, GenericModelOutput.convertTable(ordinalMetrics._cm), ordinalMetrics._hit_ratios, ordinalMetrics._logloss, GenericModelOutput.customMetric((MojoModelMetrics)ordinalMetrics), GenericModelOutput.convertTable(ordinalMetrics._hit_ratio_table), ordinalMetrics._mean_per_class_error, ordinalMetrics._description);
            }
            case CoxPH: {
                assert (mojoMetrics instanceof MojoModelMetricsRegressionCoxPH);
                MojoModelMetricsRegressionCoxPH metricsCoxPH = (MojoModelMetricsRegressionCoxPH)mojoMetrics;
                return new ModelMetricsRegressionCoxPH(null, null, metricsCoxPH._nobs, metricsCoxPH._MSE, metricsCoxPH._sigma, metricsCoxPH._mae, metricsCoxPH._root_mean_squared_log_error, metricsCoxPH._mean_residual_deviance, GenericModelOutput.customMetric(mojoMetrics), metricsCoxPH._concordance, metricsCoxPH._concordant, metricsCoxPH._discordant, metricsCoxPH._tied_y);
            }
            case BinomialUplift: {
                assert (mojoMetrics instanceof MojoModelMetricsBinomialUplift);
                MojoModelMetricsBinomialUplift metricsUplift = (MojoModelMetricsBinomialUplift)mojoMetrics;
                AUUC.AUUCType auucType = AUUC.AUUCType.valueOf((String)((String)modelAttributes.getParameterValueByName("auuc_type")));
                AUUC auuc = GenericModelOutput.createAUUC(auucType, metricsUplift._thresholds_and_metric_scores, metricsUplift._auuc_table, metricsUplift._aecu_table);
                return new ModelMetricsBinomialUpliftGeneric(null, null, metricsUplift._nobs, this._domains[this._domains.length - 1], metricsUplift._ate, metricsUplift._att, metricsUplift._atc, metricsUplift._sigma, auuc, GenericModelOutput.customMetric((MojoModelMetrics)metricsUplift), GenericModelOutput.convertTable(metricsUplift._thresholds_and_metric_scores), GenericModelOutput.convertTable(metricsUplift._auuc_table), GenericModelOutput.convertTable(metricsUplift._aecu_table), metricsUplift._description);
            }
        }
        return new ModelMetrics(null, null, mojoMetrics._nobs, mojoMetrics._MSE, mojoMetrics._description, GenericModelOutput.customMetric(mojoMetrics));
    }

    private static CustomMetric customMetric(MojoModelMetrics mojoModelMetrics) {
        if (mojoModelMetrics._custom_metric_name == null) {
            return null;
        }
        return new CustomMetric(mojoModelMetrics._custom_metric_name, mojoModelMetrics._custom_metric_value);
    }

    public double defaultThreshold() {
        return this._defaultThreshold;
    }

    public ModelCategory getModelCategory() {
        return this._modelCategory;
    }

    public int nfeatures() {
        return this._nfeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object convertObjects(Object source, Object target) {
        Class<?> targetClass = target.getClass();
        Field[] targetDeclaredFields = targetClass.getFields();
        Class<?> sourceClass = source.getClass();
        Field[] sourceDeclaredFields = sourceClass.getFields();
        HashMap<String, Field> sourceFieldMap = new HashMap<String, Field>(sourceDeclaredFields.length);
        for (Field sourceField : sourceDeclaredFields) {
            sourceFieldMap.put(sourceField.getName(), sourceField);
        }
        for (int i = 0; i < targetDeclaredFields.length; ++i) {
            Field sourceField;
            Field targetField = targetDeclaredFields[i];
            String targetFieldName = targetField.getName();
            sourceField = (Field)sourceFieldMap.get(targetFieldName);
            if (sourceField == null) {
                Log.debug((Object[])new Object[]{String.format("Field '%s' not found in the source object. Ignoring.", targetFieldName)});
                continue;
            }
            boolean targetAccessible = targetField.isAccessible();
            boolean sourceAccessible = sourceField.isAccessible();
            try {
                targetField.setAccessible(true);
                sourceField.setAccessible(true);
                if (!targetField.getType().isAssignableFrom(sourceField.getType())) continue;
                targetField.set(target, sourceField.get(source));
                continue;
            }
            catch (IllegalAccessException e) {
                Log.err((Object[])new Object[]{e});
                continue;
            }
            finally {
                targetField.setAccessible(targetAccessible);
                sourceField.setAccessible(sourceAccessible);
            }
        }
        return target;
    }

    private static TwoDimTable convertVariableImportances(VariableImportances variableImportances) {
        if (variableImportances == null) {
            return null;
        }
        TwoDimTable varImps = ModelMetrics.calcVarImp((double[])variableImportances._importances, (String[])variableImportances._variables);
        return varImps;
    }

    private static TwoDimTable[] convertTables(Table[] inputTables) {
        if (inputTables == null) {
            return null;
        }
        TwoDimTable[] tables = new TwoDimTable[inputTables.length];
        for (int i = 0; i < inputTables.length; ++i) {
            tables[i] = GenericModelOutput.convertTable(inputTables[i]);
        }
        return tables;
    }

    private static TwoDimTable convertTable(Table convertedTable) {
        if (convertedTable == null) {
            return null;
        }
        TwoDimTable table = new TwoDimTable(convertedTable.getTableHeader(), convertedTable.getTableDescription(), convertedTable.getRowHeaders(), convertedTable.getColHeaders(), convertedTable.getColTypesString(), convertedTable.getColumnFormats(), convertedTable.getColHeaderForRowHeaders());
        for (int i = 0; i < convertedTable.columns(); ++i) {
            for (int j = 0; j < convertedTable.rows(); ++j) {
                table.set(j, i, convertedTable.getCell(i, j));
            }
        }
        return table;
    }

    private static AUUC createAUUC(AUUC.AUUCType auucType, Table thresholds_and_metric_scores, Table auuc_table, Table aecu_table) {
        int i;
        int nbins = thresholds_and_metric_scores.rows();
        double[] ths = new double[nbins];
        long[] freq = new long[nbins];
        AUUC.AUUCType[] auucTypes = AUUC.AUUCType.values();
        double[][] uplift = new double[auucTypes.length][nbins];
        double[][] upliftNorm = new double[auucTypes.length][nbins];
        double[][] upliftRand = new double[auucTypes.length][nbins];
        double[] auuc = new double[auucTypes.length];
        double[] auucNorm = new double[auucTypes.length];
        double[] auucRand = new double[auucTypes.length];
        double[] aecu = new double[auucTypes.length];
        Object[] thrHeader = thresholds_and_metric_scores.getColHeaders();
        int thrIndex = ArrayUtils.find((Object[])thrHeader, (Object)"thresholds");
        int freqIndex = ArrayUtils.find((Object[])thrHeader, (Object)"n");
        int[] upliftIndices = new int[auucTypes.length];
        int[] upliftNormIndices = new int[auucTypes.length];
        int[] upliftRandIndices = new int[auucTypes.length];
        for (i = 1; i < auucTypes.length; ++i) {
            String auucTypeName = auucTypes[i].name();
            upliftIndices[i] = ArrayUtils.find((Object[])thrHeader, (Object)auucTypeName);
            upliftNormIndices[i] = ArrayUtils.find((Object[])thrHeader, (Object)(auucTypeName + "_normalized"));
            upliftRandIndices[i] = ArrayUtils.find((Object[])thrHeader, (Object)(auucTypeName + "_random"));
            if (!auucTypeName.equals(AUUC.AUUCType.nameAuto())) continue;
            upliftIndices[0] = upliftIndices[i];
            upliftNormIndices[0] = upliftNormIndices[i];
            upliftRandIndices[0] = upliftRandIndices[i];
        }
        for (i = 0; i < thresholds_and_metric_scores.rows(); ++i) {
            ths[i] = (Double)thresholds_and_metric_scores.getCell(thrIndex, i);
            freq[i] = (Long)thresholds_and_metric_scores.getCell(freqIndex, i);
            for (int j = 0; j < auucTypes.length; ++j) {
                uplift[j][i] = (Double)thresholds_and_metric_scores.getCell(upliftIndices[j], i);
                upliftNorm[j][i] = (Double)thresholds_and_metric_scores.getCell(upliftNormIndices[j], i);
                upliftRand[j][i] = (Double)thresholds_and_metric_scores.getCell(upliftRandIndices[j], i);
            }
        }
        Object[] auucHeader = auuc_table.getColHeaders();
        Object[] aecuHeader = aecu_table.getColHeaders();
        for (int i2 = 1; i2 < auucTypes.length; ++i2) {
            AUUC.AUUCType type = auucTypes[i2];
            String auucTypeName = type.name();
            int colIndex = ArrayUtils.find((Object[])auucHeader, (Object)auucTypeName);
            auuc[i2] = (Double)auuc_table.getCell(colIndex, 0);
            auucNorm[i2] = (Double)auuc_table.getCell(colIndex, 1);
            auucRand[i2] = (Double)auuc_table.getCell(colIndex, 2);
            colIndex = ArrayUtils.find((Object[])aecuHeader, (Object)auucTypeName);
            aecu[i2] = (Double)aecu_table.getCell(colIndex, 0);
            if (!auucTypeName.equals(AUUC.AUUCType.nameAuto())) continue;
            auuc[0] = auuc[i2];
            auucNorm[0] = auucNorm[i2];
            auucRand[0] = auucRand[i2];
            aecu[0] = aecu[i2];
        }
        return new AUUC(ths, freq, auuc, auucNorm, auucRand, aecu, auucType, uplift, upliftNorm, upliftRand);
    }

    public boolean hasTreatment() {
        return super.hasTreatment();
    }
}

