/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModel;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelParametersSchemaV3;

public class DeepLearningV3
extends ModelBuilderSchema<DeepLearning, DeepLearningV3, DeepLearningParametersV3> {

    public static final class DeepLearningParametersV3
    extends ModelParametersSchemaV3<DeepLearningModel.DeepLearningParameters, DeepLearningParametersV3> {
        public static String[] fields = new String[]{"model_id", "training_frame", "validation_frame", "nfolds", "keep_cross_validation_models", "keep_cross_validation_predictions", "keep_cross_validation_fold_assignment", "fold_assignment", "fold_column", "response_column", "ignored_columns", "ignore_const_cols", "score_each_iteration", "weights_column", "offset_column", "balance_classes", "class_sampling_factors", "max_after_balance_size", "max_confusion_matrix_size", "checkpoint", "pretrained_autoencoder", "overwrite_with_best_model", "use_all_factor_levels", "standardize", "activation", "hidden", "epochs", "train_samples_per_iteration", "target_ratio_comm_to_comp", "seed", "adaptive_rate", "rho", "epsilon", "rate", "rate_annealing", "rate_decay", "momentum_start", "momentum_ramp", "momentum_stable", "nesterov_accelerated_gradient", "input_dropout_ratio", "hidden_dropout_ratios", "l1", "l2", "max_w2", "initial_weight_distribution", "initial_weight_scale", "initial_weights", "initial_biases", "loss", "distribution", "quantile_alpha", "tweedie_power", "huber_alpha", "score_interval", "score_training_samples", "score_validation_samples", "score_duty_cycle", "classification_stop", "regression_stop", "stopping_rounds", "stopping_metric", "stopping_tolerance", "max_runtime_secs", "score_validation_sampling", "diagnostics", "fast_mode", "force_load_balance", "variable_importances", "replicate_training_data", "single_node_mode", "shuffle_training_data", "missing_values_handling", "quiet_mode", "autoencoder", "sparse", "col_major", "average_activation", "sparsity_beta", "max_categorical_features", "reproducible", "export_weights_and_biases", "mini_batch_size", "categorical_encoding", "elastic_averaging", "elastic_averaging_moving_rate", "elastic_averaging_regularization", "export_checkpoints_dir", "auc_type", "custom_metric_func", "gainslift_bins"};
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Balance training data class counts via over/under-sampling (for imbalanced data).")
        public boolean balance_classes;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes.")
        public float[] class_sampling_factors;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=false, help="Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes.")
        public float max_after_balance_size;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=false, help="[Deprecated] Maximum size (# classes) for confusion matrices to be printed in the Logs.")
        public int max_confusion_matrix_size;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, values={"Tanh", "TanhWithDropout", "Rectifier", "RectifierWithDropout", "Maxout", "MaxoutWithDropout"}, help="Activation function.")
        public DeepLearningModel.DeepLearningParameters.Activation activation;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, help="Hidden layer sizes (e.g. [100, 100]).")
        public int[] hidden;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, help="How many times the dataset should be iterated (streamed), can be fractional.")
        public double epochs;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all available data (e.g., replicated training data), -2: automatic.")
        public long train_samples_per_iteration;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Target ratio of communication overhead to computation. Only for multi-node operation and train_samples_per_iteration = -2 (auto-tuning).")
        public double target_ratio_comm_to_comp;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded.")
        public long seed;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Adaptive learning rate.")
        public boolean adaptive_rate;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Adaptive learning rate time decay factor (similarity to prior updates).")
        public double rho;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress).")
        public double epsilon;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Learning rate (higher => less stable, lower => slower convergence).")
        public double rate;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Learning rate annealing: rate / (1 + rate_annealing * samples).")
        public double rate_annealing;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Learning rate decay factor between layers (N-th layer: rate * rate_decay ^ (n - 1).")
        public double rate_decay;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Initial momentum at the beginning of training (try 0.5).")
        public double momentum_start;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Number of training samples for which momentum increases.")
        public double momentum_ramp;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Final momentum after the ramp is over (try 0.99).")
        public double momentum_stable;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Use Nesterov accelerated gradient (recommended).")
        public boolean nesterov_accelerated_gradient;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Input layer dropout ratio (can improve generalization, try 0.1 or 0.2).")
        public double input_dropout_ratio;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5.")
        public double[] hidden_dropout_ratios;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="L1 regularization (can add stability and improve generalization, causes many weights to become 0).")
        public double l1;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="L2 regularization (can add stability and improve generalization, causes many weights to be small.")
        public double l2;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Constraint for squared sum of incoming weights per unit (e.g. for Rectifier).")
        public float max_w2;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, values={"UniformAdaptive", "Uniform", "Normal"}, help="Initial weight distribution.")
        public DeepLearningModel.DeepLearningParameters.InitialWeightDistribution initial_weight_distribution;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Uniform: -value...value, Normal: stddev.")
        public double initial_weight_scale;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="A list of H2OFrame ids to initialize the weight matrices of this model with.")
        public KeyV3.FrameKeyV3[] initial_weights;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="A list of H2OFrame ids to initialize the bias vectors of this model with.")
        public KeyV3.FrameKeyV3[] initial_biases;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, required=false, values={"Automatic", "CrossEntropy", "Quadratic", "Huber", "Absolute", "Quantile"}, help="Loss function.")
        public DeepLearningModel.DeepLearningParameters.Loss loss;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Shortest time interval (in seconds) between model scoring.")
        public double score_interval;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of training set samples for scoring (0 for all).")
        public long score_training_samples;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of validation set samples for scoring (0 for all).")
        public long score_validation_samples;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring).")
        public double score_duty_cycle;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Stopping criterion for classification error fraction on training data (-1 to disable).")
        public double classification_stop;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Stopping criterion for regression error (MSE) on training data (-1 to disable).")
        public double regression_stop;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Enable quiet mode for less output to standard output.")
        public boolean quiet_mode;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, values={"Uniform", "Stratified"}, help="Method used to sample validation dataset for scoring.")
        public DeepLearningModel.DeepLearningParameters.ClassSamplingMethod score_validation_sampling;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="If enabled, override the final model with the best model found during training.")
        public boolean overwrite_with_best_model;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, help="Auto-Encoder.")
        public boolean autoencoder;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Use all factor levels of categorical variables. Otherwise, the first factor level is omitted (without loss of accuracy). Useful for variable importances and auto-enabled for autoencoder.")
        public boolean use_all_factor_levels;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="If enabled, automatically standardize the data. If disabled, the user must provide properly scaled input data.")
        public boolean standardize;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Enable diagnostics for hidden layers.")
        public boolean diagnostics;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, help="Compute variable importances for input features (Gedeon method) - can be slow for large networks.")
        public boolean variable_importances;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Enable fast mode (minor approximation in back-propagation).")
        public boolean fast_mode;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Force extra load balancing to increase training speed for small datasets (to keep all cores busy).")
        public boolean force_load_balance;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Replicate the entire training dataset onto every node for faster training on small datasets.")
        public boolean replicate_training_data;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Run on a single node for fine-tuning of model parameters.")
        public boolean single_node_mode;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Enable shuffling of training data (recommended if training data is replicated and train_samples_per_iteration is close to #nodes x #rows, of if using balance_classes).")
        public boolean shuffle_training_data;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, values={"MeanImputation", "Skip"}, help="Handling of missing values. Either MeanImputation or Skip.")
        public DeepLearningModel.DeepLearningParameters.MissingValuesHandling missing_values_handling;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Sparse data handling (more efficient for data with lots of 0 values).")
        public boolean sparse;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="#DEPRECATED Use a column major weight matrix for input layer. Can speed up forward propagation, but might slow down backpropagation.")
        public boolean col_major;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Average activation for sparse auto-encoder. #Experimental")
        public double average_activation;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Sparsity regularization. #Experimental")
        public double sparsity_beta;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Max. number of categorical features, enforced via hashing. #Experimental")
        public int max_categorical_features;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Force reproducibility on small data (will be slow - only uses 1 thread).")
        public boolean reproducible;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Whether to export Neural Network weights and biases to H2O Frames.")
        public boolean export_weights_and_biases;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Mini-batch size (smaller leads to better fit, larger can speed up and generalize better).")
        public int mini_batch_size;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Elastic averaging between compute nodes can improve distributed model convergence. #Experimental")
        public boolean elastic_averaging;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Elastic averaging moving rate (only if elastic averaging is enabled).")
        public double elastic_averaging_moving_rate;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Elastic averaging regularization strength (only if elastic averaging is enabled).")
        public double elastic_averaging_regularization;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Pretrained autoencoder model to initialize this model with.")
        public KeyV3.ModelKeyV3 pretrained_autoencoder;
    }
}

