/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DTree;
import water.MRTask;
import water.fvec.C4VolatileChunk;
import water.fvec.Chunk;
import water.util.RandomBase;
import water.util.RandomUtils;

public class Sample
extends MRTask<Sample> {
    final long _seed;
    final int _useMarker;
    final int _ignoreMarker;
    final double _rate;
    final double[] _rate_per_class;

    public Sample(DTree tree, double rate, double[] rate_per_class) {
        this(tree._seed, rate, rate_per_class, 0, -2);
    }

    public Sample(long seed, double rate, double[] rate_per_class, int useMarker, int ignoreMarker) {
        this._seed = seed;
        this._useMarker = useMarker;
        this._ignoreMarker = ignoreMarker;
        this._rate = rate;
        this._rate_per_class = rate_per_class;
    }

    public void map(Chunk nids, Chunk ys) {
        C4VolatileChunk nids2 = (C4VolatileChunk)nids;
        RandomBase rand = RandomUtils.getRNG((long[])new long[]{this._seed});
        int[] is = nids2.getValues();
        for (int row = 0; row < nids._len; ++row) {
            boolean skip = ys.isNA(row);
            if (!skip) {
                double rate = this._rate_per_class == null ? this._rate : this._rate_per_class[(int)ys.at8(row)];
                rand.setSeed(this._seed + (long)row + nids.start());
                boolean bl = skip = (double)rand.nextFloat() >= rate;
            }
            if (skip) {
                is[row] = this._ignoreMarker;
                continue;
            }
            if (this._useMarker == 0) continue;
            is[row] = this._useMarker;
        }
    }
}

