/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.tree.CompressedTree;
import hex.tree.TreeVisitor;
import water.exceptions.JCodeSB;
import water.util.IcedBitSet;
import water.util.SB;

class TreeJCodeGen
extends TreeVisitor<RuntimeException> {
    public static final int MAX_NODES = 1024;
    private static final int MAX_DEPTH = 70;
    private static final int MAX_CONSTANT_POOL_SIZE = 61440;
    private static final int MAX_METHOD_SIZE = 61440;
    final SB[] _sbs = new SB[70];
    final int[] _nodesCnt = new int[70];
    final SB[] _grpSplits = new SB[70];
    final int[] _grpSplitsCnt = new int[70];
    final int[] _constantPool = new int[70];
    final int[] _staticInit = new int[70];
    final String _javaClassName;
    final Model.Output _output;
    SB _sb;
    SB _csb;
    SB _grpsplit;
    int _subtrees = 0;
    int _grpCnt = 0;
    int _constantPoolSize = 0;
    int _staticInitSize = 0;
    private final boolean _verboseCode;

    public TreeJCodeGen(Model.Output output, CompressedTree ct, SB sb, String javaClassName, boolean verboseCode) {
        super(ct);
        this._output = output;
        this._sb = sb;
        this._csb = new SB();
        this._grpsplit = new SB();
        this._verboseCode = verboseCode;
        this._javaClassName = javaClassName;
    }

    protected void preamble(SB sb, int subtree) throws RuntimeException {
        String subt = subtree > 0 ? "_" + String.valueOf(subtree) : "";
        sb.p("class ").p(this._javaClassName).p(subt).p(" {").nl().ii(1);
        sb.ip("static final double score0").p("(double[] data) {").nl().ii(1);
        sb.ip("double pred = ");
    }

    protected void closure(SB sb) throws RuntimeException {
        sb.p(";").nl();
        sb.ip("return pred;").nl().di(1);
        sb.ip("}").p(" // constant pool size = ").p(this._constantPoolSize).p("B, number of visited nodes = ").p(this._nodes).p(", static init size = ").p(this._staticInitSize).p("B");
        sb.nl();
        this._sb.p((JCodeSB)this._grpsplit);
        sb.di(1).ip("}").nl().nl();
    }

    @Override
    protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal, int naSplitDirInt) {
        int limit;
        if (this._nodes > 1024 || this._constantPoolSize > 61440 || this._staticInitSize > 61440) {
            this._sb.p(this._javaClassName).p('_').p(this._subtrees).p(".score0").p("(data)");
            this._nodesCnt[this._depth] = this._nodes;
            this._sbs[this._depth] = this._sb;
            this._grpSplits[this._depth] = this._grpsplit;
            this._grpSplitsCnt[this._depth] = this._grpCnt;
            this._constantPool[this._depth] = this._constantPoolSize;
            this._staticInit[this._depth] = this._staticInitSize;
            this._sb = new SB();
            this._nodes = 0;
            this._grpsplit = new SB();
            this._grpCnt = 0;
            this._constantPoolSize = 0;
            this._staticInitSize = 0;
            this.preamble(this._sb, this._subtrees);
            ++this._subtrees;
        }
        if (equal == 2 || equal == 3 && gcmp != null) {
            this._grpsplit.i(1).p("// ").p(gcmp.toString()).nl();
            this._grpsplit.i(1).p("public static final byte[] GRPSPLIT").p(this._grpCnt).p(" = new byte[] ").p(gcmp.toStrArray()).p(";").nl();
            this._constantPoolSize += gcmp.numBytes() + 3;
            this._staticInitSize += 6 + gcmp.numBytes() * 6;
        }
        this._sb.ip(" (");
        String colName = this._verboseCode ? " /* " + this._output._names[col] + " */" : "";
        String[][] domains = this._output._domains;
        int n = limit = domains != null && domains[col] != null ? domains[col].length : Integer.MAX_VALUE;
        assert (equal != 1);
        if (equal == 0) {
            if (naSplitDirInt == DhnasdNaVsRest) {
                this._sb.p("!Double.isNaN(data[").p(col).p("])");
                if (limit != Integer.MAX_VALUE) {
                    this._sb.p(" && (data[").p(col).p("] < " + limit + ") ");
                }
            } else if (naSplitDirInt == DhnasdNaLeft || naSplitDirInt == DhnasdLeft) {
                this._sb.p("Double.isNaN(data[").p(col).p("]) ");
                if (limit != Integer.MAX_VALUE) {
                    this._sb.p("|| (data[").p(col).p("] >= " + limit + ") ");
                }
                this._sb.p("|| ");
            }
            if (naSplitDirInt != DhnasdNaVsRest) {
                this._sb.p("data[").p(col);
                this._sb.p(colName);
                this._sb.p("] < ").pj(fcmp);
                this._constantPoolSize += 2;
            }
        } else {
            boolean leftward;
            assert (naSplitDirInt != DhnasdNaVsRest) : "NAvsREST splits are expected to be represented with equal==0";
            boolean bl = leftward = naSplitDirInt == DhnasdNaLeft || naSplitDirInt == DhnasdLeft;
            if (leftward) {
                this._sb.p("Double.isNaN(data[").p(col).p(colName).p("]) || !");
                gcmp.toJavaRangeCheck(this._sb, col);
                if (limit != Integer.MAX_VALUE) {
                    this._sb.p(" || (data[").p(col).p("] >= " + limit + ")");
                }
                this._sb.p(" || ");
            } else {
                this._sb.p("!Double.isNaN(data[").p(col).p(colName).p("]) && ");
            }
            this._sb.p("(");
            gcmp.toJavaRangeCheck(this._sb, col);
            this._sb.p(" && ");
            if (limit != Integer.MAX_VALUE) {
                this._sb.p("(data[").p(col).p("] < " + limit + ")");
            }
            this._sb.p(" && ");
            gcmp.toJava(this._sb, "GRPSPLIT" + this._grpCnt, col);
            this._sb.p(")");
            ++this._grpCnt;
        }
        this._sb.p(" ? ").ii(2).nl();
    }

    @Override
    protected void leaf(float pred) {
        this._sb.i().pj(pred);
        this._constantPoolSize += 2;
    }

    @Override
    protected void mid(int col, float fcmp, int equal) throws RuntimeException {
        this._sb.p(" : ").nl();
    }

    @Override
    protected void post(int col, float fcmp, int equal) {
        this._sb.p(')').di(2);
        if (this._sbs[this._depth] != null) {
            this.closure(this._sb);
            this._csb.p((JCodeSB)this._sb);
            this._sb = this._sbs[this._depth];
            this._nodes = this._nodesCnt[this._depth];
            this._sbs[this._depth] = null;
            this._grpsplit = this._grpSplits[this._depth];
            this._grpCnt = this._grpSplitsCnt[this._depth];
            this._grpSplits[this._depth] = null;
            this._constantPoolSize = this._constantPool[this._depth];
            this._staticInitSize = this._staticInit[this._depth];
        }
    }

    public void generate() {
        this.preamble(this._sb, this._subtrees++);
        this.visit();
        this.closure(this._sb);
        this._sb.p((JCodeSB)this._csb);
    }
}

