/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.tree.dt.CompressedDT;
import hex.tree.dt.DT;
import hex.tree.dt.DTPrediction;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;

public class DTModel
extends Model<DTModel, DTParameters, DTOutput> {
    private static final Logger LOG = Logger.getLogger(DTModel.class);

    public DTModel(Key<DTModel> selfKey, DTParameters parms, DTOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((DTOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((DTOutput)this._output).nclasses(), domain, ((DTParameters)this._parms)._auc_type);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
        }
        throw H2O.unimpl();
    }

    protected double[] score0(double[] data, double[] preds) {
        assert (((DTOutput)this._output)._treeKey != null) : "Output has no tree, check if tree is properly set to the output.";
        CompressedDT tree = (CompressedDT)DKV.getGet(((DTOutput)this._output)._treeKey);
        DTPrediction prediction = tree.predictRowStartingFromNode(data, 0, "");
        preds[0] = prediction.classPrediction;
        preds[1] = prediction.probability;
        preds[2] = 1.0 - prediction.probability;
        return preds;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Keyed.remove(((DTOutput)this._output)._treeKey, (Futures)fs, (boolean)true);
        return super.remove_impl(fs, cascade);
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putKey(((DTOutput)this._output)._treeKey);
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        ab.getKey(((DTOutput)this._output)._treeKey, fs);
        return super.readAll_impl(ab, fs);
    }

    public static class DTParameters
    extends Model.Parameters {
        long seed = -1L;
        public int _max_depth = 20;
        public int _min_rows = 10;

        public String algoName() {
            return "DT";
        }

        public String fullName() {
            return "Decision Tree";
        }

        public String javaName() {
            return DTModel.class.getName();
        }

        public long progressUnits() {
            return 1L;
        }
    }

    public static class DTOutput
    extends Model.Output {
        public int _max_depth;
        public int _limitNumSamplesForSplit;
        public Key<CompressedDT> _treeKey;

        public DTOutput(DT dt) {
            super((ModelBuilder)dt);
            this._max_depth = ((DTParameters)dt._parms)._max_depth;
            this._limitNumSamplesForSplit = ((DTParameters)dt._parms)._min_rows;
        }
    }
}

