/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import water.fvec.Chunk;

class PathTracker {
    PathTracker() {
    }

    static int encodeNewPathLength(Chunk tree, int row, int depth, boolean wasOOB) {
        long old_len_enc = tree.at8(row);
        long len_enc = PathTracker.addNewPathLength(old_len_enc, depth, wasOOB);
        tree.set(row, len_enc);
        return PathTracker.decodeTotalPathLength(len_enc);
    }

    static int decodeOOBPathLength(Chunk tree, int row) {
        return PathTracker.decodeOOBPathLength(tree.at8(row));
    }

    private static int decodeTotalPathLength(long lengthEncoded) {
        long total_len = (lengthEncoded >> 31) + (lengthEncoded & Integer.MAX_VALUE);
        assert (total_len == (long)((int)total_len));
        return (int)total_len;
    }

    static int decodeOOBPathLength(long lengthEncoded) {
        return (int)(lengthEncoded >> 31);
    }

    static long addNewPathLength(long oldLengthEncoded, int depth, boolean wasOOB) {
        if (wasOOB) {
            return oldLengthEncoded + ((long)depth << 31);
        }
        return oldLengthEncoded + (long)depth;
    }
}

