/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.genmodel.algos.isoforextended.ExtendedIsolationForestMojoModel;
import hex.tree.isofor.ModelMetricsAnomaly;
import hex.tree.isoforextended.ExtendedIsolationForest;
import hex.tree.isoforextended.ExtendedIsolationForestMojoWriter;
import hex.tree.isoforextended.isolationtree.CompressedIsolationTree;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.fvec.Frame;

public class ExtendedIsolationForestModel
extends Model<ExtendedIsolationForestModel, ExtendedIsolationForestParameters, ExtendedIsolationForestOutput> {
    private static final Logger LOG = Logger.getLogger(ExtendedIsolationForestModel.class);

    public ExtendedIsolationForestModel(Key<ExtendedIsolationForestModel> selfKey, ExtendedIsolationForestParameters parms, ExtendedIsolationForestOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsAnomaly.MetricBuilderAnomaly("Extended Isolation Forest Metrics", false);
    }

    protected String[] makeScoringNames() {
        return new String[]{"anomaly_score", "mean_length"};
    }

    protected String[][] makeScoringDomains(Frame adaptFrm, boolean computeMetrics, String[] names) {
        assert (names.length == 2);
        return new String[2][];
    }

    protected double[] score0(double[] data, double[] preds) {
        assert (((ExtendedIsolationForestOutput)this._output)._iTreeKeys != null) : "Output has no trees, check if trees are properly set to the output.";
        double pathLength = 0.0;
        int numberOfTrees = 0;
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            if (iTreeKey == null) continue;
            ++numberOfTrees;
            CompressedIsolationTree iTree = (CompressedIsolationTree)DKV.getGet(iTreeKey);
            double iTreeScore = iTree.computePathLength(data);
            pathLength += iTreeScore;
            LOG.trace((Object)("iTreeScore " + iTreeScore));
        }
        LOG.trace((Object)("Path length " + (pathLength /= (double)numberOfTrees)));
        double anomalyScore = ExtendedIsolationForestMojoModel.anomalyScore((double)pathLength, (long)((ExtendedIsolationForestOutput)this._output)._sample_size);
        LOG.trace((Object)("Anomaly score " + anomalyScore));
        preds[0] = anomalyScore;
        preds[1] = pathLength;
        return preds;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            Keyed.remove(iTreeKey, (Futures)fs, (boolean)true);
        }
        return super.remove_impl(fs, cascade);
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            ab.putKey(iTreeKey);
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            ab.getKey(iTreeKey, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public ExtendedIsolationForestMojoWriter getMojo() {
        return new ExtendedIsolationForestMojoWriter(this);
    }

    public static class ExtendedIsolationForestOutput
    extends Model.Output {
        public int _ntrees;
        public long _sample_size;
        public ScoreKeeper[] _scored_train;
        public long[] _training_time_ms;
        public Key<CompressedIsolationTree>[] _iTreeKeys;

        public ExtendedIsolationForestOutput(ExtendedIsolationForest eif) {
            super((ModelBuilder)eif);
            this._ntrees = ((ExtendedIsolationForestParameters)eif._parms)._ntrees;
            this._sample_size = ((ExtendedIsolationForestParameters)eif._parms)._sample_size;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.AnomalyDetection;
        }
    }

    public static class ExtendedIsolationForestParameters
    extends Model.Parameters {
        public int _ntrees = 100;
        public int _extension_level = 0;
        public int _sample_size = 256;
        public int _score_tree_interval = 0;
        public boolean _disable_training_metrics = true;
        public int _initial_score_interval = 4000;
        public int _score_interval = 4000;

        public String algoName() {
            return "ExtendedIsolationForest";
        }

        public String fullName() {
            return "Extended Isolation Forest";
        }

        public String javaName() {
            return ExtendedIsolationForestModel.class.getName();
        }

        public long progressUnits() {
            return this._ntrees;
        }
    }
}

