/*
 * Decompiled with CFR 0.152.
 */
package hex.util;

import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMModel;
import water.exceptions.H2OIllegalArgumentException;

public class DistributionUtils {
    public static DistributionFamily familyToDistribution(GLMModel.GLMParameters.Family aFamily) {
        if (aFamily == GLMModel.GLMParameters.Family.binomial) {
            return DistributionFamily.bernoulli;
        }
        try {
            return Enum.valueOf(DistributionFamily.class, aFamily.toString());
        }
        catch (IllegalArgumentException e) {
            throw new H2OIllegalArgumentException("DistributionFamily not supported for Family: " + (Object)((Object)aFamily));
        }
    }

    public static GLMModel.GLMParameters.Family distributionToFamily(DistributionFamily distribution) {
        if (DistributionFamily.bernoulli.equals((Object)distribution)) {
            return GLMModel.GLMParameters.Family.binomial;
        }
        try {
            return Enum.valueOf(GLMModel.GLMParameters.Family.class, distribution.toString());
        }
        catch (IllegalArgumentException e) {
            throw new H2OIllegalArgumentException("Family not supported for DistributionFamily: " + distribution);
        }
    }
}

