/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.glrm.GLRM;
import hex.glrm.ModelMetricsGLRM;
import hex.svd.SVDModel;
import java.util.Random;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.MathUtils;
import water.util.TwoDimTable;

public class GLRMModel
extends Model<GLRMModel, GLRMParameters, GLRMOutput> {
    public GLRMModel(Key selfKey, GLRMParameters parms, GLRMOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    protected Futures remove_impl(Futures fs) {
        if (null != ((GLRMOutput)this._output)._init_key) {
            ((GLRMOutput)this._output)._init_key.remove(fs);
        }
        if (null != ((GLRMOutput)this._output)._representation_key) {
            ((GLRMOutput)this._output)._representation_key.remove(fs);
        }
        return super.remove_impl(fs);
    }

    protected Frame predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        int ncols = ((GLRMOutput)this._output)._names.length;
        assert (ncols == adaptedFr.numCols());
        String prefix = "reconstr_";
        Frame fullFrm = new Frame(adaptedFr);
        Frame loadingFrm = (Frame)DKV.get(((GLRMOutput)this._output)._representation_key).get();
        fullFrm.add(loadingFrm);
        String[][] adaptedDomme = adaptedFr.domains();
        for (int i = 0; i < ncols; ++i) {
            Vec v = fullFrm.anyVec().makeZero();
            v.setDomain(adaptedDomme[i]);
            fullFrm.add(prefix + ((GLRMOutput)this._output)._names[i], v);
        }
        GLRMScore gs = (GLRMScore)new GLRMScore(ncols, ((GLRMParameters)this._parms)._k, true).doAll(fullFrm);
        int x = ncols + ((GLRMParameters)this._parms)._k;
        int y = fullFrm.numCols();
        Frame f = fullFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        gs._mb.makeModelMetrics((Model)this, orig);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        throw H2O.unimpl();
    }

    public ModelMetricsGLRM scoreMetricsOnly(Frame frame) {
        int ncols = ((GLRMOutput)this._output)._names.length;
        Frame adaptedFr = new Frame(frame);
        this.adaptTestForTrain(adaptedFr, true, false);
        assert (ncols == adaptedFr.numCols());
        Frame fullFrm = new Frame(adaptedFr);
        Frame loadingFrm = (Frame)DKV.get(((GLRMOutput)this._output)._representation_key).get();
        fullFrm.add(loadingFrm);
        GLRMScore gs = (GLRMScore)new GLRMScore(ncols, ((GLRMParameters)this._parms)._k, false).doAll(fullFrm);
        ModelMetrics mm = gs._mb.makeModelMetrics((Model)this, adaptedFr);
        return (ModelMetricsGLRM)mm;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsGLRM.GLRMModelMetrics(((GLRMParameters)this._parms)._k, ((GLRMOutput)this._output)._permutation, ((GLRMParameters)this._parms)._impute_original);
    }

    private class GLRMScore
    extends MRTask<GLRMScore> {
        final int _ncolA;
        final int _ncolX;
        final boolean _save_imputed;
        ModelMetrics.MetricBuilder _mb;

        GLRMScore(int ncolA, int ncolX, boolean save_imputed) {
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._save_imputed = save_imputed;
        }

        public void map(Chunk[] chks) {
            float[] atmp = new float[this._ncolA];
            double[] xtmp = new double[this._ncolX];
            double[] preds = new double[this._ncolA];
            this._mb = GLRMModel.this.makeMetricBuilder(null);
            if (this._save_imputed) {
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = this.impute_data(chks, row, xtmp, preds);
                    this.compute_metrics(chks, row, atmp, p);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[this._ncolA + this._ncolX + c].set(row, p[c]);
                    }
                }
            } else {
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = this.impute_data(chks, row, xtmp, preds);
                    this.compute_metrics(chks, row, atmp, p);
                }
            }
        }

        public void reduce(GLRMScore other) {
            if (this._mb != null) {
                this._mb.reduce(other._mb);
            }
        }

        protected void postGlobal() {
            if (this._mb != null) {
                this._mb.postGlobal();
            }
        }

        private float[] compute_metrics(Chunk[] chks, int row_in_chunk, float[] tmp, double[] preds) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = (float)chks[i].atd(row_in_chunk);
            }
            this._mb.perRow(preds, tmp, (Model)GLRMModel.this);
            return tmp;
        }

        private double[] impute_data(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = chks[this._ncolA + i].atd(row_in_chunk);
            }
            this.impute_data(tmp, preds);
            return preds;
        }

        private double[] impute_data(double[] tmp, double[] preds) {
            int d;
            assert (preds.length == ((GLRMOutput)GLRMModel.this._output)._nnums + ((GLRMOutput)GLRMModel.this._output)._ncats);
            for (d = 0; d < ((GLRMOutput)GLRMModel.this._output)._ncats; ++d) {
                double[] xyblock = ((GLRMOutput)GLRMModel.this._output)._archetypes_raw.lmulCatBlock(tmp, d);
                GLRMParameters cfr_ignored_0 = (GLRMParameters)GLRMModel.this._parms;
                preds[((GLRMOutput)GLRMModel.this._output)._permutation[d]] = GLRMParameters.mimpute(xyblock, ((GLRMOutput)GLRMModel.this._output)._lossFunc[d]);
            }
            for (d = ((GLRMOutput)GLRMModel.this._output)._ncats; d < preds.length; ++d) {
                int ds = d - ((GLRMOutput)GLRMModel.this._output)._ncats;
                double xy = ((GLRMOutput)GLRMModel.this._output)._archetypes_raw.lmulNumCol(tmp, ds);
                GLRMParameters cfr_ignored_1 = (GLRMParameters)GLRMModel.this._parms;
                preds[((GLRMOutput)GLRMModel.this._output)._permutation[d]] = GLRMParameters.impute(xy, ((GLRMOutput)GLRMModel.this._output)._lossFunc[d]);
                if (!((GLRMParameters)GLRMModel.this._parms)._impute_original) continue;
                preds[((GLRMOutput)GLRMModel.this._output)._permutation[d]] = preds[((GLRMOutput)GLRMModel.this._output)._permutation[d]] / ((GLRMOutput)GLRMModel.this._output)._normMul[ds] + ((GLRMOutput)GLRMModel.this._output)._normSub[ds];
            }
            return preds;
        }
    }

    public static class GLRMOutput
    extends Model.Output {
        public int _iterations;
        public double _objective;
        public double _avg_change_obj;
        public double[] _history_objective = new double[0];
        public TwoDimTable _archetypes;
        public GLRM.Archetypes _archetypes_raw;
        public double[] _history_step_size = new double[0];
        public double[][] _eigenvectors_raw;
        public TwoDimTable _eigenvectors;
        public double[] _singular_vals;
        public String _representation_name;
        public Key<Frame> _representation_key;
        public Key<? extends Model> _init_key;
        public int _ncats;
        public int _nnums;
        public long _nobs;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;
        public String[] _names_expanded;
        public GLRMParameters.Loss[] _lossFunc;
        public long[] _training_time_ms = new long[0];

        public GLRMOutput(GLRM b) {
            super((ModelBuilder)b);
        }

        public int nfeatures() {
            return this._names.length;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class GLRMParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public int _k = 1;
        public GLRM.Initialization _init = GLRM.Initialization.PlusPlus;
        public SVDModel.SVDParameters.Method _svd_method = SVDModel.SVDParameters.Method.Randomized;
        public Key<Frame> _user_y;
        public Key<Frame> _user_x;
        public boolean _expand_user_y = true;
        public Loss _loss = Loss.Quadratic;
        public Loss _multi_loss = Loss.Categorical;
        public int _period = 1;
        public Loss[] _loss_by_col;
        public int[] _loss_by_col_idx;
        public Regularizer _regularization_x = Regularizer.None;
        public Regularizer _regularization_y = Regularizer.None;
        public double _gamma_x = 0.0;
        public double _gamma_y = 0.0;
        public int _max_iterations = 1000;
        public double _init_step_size = 1.0;
        public double _min_step_size = 1.0E-4;
        public long _seed = System.nanoTime();
        public String _representation_name;
        public boolean _recover_svd = false;
        public boolean _impute_original = false;
        public boolean _verbose = true;

        private final boolean allLossEquals(Loss loss) {
            if (null == this._loss_by_col) {
                return false;
            }
            boolean res = true;
            for (int i = 0; i < this._loss_by_col.length; ++i) {
                if (this._loss_by_col[i] == loss) continue;
                res = false;
                break;
            }
            return res;
        }

        public final boolean hasClosedForm() {
            long na_cnt = 0L;
            Frame train = (Frame)this._train.get();
            for (int i = 0; i < train.numCols(); ++i) {
                na_cnt += train.vec(i).naCnt();
            }
            return this.hasClosedForm(na_cnt);
        }

        public final boolean hasClosedForm(long na_cnt) {
            boolean loss_quad = null == this._loss_by_col && this._loss == Loss.Quadratic || null != this._loss_by_col && this.allLossEquals(Loss.Quadratic) && (this._loss_by_col.length == ((Frame)this._train.get()).numCols() || this._loss == Loss.Quadratic);
            return !(na_cnt != 0L || !loss_quad || this._gamma_x != 0.0 && this._regularization_x != Regularizer.None && this._regularization_x != Regularizer.Quadratic || this._gamma_y != 0.0 && this._regularization_y != Regularizer.None && this._regularization_y != Regularizer.Quadratic);
        }

        public final double loss(double u, double a) {
            return this.loss(u, a, this._loss);
        }

        public final double loss(double u, double a, Loss loss) {
            assert (loss.isForNumeric()) : "Loss function " + (Object)((Object)loss) + " not applicable to numerics";
            switch (loss) {
                case Quadratic: {
                    return (u - a) * (u - a);
                }
                case Absolute: {
                    return Math.abs(u - a);
                }
                case Huber: {
                    return Math.abs(u - a) <= 1.0 ? 0.5 * (u - a) * (u - a) : Math.abs(u - a) - 0.5;
                }
                case Poisson: {
                    assert (a >= 0.0) : "Poisson loss L(u,a) requires variable a >= 0";
                    return Math.exp(u) + (a == 0.0 ? 0.0 : -a * u + a * Math.log(a) - a);
                }
                case Hinge: {
                    return Math.max(1.0 - (a == 0.0 ? -u : u), 0.0);
                }
                case Logistic: {
                    return Math.log(1.0 + Math.exp(a == 0.0 ? u : -u));
                }
                case Periodic: {
                    return 1.0 - Math.cos((a - u) * (Math.PI * 2) / (double)this._period);
                }
            }
            throw new RuntimeException("Unknown loss function " + (Object)((Object)loss));
        }

        public final double lgrad(double u, double a) {
            return this.lgrad(u, a, this._loss);
        }

        public final double lgrad(double u, double a, Loss loss) {
            assert (loss.isForNumeric()) : "Loss function " + (Object)((Object)loss) + " not applicable to numerics";
            switch (loss) {
                case Quadratic: {
                    return 2.0 * (u - a);
                }
                case Absolute: {
                    return Math.signum(u - a);
                }
                case Huber: {
                    return Math.abs(u - a) <= 1.0 ? u - a : Math.signum(u - a);
                }
                case Poisson: {
                    assert (a >= 0.0) : "Poisson loss L(u,a) requires variable a >= 0";
                    return Math.exp(u) - a;
                }
                case Hinge: {
                    return a == 0.0 ? (double)(-u <= 1.0 ? 1 : 0) : (double)(u <= 1.0 ? -1 : 0);
                }
                case Logistic: {
                    return a == 0.0 ? 1.0 / (1.0 + Math.exp(-u)) : -1.0 / (1.0 + Math.exp(u));
                }
                case Periodic: {
                    return Math.PI * 2 / (double)this._period * Math.sin((a - u) * (Math.PI * 2) / (double)this._period);
                }
            }
            throw new RuntimeException("Unknown loss function " + (Object)((Object)loss));
        }

        public final double mloss(double[] u, int a) {
            return GLRMParameters.mloss(u, a, this._multi_loss);
        }

        public static double mloss(double[] u, int a, Loss multi_loss) {
            assert (multi_loss.isForCategorical()) : "Loss function " + (Object)((Object)multi_loss) + " not applicable to categoricals";
            if (a < 0 || a > u.length - 1) {
                throw new IllegalArgumentException("Index must be between 0 and " + String.valueOf(u.length - 1));
            }
            double sum = 0.0;
            switch (multi_loss) {
                case Categorical: {
                    for (int i = 0; i < u.length; ++i) {
                        sum += Math.max(1.0 + u[i], 0.0);
                    }
                    return sum += Math.max(1.0 - u[a], 0.0) - Math.max(1.0 + u[a], 0.0);
                }
                case Ordinal: {
                    for (int i = 0; i < u.length - 1; ++i) {
                        sum += Math.max(a > i ? 1.0 - u[i] : 1.0, 0.0);
                    }
                    return sum;
                }
            }
            throw new RuntimeException("Unknown multidimensional loss function " + (Object)((Object)multi_loss));
        }

        public final double[] mlgrad(double[] u, int a) {
            return GLRMParameters.mlgrad(u, a, this._multi_loss);
        }

        public static double[] mlgrad(double[] u, int a, Loss multi_loss) {
            assert (multi_loss.isForCategorical()) : "Loss function " + (Object)((Object)multi_loss) + " not applicable to categoricals";
            if (a < 0 || a > u.length - 1) {
                throw new IllegalArgumentException("Index must be between 0 and " + String.valueOf(u.length - 1));
            }
            double[] grad = new double[u.length];
            switch (multi_loss) {
                case Categorical: {
                    for (int i = 0; i < u.length; ++i) {
                        grad[i] = 1.0 + u[i] > 0.0 ? 1.0 : 0.0;
                    }
                    grad[a] = 1.0 - u[a] > 0.0 ? -1.0 : 0.0;
                    return grad;
                }
                case Ordinal: {
                    for (int i = 0; i < u.length - 1; ++i) {
                        grad[i] = a > i && 1.0 - u[i] > 0.0 ? -1.0 : 0.0;
                    }
                    return grad;
                }
            }
            throw new RuntimeException("Unknown multidimensional loss function " + (Object)((Object)multi_loss));
        }

        public final double regularize_x(double[] u) {
            return this.regularize(u, this._regularization_x);
        }

        public final double regularize_y(double[] u) {
            return this.regularize(u, this._regularization_y);
        }

        public final double regularize(double[] u, Regularizer regularization) {
            if (u == null) {
                return 0.0;
            }
            double ureg = 0.0;
            switch (regularization) {
                case None: {
                    return 0.0;
                }
                case Quadratic: {
                    for (int i = 0; i < u.length; ++i) {
                        ureg += u[i] * u[i];
                    }
                    return ureg;
                }
                case L2: {
                    for (int i = 0; i < u.length; ++i) {
                        ureg += u[i] * u[i];
                    }
                    return Math.sqrt(ureg);
                }
                case L1: {
                    for (int i = 0; i < u.length; ++i) {
                        ureg += Math.abs(u[i]);
                    }
                    return ureg;
                }
                case NonNegative: {
                    for (int i = 0; i < u.length; ++i) {
                        if (!(u[i] < 0.0)) continue;
                        return Double.POSITIVE_INFINITY;
                    }
                    return 0.0;
                }
                case OneSparse: {
                    int card = 0;
                    for (int i = 0; i < u.length; ++i) {
                        if (u[i] < 0.0) {
                            return Double.POSITIVE_INFINITY;
                        }
                        if (!(u[i] > 0.0)) continue;
                        ++card;
                    }
                    return card == 1 ? 0.0 : Double.POSITIVE_INFINITY;
                }
                case UnitOneSparse: {
                    int ones = 0;
                    int zeros = 0;
                    for (int i = 0; i < u.length; ++i) {
                        if (u[i] == 1.0) {
                            ++ones;
                            continue;
                        }
                        if (u[i] == 0.0) {
                            ++zeros;
                            continue;
                        }
                        return Double.POSITIVE_INFINITY;
                    }
                    return ones == 1 && zeros == u.length - 1 ? 0.0 : Double.POSITIVE_INFINITY;
                }
                case Simplex: {
                    double sum = 0.0;
                    for (int i = 0; i < u.length; ++i) {
                        if (u[i] < 0.0) {
                            return Double.POSITIVE_INFINITY;
                        }
                        sum += u[i];
                    }
                    return MathUtils.equalsWithinOneSmallUlp((double)sum, (double)1.0) ? 0.0 : Double.POSITIVE_INFINITY;
                }
            }
            throw new RuntimeException("Unknown regularization function " + (Object)((Object)regularization));
        }

        public final double regularize_x(double[][] u) {
            return this.regularize(u, this._regularization_x);
        }

        public final double regularize_y(double[][] u) {
            return this.regularize(u, this._regularization_y);
        }

        public final double regularize(double[][] u, Regularizer regularization) {
            if (u == null || regularization == Regularizer.None) {
                return 0.0;
            }
            double ureg = 0.0;
            for (int i = 0; i < u.length; ++i) {
                if (!Double.isInfinite(ureg += this.regularize(u[i], regularization))) continue;
                return ureg;
            }
            return ureg;
        }

        public final double[] rproxgrad_x(double[] u, double alpha, Random rand) {
            return GLRMParameters.rproxgrad(u, alpha, this._gamma_x, this._regularization_x, rand);
        }

        public final double[] rproxgrad_y(double[] u, double alpha, Random rand) {
            return GLRMParameters.rproxgrad(u, alpha, this._gamma_y, this._regularization_y, rand);
        }

        static double[] rproxgrad(double[] u, double alpha, double gamma, Regularizer regularization, Random rand) {
            if (u == null || alpha == 0.0 || gamma == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            switch (regularization) {
                case None: {
                    return u;
                }
                case Quadratic: {
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = u[i] / (1.0 + 2.0 * alpha * gamma);
                    }
                    return v;
                }
                case L2: {
                    double weight = 1.0 - alpha * gamma / ArrayUtils.l2norm((double[])u);
                    if (weight < 0.0) {
                        return v;
                    }
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = weight * u[i];
                    }
                    return v;
                }
                case L1: {
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = Math.max(u[i] - alpha * gamma, 0.0) + Math.min(u[i] + alpha * gamma, 0.0);
                    }
                    return v;
                }
                case NonNegative: {
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = Math.max(u[i], 0.0);
                    }
                    return v;
                }
                case OneSparse: {
                    int idx = ArrayUtils.maxIndex((double[])u, (Random)rand);
                    v[idx] = u[idx] > 0.0 ? u[idx] : 1.0E-6;
                    return v;
                }
                case UnitOneSparse: {
                    int idx = ArrayUtils.maxIndex((double[])u, (Random)rand);
                    v[idx] = 1.0;
                    return v;
                }
                case Simplex: {
                    int n = u.length;
                    int[] idxs = new int[n];
                    for (int i = 0; i < n; ++i) {
                        idxs[i] = i;
                    }
                    ArrayUtils.sort((int[])idxs, (double[])u);
                    double[] ucsum = new double[n];
                    ucsum[n - 1] = u[idxs[n - 1]];
                    for (int i = n - 2; i >= 0; --i) {
                        ucsum[i] = ucsum[i + 1] + u[idxs[i]];
                    }
                    double t = (ucsum[0] - 1.0) / (double)n;
                    for (int i = n - 1; i >= 1; --i) {
                        double tmp = (ucsum[i] - 1.0) / (double)(n - i);
                        if (!(tmp >= u[idxs[i - 1]])) continue;
                        t = tmp;
                        break;
                    }
                    double[] x = new double[u.length];
                    for (int i = 0; i < u.length; ++i) {
                        x[i] = Math.max(u[i] - t, 0.0);
                    }
                    return x;
                }
            }
            throw new RuntimeException("Unknown regularization function " + (Object)((Object)regularization));
        }

        public final double[] project_x(double[] u, Random rand) {
            return this.project(u, this._regularization_x, rand);
        }

        public final double[] project_y(double[] u, Random rand) {
            return this.project(u, this._regularization_y, rand);
        }

        public final double[] project(double[] u, Regularizer regularization, Random rand) {
            if (u == null) {
                return u;
            }
            switch (regularization) {
                case None: 
                case Quadratic: 
                case L2: 
                case L1: {
                    return u;
                }
                case NonNegative: 
                case OneSparse: 
                case UnitOneSparse: {
                    return GLRMParameters.rproxgrad(u, 1.0, 1.0, regularization, rand);
                }
                case Simplex: {
                    double reg = this.regularize(u, regularization);
                    if (reg == 0.0) {
                        return u;
                    }
                    return GLRMParameters.rproxgrad(u, 1.0, 1.0, regularization, rand);
                }
            }
            throw new RuntimeException("Unknown regularization function " + (Object)((Object)regularization));
        }

        public final double impute(double u) {
            return GLRMParameters.impute(u, this._loss);
        }

        public static double impute(double u, Loss loss) {
            assert (loss.isForNumeric()) : "Loss function " + (Object)((Object)loss) + " not applicable to numerics";
            switch (loss) {
                case Quadratic: 
                case Absolute: 
                case Huber: 
                case Periodic: {
                    return u;
                }
                case Poisson: {
                    return Math.exp(u) - 1.0;
                }
                case Hinge: 
                case Logistic: {
                    return u > 0.0 ? 1.0 : 0.0;
                }
            }
            throw new RuntimeException("Unknown loss function " + (Object)((Object)loss));
        }

        public final int mimpute(double[] u) {
            return GLRMParameters.mimpute(u, this._multi_loss);
        }

        public static int mimpute(double[] u, Loss multi_loss) {
            assert (multi_loss.isForCategorical()) : "Loss function " + (Object)((Object)multi_loss) + " not applicable to categoricals";
            switch (multi_loss) {
                case Categorical: 
                case Ordinal: {
                    double[] cand = new double[u.length];
                    for (int a = 0; a < cand.length; ++a) {
                        cand[a] = GLRMParameters.mloss(u, a, multi_loss);
                    }
                    return ArrayUtils.minIndex((double[])cand);
                }
            }
            throw new RuntimeException("Unknown multidimensional loss function " + (Object)((Object)multi_loss));
        }

        public static enum Regularizer {
            None,
            Quadratic,
            L2,
            L1,
            NonNegative,
            OneSparse,
            UnitOneSparse,
            Simplex;

        }

        public static enum Loss {
            Quadratic(true),
            Absolute(true),
            Huber(true),
            Poisson(true),
            Periodic(true),
            Logistic(true, true),
            Hinge(true, true),
            Categorical(false),
            Ordinal(false);

            private boolean forNumeric;
            private boolean forBinary;

            private Loss(boolean forNumeric) {
                this(forNumeric, false);
            }

            private Loss(boolean forNumeric, boolean forBinary) {
                this.forNumeric = forNumeric;
                this.forBinary = forBinary;
            }

            public boolean isForNumeric() {
                return this.forNumeric;
            }

            public boolean isForCategorical() {
                return !this.forNumeric;
            }

            public boolean isForBinary() {
                return this.forBinary;
            }
        }
    }
}

