/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.Distribution;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.DeepLearningParameters;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.DeepLearningTask2;
import hex.schemas.DeepLearningV3;
import hex.schemas.ModelBuilderSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Job;
import water.Key;
import water.Keyed;
import water.Scope;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.init.Linpack;
import water.init.NetworkTest;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;

public class DeepLearning
extends ModelBuilder<DeepLearningModel, DeepLearningParameters, DeepLearningModel.DeepLearningModelOutput> {
    public DeepLearning(DeepLearningParameters parms) {
        super("DeepLearning", (Model.Parameters)parms);
        this.init(false);
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial, ModelCategory.AutoEncoder};
    }

    public ModelBuilderSchema schema() {
        return new DeepLearningV3();
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public boolean isSupervised() {
        return !((DeepLearningParameters)this._parms)._autoencoder;
    }

    protected Job<DeepLearningModel> trainModelImpl(long work, boolean restartTimer) {
        return this.start(new DeepLearningDriver(), work, restartTimer);
    }

    public long progressUnits() {
        long work = 1L;
        if (null != this._train) {
            work = (long)(((DeepLearningParameters)this._parms)._epochs * (double)this._train.numRows());
        }
        return Math.max(1L, work);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        ((DeepLearningParameters)this._parms).validate(this, expensive);
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, DeepLearningParameters parms) {
        double x = 0.782347234;
        boolean identityLink = new Distribution(parms._distribution, parms._tweedie_power).link(x) == x;
        return new DataInfo(Key.make(), train, valid, parms._autoencoder ? 0 : 1, parms._autoencoder || parms._use_all_factor_levels, parms._autoencoder ? DataInfo.TransformType.NORMALIZE : (parms._sparse ? DataInfo.TransformType.DESCALE : DataInfo.TransformType.STANDARDIZE), train.lastVec().isCategorical() ? DataInfo.TransformType.NONE : (identityLink ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE), parms._missing_values_handling == DeepLearningParameters.MissingValuesHandling.Skip, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
    }

    protected void checkMemoryFootPrint() {
        int layer;
        if (((DeepLearningParameters)this._parms)._checkpoint != null) {
            return;
        }
        long p = this._train.degreesOfFreedom() - (long)(((DeepLearningParameters)this._parms)._autoencoder ? 0 : this._train.lastVec().cardinality());
        String[][] dom = this._train.domains();
        for (int i = 0; i < this._train.numCols() - (((DeepLearningParameters)this._parms)._autoencoder ? 0 : 1); ++i) {
            if (dom[i] == null) continue;
            ++p;
        }
        long output = ((DeepLearningParameters)this._parms)._autoencoder ? p : (long)Math.abs(this._train.lastVec().cardinality());
        long model_size = p * (long)((DeepLearningParameters)this._parms)._hidden[0];
        for (layer = 1; layer < ((DeepLearningParameters)this._parms)._hidden.length; ++layer) {
            model_size += (long)(((DeepLearningParameters)this._parms)._hidden[layer - 1] * ((DeepLearningParameters)this._parms)._hidden[layer]);
        }
        model_size += (long)((DeepLearningParameters)this._parms)._hidden[layer - 1] * output;
        for (layer = 0; layer < ((DeepLearningParameters)this._parms)._hidden.length; ++layer) {
            model_size += (long)((DeepLearningParameters)this._parms)._hidden[layer];
        }
        if ((double)(model_size += output) > 1.0E8) {
            String msg = "Model is too large: " + model_size + " parameters. Try reducing the number of neurons in the hidden layers (or reduce the number of categorical factors).";
            this.error("_hidden", msg);
            this.cancel(msg);
        }
    }

    public void modifyParmsForCrossValidationSplits(int i, int N, Key<Model> model_id) {
        super.modifyParmsForCrossValidationSplits(i, N, model_id);
        if (((DeepLearningParameters)this._parms)._overwrite_with_best_model) {
            if (!((DeepLearningParameters)this._parms)._quiet_mode) {
                this.warn("_overwrite_with_best_model", "Disabling overwrite_with_best_model for cross-validation split " + (i + 1) + "/" + N + ": No early stopping.");
            }
            ((DeepLearningParameters)this._parms)._overwrite_with_best_model = false;
        }
    }

    public void modifyParmsForCrossValidationMainModel(int N, Key<Model>[] cvModelBuilderKeys) {
        super.modifyParmsForCrossValidationMainModel(N, cvModelBuilderKeys);
        if (((DeepLearningParameters)this._parms)._overwrite_with_best_model) {
            if (!((DeepLearningParameters)this._parms)._quiet_mode) {
                this.warn("_overwrite_with_best_model", "Disabling overwrite_with_best_model for cross-validation main model: No early stopping.");
            }
            ((DeepLearningParameters)this._parms)._overwrite_with_best_model = false;
        }
        if (cvModelBuilderKeys != null && ((DeepLearningParameters)this._parms)._stopping_rounds > 0) {
            double[] epochs = new double[cvModelBuilderKeys.length];
            for (int i = 0; i < epochs.length; ++i) {
                epochs[i] = ((DeepLearningModel)DKV.getGet((Key)((DeepLearning)DKV.getGet(cvModelBuilderKeys[i])).dest())).last_scored().epoch_counter;
            }
            ((DeepLearningParameters)this._parms)._epochs = ArrayUtils.sum((double[])epochs) / (double)epochs.length;
            if (!((DeepLearningParameters)this._parms)._quiet_mode) {
                this.warn("_epochs", "Setting optimal _epochs to " + ((DeepLearningParameters)this._parms)._epochs + " for cross-validation main model based on early stopping of cross-validation models.");
            }
            ((DeepLearningParameters)this._parms)._stopping_rounds = 0;
            if (!((DeepLearningParameters)this._parms)._quiet_mode) {
                this.warn("_stopping_rounds", "Disabling convergence-based early stopping for cross-validation main model.");
            }
        }
    }

    public class DeepLearningDriver
    extends H2O.H2OCountedCompleter<DeepLearningDriver> {
        transient HashSet<Frame> _delete_me;

        protected DeepLearningDriver() {
            super(true);
            this._delete_me = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block9: {
                try {
                    long cs = ((DeepLearningParameters)DeepLearning.this._parms).checksum();
                    DeepLearning.this.init(true);
                    ((DeepLearningParameters)DeepLearning.this._parms).read_lock_frames((Job)DeepLearning.this);
                    if (DeepLearning.this.error_count() > 0) {
                        DeepLearning.this.updateValidationMessages();
                        throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)DeepLearning.this);
                    }
                    this.buildModel();
                    if (DeepLearning.this.isRunning()) {
                        DeepLearning.this.done();
                    }
                    long cs2 = ((DeepLearningParameters)DeepLearning.this._parms).checksum();
                    assert (cs == cs2);
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)DeepLearning.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block9;
                    }
                    t.printStackTrace();
                    DeepLearning.this.failed(t);
                    throw t;
                }
                finally {
                    DeepLearning.this.updateModelOutput();
                    ((DeepLearningParameters)DeepLearning.this._parms).read_unlock_frames((Job)DeepLearning.this);
                }
            }
            this.tryComplete();
        }

        Key self() {
            return DeepLearning.this._key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel() {
            Scope.enter();
            DeepLearningModel cp = null;
            if (((DeepLearningParameters)DeepLearning.this._parms)._checkpoint == null) {
                cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningParameters)DeepLearning.this._parms, new DeepLearningModel.DeepLearningModelOutput(DeepLearning.this), DeepLearning.this._train, DeepLearning.this._valid, DeepLearning.this.nclasses());
                cp.model_info().initializeMembers();
            } else {
                DeepLearningModel previous = (DeepLearningModel)DKV.getGet((Key)((DeepLearningParameters)DeepLearning.this._parms)._checkpoint);
                if (previous == null) {
                    throw new IllegalArgumentException("Checkpoint not found.");
                }
                Log.info((Object[])new Object[]{"Resuming from checkpoint."});
                new Job.ProgressUpdate("Resuming from checkpoint").fork(DeepLearning.this._progressKey);
                if (DeepLearning.this.isClassifier() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isClassifier()) {
                    throw new H2OIllegalArgumentException("Response type must be the same as for the checkpointed model.");
                }
                if (DeepLearning.this.isSupervised() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isSupervised()) {
                    throw new H2OIllegalArgumentException("Model type must be the same as for the checkpointed model.");
                }
                DeepLearningParameters oldP = (DeepLearningParameters)previous._parms;
                DeepLearningParameters newP = (DeepLearningParameters)DeepLearning.this._parms;
                DeepLearningParameters oldP2 = (DeepLearningParameters)oldP.clone();
                DeepLearningParameters newP2 = (DeepLearningParameters)newP.clone();
                DeepLearningParameters.Sanity.modifyParms(oldP, oldP2, DeepLearning.this.nclasses());
                DeepLearningParameters.Sanity.modifyParms(newP, newP2, DeepLearning.this.nclasses());
                DeepLearningParameters.Sanity.checkpoint(oldP2, newP2);
                try {
                    DataInfo dinfo = DeepLearning.makeDataInfo(DeepLearning.this._train, DeepLearning.this._valid, (DeepLearningParameters)DeepLearning.this._parms);
                    DKV.put((Keyed)dinfo);
                    cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningParameters)DeepLearning.this._parms, previous, false, dinfo);
                    cp.write_lock(this.self());
                    if (!Arrays.equals(((DeepLearningModel.DeepLearningModelOutput)cp._output)._names, ((DeepLearningModel.DeepLearningModelOutput)previous._output)._names)) {
                        throw new H2OIllegalArgumentException("The columns of the training data must be the same as for the checkpointed model. Check ignored columns (or disable ignore_const_cols).");
                    }
                    if (!Arrays.deepEquals((Object[])((DeepLearningModel.DeepLearningModelOutput)cp._output)._domains, (Object[])((DeepLearningModel.DeepLearningModelOutput)previous._output)._domains)) {
                        throw new H2OIllegalArgumentException("Categorical factor levels of the training data must be the same as for the checkpointed model.");
                    }
                    if (dinfo.fullN() != previous.model_info().data_info().fullN()) {
                        throw new H2OIllegalArgumentException("Total number of predictors is different than for the checkpointed model.");
                    }
                    if (((DeepLearningParameters)DeepLearning.this._parms)._epochs <= previous.epoch_counter) {
                        throw new H2OIllegalArgumentException("Total number of epochs must be larger than the number of epochs already trained for the checkpointed model (" + previous.epoch_counter + ").");
                    }
                    DeepLearningParameters actualNewP = cp.model_info().get_params();
                    assert (actualNewP != previous.model_info().get_params());
                    assert (actualNewP != newP);
                    assert (actualNewP != oldP);
                    DeepLearningParameters.Sanity.update(actualNewP, newP, DeepLearning.this.nclasses());
                    Log.info((Object[])new Object[]{"Continuing training after " + String.format("%.3f", previous.epoch_counter) + " epochs from the checkpointed model."});
                    cp.update(this.self());
                }
                catch (H2OIllegalArgumentException ex) {
                    if (cp != null) {
                        cp.unlock(this.self());
                        cp.delete();
                        cp = null;
                    }
                    throw ex;
                }
                finally {
                    if (cp != null) {
                        cp.unlock(this.self());
                    }
                }
            }
            this.trainModel(cp);
            ArrayList<Key> keep = new ArrayList<Key>();
            try {
                keep.add(DeepLearning.this.dest());
                keep.add(cp.model_info().data_info()._key);
                keep.add(((DeepLearningModel.DeepLearningModelOutput)cp._output)._training_metrics._key);
                if (((DeepLearningModel.DeepLearningModelOutput)cp._output)._validation_metrics != null) {
                    keep.add(((DeepLearningModel.DeepLearningModelOutput)cp._output)._validation_metrics._key);
                }
                if (((DeepLearningModel.DeepLearningModelOutput)cp._output).weights != null && ((DeepLearningModel.DeepLearningModelOutput)cp._output).biases != null) {
                    for (Key k : Arrays.asList(((DeepLearningModel.DeepLearningModelOutput)cp._output).weights)) {
                        keep.add(k);
                        for (Vec vk : ((Frame)DKV.getGet((Key)k)).vecs()) {
                            keep.add(vk._key);
                        }
                    }
                    for (Key k : Arrays.asList(((DeepLearningModel.DeepLearningModelOutput)cp._output).biases)) {
                        keep.add(k);
                        for (Vec vk : ((Frame)DKV.getGet((Key)k)).vecs()) {
                            keep.add(vk._key);
                        }
                    }
                }
            }
            finally {
                Scope.exit((Key[])keep.toArray(new Key[0]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DeepLearningModel trainModel(DeepLearningModel model) {
            Frame validScoreFrame = null;
            try {
                DeepLearningModel best_model;
                if (model == null) {
                    model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                }
                Log.info((Object[])new Object[]{"Model category: " + (((DeepLearningParameters)DeepLearning.this._parms)._autoencoder ? "Auto-Encoder" : (DeepLearning.this.isClassifier() ? "Classification" : "Regression"))});
                long model_size = model.model_info().size();
                Log.info((Object[])new Object[]{"Number of model parameters (weights/biases): " + String.format("%,d", model_size)});
                model.write_lock(this.self());
                new Job.ProgressUpdate("Setting up training data...").fork(DeepLearning.this._progressKey);
                DeepLearningParameters mp = model.model_info().get_params();
                Frame tra_fr = new Frame(mp._train, DeepLearning.this._train.names(), DeepLearning.this._train.vecs());
                Frame val_fr = DeepLearning.this._valid != null ? new Frame(mp._valid, DeepLearning.this._valid.names(), DeepLearning.this._valid.vecs()) : null;
                Frame train = tra_fr;
                if (mp._force_load_balance) {
                    new Job.ProgressUpdate("Load balancing training data...").fork(DeepLearning.this._progressKey);
                    train = this.reBalance(train, mp._replicate_training_data, mp._train.toString() + "." + model._key.toString() + ".temporary.train");
                }
                if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes) {
                    new Job.ProgressUpdate("Balancing class distribution of training data...").fork(DeepLearning.this._progressKey);
                    float[] trainSamplingFactors = new float[train.lastVec().domain().length];
                    if (mp._class_sampling_factors != null) {
                        if (mp._class_sampling_factors.length != train.lastVec().domain().length) {
                            throw new IllegalArgumentException("class_sampling_factors must have " + train.lastVec().domain().length + " elements");
                        }
                        trainSamplingFactors = (float[])mp._class_sampling_factors.clone();
                    }
                    train = MRUtils.sampleFrameStratified((Frame)train, (Vec)train.lastVec(), (Vec)train.vec(((DeepLearningModel.DeepLearningModelOutput)model._output).weightsName()), (float[])trainSamplingFactors, (long)((long)(mp._max_after_balance_size * (float)train.numRows())), (long)mp._seed, (boolean)true, (boolean)false);
                    Vec l = train.lastVec();
                    Vec w = train.vec(((DeepLearningModel.DeepLearningModelOutput)model._output).weightsName());
                    MRUtils.ClassDist cd = new MRUtils.ClassDist(l);
                    ((DeepLearningModel.DeepLearningModelOutput)model._output)._modelClassDist = DeepLearning.this._weights != null ? ((MRUtils.ClassDist)cd.doAll(new Vec[]{l, w})).rel_dist() : ((MRUtils.ClassDist)cd.doAll(new Vec[]{l})).rel_dist();
                }
                model.training_rows = train.numRows();
                Frame trainScoreFrame = MRUtils.sampleFrame((Frame)train, (long)mp._score_training_samples, (long)mp._seed);
                if (trainScoreFrame != train) {
                    this._delete_me.add(trainScoreFrame);
                }
                if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.info((Object[])new Object[]{"Number of chunks of the training data: " + train.anyVec().nChunks()});
                }
                if (val_fr != null) {
                    model.validation_rows = val_fr.numRows();
                    if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes && mp._score_validation_sampling == DeepLearningParameters.ClassSamplingMethod.Stratified) {
                        new Job.ProgressUpdate("Sampling validation data (stratified)...").fork(DeepLearning.this._progressKey);
                        validScoreFrame = MRUtils.sampleFrameStratified((Frame)val_fr, (Vec)val_fr.lastVec(), (Vec)val_fr.vec(((DeepLearningModel.DeepLearningModelOutput)model._output).weightsName()), null, (long)(mp._score_validation_samples > 0L ? mp._score_validation_samples : val_fr.numRows()), (long)(mp._seed + 1L), (boolean)false, (boolean)false);
                    } else {
                        new Job.ProgressUpdate("Sampling validation data...").fork(DeepLearning.this._progressKey);
                        validScoreFrame = MRUtils.sampleFrame((Frame)val_fr, (long)mp._score_validation_samples, (long)(mp._seed + 1L));
                        if (validScoreFrame != val_fr) {
                            this._delete_me.add(validScoreFrame);
                        }
                    }
                    if (mp._force_load_balance) {
                        new Job.ProgressUpdate("Balancing class distribution of validation data...").fork(DeepLearning.this._progressKey);
                        validScoreFrame = this.reBalance(validScoreFrame, false, mp._valid.toString() + "." + model._key.toString() + ".temporary.valid");
                    }
                    if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"Number of chunks of the validation data: " + validScoreFrame.anyVec().nChunks()});
                    }
                }
                model.actual_train_samples_per_iteration = this.computeTrainSamplesPerIteration(mp, train.numRows(), model);
                if (mp._replicate_training_data && model.actual_train_samples_per_iteration == train.numRows() * (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) && !mp._shuffle_training_data && H2O.CLOUD.size() > 1 && !mp._reproducible) {
                    if (!mp._quiet_mode) {
                        Log.info((Object[])new Object[]{"Enabling training data shuffling, because all nodes train on the full dataset (replicated training data)."});
                    }
                    mp._shuffle_training_data = true;
                }
                if (!mp._shuffle_training_data && model.actual_train_samples_per_iteration == train.numRows() && train.anyVec().nChunks() == 1) {
                    if (!mp._quiet_mode) {
                        Log.info((Object[])new Object[]{"Enabling training data shuffling to avoid training rows in the same order over and over (no Hogwild since there's only 1 chunk)."});
                    }
                    mp._shuffle_training_data = true;
                }
                model._timeLastIterationEnter = System.currentTimeMillis();
                if (((DeepLearningParameters)DeepLearning.this._parms)._autoencoder) {
                    new Job.ProgressUpdate("Scoring null model of autoencoder...").fork(DeepLearning.this._progressKey);
                    if (!mp._quiet_mode) {
                        Log.info((Object[])new Object[]{"Scoring the null model of the autoencoder."});
                    }
                    model.doScoring(trainScoreFrame, validScoreFrame, this.self(), null, 0, false);
                }
                model.update(this.self());
                Log.info((Object[])new Object[]{"Starting to train the Deep Learning model."});
                new Job.ProgressUpdate("Training...").fork(DeepLearning.this._progressKey);
                do {
                    ++model.iterations;
                    model.set_model_info(mp._epochs == 0.0 ? model.model_info() : (H2O.CLOUD.size() > 1 && mp._replicate_training_data ? (mp._single_node_mode ? ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, model.model_info(), this.rowFraction(train, mp, model), model.iterations).doAll(new Key[]{Key.make((H2ONode)H2O.SELF)})).model_info() : ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, model.model_info(), this.rowFraction(train, mp, model), model.iterations).doAllNodes()).model_info()) : ((DeepLearningTask)new DeepLearningTask(this.self(), model.model_info(), this.rowFraction(train, mp, model), model.iterations).doAll(train)).model_info()));
                } while (DeepLearning.this.isRunning() && model.doScoring(trainScoreFrame, validScoreFrame, this.self(), DeepLearning.this._progressKey, model.iterations, false));
                if (DeepLearning.this.isRunning() && ((DeepLearningParameters)DeepLearning.this._parms)._overwrite_with_best_model && model.actual_best_model_key != null && ((DeepLearningParameters)DeepLearning.this._parms)._nfolds == 0 && (best_model = (DeepLearningModel)DKV.getGet((Key)model.actual_best_model_key)) != null && best_model.loss() < model.loss() && Arrays.equals(best_model.model_info().units, model.model_info().units)) {
                    if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"Setting the model to be the best model so far (based on scoring history)."});
                    }
                    DeepLearningModelInfo mi = best_model.model_info().deep_clone();
                    mi.set_processed_global(model.model_info().get_processed_global());
                    mi.set_processed_local(model.model_info().get_processed_local());
                    model.set_model_info(mi);
                    model.update(this.self());
                    model.doScoring(trainScoreFrame, validScoreFrame, this.self(), DeepLearning.this._progressKey, model.iterations, true);
                    assert (best_model.loss() == model.loss());
                }
                if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
                    if (DeepLearning.this.isCancelledOrCrashed()) {
                        Log.info((Object[])new Object[]{"Deep Learning model training was interrupted."});
                    } else {
                        Log.info((Object[])new Object[]{"Finished training the Deep Learning model."});
                        Log.info((Object[])new Object[]{model});
                    }
                    Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
                }
            }
            finally {
                if (model != null) {
                    model.deleteElasticAverageModels();
                    model.unlock(this.self());
                    if (model.actual_best_model_key != null) {
                        assert (model.actual_best_model_key != model._key);
                        DKV.remove((Key)model.actual_best_model_key);
                    }
                }
                for (Frame f : this._delete_me) {
                    f.delete();
                }
            }
            return model;
        }

        private Frame reBalance(Frame fr, boolean local, String name) {
            int chunks = (int)Math.min((long)(4 * H2O.NUMCPUS * (local ? 1 : H2O.CLOUD.size())), fr.numRows());
            if (fr.anyVec().nChunks() > chunks && !((DeepLearningParameters)DeepLearning.this._parms)._reproducible) {
                if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.info((Object[])new Object[]{"Dataset already contains " + fr.anyVec().nChunks() + " chunks. No need to rebalance."});
                }
                return fr;
            }
            if (((DeepLearningParameters)DeepLearning.this._parms)._reproducible) {
                if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.warn((Object[])new Object[]{"Reproducibility enforced - using only 1 thread - can be slow."});
                }
                chunks = 1;
            }
            if (!((DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                Log.info((Object[])new Object[]{"ReBalancing dataset into (at least) " + chunks + " chunks."});
            }
            Key newKey = Key.make((String)(name + ".chunks" + chunks));
            RebalanceDataSet rb = new RebalanceDataSet(fr, newKey, chunks);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            Frame f = (Frame)DKV.get((Key)newKey).get();
            this._delete_me.add(f);
            return f;
        }

        private long computeTrainSamplesPerIteration(DeepLearningParameters mp, long numRows, DeepLearningModel model) {
            long tspi = mp._train_samples_per_iteration;
            assert (tspi == 0L || tspi == -1L || tspi == -2L || tspi >= 1L);
            if (tspi == 0L || !mp._replicate_training_data && tspi == -1L) {
                tspi = numRows;
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to one epoch: #rows (" + tspi + ")."});
                }
            } else if (tspi == -1L) {
                tspi = (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows;
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to #nodes x #rows (" + tspi + ")."});
                }
            } else if (tspi == -2L) {
                double total_gflops = 0.0;
                for (H2ONode h2o : H2O.CLOUD._memary) {
                    HeartBeat hb = h2o._heartbeat;
                    total_gflops += hb._gflops;
                }
                if (mp._single_node_mode) {
                    total_gflops /= (double)H2O.CLOUD.size();
                }
                if (total_gflops == 0.0) {
                    total_gflops = Linpack.run((int)H2O.SELF._heartbeat._cpus_allowed) * (double)(mp._single_node_mode ? 1 : H2O.CLOUD.size());
                }
                long model_size = model.model_info().size();
                int[] msg_sizes = new int[]{1, (long)((int)(model_size * 4L)) == model_size * 4L ? (int)(model_size * 4L) : Integer.MAX_VALUE};
                double[] microseconds_collective = new double[msg_sizes.length];
                NetworkTest.NetworkTester nt = new NetworkTest.NetworkTester(msg_sizes, (double[][])null, microseconds_collective, (double)model_size > 1000000.0 ? 1 : 5, false, true);
                nt.compute2();
                int network_queue_length = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 1 : 2 * (int)Math.floor(Math.log(H2O.CLOUD.size()) / Math.log(2.0));
                double flops_overhead_per_row = 50.0;
                if (mp._activation == DeepLearningParameters.Activation.Maxout || mp._activation == DeepLearningParameters.Activation.MaxoutWithDropout) {
                    flops_overhead_per_row *= 8.0;
                } else if (mp._activation == DeepLearningParameters.Activation.Tanh || mp._activation == DeepLearningParameters.Activation.TanhWithDropout) {
                    flops_overhead_per_row *= 5.0;
                }
                double fraction = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 0.001 : mp._target_ratio_comm_to_comp;
                model.time_for_communication_us = (H2O.CLOUD.size() == 1 ? 10000.0 : 100000.0) + (double)network_queue_length * microseconds_collective[1];
                double time_per_row_us = (flops_overhead_per_row * (double)model_size + (double)(10000 * model.model_info().units[0])) / (total_gflops * 1.0E9) / (double)H2O.SELF._heartbeat._cpus_allowed * 1000000.0;
                tspi = (long)((model.time_for_communication_us / fraction - model.time_for_communication_us) / time_per_row_us);
                tspi = Math.min(tspi, (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows * 10L);
                if (tspi > numRows && (double)Math.abs(tspi % numRows) / (double)numRows < 0.2) {
                    tspi -= tspi % numRows;
                }
                tspi = Math.min(tspi, (long)(mp._epochs * (double)numRows / 10.0));
                if (H2O.CLOUD.size() == 1 || mp._single_node_mode) {
                    tspi = Math.min(tspi, (long)(10 * (int)(1000000.0 / time_per_row_us)));
                }
                tspi = Math.max(1L, tspi);
                tspi = Math.min((long)(100000 * H2O.CLOUD.size()), tspi);
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Auto-tuning parameter 'train_samples_per_iteration':"});
                    Log.info((Object[])new Object[]{"Estimated compute power : " + (int)total_gflops + " GFlops"});
                    Log.info((Object[])new Object[]{"Estimated time for comm : " + PrettyPrint.usecs((long)((long)model.time_for_communication_us))});
                    Log.info((Object[])new Object[]{"Estimated time per row  : " + ((long)time_per_row_us > 0L ? PrettyPrint.usecs((long)((long)time_per_row_us)) : time_per_row_us + " usecs")});
                    Log.info((Object[])new Object[]{"Estimated training speed: " + (int)(1000000.0 / time_per_row_us) + " rows/sec"});
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to auto-tuned value: " + tspi});
                }
            } else {
                tspi = Math.max(1L, Math.min(tspi, (long)(mp._epochs * (double)numRows)));
            }
            assert (tspi != 0L && tspi != -1L && tspi != -2L && tspi >= 1L);
            model.tspiGuess = tspi;
            return tspi;
        }

        private float computeRowUsageFraction(long numRows, long train_samples_per_iteration, boolean replicate_training_data) {
            float rowUsageFraction = (float)train_samples_per_iteration / (float)numRows;
            if (replicate_training_data) {
                rowUsageFraction /= (float)H2O.CLOUD.size();
            }
            assert (rowUsageFraction > 0.0f);
            return rowUsageFraction;
        }

        private float rowFraction(Frame train, DeepLearningParameters p, DeepLearningModel m) {
            return this.computeRowUsageFraction(train.numRows(), m.actual_train_samples_per_iteration, p._replicate_training_data);
        }
    }
}

