/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.FrameTask2;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMValidation;
import hex.gram.Gram;
import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.C0DChunk;
import water.fvec.CBSChunk;
import water.fvec.Chunk;
import water.util.ArrayUtils;

public abstract class GLMTask {
    static double computeMultinomialEtas(DataInfo.Row row, double[][] beta, double[] etas, double[] etaOffsets, double[] exps) {
        double maxRow = 0.0;
        for (int c = 0; c < beta.length; ++c) {
            double e = etaOffsets[c] + row.innerProduct(beta[c]);
            if (e > maxRow) {
                maxRow = e;
            }
            etas[c] = e;
        }
        double sumExp = 0.0;
        for (int c = 0; c < beta.length; ++c) {
            double x = Math.exp(etas[c] - maxRow);
            sumExp += x;
            exps[c + 1] = x;
        }
        double reg = 1.0 / sumExp;
        for (int c = 0; c < etas.length; ++c) {
            int n = c + 1;
            exps[n] = exps[n] * reg;
        }
        exps[0] = 0.0;
        exps[0] = ArrayUtils.maxIndex((double[])exps) - 1;
        return Math.log(sumExp) + maxRow;
    }

    public static class GLMGenerateWeightsTask
    extends MRTask<GLMGenerateWeightsTask> {
        final GLMModel.GLMParameters _params;
        final double[] _betaw;
        double[] denums;
        double wsum;
        double wsumu;
        DataInfo _dinfo;
        double _likelihood;

        public GLMGenerateWeightsTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters glm, double[] betaw) {
            this._params = glm;
            this._betaw = betaw;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            Chunk wChunk = chunks[chunks.length - 3];
            Chunk zChunk = chunks[chunks.length - 2];
            Chunk zTilda = chunks[chunks.length - 1];
            chunks = Arrays.copyOf(chunks, chunks.length - 3);
            this.denums = new double[this._dinfo.fullN() + 1];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                int j;
                double mu;
                double z;
                double w;
                this._dinfo.extractDenseRow(chunks, i, r);
                if (r.bad || r.weight == 0.0) {
                    wChunk.set(i, 0L);
                    zChunk.set(i, 0L);
                    zTilda.set(i, 0L);
                    continue;
                }
                double y = r.response(0);
                assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
                assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
                int numStart = this._dinfo.numStart();
                double d = 1.0;
                double eta = r.innerProduct(this._betaw);
                if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                    w = r.weight;
                    z = y - r.offset;
                    mu = 0.0;
                } else {
                    mu = this._params.linkInv(eta + r.offset);
                    double var = Math.max(1.0E-6, this._params.variance(mu));
                    d = this._params.linkDeriv(mu);
                    z = eta + (y - mu) * d;
                    w = r.weight / (var * d * d);
                }
                this._likelihood += this._params.likelihood(y, mu);
                zTilda.set(i, eta - this._betaw[this._betaw.length - 1]);
                assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
                wChunk.set(i, w);
                zChunk.set(i, z);
                this.wsum += w;
                this.wsumu += r.weight;
                for (j = 0; j < r.nBins; ++j) {
                    int n = r.binIds[j];
                    this.denums[n] = this.denums[n] + w;
                }
                for (j = 0; j < r.nNums; ++j) {
                    int id;
                    int n = id = r.numIds == null ? j + numStart : r.numIds[j];
                    this.denums[n] = this.denums[n] + w * r.get(id) * r.get(id);
                }
            }
        }

        public void reduce(GLMGenerateWeightsTask git) {
            ArrayUtils.add((double[])this.denums, (double[])git.denums);
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqIntercept
    extends MRTask<GLMCoordinateDescentTaskSeqIntercept> {
        final double[] _betaold;
        public double _temp;
        DataInfo _dinfo;

        public GLMCoordinateDescentTaskSeqIntercept(double[] betaold, DataInfo dinfo) {
            this._betaold = betaold;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk filterChunk = chunks[cnt++];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                if (filterChunk.atd(i) == 1.0) continue;
                this._dinfo.extractDenseRow(chunks, i, r);
                this._temp = (double)wChunk.at8(i) * (zChunk.atd(i) - r.innerProduct(this._betaold));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqIntercept git) {
            this._temp += git._temp;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqNaive
    extends MRTask<GLMCoordinateDescentTaskSeqNaive> {
        public double[] _normMulold;
        public double[] _normSubold;
        public double[] _normMulnew;
        public double[] _normSubnew;
        final double[] _betaold;
        final double[] _betanew;
        final int[] _catLvls_new;
        final int[] _catLvls_old;
        public double[] _temp;
        boolean _skipFirst;
        long _nobs;
        int _cat_num;
        boolean _interceptnew;
        boolean _interceptold;

        public GLMCoordinateDescentTaskSeqNaive(boolean interceptold, boolean interceptnew, int cat_num, double[] betaold, double[] betanew, int[] catLvlsold, int[] catLvlsnew, double[] normMulold, double[] normSubold, double[] normMulnew, double[] normSubnew, boolean skipFirst) {
            this._normMulold = normMulold;
            this._normSubold = normSubold;
            this._normMulnew = normMulnew;
            this._normSubnew = normSubnew;
            this._cat_num = cat_num;
            this._betaold = betaold;
            this._betanew = betanew;
            this._interceptold = interceptold;
            this._interceptnew = interceptnew;
            this._catLvls_old = catLvlsold;
            this._catLvls_new = catLvlsnew;
            this._skipFirst = skipFirst;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk ztildaChunk = chunks[cnt++];
            Chunk xpChunk = null;
            Chunk xChunk = null;
            this._temp = new double[this._betaold.length];
            if (this._interceptnew) {
                xChunk = new C0DChunk(1.0, chunks[0]._len);
                xpChunk = chunks[cnt++];
            } else if (this._interceptold) {
                xChunk = chunks[cnt++];
                xpChunk = new C0DChunk(1.0, chunks[0]._len);
            } else {
                xChunk = chunks[cnt++];
                xpChunk = chunks[cnt++];
            }
            for (int i = 0; i < chunks[0]._len; ++i) {
                double betanew = 0.0;
                double betaold = 0.0;
                double w = wChunk.atd(i);
                if (w == 0.0) continue;
                ++this._nobs;
                int observation_level = 0;
                int observation_level_p = 0;
                double val = 1.0;
                double valp = 1.0;
                if (this._cat_num == 1) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                        --observation_level_p;
                    }
                } else if (this._cat_num == 2) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level_p;
                    }
                } else if (this._cat_num == 3) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                } else if (this._cat_num == 4) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                }
                if (observation_level >= 0) {
                    betaold = this._betaold[observation_level];
                }
                if (observation_level_p >= 0) {
                    betanew = this._betanew[observation_level_p];
                }
                if (this._interceptnew) {
                    ztildaChunk.set(i, ztildaChunk.atd(i) - betaold + valp * betanew);
                    this._temp[0] = this._temp[0] + w * (zChunk.atd(i) - ztildaChunk.atd(i));
                    continue;
                }
                ztildaChunk.set(i, ztildaChunk.atd(i) - val * betaold + valp * betanew);
                if (observation_level < 0) continue;
                int n = observation_level;
                this._temp[n] = this._temp[n] + w * val * (zChunk.atd(i) - ztildaChunk.atd(i));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqNaive git) {
            ArrayUtils.add((double[])this._temp, (double[])git._temp);
            this._nobs += git._nobs;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMIterationTask
    extends FrameTask2<GLMIterationTask> {
        final GLMModel.GLMParameters _params;
        final double[][] _beta_multinomial;
        final double[] _beta;
        final int _c;
        protected Gram _gram;
        double[] _xy;
        GLMValidation _val;
        final double[] _ymu;
        long _nobs;
        final boolean _validate;
        int[] _ti;
        public double _likelihood;
        final double _lambda;
        double wsum;
        double wsumu;
        final boolean _intercept;
        private transient double[] _etas;
        private transient double[] _sparseOffsets;
        private transient double _sparseOffset;

        public GLMIterationTask(Key jobKey, DataInfo dinfo, double lambda, GLMModel.GLMParameters glm, boolean validate, double[][] betaMultinomial, double[] beta, int c, double[] ymu, boolean intercept, H2O.H2OCountedCompleter cmp) {
            super(cmp, dinfo, jobKey);
            this._params = glm;
            this._beta = beta;
            this._beta_multinomial = (double[][])betaMultinomial.clone();
            this._beta_multinomial[c] = beta;
            this._c = c;
            this._ymu = ymu;
            this._validate = validate;
            this._lambda = lambda;
            this._intercept = intercept;
        }

        public GLMIterationTask(Key jobKey, DataInfo dinfo, double lambda, GLMModel.GLMParameters glm, boolean validate, double[] beta, double ymu, boolean intercept, H2O.H2OCountedCompleter cmp) {
            super(cmp, dinfo, jobKey);
            this._params = glm;
            this._beta = beta;
            this._beta_multinomial = null;
            this._c = -1;
            this._ymu = new double[]{ymu};
            this._validate = validate;
            this._lambda = lambda;
            this._intercept = intercept;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            if (this._params._family == GLMModel.GLMParameters.Family.multinomial) {
                this._etas = new double[this._beta_multinomial.length];
            }
            if (this._validate) {
                String[] domain;
                int rank = 0;
                if (this._beta != null) {
                    for (double d : this._beta) {
                        if (d == 0.0) continue;
                        ++rank;
                    }
                }
                if ((domain = this._dinfo._adaptedFrame.lastVec().domain()) == null && this._params._family == GLMModel.GLMParameters.Family.binomial) {
                    domain = new String[]{"0", "1"};
                }
                this._val = new GLMValidation(domain, this._ymu, this._params, rank, 0.5, true, this._intercept);
            }
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._params._family == GLMModel.GLMParameters.Family.binomial && this._validate) {
                this._ti = new int[2];
            }
            if (this._params._family == GLMModel.GLMParameters.Family.multinomial) {
                this._sparseOffsets = new double[this._beta_multinomial.length];
                if (this._sparse) {
                    for (int i = 0; i < this._beta_multinomial.length; ++i) {
                        this._sparseOffsets[i] = GLM.sparseOffset(this._beta_multinomial[i], this._dinfo);
                    }
                }
            } else if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double eta;
            double mu;
            double wz;
            double w;
            if (r.bad || r.weight == 0.0) {
                return;
            }
            ++this._nobs;
            double y = r.response(0);
            assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
            assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
            int numStart = this._dinfo.numStart();
            double d = 1.0;
            if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                w = r.weight;
                wz = w * (y - r.offset);
                eta = mu = 0.0;
            } else if (this._params._family == GLMModel.GLMParameters.Family.multinomial) {
                y = y == (double)this._c ? 1.0 : 0.0;
                double maxrow = 0.0;
                for (int i2 = 0; i2 < this._beta_multinomial.length; ++i2) {
                    this._etas[i2] = r.innerProduct(this._beta_multinomial[i2]) + this._sparseOffsets[i2];
                    if (!(this._etas[i2] > maxrow)) continue;
                    maxrow = this._etas[i2];
                }
                eta = this._etas[this._c];
                double etaExp = Math.exp(this._etas[this._c] - maxrow);
                double sumExp = 0.0;
                for (int i3 = 0; i3 < this._beta_multinomial.length; ++i3) {
                    sumExp += Math.exp(this._etas[i3] - maxrow);
                }
                mu = etaExp / sumExp;
                if (mu < 1.0E-16) {
                    mu = 1.0E-16;
                }
                double logSumExp = Math.log(sumExp) + maxrow;
                this._likelihood -= r.weight * (this._etas[(int)r.response(0)] - logSumExp);
                d = mu * (1.0 - mu);
                wz = r.weight * (eta * d + (y - mu));
                w = r.weight * d;
            } else {
                eta = r.innerProduct(this._beta) + this._sparseOffset;
                mu = this._params.linkInv(eta + r.offset);
                this._likelihood += r.weight * this._params.likelihood(y, mu);
                double var = Math.max(1.0E-6, this._params.variance(mu));
                d = this._params.linkDeriv(mu);
                double z = eta + (y - mu) * d;
                w = r.weight / (var * d * d);
                wz = w * z;
                if (this._validate) {
                    this._val.add(y, mu, r.weight, r.offset);
                }
            }
            assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
            this.wsum += w;
            this.wsumu += r.weight;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        public void reduce(GLMIterationTask git) {
            ArrayUtils.add((double[])this._xy, (double[])git._xy);
            this._gram.add(git._gram);
            this._nobs += git._nobs;
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            if (this._validate) {
                this._val.reduce(git._val);
            }
            this._likelihood += git._likelihood;
            super.reduce((MRTask)git);
        }

        protected void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
            if (this._val != null) {
                this._val.computeAIC();
            }
        }

        public boolean hasNaNsOrInf() {
            return ArrayUtils.hasNaNsOrInfs((double[])this._xy) || this._gram.hasNaNsOrInfs();
        }
    }

    public static class LBFGS_LogisticGradientTask
    extends GLMGradientTask {
        public LBFGS_LogisticGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, boolean intercept) {
            super(dinfo, params, lambda, beta, reg, intercept);
        }

        @Override
        protected void goByRows(Chunk[] chks, boolean[] skp) {
            DataInfo.Row row = this._dinfo.newDenseRow();
            double[] g = this._gradient;
            double[] b = this._beta;
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                if (skp[rid]) continue;
                row = this._dinfo.extractDenseRow(chks, rid, row);
                if (row.bad || row.weight == 0.0) continue;
                double y = -1.0 + 2.0 * row.response(0);
                ++this._nobs;
                double eta = row.innerProduct(b) + row.offset;
                double d = 1.0 + Math.exp(-y * eta);
                this._likelihood += row.weight * Math.log(d);
                double gval = row.weight * -y * (1.0 - 1.0 / d);
                for (int i = 0; i < row.nBins; ++i) {
                    int n = row.binIds[i];
                    g[n] = g[n] + gval;
                }
                int off = this._dinfo.numStart();
                for (int j = 0; j < this._dinfo._nums; ++j) {
                    int n = j + off;
                    g[n] = g[n] + row.numVals[j] * gval;
                }
                if (!this._dinfo._intercept) continue;
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }

        @Override
        protected void goByCols(Chunk[] chks, boolean[] skp) {
            int r;
            int i;
            int numStart = this._dinfo.numStart();
            double[] eta = this.computeEtaByCols(chks, skp);
            double[] g = this._gradient;
            Chunk offsetChunk = null;
            int nxs = chks.length - 1;
            if (this._dinfo._offset) {
                offsetChunk = chks[--nxs];
            }
            Chunk responseChunk = chks[nxs];
            C0DChunk weightsChunk = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, chks[0]._len);
            double eta_sum = 0.0;
            for (int r2 = 0; r2 < chks[0]._len; ++r2) {
                double w = weightsChunk.atd(r2);
                if (skp[r2] || responseChunk.isNA(r2) || w == 0.0) continue;
                ++this._nobs;
                double off = this._dinfo._offset ? offsetChunk.atd(r2) : 0.0;
                double e = eta[r2] + off;
                switch (this._params._family) {
                    case gaussian: {
                        double diff = e - responseChunk.atd(r2);
                        this._likelihood += w * diff * diff;
                        eta[r2] = diff;
                        break;
                    }
                    case binomial: {
                        double y = -1.0 + 2.0 * responseChunk.atd(r2);
                        double d = 1.0 + Math.exp(-y * e);
                        this._likelihood += w * Math.log(d);
                        eta[r2] = w * -y * (1.0 - 1.0 / d);
                        break;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
                eta_sum += eta[r2];
            }
            if (this._dinfo._intercept) {
                g[g.length - 1] = eta_sum;
            }
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    g[numStart + i] = -this._dinfo._normSub[i] * this._dinfo._normMul[i] * eta_sum;
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (r = 0; r < c._len; ++r) {
                    int off;
                    if (skp[r] || (off = this._dinfo.getCategoricalId(i, (int)chks[i].at8(r))) == -1) continue;
                    int n = off;
                    g[n] = g[n] + eta[r];
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = numStart + i;
                        g[n] = g[n] + eta[r] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            this._skip = skp;
        }
    }

    static class GLMGradientTask
    extends MRTask<GLMGradientTask> {
        final GLMModel.GLMParameters _params;
        GLMValidation _val;
        double _currentLambda;
        final double[] _beta;
        protected final DataInfo _dinfo;
        final double _reg;
        public double[] _gradient;
        public double _likelihood;
        protected transient boolean[] _skip;
        boolean _validate;
        long _nobs;
        double _wsum;
        double _ymu;
        final boolean _intercept;
        private boolean _forceRows;
        private boolean _forceCols;

        public GLMGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, boolean intercept) {
            this(dinfo, params, lambda, beta, reg, intercept, null);
        }

        public GLMGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, boolean intercept, H2O.H2OCountedCompleter cc) {
            super(cc);
            this._dinfo = dinfo;
            this._params = params;
            this._beta = beta;
            this._reg = reg;
            this._currentLambda = lambda;
            this._intercept = intercept;
        }

        public GLMGradientTask setValidate(double ymu, boolean validate) {
            this._ymu = ymu;
            this._validate = validate;
            return this;
        }

        protected void goByRows(Chunk[] chks, boolean[] skp) {
            DataInfo.Row row = this._dinfo.newDenseRow();
            double[] g = this._gradient;
            double[] b = this._beta;
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                if (skp[rid]) continue;
                row = this._dinfo.extractDenseRow(chks, rid, row);
                if (row.weight == 0.0 || row.bad) continue;
                ++this._nobs;
                this._wsum += row.weight;
                double eta = row.innerProduct(b) + row.offset;
                double mu = this._params.linkInv(eta);
                this._val.add(row.response(0), mu, row.weight, row.offset);
                this._likelihood += row.weight * this._params.likelihood(row.response(0), mu);
                double var = this._params.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                double gval = row.weight * (mu - row.response(0)) / (var * this._params.linkDeriv(mu));
                for (int i = 0; i < row.nBins; ++i) {
                    int n = row.binIds[i];
                    g[n] = g[n] + gval;
                }
                int off = this._dinfo.numStart();
                for (int j = 0; j < this._dinfo._nums; ++j) {
                    int n = j + off;
                    g[n] = g[n] + row.numVals[j] * gval;
                }
                if (!this._dinfo._intercept) continue;
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            for (int j = 0; j < this._beta.length - (this._dinfo._intercept ? 1 : 0); ++j) {
                int n = j;
                this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[j];
            }
        }

        protected final double[] computeEtaByCols(Chunk[] chks, boolean[] skip) {
            int r;
            double[] eta = MemoryManager.malloc8d((int)chks[0]._len);
            if (this._dinfo._intercept) {
                Arrays.fill(eta, this._beta[this._beta.length - 1]);
            }
            if (this._dinfo._offset) {
                for (int i = 0; i < eta.length; ++i) {
                    if (skip[i]) continue;
                    int n = i;
                    eta[n] = eta[n] + chks[this._dinfo.offsetChunkId()].atd(i);
                    if (!Double.isNaN(eta[i])) continue;
                    skip[i] = true;
                }
            }
            double[] b = this._beta;
            for (int i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (int r2 = 0; r2 < c._len; ++r2) {
                    if (skip[r2] || c.isNA(r2)) {
                        skip[r2] = true;
                        continue;
                    }
                    int off = this._dinfo.getCategoricalId(i, (int)c.at8(r2));
                    if (off == -1) continue;
                    int n = r2;
                    eta[n] = eta[n] + b[off];
                }
            }
            int numStart = this._dinfo.numStart();
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                double off = 0.0;
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    off -= b[numStart + i] * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                }
                r = 0;
                while (r < chks[0]._len) {
                    int n = r++;
                    eta[n] = eta[n] + off;
                }
            }
            for (int i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                    } else {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = r;
                        eta[n] = eta[n] + b[numStart + i] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            return eta;
        }

        protected void goByCols(Chunk[] chks, boolean[] skp) {
            int r;
            int i;
            int numStart = this._dinfo.numStart();
            double[] eta = this.computeEtaByCols(chks, skp);
            double[] b = this._beta;
            double[] g = this._gradient;
            C0DChunk offsetChunk = this._dinfo._offset ? chks[this._dinfo.offsetChunkId()] : new C0DChunk(0.0, chks[0]._len);
            C0DChunk weightChunk = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, chks[0]._len);
            Chunk responseChunk = chks[this._dinfo.responseChunkId()];
            double eta_sum = 0.0;
            for (int r2 = 0; r2 < chks[0]._len; ++r2) {
                double w;
                if (skp[r2] || responseChunk.isNA(r2) || (w = weightChunk.atd(r2)) == 0.0 || Double.isNaN(w)) continue;
                ++this._nobs;
                this._wsum += w;
                assert (w > 0.0);
                double y = responseChunk.atd(r2);
                double mu = this._params.linkInv(eta[r2]);
                this._val.add(y, mu, w, offsetChunk.atd(r2));
                this._likelihood += w * this._params.likelihood(y, mu);
                double var = this._params.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                eta[r2] = w * (mu - y) / (var * this._params.linkDeriv(mu));
                eta_sum += eta[r2];
            }
            if (this._dinfo._intercept) {
                g[g.length - 1] = eta_sum;
            }
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    g[numStart + i] = -this._dinfo._normSub[i] * this._dinfo._normMul[i] * eta_sum;
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (r = 0; r < c._len; ++r) {
                    int off;
                    if (skp[r] || (off = this._dinfo.getCategoricalId(i, (int)chks[i].at8(r))) == -1) continue;
                    int n = off;
                    g[n] = g[n] + eta[r];
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = numStart + i;
                        g[n] = g[n] + eta[r] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            this._skip = skp;
        }

        private boolean mostlySparse(Chunk[] chks) {
            int cnt = 0;
            for (Chunk chk : chks) {
                if (!chk.isSparse()) continue;
                ++cnt;
            }
            return cnt >= chks.length >> 1;
        }

        public GLMGradientTask forceColAccess() {
            this._forceCols = true;
            this._forceRows = false;
            return this;
        }

        public GLMGradientTask forceRowAccess() {
            this._forceCols = false;
            this._forceRows = true;
            return this;
        }

        public void map(Chunk[] chks) {
            int rank = 0;
            for (int i = 0; i < this._beta.length; ++i) {
                if (this._beta[i] == 0.0) continue;
                ++rank;
            }
            this._gradient = MemoryManager.malloc8d((int)this._beta.length);
            String[] domain = this._dinfo._adaptedFrame.lastVec().domain();
            if (domain == null && this._params._family == GLMModel.GLMParameters.Family.binomial) {
                domain = new String[]{"0", "1"};
            }
            this._val = new GLMValidation(domain, new double[]{this._ymu}, this._params, rank, 0.0, this._validate, this._intercept);
            boolean[] skp = MemoryManager.mallocZ((int)chks[0]._len);
            if (this._forceCols || !this._forceRows && (chks.length >= 100 || this.mostlySparse(chks))) {
                this.goByCols(chks, skp);
            } else {
                this.goByRows(chks, skp);
            }
        }

        public void reduce(GLMGradientTask grt) {
            this._likelihood += grt._likelihood;
            this._nobs += grt._nobs;
            this._wsum += grt._wsum;
            this._val.reduce(grt._val);
            ArrayUtils.add((double[])this._gradient, (double[])grt._gradient);
        }
    }

    static class GLMMultinomialGradientTask
    extends MRTask<GLMMultinomialGradientTask> {
        final double[][] _beta;
        final DataInfo _dinfo;
        final double _currentLambda;
        final double _reg;
        final double[] _ymu;
        double[] _gradient;
        long _nobs;
        double _wsum;
        double _likelihood;
        GLMValidation _val;
        final boolean _validate;

        public GLMMultinomialGradientTask(DataInfo dinfo, double lambda, double[] ymu, double[][] beta, double reg, boolean validate, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._dinfo = dinfo;
            this._currentLambda = lambda;
            this._reg = reg;
            this._validate = validate;
            this._beta = beta;
            this._ymu = ymu;
        }

        private final void processRow(DataInfo.Row row, double[][] beta, double[] etas, double[] etaOffsets, double[] exps) {
            int y = (int)row.response(0);
            assert ((double)y == row.response(0));
            double logSumExp = GLMTask.computeMultinomialEtas(row, beta, etas, etaOffsets, exps);
            int P = this._dinfo.fullN() + 1;
            this._likelihood -= row.weight * (etas[(int)row.response(0)] - logSumExp);
            this._val.add((double)y, exps, row.weight, row.offset);
            int numOff = this._dinfo.numStart();
            for (int c = 0; c < beta.length; ++c) {
                int j;
                double val = row.weight * (exps[c + 1] - (double)(y == c ? 1 : 0));
                for (j = 0; j < row.nBins; ++j) {
                    int n = c * P + row.binIds[j];
                    this._gradient[n] = this._gradient[n] + val;
                }
                for (j = 0; j < row.nNums; ++j) {
                    int n = c * P + (row.numIds == null ? j + numOff : row.numIds[j]);
                    this._gradient[n] = this._gradient[n] + row.numVals[j] * val;
                }
                int n = (c + 1) * P - 1;
                this._gradient[n] = this._gradient[n] + val;
            }
        }

        public void map(Chunk[] chks) {
            int rank = 0;
            for (int i = 0; i < this._beta.length; ++i) {
                for (int j = 0; j < this._beta[i].length; ++j) {
                    if (this._beta[i][j] == 0.0) continue;
                    ++rank;
                }
            }
            this._gradient = new double[this._beta.length * this._beta[0].length];
            this._val = new GLMValidation(this._dinfo._adaptedFrame.lastVec().domain(), this._ymu, new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.multinomial), rank, 0.0, this._validate, true);
            int P = this._beta[0].length;
            double[] etas = new double[this._beta.length];
            double[] exps = new double[this._beta.length + 1];
            double[] etaOffsets = new double[this._beta.length];
            DataInfo.Rows rows = this._dinfo.rows(chks);
            if (rows._sparse) {
                for (int i = 0; i < this._beta.length; ++i) {
                    etaOffsets[i] = GLM.sparseOffset(this._beta[i], this._dinfo);
                }
            }
            for (int r = 0; r < rows._nrows; ++r) {
                DataInfo.Row row = rows.row(r);
                if (row.bad || row.weight == 0.0) continue;
                this._wsum += row.weight;
                ++this._nobs;
                this.processRow(row, this._beta, etas, etaOffsets, exps);
            }
            if (rows._sparse && this._dinfo._normSub != null) {
                int off = this._dinfo.numStart();
                for (int c = 0; c < this._beta.length; ++c) {
                    double val = this._gradient[(c + 1) * P - 1];
                    for (int i = 0; i < this._dinfo._nums; ++i) {
                        int n = c * P + off + i;
                        this._gradient[n] = this._gradient[n] - val * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    }
                }
            }
        }

        public void reduce(GLMMultinomialGradientTask gmgt) {
            ArrayUtils.add((double[])this._gradient, (double[])gmgt._gradient);
            this._nobs += gmgt._nobs;
            this._wsum += gmgt._wsum;
            this._likelihood += gmgt._likelihood;
            this._val.reduce(gmgt._val);
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            int P = this._beta[0].length;
            for (int c = 0; c < this._beta.length; ++c) {
                for (int j = 0; j < P - 1; ++j) {
                    int n = c * P + j;
                    this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[c][j];
                }
            }
        }
    }

    static class GLMMultinomialLineSearchTask
    extends MRTask<GLMMultinomialLineSearchTask> {
        private final DataInfo _dinfo;
        public final double _initialStep;
        public final double _stepDec;
        public final int _nSteps;
        private double[][] _betaBase;
        private double[][] _direction2D;
        private double[] _direction1D;
        final int _c;
        public long _nobs;
        double[] _likelihoods;

        static double[][] reshapeAry(double[] ary, int n) {
            int d = ary.length / n;
            if (d * n != ary.length) {
                throw new IllegalArgumentException("Array length is not multiple of n");
            }
            double[][] res = new double[d][n];
            int off = 0;
            for (int i = 0; i < d; ++i) {
                for (int j = 0; j < n; ++j) {
                    res[i][j] = ary[off++];
                }
            }
            return res;
        }

        GLMMultinomialLineSearchTask(H2O.H2OCountedCompleter cc, DataInfo dinfo, double[] beta, double[] direction, double initialStep, double stepDec, int nSteps) {
            this(cc, dinfo, GLMMultinomialLineSearchTask.reshapeAry(beta, dinfo.fullN() + 1), GLMMultinomialLineSearchTask.reshapeAry(direction, dinfo.fullN() + 1), initialStep, stepDec, nSteps);
        }

        GLMMultinomialLineSearchTask(H2O.H2OCountedCompleter cc, DataInfo dinfo, double[][] beta, double[] direction, int c, double initialStep, double stepDec, int nSteps) {
            super(cc);
            this._dinfo = dinfo;
            this._betaBase = beta;
            this._direction1D = direction;
            this._direction2D = null;
            this._c = c;
            this._initialStep = initialStep;
            this._stepDec = stepDec;
            this._nSteps = nSteps;
        }

        GLMMultinomialLineSearchTask(H2O.H2OCountedCompleter cc, DataInfo dinfo, double[][] beta, double[][] direction, double initialStep, double stepDec, int nSteps) {
            super(cc);
            this._dinfo = dinfo;
            this._betaBase = beta;
            this._direction2D = direction;
            this._direction1D = null;
            this._initialStep = initialStep;
            this._stepDec = stepDec;
            this._nSteps = nSteps;
            this._c = -1;
        }

        public void map(Chunk[] chks) {
            double t = this._initialStep;
            this._nobs = 0L;
            double[][] beta = (double[][])this._betaBase.clone();
            for (int i = 0; i < beta.length; ++i) {
                beta[i] = (double[])beta[i].clone();
            }
            DataInfo.Rows rows = this._dinfo.rows(chks);
            double[] etas = new double[this._betaBase.length];
            double[] etaOffsets = new double[etas.length];
            double[] exps = new double[this._betaBase.length + 1];
            double[] likelihoods = new double[this._nSteps];
            for (int i = 0; i < this._nSteps; ++i) {
                int j;
                for (j = 0; j < this._betaBase.length; ++j) {
                    double[] base = this._betaBase[j];
                    double[] b = beta[j];
                    if (this._direction2D != null) {
                        double[] d = this._direction2D[j];
                        for (int k = 0; k < base.length; ++k) {
                            b[k] = base[k] + t * d[k];
                        }
                    } else if (j == this._c) {
                        for (int k = 0; k < base.length; ++k) {
                            b[k] = base[k] + t * this._direction1D[k];
                        }
                    }
                    if (!rows._sparse) continue;
                    etaOffsets[j] = GLM.sparseOffset(b, this._dinfo);
                }
                for (j = 0; j < rows._nrows; ++j) {
                    DataInfo.Row row = rows.row(j);
                    if (i == 0) {
                        ++this._nobs;
                    }
                    double logSumExp = GLMTask.computeMultinomialEtas(row, beta, etas, etaOffsets, exps);
                    int n = i;
                    likelihoods[n] = likelihoods[n] - row.weight * (etas[(int)row.response(0)] - logSumExp);
                }
                t *= this._stepDec;
            }
            this._likelihoods = likelihoods;
            this._betaBase = null;
            this._direction1D = null;
            this._direction2D = null;
        }

        public void reduce(GLMMultinomialLineSearchTask glmt) {
            ArrayUtils.add((double[])this._likelihoods, (double[])glmt._likelihoods);
            this._nobs += glmt._nobs;
        }
    }

    static class GLMLineSearchTask
    extends MRTask<GLMLineSearchTask> {
        final DataInfo _dinfo;
        final double[] _beta;
        final double[][] _betaMultinomial;
        final int _c;
        final double[] _direction;
        final double _step;
        final double _initStep;
        final int _nSteps;
        final GLMModel.GLMParameters _params;
        boolean _useFasterMetrics = false;
        long _nobs;
        double[] _likelihoods;

        public GLMLineSearchTask(DataInfo dinfo, GLMModel.GLMParameters params, double[] beta, double[] direction, double initStep, double step, int nsteps, CountedCompleter cc) {
            super((H2O.H2OCountedCompleter)cc);
            this._dinfo = dinfo;
            this._beta = beta;
            this._betaMultinomial = null;
            this._direction = direction;
            this._step = step;
            this._nSteps = nsteps;
            this._params = params;
            this._initStep = initStep;
            this._c = -1;
        }

        public void map(Chunk[] chks) {
            int i;
            int r;
            Chunk responseChunk = chks[this._dinfo.responseChunkId()];
            boolean[] skip = MemoryManager.mallocZ((int)chks[0]._len);
            double[][] eta = new double[responseChunk._len][this._nSteps];
            if (this._dinfo._offset) {
                Chunk offsetChunk = chks[this._dinfo.offsetChunkId()];
                for (int r2 = 0; r2 < eta.length; ++r2) {
                    Arrays.fill(eta[r2], offsetChunk.atd(r2));
                }
            }
            C0DChunk weightsChunk = this._dinfo._weights ? chks[this._dinfo.weightChunkId()] : new C0DChunk(1.0, chks[0]._len);
            double[] beta = this._beta;
            double[] pk = this._direction;
            for (int r3 = 0; r3 < eta.length; ++r3) {
                double b = beta[beta.length - 1];
                double t = pk[beta.length - 1] * this._initStep;
                int j = 0;
                while (j < this._nSteps) {
                    double[] dArray = eta[r3];
                    int n = j++;
                    dArray[n] = dArray[n] + (b + t);
                    t *= this._step;
                }
            }
            for (int i2 = 0; i2 < this._dinfo._cats; ++i2) {
                Chunk c = chks[i2];
                for (r = 0; r < c._len; ++r) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                        continue;
                    }
                    int off = this._dinfo.getCategoricalId(i2, (int)c.at8(r));
                    if (off == -1) continue;
                    double t = pk[off] * this._initStep;
                    double b = beta[off];
                    int j = 0;
                    while (j < this._nSteps) {
                        double[] dArray = eta[r];
                        int n = j++;
                        dArray[n] = dArray[n] + (b + t);
                        t *= this._step;
                    }
                }
            }
            int numStart = this._dinfo.numStart();
            double[] off = new double[this._nSteps];
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    double b = beta[numStart + i];
                    double s = pk[numStart + i] * this._initStep;
                    double d = this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    int j = 0;
                    while (j < this._nSteps) {
                        int n = j++;
                        off[n] = off[n] - (b + s) * d;
                        s *= this._step;
                    }
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                int r4 = c.nextNZ(-1);
                while (r4 < c._len) {
                    if (skip[r4] || c.isNA(r4)) {
                        skip[r4] = true;
                    } else {
                        double d = c.atd(r4);
                        if (d != 0.0) {
                            if (this._dinfo._normMul != null) {
                                d *= this._dinfo._normMul[i];
                            }
                            double b = beta[numStart + i];
                            double s = pk[numStart + i] * this._initStep;
                            int j = 0;
                            while (j < this._nSteps) {
                                double[] dArray = eta[r4];
                                int n = j++;
                                dArray[n] = dArray[n] + (b + s) * d;
                                s *= this._step;
                            }
                        }
                    }
                    r4 = c.nextNZ(r4);
                }
            }
            this._likelihoods = MemoryManager.malloc8d((int)this._nSteps);
            for (r = 0; r < chks[0]._len; ++r) {
                double w = weightsChunk.atd(r);
                if (w == 0.0 || responseChunk.isNA(r)) continue;
                ++this._nobs;
                double y = responseChunk.atd(r);
                double yy = -1.0 + 2.0 * y;
                for (int i3 = 0; i3 < this._nSteps; ++i3) {
                    double e = eta[r][i3] + off[i3];
                    if (this._params._family == GLMModel.GLMParameters.Family.binomial && this._useFasterMetrics) {
                        int n = i3;
                        this._likelihoods[n] = this._likelihoods[n] + w * Math.log(1.0 + Math.exp(-yy * e));
                        continue;
                    }
                    double mu = this._params.linkInv(e);
                    int n = i3;
                    this._likelihoods[n] = this._likelihoods[n] + w * this._params.likelihood(y, mu);
                }
            }
        }

        public void reduce(GLMLineSearchTask glt) {
            ArrayUtils.add((double[])this._likelihoods, (double[])glt._likelihoods);
            this._nobs += glt._nobs;
        }
    }

    static class YMUTask
    extends MRTask<YMUTask> {
        double _yMin = Double.POSITIVE_INFINITY;
        double _yMax = Double.NEGATIVE_INFINITY;
        long _nobs;
        double _wsum;
        final int _responseId;
        final int _weightId;
        final int _offsetId;
        final int _nums;
        final int _numOff;
        final boolean _comupteWeightedSigma;
        double[] _xsum;
        double[] _xxsum;
        double[] _yMu;
        final int _nClasses;

        public YMUTask(DataInfo dinfo, int nclasses, boolean computeWeightedSigma, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._nums = dinfo._nums;
            this._numOff = dinfo._cats;
            this._responseId = dinfo.responseChunkId();
            this._weightId = dinfo._weights ? dinfo.weightChunkId() : -1;
            this._offsetId = dinfo._offset ? dinfo.offsetChunkId() : -1;
            this._nClasses = nclasses;
            this._comupteWeightedSigma = computeWeightedSigma;
        }

        public void setupLocal() {
        }

        public void map(Chunk[] chunks) {
            int r;
            this._yMu = new double[this._nClasses > 2 ? this._nClasses : 1];
            boolean[] good = MemoryManager.mallocZ((int)chunks[0]._len);
            Arrays.fill(good, true);
            Chunk weight = chunks[this._weightId];
            for (int i = 0; i < chunks.length; ++i) {
                r = chunks[i].nextNZ(-1);
                while (r < chunks[i]._len) {
                    if (weight.atd(r) != 0.0 && chunks[i].isNA(r)) {
                        good[r] = false;
                    }
                    r = chunks[i].nextNZ(r);
                }
            }
            Chunk response = chunks[this._responseId];
            if (this._comupteWeightedSigma) {
                this._xsum = MemoryManager.malloc8d((int)this._nums);
                this._xxsum = MemoryManager.malloc8d((int)this._nums);
            }
            for (r = 0; r < response._len; ++r) {
                double w = weight.atd(r);
                if (!good[r] || w == 0.0) continue;
                if (this._comupteWeightedSigma) {
                    int i = 0;
                    while (i < this._nums) {
                        double d = chunks[i + this._numOff].atd(r);
                        int n = i;
                        this._xsum[n] = this._xsum[n] + w * d;
                        int n2 = i++;
                        this._xxsum[n2] = this._xxsum[n2] + w * d * d;
                    }
                }
                this._wsum += w;
                double d = w * response.atd(r);
                assert (!Double.isNaN(d));
                if (this._nClasses > 2) {
                    int n = (int)d;
                    this._yMu[n] = this._yMu[n] + 1.0;
                } else {
                    this._yMu[0] = this._yMu[0] + d;
                }
                if (d < this._yMin) {
                    this._yMin = d;
                }
                if (d > this._yMax) {
                    this._yMax = d;
                }
                ++this._nobs;
            }
            boolean all_good = true;
            for (boolean b : good) {
                all_good &= b;
            }
            if (!all_good) {
                if (weight instanceof C0DChunk && weight.atd(0) == 1.0) {
                    DKV.put((Key)weight.vec().chunkKey(chunks[0].cidx()), (Iced)new CBSChunk(good));
                } else {
                    for (int i = 0; i < good.length; ++i) {
                        if (good[i]) continue;
                        weight.set(i, 0L);
                    }
                }
            }
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._yMu, (double)(1.0 / this._wsum));
            Futures fs = new Futures();
            fs.blockForPending();
        }

        public void reduce(YMUTask ymt) {
            if (this._nobs > 0L && ymt._nobs > 0L) {
                this._wsum += ymt._wsum;
                ArrayUtils.add((double[])this._yMu, (double[])ymt._yMu);
                this._nobs += ymt._nobs;
                if (this._yMin > ymt._yMin) {
                    this._yMin = ymt._yMin;
                }
                if (this._yMax < ymt._yMax) {
                    this._yMax = ymt._yMax;
                }
                if (this._comupteWeightedSigma) {
                    ArrayUtils.add((double[])this._xsum, (double[])ymt._xsum);
                    ArrayUtils.add((double[])this._xxsum, (double[])ymt._xxsum);
                }
            } else if (this._nobs == 0L) {
                this._wsum = ymt._wsum;
                this._yMu = ymt._yMu;
                this._nobs = ymt._nobs;
                this._yMin = ymt._yMin;
                this._yMax = ymt._yMax;
                this._xsum = ymt._xsum;
                this._xxsum = ymt._xxsum;
            }
        }
    }
}

