/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.ClusteringModel;
import hex.ClusteringModelBuilder;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsClustering;
import hex.genmodel.GenModel;
import hex.kmeans.KMeansModel;
import hex.schemas.KMeansV3;
import hex.schemas.ModelBuilderSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class KMeans
extends ClusteringModelBuilder<KMeansModel, KMeansModel.KMeansParameters, KMeansModel.KMeansOutput> {
    private final double TOLERANCE = 1.0E-6;

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Clustering};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public KMeans(Key dest, String desc, KMeansModel.KMeansParameters parms) {
        super(dest, desc, (ClusteringModel.ClusteringParameters)parms);
        this.init(false);
    }

    public KMeans(KMeansModel.KMeansParameters parms) {
        super("K-means", (ClusteringModel.ClusteringParameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new KMeansV3();
    }

    protected void checkMemoryFootPrint() {
        long max_mem;
        long mem_usage = 8 * ((KMeansModel.KMeansParameters)this._parms)._k * this._train.numCols() * (((KMeansModel.KMeansParameters)this._parms)._standardize ? 2 : 1);
        if (mem_usage > (max_mem = H2O.SELF.get_max_mem())) {
            String msg = "Centroids won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
            this.cancel(msg);
        }
    }

    protected Job<KMeansModel> trainModelImpl(long work, boolean restartTimer) {
        return this.start(new KMeansDriver(), work, restartTimer);
    }

    public long progressUnits() {
        return ((KMeansModel.KMeansParameters)this._parms)._max_iterations;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((KMeansModel.KMeansParameters)this._parms)._max_iterations < 0 || (double)((KMeansModel.KMeansParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", " max_iterations must be between 0 and 1e6");
        }
        if (this._train == null) {
            return;
        }
        if (((KMeansModel.KMeansParameters)this._parms)._init == Initialization.User && ((KMeansModel.KMeansParameters)this._parms)._user_points == null) {
            this.error("_user_y", "Must specify initial cluster centers");
        }
        if (null != ((KMeansModel.KMeansParameters)this._parms)._user_points) {
            Frame user_points = (Frame)((KMeansModel.KMeansParameters)this._parms)._user_points.get();
            if (user_points.numCols() != this._train.numCols() - this.numSpecialCols()) {
                this.error("_user_y", "The user-specified points must have the same number of columns (" + (this._train.numCols() - this.numSpecialCols()) + ") as the training observations");
            } else if (user_points.numRows() != (long)((KMeansModel.KMeansParameters)this._parms)._k) {
                this.error("_user_y", "The number of rows in the user-specified points is not equal to k = " + ((KMeansModel.KMeansParameters)this._parms)._k);
            }
        }
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    public static TwoDimTable createCenterTable(KMeansModel.KMeansOutput output, boolean standardized) {
        String name;
        String string = name = standardized ? "Standardized Cluster Means" : "Cluster Means";
        if (output._size == null || output._names == null || output._domains == null || output._centers_raw == null || standardized && output._centers_std_raw == null) {
            TwoDimTable table = new TwoDimTable(name, null, new String[]{"1"}, new String[]{"C1"}, new String[]{"double"}, new String[]{"%f"}, "Centroid");
            table.set(0, 0, (Object)Double.NaN);
            return table;
        }
        String[] rowHeaders = new String[output._size.length];
        for (int i = 0; i < rowHeaders.length; ++i) {
            rowHeaders[i] = String.valueOf(i + 1);
        }
        String[] colTypes = new String[output._names.length];
        String[] colFormats = new String[output._names.length];
        for (int i = 0; i < output._domains.length; ++i) {
            colTypes[i] = output._domains[i] == null ? "double" : "String";
            colFormats[i] = output._domains[i] == null ? "%f" : "%s";
        }
        TwoDimTable table = new TwoDimTable(name, null, rowHeaders, output._names, colTypes, colFormats, "Centroid");
        for (int j = 0; j < output._domains.length; ++j) {
            int i;
            boolean string2;
            boolean bl = string2 = output._domains[j] != null;
            if (string2) {
                for (i = 0; i < output._centers_raw.length; ++i) {
                    table.set(i, j, (Object)output._domains[j][(int)output._centers_raw[i][j]]);
                }
                continue;
            }
            for (i = 0; i < output._centers_raw.length; ++i) {
                table.set(i, j, (Object)(standardized ? output._centers_std_raw[i][j] : output._centers_raw[i][j]));
            }
        }
        return table;
    }

    private static double minSqr(double[][] centers, double[] point, String[][] isCats, ClusterDist cd) {
        return KMeans.closest((double[][])centers, (double[])point, (String[][])isCats, (ClusterDist)cd, (int)centers.length)._dist;
    }

    private static double minSqr(double[][] centers, double[] point, String[][] isCats, ClusterDist cd, int count) {
        return KMeans.closest((double[][])centers, (double[])point, (String[][])isCats, (ClusterDist)cd, (int)count)._dist;
    }

    private static ClusterDist closest(double[][] centers, double[] point, String[][] isCats, ClusterDist cd) {
        return KMeans.closest(centers, point, isCats, cd, centers.length);
    }

    private static ClusterDist closest(double[][] centers, double[] point, String[][] isCats, ClusterDist cd, int count) {
        int min = -1;
        double minSqr = Double.MAX_VALUE;
        for (int cluster = 0; cluster < count; ++cluster) {
            double sqr = GenModel.KMeans_distance((double[])centers[cluster], (double[])point, (String[][])isCats, null, null);
            if (!(sqr < minSqr)) continue;
            min = cluster;
            minSqr = sqr;
        }
        cd._cluster = min;
        cd._dist = minSqr;
        return cd;
    }

    private static double[][] recluster(double[][] points, Random rand, int N, Initialization init, String[][] isCats) {
        double[][] res = new double[N][];
        res[0] = points[0];
        int count = 1;
        ClusterDist cd = new ClusterDist();
        switch (init) {
            case Random: {
                break;
            }
            case PlusPlus: {
                block5: while (count < res.length) {
                    double sum = 0.0;
                    for (double[] point1 : points) {
                        sum += KMeans.minSqr(res, point1, isCats, cd, count);
                    }
                    for (double[] point : points) {
                        if (!(KMeans.minSqr(res, point, isCats, cd, count) >= rand.nextDouble() * sum)) continue;
                        res[count++] = point;
                        continue block5;
                    }
                }
                break;
            }
            case Furthest: {
                while (count < res.length) {
                    double max = 0.0;
                    int index = 0;
                    for (int i = 0; i < points.length; ++i) {
                        double sqr = KMeans.minSqr(res, points[i], isCats, cd, count);
                        if (!(sqr > max)) continue;
                        max = sqr;
                        index = i;
                    }
                    res[count++] = points[index];
                }
                break;
            }
            default: {
                throw H2O.fail();
            }
        }
        return res;
    }

    private void randomRow(Vec[] vecs, Random rand, double[] center, double[] means, double[] mults, int[] modes) {
        long row = Math.max(0L, (long)(rand.nextDouble() * (double)vecs[0].length()) - 1L);
        KMeans.data(center, vecs, row, means, mults, modes);
    }

    private static double[][] max_cats(double[][] centers, long[][][] cats, String[][] isCats) {
        for (int clu = 0; clu < centers.length; ++clu) {
            for (int col = 0; col < centers[0].length; ++col) {
                if (isCats[col] == null) continue;
                centers[clu][col] = ArrayUtils.maxIndex((long[])cats[clu][col]);
            }
        }
        return centers;
    }

    private static double[][] destandardize(double[][] centers, String[][] isCats, double[] means, double[] mults) {
        int K = centers.length;
        int N = centers[0].length;
        double[][] value = new double[K][N];
        for (int clu = 0; clu < K; ++clu) {
            System.arraycopy(centers[clu], 0, value[clu], 0, N);
            if (mults == null) continue;
            for (int col = 0; col < N; ++col) {
                if (isCats[col] != null) continue;
                value[clu][col] = value[clu][col] / mults[col] + means[col];
            }
        }
        return value;
    }

    private static void data(double[] values, Vec[] vecs, long row, double[] means, double[] mults, int[] modes) {
        for (int i = 0; i < values.length; ++i) {
            double d = vecs[i].at(row);
            values[i] = KMeans.data(d, i, means, mults, modes);
        }
    }

    private static void data(double[] values, Chunk[] chks, int row, double[] means, double[] mults, int[] modes) {
        for (int i = 0; i < values.length; ++i) {
            double d = chks[i].atd(row);
            values[i] = KMeans.data(d, i, means, mults, modes);
        }
    }

    private static double data(double d, int i, double[] means, double[] mults, int[] modes) {
        if (modes[i] == -1) {
            if (Double.isNaN(d)) {
                d = means[i];
            }
            if (mults != null) {
                d -= means[i];
                d *= mults[i];
            }
        } else if (Double.isNaN(d)) {
            d = modes[i];
        }
        return d;
    }

    private ModelMetricsClustering makeTrainingMetrics(KMeansModel model) {
        ModelMetricsClustering mm = new ModelMetricsClustering((Model)model, ((KMeansModel.KMeansParameters)model._parms).train());
        mm._size = ((KMeansModel.KMeansOutput)model._output)._size;
        mm._withinss = ((KMeansModel.KMeansOutput)model._output)._withinss;
        mm._betweenss = ((KMeansModel.KMeansOutput)model._output)._betweenss;
        mm._totss = ((KMeansModel.KMeansOutput)model._output)._totss;
        mm._tot_withinss = ((KMeansModel.KMeansOutput)model._output)._tot_withinss;
        model.addMetrics((ModelMetrics)mm);
        return mm;
    }

    private static final class ClusterDist {
        int _cluster;
        double _dist;

        private ClusterDist() {
        }
    }

    private static class Lloyds
    extends MRTask<Lloyds> {
        double[][] _centers;
        double[] _means;
        double[] _mults;
        int[] _modes;
        final int _k;
        final String[][] _isCats;
        boolean _hasWeight;
        double[][] _cMeans;
        long[][][] _cats;
        double[] _cSqr;
        long[] _size;
        long _worst_row;
        double _worst_err;

        Lloyds(double[][] centers, double[] means, double[] mults, int[] modes, String[][] isCats, int k, boolean hasWeight) {
            this._centers = centers;
            this._means = means;
            this._mults = mults;
            this._modes = modes;
            this._isCats = isCats;
            this._k = k;
            this._hasWeight = hasWeight;
        }

        public void map(Chunk[] cs) {
            int N = cs.length - (this._hasWeight ? 1 : 0);
            assert (this._centers[0].length == N);
            this._cMeans = new double[this._k][N];
            this._cSqr = new double[this._k];
            this._size = new long[this._k];
            this._cats = new long[this._k][N][];
            for (int clu = 0; clu < this._k; ++clu) {
                for (int col = 0; col < N; ++col) {
                    this._cats[clu][col] = this._isCats[col] == null ? null : new long[cs[col].vec().cardinality()];
                }
            }
            this._worst_err = 0.0;
            double[] values = new double[N];
            ClusterDist cd = new ClusterDist();
            for (int row = 0; row < cs[0]._len; ++row) {
                double weight;
                double d = weight = this._hasWeight ? cs[N].atd(row) : 1.0;
                if (weight == 0.0) continue;
                assert (weight == 1.0);
                KMeans.data(values, cs, row, this._means, this._mults, this._modes);
                KMeans.closest(this._centers, values, this._isCats, cd);
                int clu = cd._cluster;
                assert (clu != -1);
                int n = clu;
                this._cSqr[n] = this._cSqr[n] + cd._dist;
                for (int col = 0; col < N; ++col) {
                    if (this._isCats[col] != null) {
                        long[] lArray = this._cats[clu][col];
                        int n2 = (int)values[col];
                        lArray[n2] = lArray[n2] + 1L;
                        continue;
                    }
                    double[] dArray = this._cMeans[clu];
                    int n3 = col;
                    dArray[n3] = dArray[n3] + values[col];
                }
                int n4 = clu;
                this._size[n4] = this._size[n4] + 1L;
                if (!(cd._dist > this._worst_err)) continue;
                this._worst_err = cd._dist;
                this._worst_row = cs[0].start() + (long)row;
            }
            for (int clu = 0; clu < this._k; ++clu) {
                if (this._size[clu] == 0L) continue;
                ArrayUtils.div((double[])this._cMeans[clu], (double)this._size[clu]);
            }
            this._centers = null;
            this._mults = null;
            this._means = null;
            this._modes = null;
        }

        public void reduce(Lloyds mr) {
            for (int clu = 0; clu < this._k; ++clu) {
                long ra = this._size[clu];
                long rb = mr._size[clu];
                double[] ma = this._cMeans[clu];
                double[] mb = mr._cMeans[clu];
                for (int c = 0; c < ma.length; ++c) {
                    if (ra + rb <= 0L) continue;
                    ma[c] = (ma[c] * (double)ra + mb[c] * (double)rb) / (double)(ra + rb);
                }
            }
            ArrayUtils.add((long[][][])this._cats, (long[][][])mr._cats);
            ArrayUtils.add((double[])this._cSqr, (double[])mr._cSqr);
            ArrayUtils.add((long[])this._size, (long[])mr._size);
            if (this._worst_err < mr._worst_err) {
                this._worst_err = mr._worst_err;
                this._worst_row = mr._worst_row;
            }
        }
    }

    private static class Sampler
    extends MRTask<Sampler> {
        double[][] _centers;
        double[] _means;
        double[] _mults;
        int[] _modes;
        final String[][] _isCats;
        final double _sqr;
        final double _probability;
        final long _seed;
        boolean _hasWeight;
        double[][] _sampled;

        Sampler(double[][] centers, double[] means, double[] mults, int[] modes, String[][] isCats, double sqr, double prob, long seed, boolean hasWeight) {
            this._centers = centers;
            this._means = means;
            this._mults = mults;
            this._modes = modes;
            this._isCats = isCats;
            this._sqr = sqr;
            this._probability = prob;
            this._seed = seed;
            this._hasWeight = hasWeight;
        }

        public void map(Chunk[] cs) {
            int N = cs.length - (this._hasWeight ? 1 : 0);
            double[] values = new double[N];
            ArrayList<Object> list = new ArrayList<Object>();
            Random rand = RandomUtils.getRNG((long[])new long[]{this._seed + cs[0].start()});
            ClusterDist cd = new ClusterDist();
            for (int row = 0; row < cs[0]._len; ++row) {
                KMeans.data(values, cs, row, this._means, this._mults, this._modes);
                double sqr = KMeans.minSqr(this._centers, values, this._isCats, cd);
                if (!(this._probability * sqr > rand.nextDouble() * this._sqr)) continue;
                list.add(values.clone());
            }
            this._sampled = new double[list.size()][];
            list.toArray((T[])this._sampled);
            this._centers = null;
            this._mults = null;
            this._means = null;
            this._modes = null;
        }

        public void reduce(Sampler other) {
            this._sampled = ArrayUtils.append((double[][])this._sampled, (double[][])other._sampled);
        }
    }

    private static class SumSqr
    extends MRTask<SumSqr> {
        double[][] _centers;
        double[] _means;
        double[] _mults;
        int[] _modes;
        final String[][] _isCats;
        double _sqr;

        SumSqr(double[][] centers, double[] means, double[] mults, int[] modes, String[][] isCats) {
            this._centers = centers;
            this._means = means;
            this._mults = mults;
            this._modes = modes;
            this._isCats = isCats;
        }

        public void map(Chunk[] cs) {
            double[] values = new double[cs.length];
            ClusterDist cd = new ClusterDist();
            for (int row = 0; row < cs[0]._len; ++row) {
                KMeans.data(values, cs, row, this._means, this._mults, this._modes);
                this._sqr += KMeans.minSqr(this._centers, values, this._isCats, cd);
            }
            this._mults = null;
            this._means = null;
            this._modes = null;
            this._centers = null;
        }

        public void reduce(SumSqr other) {
            this._sqr += other._sqr;
        }
    }

    private static class TotSS
    extends MRTask<TotSS> {
        final double[] _means;
        final double[] _mults;
        final int[] _modes;
        final String[][] _isCats;
        final int[] _card;
        double _tss;
        double[] _gc;

        TotSS(double[] means, double[] mults, int[] modes, String[][] isCats, int[] card) {
            this._means = means;
            this._mults = mults;
            this._modes = modes;
            this._tss = 0.0;
            this._isCats = isCats;
            this._card = card;
            this._gc = mults != null ? new double[means.length] : Arrays.copyOf(means, means.length);
            for (int i = 0; i < means.length; ++i) {
                if (isCats[i] == null) continue;
                this._gc[i] = Math.min(Math.round(means[i]), (long)(this._card[i] - 1));
            }
        }

        public void map(Chunk[] cs) {
            for (int row = 0; row < cs[0]._len; ++row) {
                double[] values = new double[cs.length];
                KMeans.data(values, cs, row, this._means, this._mults, this._modes);
                this._tss += GenModel.KMeans_distance((double[])this._gc, (double[])values, (String[][])this._isCats, null, null);
            }
        }

        public void reduce(TotSS other) {
            this._tss += other._tss;
        }
    }

    private class KMeansDriver
    extends H2O.H2OCountedCompleter<KMeansDriver> {
        private String[][] _isCats;
        private transient int _reinit_attempts;

        private KMeansDriver() {
            super(true);
        }

        double[][] initial_centers(KMeansModel model, Vec[] vecs, double[] means, double[] mults, int[] modes) {
            double[][] centers;
            ((KMeansModel.KMeansOutput)model._output)._categorical_column_count = 0;
            this._isCats = new String[vecs.length][];
            for (int v = 0; v < vecs.length; ++v) {
                String[] stringArray = this._isCats[v] = vecs[v].isCategorical() ? new String[]{} : null;
                if (this._isCats[v] == null) continue;
                ++((KMeansModel.KMeansOutput)model._output)._categorical_column_count;
            }
            Random rand = RandomUtils.getRNG((long[])new long[]{((KMeansModel.KMeansParameters)KMeans.this._parms)._seed - 1L});
            if (null != ((KMeansModel.KMeansParameters)KMeans.this._parms)._user_points) {
                Frame user_points = (Frame)((KMeansModel.KMeansParameters)KMeans.this._parms)._user_points.get();
                int numCenters = (int)user_points.numRows();
                int numCols = ((KMeansModel.KMeansOutput)model._output).nfeatures();
                centers = new double[numCenters][numCols];
                Vec[] centersVecs = user_points.vecs();
                for (int r = 0; r < numCenters; ++r) {
                    for (int c = 0; c < numCols; ++c) {
                        centers[r][c] = centersVecs[c].at((long)r);
                        centers[r][c] = KMeans.data(centers[r][c], c, means, mults, modes);
                    }
                }
            } else if (((KMeansModel.KMeansParameters)KMeans.this._parms)._init == Initialization.Random) {
                for (double[] center : centers = new double[((KMeansModel.KMeansParameters)KMeans.this._parms)._k][((KMeansModel.KMeansOutput)model._output).nfeatures()]) {
                    KMeans.this.randomRow(vecs, rand, center, means, mults, modes);
                }
            } else {
                centers = new double[1][((KMeansModel.KMeansOutput)model._output).nfeatures()];
                KMeans.this.randomRow(vecs, rand, centers[0], means, mults, modes);
                ((KMeansModel.KMeansOutput)model._output)._iterations = 0;
                while (((KMeansModel.KMeansOutput)model._output)._iterations < 5) {
                    SumSqr sqr = (SumSqr)new SumSqr(centers, means, mults, modes, this._isCats).doAll(vecs);
                    Sampler sampler = (Sampler)new Sampler(centers, means, mults, modes, this._isCats, sqr._sqr, ((KMeansModel.KMeansParameters)KMeans.this._parms)._k * 3, ((KMeansModel.KMeansParameters)KMeans.this._parms)._seed, KMeans.this.hasWeightCol()).doAll(vecs);
                    centers = ArrayUtils.append((double[][])centers, (double[][])sampler._sampled);
                    if (!KMeans.this.isRunning()) {
                        return null;
                    }
                    ((KMeansModel.KMeansOutput)model._output)._centers_raw = KMeans.destandardize(centers, this._isCats, means, mults);
                    ((KMeansModel.KMeansOutput)model._output)._tot_withinss = sqr._sqr / (double)KMeans.this._train.numRows();
                    ++((KMeansModel.KMeansOutput)model._output)._iterations;
                    model.update(KMeans.this._key);
                }
                centers = KMeans.recluster(centers, rand, ((KMeansModel.KMeansParameters)KMeans.this._parms)._k, ((KMeansModel.KMeansParameters)KMeans.this._parms)._init, this._isCats);
                ((KMeansModel.KMeansOutput)model._output)._iterations = 0;
            }
            return centers;
        }

        boolean cleanupBadClusters(Lloyds task, Vec[] vecs, double[][] centers, double[] means, double[] mults, int[] modes) {
            int clu;
            for (clu = 0; clu < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k && task._size[clu] != 0L; ++clu) {
            }
            if (clu == ((KMeansModel.KMeansParameters)KMeans.this._parms)._k) {
                return false;
            }
            long row = task._worst_row;
            Log.warn((Object[])new Object[]{"KMeans: Re-initializing cluster " + clu + " to row " + row});
            centers[clu] = task._cMeans[clu];
            KMeans.data(centers[clu], vecs, row, means, mults, modes);
            task._size[clu] = 1L;
            for (clu = 0; clu < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k && task._size[clu] != 0L; ++clu) {
            }
            if (clu == ((KMeansModel.KMeansParameters)KMeans.this._parms)._k) {
                return false;
            }
            Log.warn((Object[])new Object[]{"KMeans: Re-running Lloyds to re-init another cluster"});
            if (this._reinit_attempts++ < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k) {
                return true;
            }
            this._reinit_attempts = 0;
            return false;
        }

        double[][] computeStatsFillModel(Lloyds task, KMeansModel model, Vec[] vecs, double[] means, double[] mults, int[] modes) {
            if (((KMeansModel.KMeansParameters)model._parms)._standardize) {
                ((KMeansModel.KMeansOutput)model._output)._centers_std_raw = task._cMeans;
            }
            ((KMeansModel.KMeansOutput)model._output)._centers_raw = KMeans.destandardize(task._cMeans, this._isCats, means, mults);
            ((KMeansModel.KMeansOutput)model._output)._size = task._size;
            ((KMeansModel.KMeansOutput)model._output)._withinss = task._cSqr;
            double ssq = 0.0;
            for (int i = 0; i < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k; ++i) {
                ssq += ((KMeansModel.KMeansOutput)model._output)._withinss[i];
            }
            ((KMeansModel.KMeansOutput)model._output)._tot_withinss = ssq;
            if (((KMeansModel.KMeansParameters)KMeans.this._parms)._k == 1) {
                ((KMeansModel.KMeansOutput)model._output)._totss = ((KMeansModel.KMeansOutput)model._output)._tot_withinss;
            } else {
                TotSS totss = (TotSS)new TotSS(means, mults, modes, ((KMeansModel.KMeansParameters)KMeans.this._parms).train().domains(), ((KMeansModel.KMeansParameters)KMeans.this._parms).train().cardinality()).doAll(vecs);
                ((KMeansModel.KMeansOutput)model._output)._totss = totss._tss;
            }
            ((KMeansModel.KMeansOutput)model._output)._betweenss = ((KMeansModel.KMeansOutput)model._output)._totss - ((KMeansModel.KMeansOutput)model._output)._tot_withinss;
            ++((KMeansModel.KMeansOutput)model._output)._iterations;
            ((KMeansModel.KMeansOutput)model._output)._history_withinss = ArrayUtils.copyAndFillOf((double[])((KMeansModel.KMeansOutput)model._output)._history_withinss, (int)(((KMeansModel.KMeansOutput)model._output)._history_withinss.length + 1), (double)((KMeansModel.KMeansOutput)model._output)._tot_withinss);
            ((KMeansModel.KMeansOutput)model._output)._model_summary = this.createModelSummaryTable((KMeansModel.KMeansOutput)model._output);
            ((KMeansModel.KMeansOutput)model._output)._scoring_history = this.createScoringHistoryTable((KMeansModel.KMeansOutput)model._output);
            ((KMeansModel.KMeansOutput)model._output)._training_metrics = KMeans.this.makeTrainingMetrics(model);
            return task._cMeans;
        }

        boolean isDone(KMeansModel model, double[][] newCenters, double[][] oldCenters) {
            if (!KMeans.this.isRunning()) {
                return true;
            }
            if (((KMeansModel.KMeansOutput)model._output)._iterations >= ((KMeansModel.KMeansParameters)KMeans.this._parms)._max_iterations) {
                return true;
            }
            if (oldCenters == null) {
                return false;
            }
            double average_change = 0.0;
            for (int clu = 0; clu < ((KMeansModel.KMeansParameters)KMeans.this._parms)._k; ++clu) {
                average_change += GenModel.KMeans_distance((double[])oldCenters[clu], (double[])newCenters[clu], (String[][])this._isCats, null, null);
            }
            ((KMeansModel.KMeansOutput)model._output)._avg_centroids_chg = ArrayUtils.copyAndFillOf((double[])((KMeansModel.KMeansOutput)model._output)._avg_centroids_chg, (int)(((KMeansModel.KMeansOutput)model._output)._avg_centroids_chg.length + 1), (double)(average_change /= (double)((KMeansModel.KMeansParameters)KMeans.this._parms)._k));
            ((KMeansModel.KMeansOutput)model._output)._training_time_ms = ArrayUtils.copyAndFillOf((long[])((KMeansModel.KMeansOutput)model._output)._training_time_ms, (int)(((KMeansModel.KMeansOutput)model._output)._training_time_ms.length + 1), (long)System.currentTimeMillis());
            return average_change < 1.0E-6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block13: {
                KMeansModel model = null;
                try {
                    KMeans.this.init(true);
                    ((KMeansModel.KMeansParameters)KMeans.this._parms).read_lock_frames((Job)KMeans.this);
                    if (KMeans.this.error_count() > 0) {
                        throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)KMeans.this);
                    }
                    model = new KMeansModel(KMeans.this.dest(), (KMeansModel.KMeansParameters)KMeans.this._parms, new KMeansModel.KMeansOutput(KMeans.this));
                    model.delete_and_lock(KMeans.this._key);
                    Vec[] vecs = KMeans.this._train.vecs();
                    double[] means = KMeans.this._train.means();
                    double[] mults = ((KMeansModel.KMeansParameters)KMeans.this._parms)._standardize ? KMeans.this._train.mults() : null;
                    int[] impute_cat = new int[vecs.length];
                    for (int i = 0; i < vecs.length; ++i) {
                        impute_cat[i] = vecs[i].isNumeric() ? -1 : DataInfo.imputeCat(vecs[i]);
                    }
                    ((KMeansModel.KMeansOutput)model._output)._normSub = means;
                    ((KMeansModel.KMeansOutput)model._output)._normMul = mults;
                    double[][] centers = this.initial_centers(model, vecs, means, mults, impute_cat);
                    if (centers == null) {
                        return;
                    }
                    double[][] oldCenters = null;
                    ((KMeansModel.KMeansOutput)model._output)._iterations = 0;
                    while (!this.isDone(model, centers, oldCenters)) {
                        Lloyds task = (Lloyds)new Lloyds(centers, means, mults, impute_cat, this._isCats, ((KMeansModel.KMeansParameters)KMeans.this._parms)._k, KMeans.this.hasWeightCol()).doAll(vecs);
                        KMeans.max_cats(task._cMeans, task._cats, this._isCats);
                        if (this.cleanupBadClusters(task, vecs, centers, means, mults, impute_cat)) continue;
                        oldCenters = centers;
                        centers = this.computeStatsFillModel(task, model, vecs, means, mults, impute_cat);
                        model.update(KMeans.this._key);
                        KMeans.this.update(1L);
                        if (!((KMeansModel.KMeansParameters)model._parms)._score_each_iteration) continue;
                        Log.info((Object[])new Object[]{((KMeansModel.KMeansOutput)model._output)._model_summary});
                    }
                    Log.info((Object[])new Object[]{((KMeansModel.KMeansOutput)model._output)._model_summary});
                    if (KMeans.this._valid != null) {
                        model.score(((KMeansModel.KMeansParameters)KMeans.this._parms).valid()).delete();
                        ((KMeansModel.KMeansOutput)model._output)._validation_metrics = ModelMetrics.getFromDKV((Model)model, (Frame)((KMeansModel.KMeansParameters)KMeans.this._parms).valid());
                        model.update(KMeans.this._key);
                    }
                    KMeans.this.done();
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)KMeans.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block13;
                    }
                    t.printStackTrace();
                    KMeans.this.failed(t);
                    throw t;
                }
                finally {
                    KMeans.this.updateModelOutput();
                    if (model != null) {
                        model.unlock(KMeans.this._key);
                    }
                    ((KMeansModel.KMeansParameters)KMeans.this._parms).read_unlock_frames((Job)KMeans.this);
                }
            }
            this.tryComplete();
        }

        private TwoDimTable createModelSummaryTable(KMeansModel.KMeansOutput output) {
            ArrayList<String> colHeaders = new ArrayList<String>();
            ArrayList<String> colTypes = new ArrayList<String>();
            ArrayList<String> colFormat = new ArrayList<String>();
            colHeaders.add("Number of Rows");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Number of Clusters");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Number of Categorical Columns");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Number of Iterations");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Within Cluster Sum of Squares");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Total Sum of Squares");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Between Cluster Sum of Squares");
            colTypes.add("double");
            colFormat.add("%.5f");
            boolean rows = true;
            TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
            int row = 0;
            int col = 0;
            table.set(row, col++, (Object)Math.round((double)KMeans.this._train.numRows() * (KMeans.this.hasWeightCol() ? KMeans.this._train.lastVec().mean() : 1.0)));
            table.set(row, col++, (Object)output._centers_raw.length);
            table.set(row, col++, (Object)output._categorical_column_count);
            table.set(row, col++, (Object)output._iterations);
            table.set(row, col++, (Object)output._tot_withinss);
            table.set(row, col++, (Object)output._totss);
            table.set(row, col++, (Object)output._betweenss);
            return table;
        }

        private TwoDimTable createScoringHistoryTable(KMeansModel.KMeansOutput output) {
            ArrayList<String> colHeaders = new ArrayList<String>();
            ArrayList<String> colTypes = new ArrayList<String>();
            ArrayList<String> colFormat = new ArrayList<String>();
            colHeaders.add("Timestamp");
            colTypes.add("string");
            colFormat.add("%s");
            colHeaders.add("Duration");
            colTypes.add("string");
            colFormat.add("%s");
            colHeaders.add("Iteration");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Avg. Change of Std. Centroids");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Within Cluster Sum Of Squares");
            colTypes.add("double");
            colFormat.add("%.5f");
            int rows = output._avg_centroids_chg.length;
            TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
            int row = 0;
            for (int i = 0; i < rows; ++i) {
                int col = 0;
                assert (row < table.getRowDim());
                assert (col < table.getColDim());
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                table.set(row, col++, (Object)fmt.print(output._training_time_ms[i]));
                table.set(row, col++, (Object)PrettyPrint.msecs((long)(output._training_time_ms[i] - KMeans.this._start_time), (boolean)true));
                table.set(row, col++, (Object)i);
                table.set(row, col++, (Object)output._avg_centroids_chg[i]);
                table.set(row, col++, (Object)output._history_withinss[i]);
                ++row;
            }
            return table;
        }
    }

    public static enum Initialization {
        Random,
        PlusPlus,
        Furthest,
        User;

    }
}

