/*
 * Decompiled with CFR 0.152.
 */
package hex.example;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.example.ExampleModel;
import hex.schemas.ExampleV3;
import hex.schemas.ModelBuilderSchema;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.Log;

public class Example
extends ModelBuilder<ExampleModel, ExampleModel.ExampleParameters, ExampleModel.ExampleOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Unknown};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public Example(ExampleModel.ExampleParameters parms) {
        super("Example", (Model.Parameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new ExampleV3();
    }

    protected Example trainModelImpl(long work, boolean restartTimer) {
        return (Example)this.start(new ExampleDriver(), work, restartTimer);
    }

    public long progressUnits() {
        return ((ExampleModel.ExampleParameters)this._parms)._max_iterations;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((ExampleModel.ExampleParameters)this._parms)._max_iterations < 1 || ((ExampleModel.ExampleParameters)this._parms)._max_iterations > 9999999) {
            this.error("max_iterations", "must be between 1 and 10 million");
        }
    }

    private static class Max
    extends MRTask<Max> {
        double[] _maxs;

        private Max() {
        }

        public void map(Chunk[] cs) {
            this._maxs = new double[cs.length];
            Arrays.fill(this._maxs, -1.7976931348623157E308);
            for (int col = 0; col < cs.length; ++col) {
                for (int row = 0; row < cs[col]._len; ++row) {
                    this._maxs[col] = Math.max(this._maxs[col], cs[col].atd(row));
                }
            }
        }

        public void reduce(Max that) {
            for (int col = 0; col < this._maxs.length; ++col) {
                this._maxs[col] = Math.max(this._maxs[col], that._maxs[col]);
            }
        }
    }

    private class ExampleDriver
    extends H2O.H2OCountedCompleter<ExampleDriver> {
        protected ExampleDriver() {
            super(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            ExampleModel model = null;
            try {
                Scope.enter();
                ((ExampleModel.ExampleParameters)Example.this._parms).read_lock_frames((Job)Example.this);
                Example.this.init(true);
                model = new ExampleModel(Example.this.dest(), (ExampleModel.ExampleParameters)Example.this._parms, new ExampleModel.ExampleOutput(Example.this));
                model.delete_and_lock(Example.this._key);
                while (((ExampleModel.ExampleOutput)model._output)._iterations < ((ExampleModel.ExampleParameters)Example.this._parms)._max_iterations && Example.this.isRunning()) {
                    double[] maxs = ((Max)new Max().doAll((Frame)((ExampleModel.ExampleParameters)Example.this._parms).train()))._maxs;
                    ((ExampleModel.ExampleOutput)model._output)._maxs = maxs;
                    model.update(Example.this._key);
                    Example.this.update(1L);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Example: iter: ").append(((ExampleModel.ExampleOutput)model._output)._iterations);
                    Log.info((Object[])new Object[]{sb});
                    ++((ExampleModel.ExampleOutput)model._output)._iterations;
                }
                Example.this.done();
            }
            catch (Throwable t) {
                try {
                    if (Example.this._state != Job.JobState.CANCELLED) {
                        t.printStackTrace();
                        Example.this.failed(t);
                        throw t;
                    }
                    Log.info((Object[])new Object[]{"Job cancelled by user."});
                }
                catch (Throwable throwable) {
                    Example.this.updateModelOutput();
                    if (model != null) {
                        model.unlock(Example.this._key);
                    }
                    ((ExampleModel.ExampleParameters)Example.this._parms).read_unlock_frames((Job)Example.this);
                    Scope.exit((Key[])new Key[]{model._key});
                    throw throwable;
                }
                Example.this.updateModelOutput();
                if (model != null) {
                    model.unlock(Example.this._key);
                }
                ((ExampleModel.ExampleParameters)Example.this._parms).read_unlock_frames((Job)Example.this);
                Scope.exit((Key[])new Key[]{model._key});
            }
            Example.this.updateModelOutput();
            if (model != null) {
                model.unlock(Example.this._key);
            }
            ((ExampleModel.ExampleParameters)Example.this._parms).read_unlock_frames((Job)Example.this);
            Scope.exit((Key[])new Key[]{model._key});
            this.tryComplete();
        }
    }
}

