/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetricsBinomial;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMValidation;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.optimization.OptimizationUtils;
import hex.schemas.GLMV3;
import hex.schemas.ModelBuilderSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.DTask;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class GLM
extends ModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    static final double LINE_SEARCH_STEP = 0.75;
    public static final double MINLINE_SEARCH_STEP = 1.0E-4;
    static final int NUM_LINE_SEARCH_STEPS = 16;
    public String _generatedWeights = null;
    private BetaConstraint _bc = new BetaConstraint();
    DataInfo _dinfo;
    transient GLMTaskInfo[] _tInfos;
    private int _lambdaId;
    private transient DataInfo _validDinfo;
    private transient ArrayList<Integer> _scoring_iters = new ArrayList();
    private transient ScoringHistory _sc;
    long _t0 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private transient GLMModel _model;
    private static final long WORK_TOTAL = 1000000L;
    static double GLM_GRAD_EPS = 1.0E-4;
    transient ArrayList<Vec> _garbage = new ArrayList();

    public boolean isSupervised() {
        return true;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    protected void checkMemoryFootPrint() {
    }

    protected void checkMemoryFootPrint(DataInfo dinfo) {
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM && !((GLMModel.GLMParameters)this._parms)._lambda_search) {
            long max_mem;
            HeartBeat hb = H2O.SELF._heartbeat;
            double p = dinfo.fullN() - dinfo.largestCat();
            long mem_usage = (long)((double)hb._cpus_allowed * (p * p + (double)dinfo.largestCat()) * 8.0 * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            if (mem_usage > (max_mem = hb.get_max_mem())) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
                this.error("_train", msg);
                this.cancel(msg);
            }
        }
    }

    public GLM(Key dest, String desc, GLMModel.GLMParameters parms) {
        super(dest, desc, (Model.Parameters)parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super("GLM", (Model.Parameters)parms);
        this.init(false);
    }

    public double likelihood() {
        return this._tInfos[0]._ginfo._likelihood;
    }

    public int nclasses() {
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
            return this._nclass;
        }
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            return 2;
        }
        return 1;
    }

    public void init(boolean expensive) {
        this._sc = new ScoringHistory();
        this._t0 = System.currentTimeMillis();
        super.init(expensive);
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (expensive) {
            GLMModel.Submodel nullSm;
            String[] warns;
            double[] dArray;
            if (this.error_count() > 0) {
                return;
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept || ((GLMModel.GLMParameters)this._parms)._lambda == null || ((GLMModel.GLMParameters)this._parms)._lambda[0] > 0.0) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
                int n = ((GLMModel.GLMParameters)this._parms)._max_active_predictors = ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM ? 7000 : 100000000;
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            this._dinfo = new DataInfo(Key.make(), (Frame)this._train.clone(), this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, ((GLMModel.GLMParameters)this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false, false, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol());
            if (this._valid != null) {
                this._validDinfo = this._dinfo.validDinfo(this._valid);
                DKV.put((Key)this._validDinfo._key, (Iced)this._validDinfo);
            }
            this.checkMemoryFootPrint(this._dinfo);
            Vec wc = this._weights == null ? this._dinfo._adaptedFrame.anyVec().makeCon(1.0) : this._weights.makeCopy();
            this._generatedWeights = "__glm_gen_weights";
            Vec wr = this._dinfo.setWeights("__glm_gen_weights", wc);
            System.out.println("made vec " + wc._key + ", replaced vec " + (wr == null ? "null" : wr._key));
            this._garbage.add(wc);
            DKV.put((Key)this._dinfo._key, (Iced)this._dinfo);
            double[] betaStart = null;
            double[] betaGiven = null;
            double[] betaLB = null;
            double[] betaUB = null;
            double[] rho = null;
            if (((GLMModel.GLMParameters)this._parms)._beta_constraints != null) {
                int idx;
                Object[] names;
                int i;
                int[] map;
                Object[] dom;
                Frame beta_constraints = (Frame)((GLMModel.GLMParameters)this._parms)._beta_constraints.get();
                Vec v = beta_constraints.vec("names");
                if (v.isString()) {
                    dom = new String[(int)v.length()];
                    map = new int[dom.length];
                    BufferedString tmpStr = new BufferedString();
                    for (int i2 = 0; i2 < dom.length; ++i2) {
                        dom[i2] = v.atStr(tmpStr, (long)i2).toString();
                        map[i2] = i2;
                    }
                    Object[] sortedDom = (String[])dom.clone();
                    Arrays.sort(sortedDom);
                    for (i = 1; i < sortedDom.length; ++i) {
                        if (!((String)sortedDom[i - 1]).equals(sortedDom[i])) continue;
                        throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)sortedDom[i - 1] + "'!");
                    }
                } else if (v.isCategorical()) {
                    dom = v.domain();
                    map = FrameUtils.asInts((Vec)v);
                    int[] sortedMap = MemoryManager.arrayCopyOf((int[])map, (int)map.length);
                    Arrays.sort(sortedMap);
                    for (int i3 = 1; i3 < sortedMap.length; ++i3) {
                        if (sortedMap[i3 - 1] != sortedMap[i3]) continue;
                        throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)dom[sortedMap[i3 - 1]] + "'!");
                    }
                } else {
                    throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
                }
                if (!Arrays.deepEquals(dom, names = (String[])ArrayUtils.append((Object[])this._dinfo.coefNames(), (Object[])new String[]{"Intercept"}))) {
                    HashMap<Object, Integer> m = new HashMap<Object, Integer>();
                    for (i = 0; i < names.length; ++i) {
                        m.put(names[i], i);
                    }
                    int[] newMap = MemoryManager.malloc4((int)dom.length);
                    for (int i4 = 0; i4 < map.length; ++i4) {
                        if (this._removedCols.contains(dom[map[i4]])) {
                            newMap[i4] = -1;
                            continue;
                        }
                        Integer I = (Integer)m.get(dom[map[i4]]);
                        if (I == null) {
                            throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i4]] + "'");
                        }
                        newMap[i4] = I;
                    }
                    map = newMap;
                }
                int numoff = this._dinfo.numStart();
                Object[] valid_col_names = new String[]{"names", "beta_given", "beta_start", "lower_bounds", "upper_bounds", "rho", "mean", "std_dev"};
                Arrays.sort(valid_col_names);
                for (String s : beta_constraints.names()) {
                    if (Arrays.binarySearch(valid_col_names, s) >= 0) continue;
                    this.error("beta_constraints", "Unknown column name '" + s + "'");
                }
                v = beta_constraints.vec("beta_start");
                if (v != null) {
                    betaStart = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    for (int i5 = 0; i5 < (int)v.length(); ++i5) {
                        if (map[i5] == -1) continue;
                        betaStart[map[i5]] = v.at((long)i5);
                    }
                }
                if ((v = beta_constraints.vec("beta_given")) != null) {
                    betaGiven = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    for (int i6 = 0; i6 < (int)v.length(); ++i6) {
                        if (map[i6] == -1) continue;
                        betaGiven[map == null ? i6 : map[i6]] = v.at((long)i6);
                    }
                }
                if ((v = beta_constraints.vec("upper_bounds")) != null) {
                    betaUB = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    Arrays.fill(betaUB, Double.POSITIVE_INFINITY);
                    for (int i7 = 0; i7 < (int)v.length(); ++i7) {
                        if (map[i7] == -1) continue;
                        betaUB[map == null ? i7 : map[i7]] = v.at((long)i7);
                    }
                }
                if ((v = beta_constraints.vec("lower_bounds")) != null) {
                    betaLB = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    Arrays.fill(betaLB, Double.NEGATIVE_INFINITY);
                    for (int i8 = 0; i8 < (int)v.length(); ++i8) {
                        if (map[i8] == -1) continue;
                        betaLB[map == null ? i8 : map[i8]] = v.at((long)i8);
                    }
                }
                if ((v = beta_constraints.vec("rho")) != null) {
                    rho = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    for (int i9 = 0; i9 < (int)v.length(); ++i9) {
                        if (map[i9] == -1) continue;
                        rho[map == null ? i9 : map[i9]] = v.at((long)i9);
                    }
                }
                if ((v = beta_constraints.vec("mean")) != null) {
                    int i10 = 0;
                    while ((long)i10 < v.length()) {
                        if (!v.isNA((long)i10) && map[i10] != -1) {
                            int n = idx = map == null ? i10 : map[i10];
                            if (idx > this._dinfo.numStart() && idx < this._dinfo.fullN()) {
                                this._dinfo._normSub[idx - this._dinfo.numStart()] = v.at((long)i10);
                            }
                        }
                        ++i10;
                    }
                }
                if ((v = beta_constraints.vec("std_dev")) != null) {
                    int i11 = 0;
                    while ((long)i11 < v.length()) {
                        if (!v.isNA((long)i11) && map[i11] != -1) {
                            int n = idx = map == null ? i11 : map[i11];
                            if (idx > this._dinfo.numStart() && idx < this._dinfo.fullN()) {
                                this._dinfo._normMul[idx - this._dinfo.numStart()] = 1.0 / v.at((long)i11);
                            }
                        }
                        ++i11;
                    }
                }
                if (this._dinfo._normMul != null) {
                    double normG = 0.0;
                    double normS = 0.0;
                    for (int i12 = numoff; i12 < this._dinfo.fullN(); ++i12) {
                        double s = this._dinfo._normSub[i12 - numoff];
                        double d = 1.0 / this._dinfo._normMul[i12 - numoff];
                        if (betaUB != null && !Double.isInfinite(betaUB[i12])) {
                            int n = i12;
                            betaUB[n] = betaUB[n] * d;
                        }
                        if (betaLB != null && !Double.isInfinite(betaUB[i12])) {
                            int n = i12;
                            betaLB[n] = betaLB[n] * d;
                        }
                        if (betaGiven != null) {
                            normG += betaGiven[i12] * s;
                            int n = i12;
                            betaGiven[n] = betaGiven[n] * d;
                        }
                        if (betaStart == null) continue;
                        normS += betaStart[i12] * s;
                        int n = i12;
                        betaStart[n] = betaStart[n] * d;
                    }
                    if (this._dinfo._intercept) {
                        int n = this._dinfo.fullN();
                        if (betaGiven != null) {
                            int n2 = n;
                            betaGiven[n2] = betaGiven[n2] + normG;
                        }
                        if (betaStart != null) {
                            int n3 = n;
                            betaStart[n3] = betaStart[n3] + normS;
                        }
                    }
                }
                if (betaStart == null && betaGiven != null) {
                    betaStart = (double[])betaGiven.clone();
                }
                if (betaStart != null && (betaLB != null || betaUB != null)) {
                    for (int i13 = 0; i13 < betaStart.length; ++i13) {
                        if (betaLB != null && betaLB[i13] > betaStart[i13]) {
                            betaStart[i13] = betaLB[i13];
                        }
                        if (betaUB == null || !(betaUB[i13] < betaStart[i13])) continue;
                        betaStart[i13] = betaUB[i13];
                    }
                }
                this._bc.setBetaStart(betaStart).setLowerBounds(betaLB).setUpperBounds(betaUB).setProximalPenalty(betaGiven, rho);
            }
            if (((GLMModel.GLMParameters)this._parms)._non_negative) {
                if (this._bc._betaLB != null) {
                    for (int i = 0; i < this._bc._betaLB.length - 1; ++i) {
                        this._bc._betaLB[i] = Math.max(0.0, this._bc._betaLB[i]);
                    }
                } else {
                    this._bc._betaLB = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                    this._bc._betaLB[this._dinfo.fullN()] = Double.NEGATIVE_INFINITY;
                    this._bc._betaUB = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                    Arrays.fill(this._bc._betaUB, Double.POSITIVE_INFINITY);
                }
            }
            this._tInfos = new GLMTaskInfo[((GLMModel.GLMParameters)this._parms)._nfolds + 1];
            InitTsk itsk = new InitTsk(0, ((GLMModel.GLMParameters)this._parms)._intercept);
            ((InitTsk)H2O.submitTask((H2O.H2OCountedCompleter)itsk)).join();
            assert (itsk._nobs == 0L || itsk.getNullGradient() != null);
            assert (itsk._nobs == 0L || itsk._nobs == itsk.getNobs()) : "unexpected _nobs, " + itsk._nobs + " != " + itsk.getNobs();
            if (itsk._nobs == 0L) {
                this.error("training_frame", "Got no data to run on after filtering out the rows with missing values.");
                return;
            }
            if (itsk._yMin == itsk._yMax) {
                this.error("response", "Can not run glm on dataset with constant response. Response == " + itsk._yMin + " for all rows in the dataset after filtering out rows with NAs, got " + itsk._nobs + " rows out of " + this._dinfo._adaptedFrame.numRows() + " rows total.");
                return;
            }
            if (itsk._nobs < this._dinfo._adaptedFrame.numRows() >> 1) {
                this.warn("_training_frame", "Dataset has less than 1/2 of the data after filtering out rows with NAs");
            }
            if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / itsk._wsum;
            }
            if (((GLMModel.GLMParameters)this._parms)._obj_reg <= 0.0) {
                this.error("obj_reg", "Must be positive or -1 for default");
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(itsk._yMu[0] * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - itsk._yMu[0])));
            }
            if (((GLMModel.GLMParameters)this._parms)._family != GLMModel.GLMParameters.Family.multinomial) {
                this._bc.adjustGradient(itsk.getNullBeta(), itsk.getNullGradient());
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM || ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE ? 0.5 : 0.0};
            }
            double lmax = this.lmax(itsk.getNullGradient());
            double objStart = ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this.objVal(itsk.getBetaStartLikelihood(), itsk.getNullMultinomialBeta(), lmax) : this.objVal(itsk.getBetaStartLikelihood(), itsk.getBetaStart(), lmax);
            long l = itsk._nobs;
            double d = itsk._wsum;
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = ((GLMModel.GLMParameters)this._parms)._prior;
            } else {
                dArray = itsk._yMu;
            }
            this._tInfos[0] = new GLMTaskInfo(this._dest, 0, l, d, dArray, lmax, this._bc._betaStart, this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0), new GLMGradientInfo(itsk.getBetaStartLikelihood(), objStart, itsk.getStartGradient()), objStart);
            this._tInfos[0]._nullGradNorm = ArrayUtils.linfnorm((double[])itsk.getNullGradient(), (boolean)false);
            this._tInfos[0]._nullDevTrain = itsk.getNullDeviance();
            this._tInfos[0]._numClasses = this.nclasses();
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                this._tInfos[0]._beta_multinomial = itsk.getNullMultinomialBeta();
            }
            this._sc.addIterationScore(0, itsk.getBetaStartLikelihood(), objStart);
            this._tInfos[0].adjustToNewLambda(0.0, lmax, ((GLMModel.GLMParameters)this._parms)._alpha[0], true);
            if (((GLMModel.GLMParameters)this._parms)._lambda != null) {
                int i;
                ArrayUtils.mult((double[])((GLMModel.GLMParameters)this._parms)._lambda, (double)-1.0);
                Arrays.sort(((GLMModel.GLMParameters)this._parms)._lambda);
                ArrayUtils.mult((double[])((GLMModel.GLMParameters)this._parms)._lambda, (double)-1.0);
                for (i = 0; i < ((GLMModel.GLMParameters)this._parms)._lambda.length && ((GLMModel.GLMParameters)this._parms)._lambda[i] > this._tInfos[0]._lambdaMax; ++i) {
                }
                if (i == ((GLMModel.GLMParameters)this._parms)._lambda.length) {
                    this.error("_lambda", "All passed lambda values are > lambda_max = " + this._tInfos[0]._lambdaMax + ", nothing to compute.");
                }
                if (i > 0) {
                    ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOfRange(((GLMModel.GLMParameters)this._parms)._lambda, i, ((GLMModel.GLMParameters)this._parms)._lambda.length);
                    this.warn("_lambda", "removed " + i + " lambda values which were greater than lambda_max = " + this._tInfos[0]._lambdaMax);
                }
            } else if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                if (((GLMModel.GLMParameters)this._parms)._nlambdas == 1) {
                    this.error("_nlambdas", "Number of lambdas must be > 1 when running with lambda_search!");
                }
                if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._tInfos[0]._nobs > (long)(25 * this._dinfo.fullN()) ? 1.0E-4 : 0.01;
                }
                double d2 = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                ((GLMModel.GLMParameters)this._parms)._lambda = MemoryManager.malloc8d((int)((GLMModel.GLMParameters)this._parms)._nlambdas);
                ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._tInfos[0]._lambdaMax;
                for (int i = 1; i < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i) {
                    ((GLMModel.GLMParameters)this._parms)._lambda[i] = ((GLMModel.GLMParameters)this._parms)._lambda[i - 1] * d2;
                }
                this._lambdaId = 1;
            } else {
                ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{this._tInfos[0]._lambdaMax * ((long)this._dinfo.fullN() < this._tInfos[0]._nobs >> 4 ? 0.001 : 0.1)};
            }
            this._model = ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? new GLMModel(this._dest, (GLMModel.GLMParameters)this._parms, this, this._tInfos[0]._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._tInfos[0]._lambdaMax, this._tInfos[0]._nobs, this.hasWeightCol(), this.hasOffsetCol()) : new GLMModel(this._dest, (GLMModel.GLMParameters)this._parms, this, this._tInfos[0]._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._tInfos[0]._lambdaMax, this._tInfos[0]._nobs, this.hasWeightCol(), this.hasOffsetCol());
            for (String s : warns = this._model.adaptTestForTrain(this._valid, true, true)) {
                this.warn("_validation_frame", s);
            }
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                double[][] betaMultinomial = itsk.getNullMultinomialBeta();
                double[][] betas = new double[this._nclass][1];
                int[] idxs = new int[]{};
                for (int i = 0; i < betas.length; ++i) {
                    betas[i][0] = betaMultinomial[i][betaMultinomial[i].length - 1];
                }
                nullSm = new GLMModel.Submodel(((GLMModel.GLMParameters)this._parms)._lambda[0], betas, idxs, 0, itsk.getNullValidation().explainedDev(), itsk._gtNullTestMultinomial != null ? ((InitTsk)itsk)._gtNullTestMultinomial._val.residualDeviance() : Double.NaN);
                if (this._valid != null) {
                    ((GLMModel.GLMOutput)this._model._output)._validation_metrics = ((InitTsk)itsk)._gtNullTestMultinomial._val.makeModelMetrics(this._model, ((GLMModel.GLMParameters)this._parms).valid());
                }
            } else {
                nullSm = new GLMModel.Submodel(((GLMModel.GLMParameters)this._parms)._lambda[0], this._bc._betaStart, 0, itsk.getNullValidation().explainedDev(), itsk._gtNullTest != null ? ((InitTsk)itsk)._gtNullTest._val.residualDeviance() : Double.NaN);
                if (this._valid != null) {
                    ((GLMModel.GLMOutput)this._model._output)._validation_metrics = ((InitTsk)itsk)._gtNullTest._val.makeModelMetrics(this._model, ((GLMModel.GLMParameters)this._parms).valid());
                }
            }
            this._model.setSubmodel(nullSm);
            ((GLMModel.GLMOutput)this._model._output).setSubmodelIdx(0);
            ((GLMModel.GLMOutput)this._model._output)._training_metrics = itsk.getNullValidation().makeModelMetrics(this._model, ((GLMModel.GLMParameters)this._parms).train());
            this._model.delete_and_lock(this._key);
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                int numclasses = this.nclasses();
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM) {
                    ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? numclasses * 10 * ((GLMModel.GLMParameters)this._parms)._nlambdas : numclasses * 50;
                } else {
                    ((GLMModel.GLMParameters)this._parms)._max_iterations = numclasses * Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                        ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._nlambdas * 100 * numclasses;
                    }
                }
            }
            this._tInfos[0]._workPerIteration = ((GLMModel.GLMParameters)this._parms)._lambda_search ? 0 : (int)(1000000L / (long)((GLMModel.GLMParameters)this._parms)._max_iterations);
            this._tInfos[0]._workPerLambda = (int)(((GLMModel.GLMParameters)this._parms)._lambda_search ? 1000000L / (long)((GLMModel.GLMParameters)this._parms)._nlambdas : 0L);
        }
    }

    public ModelBuilderSchema schema() {
        return new GLMV3();
    }

    protected Job<GLMModel> trainModelImpl(long work, boolean restartTimer) {
        this.start((H2O.H2OCountedCompleter)new GLMDriver(null), work, restartTimer);
        return this;
    }

    public long progressUnits() {
        return 1000000L;
    }

    private final double lmax(double[] grad) {
        return Math.max(ArrayUtils.maxValue((double[])grad), -ArrayUtils.minValue((double[])grad)) / Math.max(0.001, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private double currentLambda() {
        return ((GLMModel.GLMParameters)this._parms)._lambda[this._lambdaId];
    }

    double objVal(double likelihood, double[][] beta) {
        return this.objVal(likelihood, beta, this.currentLambda());
    }

    double objVal(double likelihood, double[][] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        if (this._bc._betaGiven != null) {
            throw H2O.unimpl();
        }
        double l1normSum = 0.0;
        double l2normSum = 0.0;
        for (double[] b : beta) {
            l1normSum += ArrayUtils.l1norm((double[])b, (boolean)((GLMModel.GLMParameters)this._parms)._intercept);
            l2normSum += ArrayUtils.l2norm2((double[])b, (boolean)((GLMModel.GLMParameters)this._parms)._intercept);
        }
        double res = likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + proximalPen + lambda * (alpha * l1normSum + (1.0 - alpha) * 0.5 * l2normSum);
        return res;
    }

    double objVal(double likelihood, double[] beta) {
        return this.objVal(likelihood, beta, this.currentLambda());
    }

    double objVal(double likelihood, double[] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        if (this._bc._betaGiven != null && this._bc._rho != null) {
            for (int i = 0; i < this._bc._betaGiven.length; ++i) {
                double diff = beta[i] - this._bc._betaGiven[i];
                proximalPen += diff * diff * this._bc._rho[i];
            }
        }
        return likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + 0.5 * proximalPen + lambda * (alpha * ArrayUtils.l1norm((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept));
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d((int)fullN);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static final double[] contractVec(double[] beta, int[] activeCols) {
        if (beta == null) {
            return null;
        }
        if (activeCols == null) {
            return (double[])beta.clone();
        }
        double[] res = MemoryManager.malloc8d((int)(activeCols.length + 1));
        int i = 0;
        for (int c : activeCols) {
            res[i++] = beta[c];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static final double[] resizeVec(double[] beta, int[] activeCols, int[] oldActiveCols, int fullN) {
        if (beta == null || Arrays.equals(activeCols, oldActiveCols)) {
            return beta;
        }
        double[] full = GLM.expandVec(beta, oldActiveCols, fullN);
        if (activeCols == null) {
            return full;
        }
        return GLM.contractVec(full, activeCols);
    }

    protected static double sparseOffset(double[] beta, DataInfo dinfo) {
        double etaOffset = 0.0;
        if (dinfo._normMul != null && dinfo._normSub != null && beta != null) {
            int ns = dinfo.numStart();
            for (int i = 0; i < dinfo._nums; ++i) {
                etaOffset -= beta[i + ns] * dinfo._normSub[i] * dinfo._normMul[i];
            }
        }
        return etaOffset;
    }

    public static final class GLMGradientSolver
    implements OptimizationUtils.GradientSolver {
        final GLMModel.GLMParameters _parms;
        final DataInfo _dinfo;
        final double[] _ymu;
        final double _lambda;
        final double _reg;
        double[] _beta;
        final double[][] _betaMultinomial;

        public GLMGradientSolver(GLMModel.GLMParameters glmp, DataInfo dinfo, double lambda, double[] ymu, double reg) {
            this._parms = glmp;
            this._dinfo = dinfo;
            this._ymu = ymu;
            this._lambda = lambda;
            this._reg = reg;
            this._betaMultinomial = glmp._family == GLMModel.GLMParameters.Family.multinomial ? new double[ymu.length][this._dinfo.fullN() + 1] : (double[][])null;
        }

        public GLMGradientSolver setBetaStart(double[] beta) {
            this._beta = (double[])beta.clone();
            return this;
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            GLMTask.GLMGradientTask gt;
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial) {
                int off = 0;
                for (int i = 0; i < this._betaMultinomial.length; ++i) {
                    System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                    off += this._betaMultinomial[i].length;
                }
                GLMTask.GLMMultinomialGradientTask gt2 = (GLMTask.GLMMultinomialGradientTask)new GLMTask.GLMMultinomialGradientTask(this._dinfo, this._lambda, this._ymu, this._betaMultinomial, this._reg, false, null).doAll(this._dinfo._adaptedFrame);
                double l2pen = 0.0;
                for (double[] b : this._betaMultinomial) {
                    l2pen += ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
                }
                return new GLMGradientInfo(gt2._likelihood, gt2._likelihood * this._reg + 0.5 * this._lambda * l2pen, gt2._gradient);
            }
            assert (beta.length == this._dinfo.fullN() + 1);
            if (!this._parms._intercept) {
                beta[beta.length - 1] = 0.0;
            }
            GLMTask.GLMGradientTask gLMGradientTask = gt = this._parms._family == GLMModel.GLMParameters.Family.binomial ? (GLMTask.GLMGradientTask)new GLMTask.LBFGS_LogisticGradientTask(this._dinfo, this._parms, this._lambda, beta, this._reg, this._parms._intercept).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(this._dinfo, this._parms, this._lambda, beta, this._reg, this._parms._intercept).doAll(this._dinfo._adaptedFrame);
            if (!this._parms._intercept) {
                gt._gradient[gt._gradient.length - 1] = 0.0;
            }
            return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._reg + 0.5 * this._lambda * ArrayUtils.l2norm2((double[])beta, (boolean)this._dinfo._intercept), gt._gradient);
        }
    }

    public static final class LBFGS_ProximalSolver
    implements ADMM.ProximalSolver {
        double[] _beta;
        final double[] _rho;
        final OptimizationUtils.GradientSolver _gSolver;
        double[] _gradient;
        public int _iter;
        L_BFGS.ProgressMonitor _pm;
        double _gradEps = 1.0E-8;
        double _objEps = 1.0E-5;
        double[] _beta_given;
        OptimizationUtils.GradientInfo _ginfo;

        public LBFGS_ProximalSolver(OptimizationUtils.GradientSolver gs, double[] beta, double[] rho, L_BFGS.ProgressMonitor pm) {
            this._gSolver = gs;
            this._beta = beta;
            this._rho = rho;
            this._pm = pm;
        }

        public LBFGS_ProximalSolver setGradEps(double eps) {
            this._gradEps = eps;
            return this;
        }

        public LBFGS_ProximalSolver setObjEps(double eps) {
            this._objEps = eps;
            return this;
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            ProximalGradientSolver s = new ProximalGradientSolver(this._gSolver, beta_given, this._rho);
            if (this._beta_given == null) {
                this._beta_given = MemoryManager.malloc8d((int)beta_given.length);
            }
            if (this._ginfo != null) {
                for (int i = 0; i < beta_given.length; ++i) {
                    int n = i;
                    this._ginfo._gradient[n] = this._ginfo._gradient[n] + this._rho[i] * (this._beta_given[i] - beta_given[i]);
                    this._ginfo._objVal += 0.5 * this._rho[i] * ((this._beta[i] - beta_given[i]) * (this._beta[i] - beta_given[i]) - (this._beta[i] - this._beta_given[i]) * (this._beta[i] - this._beta_given[i]));
                    this._beta_given[i] = beta_given[i];
                }
            } else {
                this._ginfo = s.getGradient(this._beta);
            }
            L_BFGS.Result r = new L_BFGS().setObjEps(this._objEps).setGradEps(this._gradEps).solve(s, this._beta, this._ginfo, this._pm);
            this._ginfo = r.ginfo;
            this._beta = r.coefs;
            this._gradient = r.ginfo._gradient;
            this._iter += r.iter;
            System.arraycopy(this._beta, 0, result, 0, this._beta.length);
            return r.converged;
        }

        @Override
        public boolean hasGradient() {
            return this._gradient != null;
        }

        @Override
        public double[] gradient(double[] beta) {
            return this._gSolver.getGradient((double[])beta)._gradient;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static final class GLMGradientInfo
    extends OptimizationUtils.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }
    }

    public static class ProximalGradientSolver
    implements OptimizationUtils.GradientSolver {
        final OptimizationUtils.GradientSolver _solver;
        final double[] _betaGiven;
        final double[] _rho;
        public OptimizationUtils.GradientInfo _lastGinfo;

        public ProximalGradientSolver(OptimizationUtils.GradientSolver s, double[] betaGiven, double[] rho) {
            this._solver = s;
            this._betaGiven = betaGiven;
            this._rho = rho;
        }

        @Override
        public OptimizationUtils.GradientInfo getGradient(double[] beta) {
            OptimizationUtils.GradientInfo gt = this._lastGinfo = this._solver.getGradient(beta);
            double[] grad = (double[])gt._gradient.clone();
            double obj = gt._objVal;
            int i = 0;
            while (i < gt._gradient.length) {
                double diff = beta[i] - this._betaGiven[i];
                double pen = this._rho[i] * diff;
                int n = i++;
                grad[n] = grad[n] + pen;
                obj += 0.5 * pen * diff;
            }
            return new ProximalGradientInfo(gt, obj, grad);
        }
    }

    public static class ProximalGradientInfo
    extends OptimizationUtils.GradientInfo {
        final OptimizationUtils.GradientInfo _origGinfo;

        public ProximalGradientInfo(OptimizationUtils.GradientInfo origGinfo, double objVal, double[] gradient) {
            super(objVal, gradient);
            this._origGinfo = origGinfo;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x, double lb, double ub) {
            if (x < lb) {
                x = lb;
            }
            if (x > ub) {
                x = ub;
            }
            return x;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            if (!intercept) {
                gram.dropIntercept();
                xy = Arrays.copyOf(xy, xy.length - 1);
            }
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf((double[])result, (int)result.length);
                for (int i = 0; i < 1000; ++i) {
                    this.solve(oldRes, result);
                    double[] g = this.gradient(result);
                    gerr = Math.max(-ArrayUtils.minValue((double[])g), ArrayUtils.maxValue((double[])g));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn((Object[])new Object[]{"Gram solver did not converge, gerr = " + gerr});
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double default_rho, double[] lb, double[] ub) {
            int i;
            if (ub != null && lb != null) {
                for (int i2 = 0; i2 < ub.length; ++i2) {
                    assert (ub[i2] >= lb[i2]) : i2 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = xy.length - 1;
            double[] rhos = MemoryManager.malloc8d((int)(xy.length - 1 + ii));
            double min = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < xy.length - 1; ++i3) {
                double d = xy[i3];
                double d2 = d = d >= 0.0 ? d : -d;
                if (!(d < min) || d == 0.0) continue;
                min = d;
            }
            double ybar = xy[icptCol];
            for (i = 0; i < rhos.length - ii; ++i) {
                double y = xy[i];
                if (y == 0.0) {
                    y = min;
                }
                double xbar = gram.get(icptCol, i);
                double x = beta_given != null && proxPen != null ? (y - ybar * gram.get(icptCol, i) + proxPen[i] * beta_given[i]) / (gram.get(i, i) - xbar * xbar + l2pen + proxPen[i]) : (y - ybar * xbar) / (gram.get(i, i) - xbar * xbar) + l2pen;
                rhos[i] = ADMM.L1Solver.estimateRho(x, l1pen, lb == null ? Double.NEGATIVE_INFINITY : lb[i], ub == null ? Double.POSITIVE_INFINITY : ub[i]);
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (!intercept) {
                gram.dropIntercept();
                xy = Arrays.copyOf(xy, xy.length - 1);
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i = 0; i < xy.length; ++i) {
                    int n = i;
                    xy[n] = xy[n] + proxPen[i] * beta_given[i];
                }
            }
            this.computeCholesky(gram, rhos, 1.0E-5);
            this._rho = rhos;
            this._xy = xy;
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd) {
            gram.addDiag(rhos);
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                ArrayUtils.mult((double[])rhos, (double)-1.0);
                int i = 0;
                while (i < rhos.length) {
                    int n = i++;
                    rhos[n] = rhos[n] + rhoAdd;
                }
                Log.info((Object[])new Object[]{"Got NonSPD matrix with original rho, re-computing with rho = " + rhos[0]});
                this._gram.addDiag(rhos);
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                    ArrayUtils.mult((double[])rhos, (double)-1.0);
                    int i2 = 0;
                    while (i2 < rhos.length) {
                        int n = i2++;
                        rhos[n] = rhos[n] * 100.0;
                    }
                    Log.warn((Object[])new Object[]{"Still NonSPD matrix, re-computing with rho = " + rhos[0]});
                    this._gram.addDiag(rhos);
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
            ArrayUtils.mult((double[])rhos, (double)-1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i = 0; i < this._xy.length; ++i) {
                    result[i] = this._xy[i] + this._rho[i] * beta_given[i];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
            return true;
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public double[] gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i = 0; i < this._xy.length; ++i) {
                int n = i;
                grad[n] = grad[n] - this._xy[i];
            }
            return grad;
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMSingleLambdaTsk
    extends DTask<GLMSingleLambdaTsk> {
        private static final int CD_MAX_ITERATIONS = 100;
        DataInfo _activeData;
        GLMTaskInfo _taskInfo;
        long _start_time;
        private int _c;
        private double _oldObj;
        int _oldIter;

        public GLMSingleLambdaTsk(H2O.H2OCountedCompleter cmp, GLMTaskInfo state) {
            super(cmp);
            this._oldObj = Double.MAX_VALUE;
            this._taskInfo = state;
            assert (DKV.get((Key)GLM.this._dinfo._key) != null);
        }

        private String LogInfo(String msg) {
            msg = "GLM[dest=" + this._taskInfo._dstKey + ", iteration=" + this._taskInfo._iter + ", lambda = " + MathUtils.roundToNDigits((double)((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], (int)4) + "]: " + msg;
            Log.info((Object[])new Object[]{msg});
            return msg;
        }

        private String LogDebug(String msg) {
            msg = "GLM[dest=" + this._taskInfo._dstKey + ", iteration=" + this._taskInfo._iter + ", lambda = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] + "]: " + msg;
            Log.debug((Object[])new Object[]{msg});
            return msg;
        }

        private int[] activeCols(double l1, double l2, double[] grad) {
            if (this._taskInfo._allIn) {
                return null;
            }
            int selected = 0;
            int[] cols = null;
            if (((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] > 0.0) {
                double rhs = ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * (2.0 * l1 - l2);
                cols = MemoryManager.malloc4((int)GLM.this._dinfo.fullN());
                int j = 0;
                int[] oldActiveCols = this._taskInfo._activeCols;
                if (oldActiveCols == null) {
                    oldActiveCols = new int[]{};
                }
                int C = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? GLM.this._nclass : 1;
                int P = GLM.this._dinfo.fullN() + 1;
                block0: for (int i = 0; i < GLM.this._dinfo.fullN(); ++i) {
                    for (int c = 0; c < C; ++c) {
                        if (!(j < oldActiveCols.length && i == oldActiveCols[j] || grad[i + c * P] > rhs) && !(grad[i + c * P] < -rhs)) continue;
                        cols[selected++] = i;
                        if (j >= oldActiveCols.length || i != oldActiveCols[j]) continue block0;
                        ++j;
                        continue block0;
                    }
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] == 0.0 || selected == GLM.this._dinfo.fullN()) {
                this._taskInfo._allIn = true;
                this._activeData = GLM.this._dinfo;
                this.LogInfo("All " + GLM.this._dinfo.fullN() + " coefficients are active");
                return null;
            }
            this.LogInfo(selected + " / " + GLM.this._dinfo.fullN() + " cols are active");
            return Arrays.copyOf(cols, selected);
        }

        private void doUpdateCD(double[] grads, double[][] xx, double[] betaold, double[] betanew, int variable) {
            double diff = betaold[variable] - betanew[variable];
            double[] ary = xx[variable];
            for (int i = 0; i < grads.length; ++i) {
                if (i == variable) continue;
                int n = i;
                grads[n] = grads[n] + diff * ary[i];
            }
        }

        protected void solve(boolean doLineSearch) {
            if (this._activeData.fullN() > ((GLMModel.GLMParameters)GLM.this._parms)._max_active_predictors) {
                throw new TooManyPredictorsException();
            }
            this._oldIter = this._taskInfo._iter;
            GLMModel.GLMParameters.Solver solverType = ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            if (solverType == GLMModel.GLMParameters.Solver.AUTO) {
                solverType = this._activeData.fullN() > 6000 || this._activeData._adaptedFrame.numCols() > 500 ? GLMModel.GLMParameters.Solver.L_BFGS : GLMModel.GLMParameters.Solver.IRLSM;
            }
            switch (solverType) {
                case L_BFGS: {
                    final double l1pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0];
                    L_BFGS.ProgressMonitor pm = new L_BFGS.ProgressMonitor(){

                        @Override
                        public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
                            if (GLMSingleLambdaTsk.this._taskInfo._iter < 8 || (GLMSingleLambdaTsk.this._taskInfo._iter & 7) == 0) {
                                double gnorm = 0.0;
                                double objval = 0.0;
                                if (ginfo instanceof ProximalGradientInfo) {
                                    ProximalGradientInfo g = (ProximalGradientInfo)ginfo;
                                    if (g._origGinfo instanceof GLMGradientInfo) {
                                        GLMGradientInfo gg = (GLMGradientInfo)g._origGinfo;
                                        double obj = gg._objVal;
                                        for (int i = 0; i < beta.length; ++i) {
                                            obj += l1pen * (beta[i] >= 0.0 ? beta[i] : -beta[i]);
                                        }
                                        GLM.this._sc.addIterationScore(GLMSingleLambdaTsk.this._taskInfo._iter, gg._likelihood, obj);
                                        double[] subgrad = (double[])ginfo._gradient.clone();
                                        ADMM.subgrad(l1pen, beta, subgrad);
                                        gnorm = ArrayUtils.l2norm2((double[])subgrad, (boolean)false);
                                        objval = obj;
                                    }
                                } else {
                                    gnorm = ArrayUtils.linfnorm((double[])ginfo._gradient, (boolean)false);
                                    objval = ginfo._objVal;
                                }
                                if (ginfo instanceof GLMGradientInfo) {
                                    GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
                                    GLM.this._sc.addIterationScore(GLMSingleLambdaTsk.this._taskInfo._iter, gginfo._likelihood, gginfo._objVal);
                                }
                                int iterDelta = GLMSingleLambdaTsk.this._taskInfo._iter < 8 ? 1 : 8;
                                GLMSingleLambdaTsk.this._taskInfo._worked += GLMSingleLambdaTsk.this._taskInfo._workPerIteration * iterDelta;
                                Job.update((long)(GLMSingleLambdaTsk.this._taskInfo._workPerIteration * iterDelta), (String)("iteration " + (GLMSingleLambdaTsk.this._taskInfo._iter + 1) + ", objective value = " + MathUtils.roundToNDigits((double)objval, (int)4) + ", ginfo norm = " + MathUtils.roundToNDigits((double)gnorm, (int)4)), (Key)GLM.this._key);
                                GLMSingleLambdaTsk.this.LogInfo("LBFGS: objval = " + objval);
                            }
                            ++GLMSingleLambdaTsk.this._taskInfo._iter;
                            return Job.isRunning((Key)GLM.this._key) && GLMSingleLambdaTsk.this._taskInfo._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
                        }
                    };
                    double[] beta = this._taskInfo._beta;
                    OptimizationUtils.GradientSolver solver = new GLMGradientSolver((GLMModel.GLMParameters)GLM.this._parms, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), this._taskInfo._ymu, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                    if (((GLM)GLM.this)._bc._betaGiven != null && ((GLM)GLM.this)._bc._rho != null) {
                        solver = new ProximalGradientSolver(solver, ((GLM)GLM.this)._bc._betaGiven, ((GLM)GLM.this)._bc._rho);
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        beta = MemoryManager.malloc8d((int)((this._activeData.fullN() + 1) * GLM.this._nclass));
                        int P = this._activeData.fullN() + 1;
                        for (int i = 0; i < GLM.this._nclass; ++i) {
                            beta[i * P + P - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(this._taskInfo._ymu[i]);
                        }
                    }
                    if (beta == null) {
                        beta = MemoryManager.malloc8d((int)(this._activeData.fullN() + (this._activeData._intercept ? 1 : 0)));
                        if (this._activeData._intercept) {
                            beta[beta.length - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(this._taskInfo._ymu[0]);
                        }
                    }
                    L_BFGS lbfgs = new L_BFGS().setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon).setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
                    assert (beta.length == this._taskInfo._ginfo._gradient.length);
                    int P = GLM.this._dinfo.fullN();
                    if (l1pen > 0.0 || GLM.this._bc.hasBounds()) {
                        int i;
                        double[] nullBeta = MemoryManager.malloc8d((int)beta.length);
                        if (GLM.this._dinfo._intercept) {
                            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                                for (int c = 0; c < GLM.this._nclass; ++c) {
                                    nullBeta[(c + 1) * (P + 1) - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(this._taskInfo._ymu[c]);
                                }
                            } else {
                                nullBeta[nullBeta.length - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(this._taskInfo._ymu[0]);
                            }
                        }
                        OptimizationUtils.GradientInfo ginfo = solver.getGradient(nullBeta);
                        double[] direction = ArrayUtils.mult((double[])((double[])ginfo._gradient.clone()), (double)-1.0);
                        OptimizationUtils.MoreThuente mt = new OptimizationUtils.MoreThuente();
                        mt.evaluate(solver, ginfo, nullBeta, direction, 1.0E-12, 1000.0, 10);
                        double t = mt.step();
                        double[] rho = MemoryManager.malloc8d((int)beta.length);
                        for (i = 0; i < rho.length - 1; ++i) {
                            rho[i] = ADMM.L1Solver.estimateRho(nullBeta[i] + t * direction[i], l1pen, ((GLM)GLM.this)._bc._betaLB == null ? Double.NEGATIVE_INFINITY : ((GLM)GLM.this)._bc._betaLB[i], ((GLM)GLM.this)._bc._betaUB == null ? Double.POSITIVE_INFINITY : ((GLM)GLM.this)._bc._betaUB[i]);
                        }
                        for (int ii = P; ii < rho.length; ii += P + 1) {
                            rho[ii] = ADMM.L1Solver.estimateRho(nullBeta[ii] + t * direction[ii], 0.0, ((GLM)GLM.this)._bc._betaLB == null ? Double.NEGATIVE_INFINITY : ((GLM)GLM.this)._bc._betaLB[ii], ((GLM)GLM.this)._bc._betaUB == null ? Double.POSITIVE_INFINITY : ((GLM)GLM.this)._bc._betaUB[ii]);
                        }
                        for (i = 0; i < rho.length - 1; ++i) {
                            rho[i] = Math.min(1000.0, rho[i]);
                        }
                        double[] objvals = new double[2];
                        objvals[1] = Double.POSITIVE_INFINITY;
                        double reltol = ADMM.L1Solver.DEFAULT_RELTOL;
                        double abstol = ADMM.L1Solver.DEFAULT_ABSTOL;
                        double ADMM_gradEps = 0.01;
                        if (GLM.this._bc != null) {
                            new ADMM.L1Solver(ADMM_gradEps, 500, reltol, abstol).solve(new LBFGS_ProximalSolver(solver, beta, rho, pm).setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon), beta, l1pen, this._activeData._intercept, ((GLM)GLM.this)._bc._betaLB, ((GLM)GLM.this)._bc._betaUB);
                        } else {
                            new ADMM.L1Solver(ADMM_gradEps, 500, reltol, abstol).solve(new LBFGS_ProximalSolver(solver, beta, rho, pm).setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon), beta, l1pen);
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial) break;
                        for (int i2 = 0; i2 < this._taskInfo._beta_multinomial.length; ++i2) {
                            System.arraycopy(beta, i2 * (P + 1), this._taskInfo._beta_multinomial[i2], 0, this._taskInfo._beta_multinomial[i2].length);
                        }
                        break;
                    }
                    L_BFGS.Result r = lbfgs.solve(solver, beta, this._taskInfo._ginfo, pm);
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        for (int i = 0; i < this._taskInfo._beta_multinomial.length; ++i) {
                            System.arraycopy(r.coefs, i * (P + 1), this._taskInfo._beta_multinomial[i], 0, this._taskInfo._beta_multinomial[i].length);
                        }
                        break;
                    }
                    this._taskInfo._beta = r.coefs;
                    break;
                }
                case COORDINATE_DESCENT_NAIVE: {
                    int p = this._activeData.fullN() + 1;
                    boolean skipFirstLevel = !this._activeData._useAllFactorLevels;
                    double[] beta = (double[])this._taskInfo._beta.clone();
                    double[] betaold = (double[])this._taskInfo._beta.clone();
                    double objold = this._taskInfo._objVal;
                    int iter2 = 0;
                    Vec[] newVecs = this._activeData._adaptedFrame.anyVec().makeZeros(3);
                    Vec w = newVecs[0];
                    Vec z = newVecs[1];
                    Vec zTilda = newVecs[2];
                    long startTimeTotalNaive = System.currentTimeMillis();
                    while (iter2++ < 30) {
                        double percdiff;
                        Frame fr = new Frame(this._activeData._adaptedFrame);
                        fr.add("w", w);
                        fr.add("z", z);
                        fr.add("zTilda", zTilda);
                        GLMTask.GLMGenerateWeightsTask gt = (GLMTask.GLMGenerateWeightsTask)new GLMTask.GLMGenerateWeightsTask(GLM.this._key, this._activeData, (GLMModel.GLMParameters)GLM.this._parms, beta).doAll(fr);
                        double objVal = GLM.this.objVal(gt._likelihood, gt._betaw);
                        double[] denums = gt.denums;
                        double wsum = gt.wsum;
                        double wsumu = gt.wsumu;
                        int iter1 = 0;
                        while (iter1++ < 100) {
                            GLMTask.GLMCoordinateDescentTaskSeqNaive iupdate;
                            boolean intercept;
                            Frame fr3;
                            Frame fr2 = new Frame(new Vec[0]);
                            fr2.add("w", w);
                            fr2.add("z", z);
                            fr2.add("zTilda", zTilda);
                            for (int i = 0; i < this._activeData._cats; ++i) {
                                fr3 = new Frame(fr2);
                                int level_num = this._activeData._catOffsets[i + 1] - this._activeData._catOffsets[i];
                                int prev_level_num = 0;
                                fr3.add("xj", this._activeData._adaptedFrame.vec(i));
                                boolean bl = intercept = i == 0;
                                if (!intercept) {
                                    prev_level_num = this._activeData._catOffsets[i] - this._activeData._catOffsets[i - 1];
                                    fr3.add("xjm1", this._activeData._adaptedFrame.vec(i - 1));
                                }
                                int start_old = this._activeData._catOffsets[i];
                                GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate = intercept ? (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 4, Arrays.copyOfRange(betaold, start_old, start_old + level_num), new double[]{beta[p - 1]}, this._activeData._catLvls[i], null, null, null, null, null, skipFirstLevel).doAll(fr3) : (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 1, Arrays.copyOfRange(betaold, start_old, start_old + level_num), Arrays.copyOfRange(beta, this._activeData._catOffsets[i - 1], this._activeData._catOffsets[i]), this._activeData._catLvls[i], this._activeData._catLvls[i - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                                for (int j = 0; j < level_num; ++j) {
                                    beta[this._activeData._catOffsets[i] + j] = ADMM.shrinkage(stupdate._temp[j] / wsumu, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[this._activeData._catOffsets[i] + j] / wsumu + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                                }
                            }
                            int cat_num = 2;
                            for (int i = 0; i < this._activeData._nums; ++i) {
                                GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate;
                                Frame fr32 = new Frame(fr2);
                                fr32.add("xj", this._activeData._adaptedFrame.vec(i + this._activeData._cats));
                                intercept = i == 0 && this._activeData.numStart() == 0;
                                double[] meannew = null;
                                double[] meanold = null;
                                double[] varnew = null;
                                double[] varold = null;
                                if (i > 0 || intercept) {
                                    cat_num = 3;
                                    if (!intercept) {
                                        fr32.add("xjm1", this._activeData._adaptedFrame.vec(i - 1 + this._activeData._cats));
                                    }
                                    if (this._activeData._normMul != null) {
                                        varold = new double[]{this._activeData._normMul[i]};
                                        meanold = new double[]{this._activeData._normSub[i]};
                                        if (i != 0) {
                                            varnew = new double[]{this._activeData._normMul[i - 1]};
                                            meannew = new double[]{this._activeData._normSub[i - 1]};
                                        }
                                    }
                                    stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[this._activeData.numStart() + i]}, new double[]{beta[(this._activeData.numStart() + i - 1 + p) % p]}, null, null, varold, meanold, varnew, meannew, skipFirstLevel).doAll(fr32);
                                    beta[i + this._activeData.numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[i + this._activeData.numStart()] / wsumu + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                                    continue;
                                }
                                if (i != 0 || intercept) continue;
                                int prev_level_num = this._activeData.numStart() - this._activeData._catOffsets[this._activeData._cats - 1];
                                fr32.add("xjm1", this._activeData._adaptedFrame.vec(this._activeData._cats - 1));
                                if (this._activeData._normMul != null) {
                                    varold = new double[]{this._activeData._normMul[i]};
                                    meanold = new double[]{this._activeData._normSub[i]};
                                }
                                stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[this._activeData.numStart()]}, Arrays.copyOfRange(beta, this._activeData._catOffsets[this._activeData._cats - 1], this._activeData.numStart()), null, this._activeData._catLvls[this._activeData._cats - 1], varold, meanold, null, null, skipFirstLevel).doAll(fr32);
                                beta[this._activeData.numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[this._activeData.numStart()] / wsumu + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                            }
                            fr3 = new Frame(fr2);
                            fr3.add("xjm1", this._activeData._adaptedFrame.vec(this._activeData._cats + this._activeData._nums - 1));
                            if (this._activeData._adaptedFrame.vec(this._activeData._cats + this._activeData._nums - 1).isCategorical()) {
                                cat_num = 2;
                                iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, Arrays.copyOfRange(beta, this._activeData._catOffsets[this._activeData._cats - 1], this._activeData._catOffsets[this._activeData._cats]), null, this._activeData._catLvls[this._activeData._cats - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                            } else {
                                cat_num = 3;
                                double[] meannew = null;
                                double[] varnew = null;
                                if (this._activeData._normMul != null) {
                                    varnew = new double[]{this._activeData._normMul[this._activeData._normMul.length - 1]};
                                    meannew = new double[]{this._activeData._normSub[this._activeData._normSub.length - 1]};
                                }
                                iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, new double[]{beta[beta.length - 2]}, null, null, null, null, varnew, meannew, skipFirstLevel).doAll(fr3);
                            }
                            if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                                beta[beta.length - 1] = iupdate._temp[0] / wsum;
                            }
                            double maxdiff = ArrayUtils.linfnorm((double[])ArrayUtils.subtract((double[])beta, (double[])betaold), (boolean)false);
                            System.arraycopy(beta, 0, betaold, 0, beta.length);
                            if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                            break;
                        }
                        if ((percdiff = Math.abs((objold - objVal) / objold)) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1) break;
                        objold = objVal;
                        this._taskInfo._beta = (double[])beta.clone();
                        System.out.println("iter1 = " + iter1);
                    }
                    System.out.println("iter2 = " + iter2);
                    long endTimeTotalNaive = System.currentTimeMillis();
                    long durationTotalNaive = (endTimeTotalNaive - startTimeTotalNaive) / 1000L;
                    System.out.println("Time to run Naive Coordinate Descent " + durationTotalNaive);
                    this._taskInfo._iter = iter2;
                    for (Vec v : newVecs) {
                        v.remove();
                    }
                    break;
                }
                case COORDINATE_DESCENT: {
                    int p = this._activeData.fullN() + 1;
                    boolean skipFirstLevel = !this._activeData._useAllFactorLevels;
                    double[] beta = (double[])this._taskInfo._beta.clone();
                    double[] betaold = (double[])this._taskInfo._beta.clone();
                    int iter2 = 0;
                    double objold = this._taskInfo._objVal;
                    long startTimeTotalCov = System.currentTimeMillis();
                    while (iter2++ < 30) {
                        long startTimeCov = System.currentTimeMillis();
                        GLMTask.GLMIterationTask gt = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._key, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], (GLMModel.GLMParameters)GLM.this._parms, false, this._taskInfo._beta_multinomial, beta, this._c, this._taskInfo._ymu, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, null).doAll(this._activeData._adaptedFrame) : (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._key, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], (GLMModel.GLMParameters)GLM.this._parms, false, this._taskInfo._beta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? this._taskInfo._ymu[0] : 0.5, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, null).doAll(this._activeData._adaptedFrame);
                        long endTimeCov = System.currentTimeMillis();
                        long durationCov = (endTimeCov - startTimeCov) / 1000L;
                        System.out.println("Time to compute cov matrix " + durationCov);
                        double objVal = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? GLM.this.objVal(gt._likelihood, gt._beta_multinomial) : GLM.this.objVal(gt._likelihood, gt._beta);
                        double wsum = gt.wsum;
                        double wsumu = gt.wsumu;
                        double wsumInv = 1.0 / wsum;
                        double wsumuInv = 1.0 / wsumu;
                        int iter1 = 0;
                        double[] grads = Arrays.copyOfRange(gt._xy, 0, gt._xy.length);
                        for (int i = 0; i < grads.length; ++i) {
                            double ip = 0.0;
                            for (int j = 0; j < beta.length; ++j) {
                                ip += beta[j] * gt._gram.get(i, j);
                            }
                            grads[i] = grads[i] - ip + beta[i] * gt._gram.get(i, i);
                        }
                        long t1 = System.currentTimeMillis();
                        long startTimeCd = System.currentTimeMillis();
                        double[][] XX = gt._gram.getXX();
                        while (iter1++ < 100) {
                            int off;
                            for (int i = 0; i < this._activeData._cats; ++i) {
                                int off2;
                                int level_num = this._activeData._catOffsets[i + 1] - this._activeData._catOffsets[i];
                                for (int j = off2 = this._activeData._catOffsets[i]; j < off2 + level_num; ++j) {
                                    beta[j] = gt._gram.get(j, j) != 0.0 ? ADMM.shrinkage(grads[j] * wsumuInv, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (gt._gram.get(j, j) * wsumuInv + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0])) : 0.0;
                                    if (beta[j] == 0.0) continue;
                                    this.doUpdateCD(grads, XX, betaold, beta, j);
                                }
                            }
                            for (int i = off = this._activeData.numStart(); i < this._activeData._nums + off; ++i) {
                                beta[i] = gt._gram.get(i, i) != 0.0 ? ADMM.shrinkage(grads[i] * wsumuInv, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (gt._gram.get(i, i) * wsumuInv + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0])) : 0.0;
                                if (beta[i] == 0.0) continue;
                                this.doUpdateCD(grads, XX, betaold, beta, i);
                            }
                            if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                                beta[beta.length - 1] = grads[grads.length - 1] * wsumInv;
                                if (beta[beta.length - 1] != 0.0) {
                                    this.doUpdateCD(grads, XX, betaold, beta, beta.length - 1);
                                }
                            }
                            double maxdiff = ArrayUtils.linfnorm((double[])ArrayUtils.subtract((double[])beta, (double[])betaold), (boolean)false);
                            System.arraycopy(beta, 0, betaold, 0, beta.length);
                            if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                            break;
                        }
                        long endTimeCd = System.currentTimeMillis();
                        long durationCd = endTimeCd - startTimeCd;
                        System.out.println("Time to run inner CD " + durationCd / 1000L);
                        System.out.println("inner loop done in " + iter1 + " iterations and " + (System.currentTimeMillis() - t1) / 1000L + "s, iter2 = " + iter2);
                        double percdiff = Math.abs((objold - objVal) / objold);
                        objold = objVal;
                        if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial) {
                            this._taskInfo._beta = (double[])beta.clone();
                        }
                        if (!(percdiff < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1)) continue;
                        break;
                    }
                    long endTimeTotalCov = System.currentTimeMillis();
                    long durationTotalCov = (endTimeTotalCov - startTimeTotalCov) / 1000L;
                    System.out.println("Time to run Cov Updates Coordinate Descent " + durationTotalCov);
                    this._taskInfo._iter = iter2;
                    break;
                }
                case IRLSM: {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        new GLMTask.GLMIterationTask(GLM.this._key, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, false, this._taskInfo._beta_multinomial, (double[])this._taskInfo._beta_multinomial[this._c].clone(), this._c, this._taskInfo._ymu, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new Iteration((CountedCompleter)this, doLineSearch)).asyncExec(this._activeData._adaptedFrame);
                    } else {
                        new GLMTask.GLMIterationTask(GLM.this._key, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, false, this._taskInfo._beta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? this._taskInfo._ymu[0] : 0.5, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new Iteration((CountedCompleter)this, doLineSearch)).asyncExec(this._activeData._adaptedFrame);
                    }
                    return;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            this.checkKKTsAndComplete(true, (H2O.H2OCountedCompleter)this);
            this.tryComplete();
        }

        protected void checkKKTsAndCompleteMultinomial(final boolean score, final H2O.H2OCountedCompleter cc) {
            final double[][] fullBeta = new double[this._taskInfo._numClasses][];
            for (int i = 0; i < fullBeta.length; ++i) {
                fullBeta[i] = GLM.expandVec(this._taskInfo._beta_multinomial[i], this._activeData._activeCols, GLM.this._dinfo.fullN() + 1);
                double[] dArray = fullBeta[i];
                int n = fullBeta[i].length - 1;
                dArray[n] = dArray[n] + GLM.this._iceptAdjust;
            }
            cc.addToPendingCount(1);
            this._taskInfo._scoredAndUpdated = score;
            new GLMTask.GLMMultinomialGradientTask(GLM.this._dinfo, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], this._taskInfo._ymu, fullBeta, 1.0 / this._taskInfo._wsum, true, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMMultinomialGradientTask>(cc){

                public void callback(final GLMTask.GLMMultinomialGradientTask gt1) {
                    int i;
                    assert (gt1._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs);
                    double[][] subgrad = new double[fullBeta.length][];
                    for (i = 0; i < subgrad.length; ++i) {
                        subgrad[i] = MemoryManager.malloc8d((int)fullBeta[i].length);
                    }
                    for (i = 0; i < fullBeta.length; ++i) {
                        ADMM.subgrad(((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], fullBeta[i], subgrad[i]);
                    }
                    double err = 0.0;
                    if (GLMSingleLambdaTsk.this._taskInfo._activeCols != null) {
                        for (int i2 = 0; i2 < subgrad.length; ++i2) {
                            for (int c : GLMSingleLambdaTsk.this._taskInfo._activeCols) {
                                if (subgrad[i2][c] > err) {
                                    err = subgrad[i2][c];
                                    continue;
                                }
                                if (!(subgrad[i2][c] < -err)) continue;
                                err = -subgrad[i2][c];
                            }
                        }
                        int[] failedCols = new int[64];
                        int fcnt = 0;
                        int P = subgrad[0].length;
                        block4: for (int i3 = 0; i3 < P - 1; ++i3) {
                            if (Arrays.binarySearch(GLMSingleLambdaTsk.this._taskInfo._activeCols, i3) >= 0) continue;
                            for (int j = 0; j < subgrad.length; ++j) {
                                if (!(subgrad[j][i3] > err) && !(-subgrad[j][i3] > err)) continue;
                                if (fcnt == failedCols.length) {
                                    failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                                }
                                failedCols[fcnt++] = i3;
                                continue block4;
                            }
                        }
                        if (fcnt > 0) {
                            throw H2O.unimpl();
                        }
                    }
                    final double[][] betaSm = GLMSingleLambdaTsk.this._taskInfo._beta_multinomial;
                    GLMModel.Submodel sm = new GLMModel.Submodel(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], betaSm, GLMSingleLambdaTsk.this._activeData._activeCols, GLMSingleLambdaTsk.this._taskInfo._iter, gt1._val.residualDeviance(), Double.NaN);
                    GLM.this._model.setSubmodel(sm);
                    GLM.this._sc.addLambdaScore(GLMSingleLambdaTsk.this._taskInfo._iter, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], sm.rank(), gt1._val.explainedDev(), Double.NaN);
                    if (score) {
                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
                        if (((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).bestSubmodel().lambda_value == ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId]) {
                            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = gt1._val.makeModelMetrics(GLM.this._model, ((GLMModel.GLMParameters)GLM.this._parms).train());
                            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial) {
                                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._threshold = ((ModelMetricsBinomial)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics)._auc.defaultThreshold();
                            }
                        }
                        GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, GLMSingleLambdaTsk.this._taskInfo._iter);
                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = GLM.this._sc.to2dTable();
                        GLM.this._model.update(GLM.this._key);
                    }
                    double l2pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) * ArrayUtils.l2norm2((double[][])gt1._beta, (boolean)GLMSingleLambdaTsk.this._activeData._intercept);
                    if (((GLM)GLM.this)._bc._betaGiven != null && ((GLM)GLM.this)._bc._rho != null) {
                        throw H2O.unimpl();
                    }
                    GLMSingleLambdaTsk.this._taskInfo._ginfo = new GLMGradientInfo(gt1._likelihood, gt1._likelihood / (double)gt1._nobs + 0.5 * l2pen, gt1._gradient);
                    GLMSingleLambdaTsk.this._taskInfo._objVal = GLM.this.objVal(gt1._likelihood, gt1._beta);
                    if (++GLMSingleLambdaTsk.this._c == GLM.this.nclasses()) {
                        GLMSingleLambdaTsk.this._c = 0;
                    }
                    double rel_improvement = (GLMSingleLambdaTsk.this._oldObj - GLMSingleLambdaTsk.this._taskInfo._objVal) / GLMSingleLambdaTsk.this._oldObj;
                    if (((GLMModel.GLMParameters)GLM.this._parms)._solver != GLMModel.GLMParameters.Solver.IRLSM || GLMSingleLambdaTsk.this._taskInfo._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations || GLMSingleLambdaTsk.this._c == 0 && rel_improvement < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon) {
                        GLMSingleLambdaTsk.this._c = 0;
                        GLMSingleLambdaTsk.this._oldObj = GLMSingleLambdaTsk.this._taskInfo._objVal;
                        GLM.this._sc.addIterationScore(GLMSingleLambdaTsk.this._taskInfo._iter, gt1._likelihood, GLMSingleLambdaTsk.this._taskInfo._objVal);
                        GLMSingleLambdaTsk.this._taskInfo._beta_multinomial = fullBeta;
                        if (GLM.this._valid != null) {
                            cc.addToPendingCount(1);
                            int iter = GLMSingleLambdaTsk.this._taskInfo._iter;
                            double[][] betaScore = new double[GLM.this._nclass][];
                            for (int i4 = 0; i4 < GLM.this._nclass; ++i4) {
                                betaScore[i4] = GLM.this._dinfo.denormalizeBeta(gt1._beta[i4]);
                            }
                            new GLMTask.GLMMultinomialGradientTask(GLM.this._validDinfo, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLMSingleLambdaTsk.this._taskInfo._ymu, betaScore, 1.0 / GLMSingleLambdaTsk.this._taskInfo._wsum, true, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMMultinomialGradientTask>(cc){

                                public void callback(GLMTask.GLMMultinomialGradientTask gt2) {
                                    GLMSingleLambdaTsk.this.LogInfo("hold-out set validation = " + gt2._val.toString());
                                    GLMSingleLambdaTsk.this._taskInfo._stopCnt = Double.isNaN(GLMSingleLambdaTsk.this._taskInfo._resDevTest) || MathUtils.roundToNDigits((double)gt2._val.residualDeviance(), (int)5) <= MathUtils.roundToNDigits((double)GLMSingleLambdaTsk.this._taskInfo._resDevTest, (int)5) ? 0 : ++GLMSingleLambdaTsk.this._taskInfo._stopCnt;
                                    GLMSingleLambdaTsk.this._taskInfo._resDevTest = gt2._val.residualDeviance();
                                    GLMModel.Submodel sm = new GLMModel.Submodel(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], betaSm, GLMSingleLambdaTsk.this._activeData._activeCols, GLMSingleLambdaTsk.this._taskInfo._iter, gt1._val.residualDeviance(), gt2._val.residualDeviance());
                                    GLM.this._model.setSubmodel(sm);
                                    if (score) {
                                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
                                        if (((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).bestSubmodel().lambda_value == ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId]) {
                                            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = gt1._val.makeModelMetrics(GLM.this._model, ((GLMModel.GLMParameters)GLM.this._parms).train());
                                            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = gt2._val.makeModelMetrics(GLM.this._model, ((GLMModel.GLMParameters)GLM.this._parms).valid());
                                            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial && gt2._nobs > 0L) {
                                                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._threshold = ((ModelMetricsBinomial)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics)._auc.defaultThreshold();
                                            }
                                        }
                                        GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, GLMSingleLambdaTsk.this._taskInfo._iter);
                                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = GLM.this._sc.to2dTable();
                                        GLM.this._model.update(GLM.this._key);
                                    }
                                    GLM.this._sc.addLambdaScore(GLMSingleLambdaTsk.this._taskInfo._iter, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], sm.rank(), gt1._val.explainedDev(), gt2._val.explainedDev());
                                }
                            }).asyncExec(((GLM)GLM.this)._validDinfo._adaptedFrame);
                        }
                        return;
                    }
                    if (GLMSingleLambdaTsk.this._c == 0) {
                        GLMSingleLambdaTsk.this._oldObj = GLMSingleLambdaTsk.this._taskInfo._objVal;
                    }
                    GLMSingleLambdaTsk.this._taskInfo._beta = GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[GLMSingleLambdaTsk.this._c];
                    GLMSingleLambdaTsk.this.addToPendingCount(1);
                    GLMSingleLambdaTsk.this.solve(false);
                }
            }).asyncExec(GLM.this._dinfo._adaptedFrame);
        }

        protected int[] checkKKTConditions(double[] grad, double[] fullBeta) {
            int P = GLM.this._dinfo.fullN() + 1;
            int[] failedCols = new int[8];
            int fcnt = 0;
            for (int start = 0; start < grad.length; start += P) {
                double[] subgrad = Arrays.copyOfRange(grad, start, start + P);
                double[] beta = Arrays.copyOfRange(fullBeta, start, start + P);
                ADMM.subgrad(((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], beta, subgrad);
                double err = 1.0E-4;
                if (this._taskInfo._activeCols == null) continue;
                for (int i = 0; i < subgrad.length - 1; ++i) {
                    if (!(subgrad[i] > err) && !(-subgrad[i] > err)) continue;
                    if (fcnt == failedCols.length) {
                        failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                    }
                    failedCols[fcnt++] = start + i;
                }
            }
            return Arrays.copyOf(failedCols, fcnt);
        }

        protected void checkKKTsAndComplete(final boolean score, H2O.H2OCountedCompleter cc) {
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                this.checkKKTsAndCompleteMultinomial(score, cc);
                return;
            }
            final double[] fullBeta = GLM.expandVec(this._taskInfo._beta, this._activeData._activeCols, GLM.this._dinfo.fullN() + 1);
            int n = fullBeta.length - 1;
            fullBeta[n] = fullBeta[n] + GLM.this._iceptAdjust;
            this.addToPendingCount(1);
            this._taskInfo._scoredAndUpdated = score;
            new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], fullBeta, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMGradientTask>(cc){

                public void callback(final GLMTask.GLMGradientTask gt1) {
                    int i;
                    assert (gt1._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs);
                    double[] subgrad = (double[])gt1._gradient.clone();
                    ADMM.subgrad(((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], fullBeta, subgrad);
                    double err = 0.0;
                    if (GLMSingleLambdaTsk.this._taskInfo._activeCols != null) {
                        for (int c : GLMSingleLambdaTsk.this._taskInfo._activeCols) {
                            if (subgrad[c] > err) {
                                err = subgrad[c];
                                continue;
                            }
                            if (!(subgrad[c] < -err)) continue;
                            err = -subgrad[c];
                        }
                        int[] failedCols = new int[64];
                        int fcnt = 0;
                        for (i = 0; i < subgrad.length - 1; ++i) {
                            if (Arrays.binarySearch(GLMSingleLambdaTsk.this._taskInfo._activeCols, i) >= 0 || !(subgrad[i] > err) && !(-subgrad[i] > err)) continue;
                            if (fcnt == failedCols.length) {
                                failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                            }
                            failedCols[fcnt++] = i;
                        }
                        if (fcnt > 0) {
                            int n = GLMSingleLambdaTsk.this._taskInfo._activeCols.length;
                            int[] newCols = Arrays.copyOf(GLMSingleLambdaTsk.this._taskInfo._activeCols, GLMSingleLambdaTsk.this._taskInfo._activeCols.length + fcnt);
                            for (int i2 = 0; i2 < fcnt; ++i2) {
                                newCols[n + i2] = failedCols[i2];
                            }
                            Arrays.sort(newCols);
                            GLMSingleLambdaTsk.this._taskInfo._beta = GLM.resizeVec(gt1._beta, newCols, GLMSingleLambdaTsk.this._taskInfo._activeCols, GLM.this._dinfo.fullN() + 1);
                            GLMSingleLambdaTsk.this._taskInfo._activeCols = newCols;
                            GLMSingleLambdaTsk.this.LogInfo(fcnt + " variables failed KKT conditions check! Adding them to the model and continuing computation.(grad_eps = " + err + ", activeCols = " + (GLMSingleLambdaTsk.this._taskInfo._activeCols.length > 100 ? "lost" : Arrays.toString(GLMSingleLambdaTsk.this._taskInfo._activeCols)));
                            GLMSingleLambdaTsk.this._activeData = GLM.this._dinfo.filterExpandedColumns(GLMSingleLambdaTsk.this._taskInfo._activeCols);
                            assert (newCols == null || GLMSingleLambdaTsk.this._activeData.fullN() == GLMSingleLambdaTsk.this._taskInfo._activeCols.length);
                            this.getCompleter().addToPendingCount(1);
                            GLMSingleLambdaTsk.this.solve(true);
                            return;
                        }
                    }
                    if (GLM.this._valid != null) {
                        GLMSingleLambdaTsk.this.addToPendingCount(1);
                        int iter = GLMSingleLambdaTsk.this._taskInfo._iter;
                        new GLMTask.GLMGradientTask(GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLM.this._dinfo.denormalizeBeta(gt1._beta), 1.0 / (double)GLMSingleLambdaTsk.this._taskInfo._nobs, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMGradientTask>((H2O.H2OCountedCompleter)GLMSingleLambdaTsk.this){

                            public void callback(GLMTask.GLMGradientTask gt2) {
                                GLMSingleLambdaTsk.this.LogInfo("hold-out set validation = " + gt2._val.toString());
                                GLMSingleLambdaTsk.this._taskInfo._stopCnt = Double.isNaN(GLMSingleLambdaTsk.this._taskInfo._resDevTest) || MathUtils.roundToNDigits((double)gt2._val.residualDeviance(), (int)5) <= MathUtils.roundToNDigits((double)GLMSingleLambdaTsk.this._taskInfo._resDevTest, (int)5) ? 0 : ++GLMSingleLambdaTsk.this._taskInfo._stopCnt;
                                GLMSingleLambdaTsk.this._taskInfo._resDevTest = gt2._val.residualDeviance();
                                GLMModel.Submodel sm = new GLMModel.Submodel(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], gt1._beta, GLMSingleLambdaTsk.this._taskInfo._iter, gt1._val.residualDeviance(), gt2._val.residualDeviance());
                                GLM.this._model.setSubmodel(sm);
                                if (score) {
                                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
                                    if (((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).bestSubmodel().lambda_value == ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId]) {
                                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = gt1._val.makeModelMetrics(GLM.this._model, ((GLMModel.GLMParameters)GLM.this._parms).train());
                                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = gt2._val.makeModelMetrics(GLM.this._model, ((GLMModel.GLMParameters)GLM.this._parms).valid());
                                        if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial && gt2._nobs > 0L) {
                                            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._threshold = ((ModelMetricsBinomial)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics)._auc.defaultThreshold();
                                        }
                                    }
                                    GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, GLMSingleLambdaTsk.this._taskInfo._iter);
                                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = GLM.this._sc.to2dTable();
                                    GLM.this._model.update(GLM.this._key);
                                }
                                GLM.this._sc.addLambdaScore(GLMSingleLambdaTsk.this._taskInfo._iter, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], sm.rank(), gt1._val.explainedDev(), gt2._val.explainedDev());
                            }
                        }).setValidate(((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu[0] : 0.0, score).asyncExec(((GLM)GLM.this)._validDinfo._adaptedFrame);
                    } else {
                        GLMModel.Submodel sm = new GLMModel.Submodel(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], gt1._beta, GLMSingleLambdaTsk.this._taskInfo._iter, gt1._val.residualDeviance(), Double.NaN);
                        GLM.this._model.setSubmodel(sm);
                        GLM.this._sc.addLambdaScore(GLMSingleLambdaTsk.this._taskInfo._iter, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], sm.rank(), gt1._val.explainedDev(), Double.NaN);
                        if (score) {
                            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
                            if (((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).bestSubmodel().lambda_value == ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId]) {
                                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = gt1._val.makeModelMetrics(GLM.this._model, ((GLMModel.GLMParameters)GLM.this._parms).train());
                                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial) {
                                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._threshold = ((ModelMetricsBinomial)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics)._auc.defaultThreshold();
                                }
                            }
                            GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, GLMSingleLambdaTsk.this._taskInfo._iter);
                            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = GLM.this._sc.to2dTable();
                            GLM.this._model.update(GLM.this._key);
                        }
                    }
                    double l2pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) * ArrayUtils.l2norm2((double[])gt1._beta, (boolean)GLMSingleLambdaTsk.this._activeData._intercept);
                    if (((GLM)GLM.this)._bc._betaGiven != null && ((GLM)GLM.this)._bc._rho != null) {
                        for (i = 0; i < ((GLM)GLM.this)._bc._betaGiven.length; ++i) {
                            double diff = gt1._beta[i] - ((GLM)GLM.this)._bc._betaGiven[i];
                            l2pen += ((GLM)GLM.this)._bc._rho[i] * diff * diff;
                        }
                    }
                    GLMSingleLambdaTsk.this._taskInfo._ginfo = new GLMGradientInfo(gt1._likelihood, gt1._likelihood / (double)gt1._nobs + (l2pen *= 0.5), gt1._gradient);
                    assert (GLMSingleLambdaTsk.this._taskInfo._ginfo._gradient.length == GLM.this._dinfo.fullN() + 1) : GLMSingleLambdaTsk.this._taskInfo._ginfo._gradient.length + " != " + GLM.this._dinfo.fullN() + ", intercept = " + ((GLMModel.GLMParameters)GLM.this._parms)._intercept;
                    GLMSingleLambdaTsk.this._taskInfo._objVal = GLM.this.objVal(gt1._likelihood, gt1._beta);
                    GLM.this._sc.addIterationScore(GLMSingleLambdaTsk.this._taskInfo._iter, gt1._likelihood, GLMSingleLambdaTsk.this._taskInfo._objVal);
                    GLMSingleLambdaTsk.this._taskInfo._beta = fullBeta;
                }
            }).setValidate(((GLMModel.GLMParameters)GLM.this._parms)._intercept ? this._taskInfo._ymu[0] : (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.binomial ? 0.5 : 0.0), score).asyncExec(GLM.this._dinfo._adaptedFrame);
        }

        protected void compute2() {
            if (!Job.isRunning((Key)GLM.this._key)) {
                throw new Job.JobCancelledException();
            }
            this._start_time = System.currentTimeMillis();
            double previousLambda = GLM.this._lambdaId == 0 ? this._taskInfo._lambdaMax : ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId - 1];
            this._taskInfo.adjustToNewLambda(previousLambda, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0], true);
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial && ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) : "multinomial only implemented for COD";
                this._activeData = GLM.this._dinfo;
                double oldObj = Double.MAX_VALUE;
                int iter = 0;
                while (iter++ < 10 && this._taskInfo._objVal < oldObj - oldObj * 1.0E-4) {
                    oldObj = this._taskInfo._objVal;
                    int c = 0;
                    while (c < this._taskInfo._numClasses) {
                        this._taskInfo._beta = this._taskInfo._beta_multinomial[c];
                        this._c = c++;
                        this.addToPendingCount(1);
                        this.solve(false);
                    }
                }
                this.tryComplete();
            } else {
                int[] activeCols = this.activeCols(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLM.this._lambdaId == 0 ? this._taskInfo._lambdaMax : ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId - 1], this._taskInfo._ginfo._gradient);
                this._taskInfo._activeCols = activeCols;
                this._activeData = GLM.this._dinfo.filterExpandedColumns(activeCols);
                assert (this._taskInfo._activeCols == null || this._taskInfo._activeCols.length == this._activeData.fullN());
                this._taskInfo._ginfo = new GLMGradientInfo(this._taskInfo._ginfo._likelihood, this._taskInfo._ginfo._objVal, GLM.contractVec(this._taskInfo._ginfo._gradient, activeCols));
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                    for (int i = 0; i < this._taskInfo._beta_multinomial.length; ++i) {
                        this._taskInfo._beta_multinomial[i] = GLM.contractVec(this._taskInfo._beta_multinomial[i], activeCols);
                    }
                } else {
                    this._taskInfo._beta = GLM.contractVec(this._taskInfo._beta, activeCols);
                }
                assert (activeCols == null || this._activeData.fullN() == activeCols.length) : this.LogInfo("mismatched number of cols, got " + activeCols.length + " active cols, but data info claims " + this._activeData.fullN());
                assert (DKV.get((Key)this._activeData._key) != null);
                this.solve(false);
            }
        }

        private final double beta_diff(double[] b1, double[] b2) {
            if (b1 == null) {
                return Double.MAX_VALUE;
            }
            double res = b1[0] >= b2[0] ? b1[0] - b2[0] : b2[0] - b1[0];
            for (int i = 1; i < b1.length; ++i) {
                double diff = b1[i] - b2[i];
                if (diff > res) {
                    res = diff;
                    continue;
                }
                if (!(-diff > res)) continue;
                res = -diff;
            }
            return res;
        }

        protected double l1norm(double[] beta) {
            if (beta == null) {
                return 0.0;
            }
            double l1 = 0.0;
            for (int i = 0; i < beta.length - 1; ++i) {
                l1 += beta[i] < 0.0 ? -beta[i] : beta[i];
            }
            return l1;
        }

        private class LineSearchIteration
        extends H2O.H2OCallback<GLMTask.GLMLineSearchTask> {
            final double _expectedLikelihood;

            LineSearchIteration(CountedCompleter cmp, double expectedLikelihood) {
                super((H2O.H2OCountedCompleter)cmp);
                this._expectedLikelihood = expectedLikelihood;
            }

            public void callback(GLMTask.GLMLineSearchTask lst) {
                assert (lst._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs) : lst._nobs + " != " + GLMSingleLambdaTsk.this._taskInfo._nobs;
                assert (Double.isNaN(this._expectedLikelihood) || Double.isInfinite(this._expectedLikelihood) || Math.abs(lst._likelihoods[0] - this._expectedLikelihood) / this._expectedLikelihood < 1.0E-6) : "expected likelihood = " + this._expectedLikelihood + ", got " + lst._likelihoods[0];
                double t = lst._initStep;
                for (int i = 0; i < lst._likelihoods.length && t >= 1.0E-4; ++i, t *= 0.75) {
                    double[] beta = ArrayUtils.wadd((double[])((double[])GLMSingleLambdaTsk.this._taskInfo._beta.clone()), (double[])lst._direction, (double)t);
                    double newObj = GLM.this.objVal(lst._likelihoods[i], beta);
                    if (!(GLMSingleLambdaTsk.this._taskInfo._objVal > newObj)) continue;
                    GLMSingleLambdaTsk.this.LogInfo("line search: found admissible step = " + t + ",  objval = " + newObj);
                    GLMSingleLambdaTsk.this._taskInfo._lineSearch = t < 1.0;
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, true, beta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu[0] : 0.5, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true, true)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    return;
                }
                if (t > 1.0E-4) {
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMLineSearchTask(GLMSingleLambdaTsk.this._activeData, (GLMModel.GLMParameters)GLM.this._parms, lst._beta, lst._direction, t /= 0.75, 0.75, 16, (CountedCompleter)new LineSearchIteration(this.getCompleter(), lst._likelihoods[lst._likelihoods.length - 1])).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    return;
                }
                GLMSingleLambdaTsk.this.LogInfo("converged (step size too small(1))");
                GLMSingleLambdaTsk.this.checkKKTsAndComplete(true, (H2O.H2OCountedCompleter)this.getCompleter());
            }
        }

        private class MultinomialLineSearchIteration
        extends H2O.H2OCallback<GLMTask.GLMMultinomialLineSearchTask> {
            final double _expectedLikelihood;
            final double _minStep;
            final boolean _countIteration;
            final double[][] _betaMultinomial;
            final double[] _direction;

            MultinomialLineSearchIteration(CountedCompleter cmp, double[][] beta, double[] direction, double expectedLikelihood, double minStep, boolean countIter) {
                super((H2O.H2OCountedCompleter)cmp);
                this._betaMultinomial = beta;
                this._direction = direction;
                this._expectedLikelihood = expectedLikelihood;
                this._minStep = minStep;
                this._countIteration = countIter;
            }

            public void callback(GLMTask.GLMMultinomialLineSearchTask lst) {
                assert (lst._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs) : lst._nobs + " != " + GLMSingleLambdaTsk.this._taskInfo._nobs;
                assert (Double.isNaN(this._expectedLikelihood) || Double.isInfinite(this._expectedLikelihood) || Math.abs(lst._likelihoods[0] - this._expectedLikelihood) / this._expectedLikelihood < 1.0E-6) : "expected likelihood = " + this._expectedLikelihood + ", got " + lst._likelihoods[0];
                double t = lst._initialStep;
                double[][] betaM = (double[][])this._betaMultinomial.clone();
                betaM[((GLMSingleLambdaTsk)GLMSingleLambdaTsk.this)._c] = ArrayUtils.wadd((double[])((double[])GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[lst._c].clone()), (double[])this._direction, (double)t);
                double firstObj = GLM.this.objVal(lst._likelihoods[0], betaM);
                double newObj = 0.0;
                for (int i = 0; i < lst._likelihoods.length && t >= 1.0E-4; ++i, t *= lst._stepDec) {
                    betaM[((GLMSingleLambdaTsk)GLMSingleLambdaTsk.this)._c] = ArrayUtils.wadd((double[])((double[])GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[lst._c].clone()), (double[])this._direction, (double)t);
                    newObj = GLM.this.objVal(lst._likelihoods[i], betaM);
                    if (!(GLMSingleLambdaTsk.this._taskInfo._objVal > newObj)) continue;
                    GLMSingleLambdaTsk.this.LogInfo("line search: found admissible step = " + t + ",  objval = " + newObj);
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, true, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, betaM[GLMSingleLambdaTsk.this._c], GLMSingleLambdaTsk.this._c, GLMSingleLambdaTsk.this._taskInfo._ymu, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true, this._countIteration)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    return;
                }
                if (newObj < firstObj && t > this._minStep) {
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMMultinomialLineSearchTask((H2O.H2OCountedCompleter)new MultinomialLineSearchIteration(this.getCompleter(), GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, this._direction, lst._likelihoods[lst._likelihoods.length - 1], 0.0625, this._countIteration), GLMSingleLambdaTsk.this._activeData, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, this._direction, GLMSingleLambdaTsk.this._c, t /= lst._stepDec, lst._stepDec, lst._nSteps).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    return;
                }
                GLMSingleLambdaTsk.this.LogInfo("converged (step size too small)");
                GLMSingleLambdaTsk.this.checkKKTsAndComplete(true, (H2O.H2OCountedCompleter)this.getCompleter());
            }
        }

        private class Iteration
        extends H2O.H2OCallback<GLMTask.GLMIterationTask> {
            public final long _iterationStartTime;
            final boolean _countIteration;
            public final boolean _doLinesearch;

            public Iteration(CountedCompleter cmp, boolean doLinesearch) {
                this(cmp, doLinesearch, true);
            }

            public Iteration(CountedCompleter cmp, boolean doLinesearch, boolean countIteration) {
                super((H2O.H2OCountedCompleter)cmp);
                this._countIteration = countIteration;
                this._iterationStartTime = System.currentTimeMillis();
                this._doLinesearch = doLinesearch;
            }

            public void callback(GLMTask.GLMIterationTask glmt) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept || glmt._beta[GLMSingleLambdaTsk.this._activeData.fullN()] == 0.0);
                double objVal = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? GLM.this.objVal(glmt._likelihood, glmt._beta_multinomial) : GLM.this.objVal(glmt._likelihood, glmt._beta);
                double oldObj = GLMSingleLambdaTsk.this._taskInfo._objVal;
                if (!Job.isRunning((Key)GLM.this._key)) {
                    throw new Job.JobCancelledException();
                }
                assert (glmt._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs) : "got wrong number of observations, expected " + GLMSingleLambdaTsk.this._taskInfo._nobs + ", but got " + glmt._nobs;
                assert (GLMSingleLambdaTsk.this._taskInfo._activeCols == null || glmt._beta == null || glmt._beta.length == GLMSingleLambdaTsk.this._taskInfo._activeCols.length + 1) : GLMSingleLambdaTsk.access$1500(GLMSingleLambdaTsk.this, "betalen = " + glmt._beta.length + ", activecols = " + GLMSingleLambdaTsk.this._taskInfo._activeCols.length);
                assert (GLMSingleLambdaTsk.this._taskInfo._activeCols == null || GLMSingleLambdaTsk.this._taskInfo._activeCols.length == GLMSingleLambdaTsk.this._activeData.fullN());
                double reg = ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg;
                glmt._gram.mul(reg);
                ArrayUtils.mult((double[])glmt._xy, (double)reg);
                if (this._countIteration) {
                    ++GLMSingleLambdaTsk.this._taskInfo._iter;
                }
                long callbackStart = System.currentTimeMillis();
                double lastObjVal = GLMSingleLambdaTsk.this._taskInfo._objVal;
                double logl = glmt._likelihood;
                if (this._doLinesearch && (glmt.hasNaNsOrInf() || !(objVal <= lastObjVal))) {
                    this.getCompleter().addToPendingCount(1);
                    GLMSingleLambdaTsk.this.LogInfo("invoking line search, objval = " + objVal + ", lastObjVal = " + lastObjVal);
                    --GLMSingleLambdaTsk.this._taskInfo._iter;
                    GLMSingleLambdaTsk.this._taskInfo._lineSearch = true;
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        double[] direction = ArrayUtils.subtract((double[])glmt._beta_multinomial[GLMSingleLambdaTsk.this._c], (double[])GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[GLMSingleLambdaTsk.this._c]);
                        new GLMTask.GLMMultinomialLineSearchTask((H2O.H2OCountedCompleter)new MultinomialLineSearchIteration(this.getCompleter(), GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, direction, glmt._likelihood, 1.0E-4, true), GLMSingleLambdaTsk.this._activeData, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, direction, GLMSingleLambdaTsk.this._c, 1.0, 0.75, 16).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    } else {
                        new GLMTask.GLMLineSearchTask(GLMSingleLambdaTsk.this._activeData, (GLMModel.GLMParameters)GLM.this._parms, (double[])GLMSingleLambdaTsk.this._taskInfo._beta.clone(), ArrayUtils.subtract((double[])glmt._beta, (double[])GLMSingleLambdaTsk.this._taskInfo._beta), 1.0, 0.75, 16, (CountedCompleter)new LineSearchIteration(this.getCompleter(), glmt._likelihood)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    }
                    return;
                }
                GLM.this._sc.addIterationScore(GLMSingleLambdaTsk.this._taskInfo._iter - 1, logl, objVal);
                if (lastObjVal > objVal) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        System.arraycopy(glmt._beta_multinomial[GLMSingleLambdaTsk.this._c], 0, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[GLMSingleLambdaTsk.this._c], 0, glmt._beta_multinomial[GLMSingleLambdaTsk.this._c].length);
                    } else {
                        GLMSingleLambdaTsk.this._taskInfo._beta = glmt._beta;
                    }
                    GLMSingleLambdaTsk.this._taskInfo._objVal = objVal;
                    GLMSingleLambdaTsk.this._taskInfo._ginfo = null;
                }
                double[] newBeta = MemoryManager.malloc8d((int)glmt._xy.length);
                double l2pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]);
                double l1pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0];
                double defaultRho = ((GLM)GLM.this)._bc._betaLB != null || ((GLM)GLM.this)._bc._betaUB != null ? GLMSingleLambdaTsk.this._taskInfo._lambdaMax * 0.01 : 0.0;
                long tx = System.currentTimeMillis();
                if (l1pen > 0.0 || ((GLM)GLM.this)._bc._betaLB != null || ((GLM)GLM.this)._bc._betaUB != null || ((GLM)GLM.this)._bc._betaGiven != null) {
                    GramSolver gslvr = new GramSolver(glmt._gram, glmt._xy, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, l2pen, l1pen, ((GLM)GLM.this)._bc._betaGiven, ((GLM)GLM.this)._bc._rho, defaultRho, ((GLM)GLM.this)._bc._betaLB, ((GLM)GLM.this)._bc._betaUB);
                    new ADMM.L1Solver(1.0E-4, 10000).solve(gslvr, newBeta, l1pen, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, ((GLM)GLM.this)._bc._betaLB, ((GLM)GLM.this)._bc._betaUB);
                } else {
                    glmt._gram.addDiag(l2pen);
                    new GramSolver(glmt._gram, glmt._xy, GLMSingleLambdaTsk.this._taskInfo._lambdaMax, ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon, ((GLMModel.GLMParameters)GLM.this._parms)._intercept).solve(newBeta);
                }
                GLMSingleLambdaTsk.this.LogInfo("iteration computed in " + (callbackStart - this._iterationStartTime) + " + " + (System.currentTimeMillis() - tx) + " ms");
                GLMSingleLambdaTsk.this._taskInfo._worked += GLMSingleLambdaTsk.this._taskInfo._workPerIteration;
                GLM.this.update(GLMSingleLambdaTsk.this._taskInfo._workPerIteration, "lambdaId = " + GLM.this._lambdaId + ", iteration = " + GLMSingleLambdaTsk.this._taskInfo._iter + ", objective value = " + MathUtils.roundToNDigits((double)objVal, (int)4));
                if (ArrayUtils.hasNaNsOrInfs((double[])newBeta)) {
                    throw new RuntimeException(GLMSingleLambdaTsk.this.LogInfo("got NaNs and/or Infs in beta"));
                }
                double bdiff = GLMSingleLambdaTsk.this.beta_diff(glmt._beta, newBeta);
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian && ((GLMModel.GLMParameters)GLM.this._parms)._link == GLMModel.GLMParameters.Link.identity || bdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon || GLMSingleLambdaTsk.this._taskInfo._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                    int diff = (int)Math.log10(bdiff);
                    int nzs = 0;
                    for (int i = 0; i < newBeta.length; ++i) {
                        if (newBeta[i] == 0.0) continue;
                        ++nzs;
                    }
                    GLMSingleLambdaTsk.this.LogInfo("converged (reached a fixed point with ~ 1e" + diff + " precision), got " + nzs + " nzs");
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        System.arraycopy(newBeta, 0, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[GLMSingleLambdaTsk.this._c], 0, newBeta.length);
                    } else if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian) {
                        GLMSingleLambdaTsk.this._taskInfo._beta = newBeta;
                    }
                    GLMSingleLambdaTsk.this.checkKKTsAndComplete(true, (H2O.H2OCountedCompleter)this.getCompleter());
                    return;
                }
                if (GLMSingleLambdaTsk.this._taskInfo._lineSearch || GLMSingleLambdaTsk.this._activeData.fullN() > 1000 || GLMSingleLambdaTsk.this._activeData._adaptedFrame.numCols() > 100) {
                    this.getCompleter().addToPendingCount(1);
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        double[] direction = ArrayUtils.subtract((double[])newBeta, (double[])GLMSingleLambdaTsk.this._taskInfo._beta_multinomial[GLMSingleLambdaTsk.this._c]);
                        new GLMTask.GLMMultinomialLineSearchTask((H2O.H2OCountedCompleter)new MultinomialLineSearchIteration(this.getCompleter(), GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, direction, Double.NaN, 0.0625, true), GLMSingleLambdaTsk.this._activeData, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, direction, GLMSingleLambdaTsk.this._c, 1.0, 0.5, 4).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    } else {
                        new GLMTask.GLMLineSearchTask(GLMSingleLambdaTsk.this._activeData, (GLMModel.GLMParameters)GLM.this._parms, (double[])GLMSingleLambdaTsk.this._taskInfo._beta.clone(), ArrayUtils.subtract((double[])newBeta, (double[])GLMSingleLambdaTsk.this._taskInfo._beta), 1.0, 0.75, 16, (CountedCompleter)new LineSearchIteration(this.getCompleter(), Double.NaN)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    }
                    return;
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), glmt._params, true, GLMSingleLambdaTsk.this._taskInfo._beta_multinomial, newBeta, GLMSingleLambdaTsk.this._c, GLMSingleLambdaTsk.this._taskInfo._ymu, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                } else {
                    boolean validate = false;
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), glmt._params, false, newBeta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu[0] : 0.5, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                }
            }
        }
    }

    public final class GLMDriver
    extends DTask<GLMDriver> {
        transient AtomicBoolean _gotException;
        final byte _priority;
        Key[] _adapt_keys;

        protected byte priority() {
            return this._priority;
        }

        public GLMDriver(H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._gotException = new AtomicBoolean();
            this._priority = this.nextThrPriority();
        }

        private void doCleanup() {
            GLM.this.updateModelOutput();
            try {
                for (Vec v : GLM.this._garbage) {
                    System.out.println("removing " + v._key);
                    v.remove();
                }
                ((GLMModel.GLMParameters)GLM.this._parms).read_unlock_frames((Job)GLM.this);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ((GLMModel.GLMParameters)GLM.this._parms).read_unlock_frames((Job)GLM.this);
            if (this._adapt_keys != null) {
                for (Key k : this._adapt_keys) {
                    Keyed.remove((Key)k);
                }
            }
            if (GLM.this._dinfo != null) {
                GLM.this._dinfo.remove();
            }
            if (GLM.this._validDinfo != null) {
                GLM.this._validDinfo.remove();
            }
            if (GLM.this._tInfos != null && GLM.this._tInfos[0] != null) {
                if (GLM.this._tInfos[0]._wVec != null) {
                    GLM.this._tInfos[0]._wVec.remove();
                }
                if (GLM.this._tInfos[0]._zVec != null) {
                    GLM.this._tInfos[0]._zVec.remove();
                }
                if (GLM.this._tInfos[0]._eVec != null) {
                    GLM.this._tInfos[0]._eVec.remove();
                }
                if (GLM.this._tInfos[0]._iVec != null) {
                    GLM.this._tInfos[0]._iVec.remove();
                }
            }
        }

        public void onCompletion(CountedCompleter cc) {
            GLM.this._model.unlock(GLM.this._key);
            this.doCleanup();
            GLM.this.done();
        }

        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
            if (!this._gotException.getAndSet(true)) {
                if (ex instanceof Job.JobCancelledException) {
                    GLM.this.cancel();
                    this.tryComplete();
                    return false;
                }
                if (ex instanceof TooManyPredictorsException) {
                    this.tryComplete();
                    return false;
                }
                try {
                    if (!(ex instanceof IllegalArgumentException)) {
                        this.doCleanup();
                    }
                    new DTask.RemoveCall(null, GLM.this._dest).invokeTask();
                }
                catch (Throwable t) {
                    Log.err((Object[])new Object[]{t});
                }
                GLM.this.failed(ex);
                return true;
            }
            return false;
        }

        protected void compute2() {
            Scope.enter();
            GLM.this.init(true);
            this._adapt_keys = Scope.pop();
            if (GLM.this.error_count() > 0) {
                GLM.this.updateValidationMessages();
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GLM.this);
            }
            ((GLMModel.GLMParameters)GLM.this._parms).read_lock_frames((Job)GLM.this);
            H2O.submitTask((H2O.H2OCountedCompleter)new GLMSingleLambdaTsk((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this), GLM.this._tInfos[0]));
        }

        private class LambdaSearchIteration
        extends H2O.H2OCallback {
            public LambdaSearchIteration(H2O.H2OCountedCompleter cmp) {
                super(cmp);
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                int rank = 0;
                if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial) {
                    for (int i = 0; i < GLM.this._tInfos[0]._beta.length - (GLM.this._dinfo._intercept ? 1 : 0); ++i) {
                        if (GLM.this._tInfos[0]._beta[i] == 0.0) continue;
                        ++rank;
                    }
                    Log.info((Object[])new Object[]{"Solution at lambda = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] + " has " + rank + " nonzeros, ginfo err = " + GLM.this._tInfos[0].gradientCheck(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0])});
                    Log.info((Object[])new Object[]{GLM.this._model.toString()});
                }
                GLM.this.update(GLM.this._tInfos[0]._workPerLambda, "lambda = " + GLM.this._lambdaId + ", iteration = " + GLM.this._tInfos[0]._iter + ", got " + rank + "nonzeros");
                ++GLM.this._lambdaId;
                if (GLM.this._tInfos[0]._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && GLM.this._lambdaId < ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length && GLM.this._tInfos[0]._stopCnt < 3) {
                    this.getCompleter().addToPendingCount(1);
                    new GLMSingleLambdaTsk((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter()), GLM.this._tInfos[0]).fork();
                }
            }
        }
    }

    public static final class GLMTaskInfo
    extends Iced {
        final int _foldId;
        final long _nobs;
        final double _wsum;
        final double[] _ymu;
        final double _lambdaMax;
        double[] _beta;
        double[][] _beta_multinomial;
        int[] _activeCols;
        GLMGradientInfo _ginfo;
        double _objVal;
        int _iter;
        int _workPerIteration;
        int _workPerLambda;
        int _worked;
        double _nullGradNorm;
        double _nullDevTrain;
        double _resDevTest = Double.NaN;
        volatile int _stopCnt;
        boolean _scoredAndUpdated;
        int _numClasses;
        final Key _dstKey;
        boolean _allIn;
        Vec _eVec;
        Vec _wVec;
        Vec _zVec;
        Vec _iVec;
        final int _fullN;
        public boolean _lineSearch;
        public int _lsCnt;

        public GLMTaskInfo(Key dstKey, int foldId, long nobs, double wsum, double[] ymu, double lmax, double[] beta, int fullN, GLMGradientInfo ginfo, double objVal) {
            this._dstKey = dstKey;
            this._foldId = foldId;
            this._nobs = nobs;
            this._wsum = wsum;
            this._ymu = ymu;
            this._lambdaMax = lmax;
            this._beta = beta;
            this._ginfo = ginfo;
            this._objVal = objVal;
            this._fullN = fullN;
        }

        public double gradientCheck(double lambda, double alpha) {
            double[] beta = this._beta;
            double[] subgrad = (double[])this._ginfo._gradient.clone();
            double err = 0.0;
            ADMM.subgrad(alpha * lambda, beta, subgrad);
            for (double d : subgrad) {
                if (err < -d) {
                    err = -d;
                    continue;
                }
                if (!(err < d)) continue;
                err = d;
            }
            return err;
        }

        public void adjustToNewLambda(double currentLambda, double newLambda, double alpha, boolean intercept) {
            assert (currentLambda == 0.0 || newLambda < currentLambda) : "newLambda = " + newLambda + ", last lambda = " + currentLambda;
            double ldiff = newLambda - currentLambda;
            if (this._beta_multinomial != null) {
                double l2pen = 0.0;
                double l1pen = 0.0;
                for (double[] b : this._beta_multinomial) {
                    l1pen += ArrayUtils.l1norm((double[])b, (boolean)intercept);
                    l2pen += ArrayUtils.l2norm2((double[])b, (boolean)intercept);
                }
                l2pen *= 0.5 * (1.0 - alpha);
                l1pen *= alpha;
                int off = 0;
                for (int c = 0; c < this._beta_multinomial.length; ++c) {
                    for (int i = 0; i < this._beta_multinomial[c].length; ++i) {
                        int n = off + i;
                        this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * (1.0 - alpha) * this._beta_multinomial[c][i];
                    }
                    off += this._beta_multinomial.length;
                }
                this._ginfo = new GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal + ldiff * l2pen, this._ginfo._gradient);
                this._objVal += ldiff * (l1pen + l2pen);
            } else {
                double l2pen = 0.5 * (1.0 - alpha) * ArrayUtils.l2norm2((double[])this._beta, (boolean)intercept);
                double l1pen = alpha * ArrayUtils.l1norm((double[])this._beta, (boolean)intercept);
                for (int i = 0; i < this._ginfo._gradient.length - (intercept ? 1 : 0); ++i) {
                    int n = i;
                    this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * (1.0 - alpha) * this._beta[i];
                }
                this._ginfo = new GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal + ldiff * l2pen, this._ginfo._gradient);
                this._objVal += ldiff * (l1pen + l2pen);
            }
        }
    }

    public static class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint setLowerBounds(double[] lb) {
            this._betaLB = lb;
            return this;
        }

        public BetaConstraint setUpperBounds(double[] ub) {
            this._betaUB = ub;
            return this;
        }

        public BetaConstraint setBetaStart(double[] bs) {
            this._betaStart = bs;
            return this;
        }

        public BetaConstraint setProximalPenalty(double[] bGiven, double[] rho) {
            this._betaGiven = bGiven;
            this._rho = rho;
            return this;
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i = 0; i < this._betaGiven.length; ++i) {
                ary[i][0] = this._betaGiven[i];
                ary[i][1] = this._betaLB[i];
                ary[i][2] = this._betaUB[i];
            }
            return ArrayUtils.pprint((double[][])ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d : this._betaLB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d : this._betaUB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            return false;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    int n = i;
                    grad[n] = grad[n] + this._rho[i] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    res += this._rho[i] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }
    }

    private class InitTsk
    extends H2O.H2OCountedCompleter {
        final int _foldId;
        final boolean _intercept;
        long _nobs;
        double[] _yMu;
        double _wsum;
        double _ymuLink;
        double _yMin;
        double _yMax;
        private GLMTask.GLMGradientTask _gtNull;
        private GLMTask.GLMGradientTask _gtNullTest;
        private GLMTask.GLMGradientTask _gtBetaStart;
        private GLMTask.GLMMultinomialGradientTask _gtNullMultinomial;
        private GLMTask.GLMMultinomialGradientTask _gtNullTestMultinomial;
        private GLMTask.GLMMultinomialGradientTask _gtBetaStartMultinomial;
        private transient double _likelihood;
        private transient int _iter;

        public InitTsk(int foldId, boolean intercept) {
            super(true);
            this._likelihood = Double.POSITIVE_INFINITY;
            this._foldId = foldId;
            this._intercept = intercept;
        }

        public InitTsk(int foldId, boolean intercept, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._likelihood = Double.POSITIVE_INFINITY;
            this._foldId = foldId;
            this._intercept = intercept;
        }

        public double[] getNullGradient() {
            return ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this._gtNullMultinomial._gradient : this._gtNull._gradient;
        }

        public double getNullDeviance() {
            return ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this._gtNullMultinomial._val.nullDeviance() : this._gtNull._val.nullDeviance();
        }

        public double getBetaStartLikelihood() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                return this._gtBetaStartMultinomial == null ? this._gtNullMultinomial._likelihood : this._gtBetaStartMultinomial._likelihood;
            }
            return this._gtBetaStart == null ? this._gtNull._likelihood : this._gtBetaStart._likelihood;
        }

        public long getNobs() {
            return ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this._gtNullMultinomial._nobs : this._gtNull._nobs;
        }

        public double[] getNullBeta() {
            assert (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial);
            return this._gtNull._gradient;
        }

        public double[] getBetaStart() {
            assert (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial);
            return this._gtBetaStart != null ? this._gtBetaStart._beta : this._gtNull._beta;
        }

        public double[][] getNullMultinomialBeta() {
            return this._gtNullMultinomial._beta;
        }

        public GLMValidation getNullValidation() {
            return ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this._gtNullMultinomial._val : this._gtNull._val;
        }

        public GLMValidation getNullTestValidation() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                return null;
            }
            return this._gtNullTest == null ? null : this._gtNullTest._val;
        }

        public double[] getStartGradient() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                return this._gtBetaStartMultinomial == null ? this._gtNullMultinomial._gradient : this._gtBetaStartMultinomial._gradient;
            }
            return this._gtBetaStart == null ? this._gtNull._gradient : this._gtBetaStart._gradient;
        }

        protected void compute2() {
            new GLMTask.YMUTask(GLM.this._dinfo, GLM.this.nclasses(), ((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints == null, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.YMUTask>((H2O.H2OCountedCompleter)this){

                public void callback(GLMTask.YMUTask ymut) {
                    InitTsk.this._yMu = ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? ymut._yMu : new double[GLM.this.nclasses()];
                    InitTsk.this._wsum = ymut._wsum;
                    if (((GLMModel.GLMParameters)GLM.this._parms)._obj_reg == -1.0) {
                        ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg = 1.0 / InitTsk.this._wsum;
                    }
                    InitTsk.this._ymuLink = ((GLMModel.GLMParameters)GLM.this._parms)._intercept && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial ? ((GLMModel.GLMParameters)GLM.this._parms).link(InitTsk.this._yMu[0]) : 0.0;
                    InitTsk.this._yMin = ymut._yMin;
                    InitTsk.this._yMax = ymut._yMax;
                    InitTsk.this._nobs = ymut._nobs;
                    if (ymut._comupteWeightedSigma) {
                        double[] sigmas = MemoryManager.malloc8d((int)GLM.this._dinfo._nums);
                        double[] mean = MemoryManager.malloc8d((int)GLM.this._dinfo._nums);
                        for (int i = 0; i < GLM.this._dinfo._nums; ++i) {
                            sigmas[i] = MathUtils.weightedSigma((long)ymut._nobs, (double)ymut._wsum, (double)ymut._xsum[i], (double)ymut._xxsum[i]);
                            mean[i] = ymut._xsum[i] / ymut._wsum;
                        }
                        GLM.this._dinfo.updateWeightedSigmaAndMean(sigmas, mean);
                    }
                    if (GLM.this._dinfo._offset && ((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                        InitTsk.this.addToPendingCount(1);
                        DataInfo dinfo = GLM.this._dinfo.filterExpandedColumns(new int[0]);
                        new GLMTask.GLMIterationTask(GLM.this._key, dinfo, 0.0, (GLMModel.GLMParameters)GLM.this._parms, false, new double[]{((GLMModel.GLMParameters)GLM.this._parms).link(GLM.this._response.mean()) - GLM.this._offset.mean()}, 0.0, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new NullModelIteration(dinfo)).asyncExec(dinfo._adaptedFrame);
                    } else {
                        InitTsk.this.computeGradients();
                    }
                }
            }).asyncExec(GLM.this._dinfo._adaptedFrame);
        }

        private void computeGradients() {
            if (this._nobs > 0L) {
                this.addToPendingCount(1);
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                    double[][] beta = new double[GLM.this.nclasses()][];
                    for (int i = 0; i < beta.length; ++i) {
                        beta[i] = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                        beta[i][GLM.this._dinfo.fullN()] = Math.log(this._yMu[i]);
                    }
                    this._gtNullMultinomial = (GLMTask.GLMMultinomialGradientTask)new GLMTask.GLMMultinomialGradientTask(GLM.this._dinfo, 0.0, this._yMu, beta, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg, true, this).asyncExec(GLM.this._dinfo._adaptedFrame);
                    if (GLM.this._validDinfo != null) {
                        this.addToPendingCount(1);
                        this._gtNullTestMultinomial = (GLMTask.GLMMultinomialGradientTask)new GLMTask.GLMMultinomialGradientTask(GLM.this._validDinfo, 0.0, this._yMu, beta, 1.0, true, this).asyncExec(((GLM)GLM.this)._validDinfo._adaptedFrame);
                    }
                } else {
                    double[] beta = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                    if (this._intercept) {
                        beta[beta.length - 1] = this._ymuLink;
                    }
                    if (((GLM)GLM.this)._bc._betaStart == null) {
                        GLM.this._bc.setBetaStart(beta);
                    }
                    this._gtNull = (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, 0.0, beta, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, this).setValidate(this._yMu[0], true).asyncExec(GLM.this._dinfo._adaptedFrame);
                    if (GLM.this._validDinfo != null) {
                        this.addToPendingCount(1);
                        this._gtNullTest = (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, 0.0, beta, 1.0, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, this).setValidate(this._yMu[0], true).asyncExec(((GLM)GLM.this)._validDinfo._adaptedFrame);
                    }
                    if (beta != ((GLM)GLM.this)._bc._betaStart) {
                        this.addToPendingCount(1);
                        this._gtBetaStart = (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, 0.0, ((GLM)GLM.this)._bc._betaStart, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, this).setValidate(this._yMu[0], true).asyncExec(GLM.this._dinfo._adaptedFrame);
                    }
                }
            }
        }

        public void onCompletion(CountedCompleter cc) {
            if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                this._gtNull._gradient[this._gtNull._gradient.length - 1] = 0.0;
                if (this._gtBetaStart != null) {
                    this._gtBetaStart._gradient[this._gtBetaStart._gradient.length - 1] = 0.0;
                }
            }
        }

        private class NullModelIteration
        extends H2O.H2OCallback<GLMTask.GLMIterationTask> {
            final DataInfo _nullDinfo;

            NullModelIteration(DataInfo dinfo) {
                super((H2O.H2OCountedCompleter)InitTsk.this);
                this._nullDinfo = dinfo;
                assert (InitTsk.this._yMu.length == 1) : "unimplemented for multinomial";
            }

            public void callback(GLMTask.GLMIterationTask glmIterationTask) {
                if (glmIterationTask._likelihood > InitTsk.this._likelihood) {
                    if (++InitTsk.this._iter < 50) {
                        InitTsk.this.addToPendingCount(1);
                        new GLMTask.GLMIterationTask(GLM.this._key, this._nullDinfo, 0.0, (GLMModel.GLMParameters)GLM.this._parms, false, new double[]{0.5 * (InitTsk.this._yMu[0] + glmIterationTask._beta[0])}, 0.0, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new NullModelIteration(this._nullDinfo)).asyncExec(this._nullDinfo._adaptedFrame);
                    } else {
                        InitTsk.this._ymuLink = InitTsk.this._yMu[0];
                        InitTsk.this._yMu[0] = ((GLMModel.GLMParameters)GLM.this._parms).linkInv(InitTsk.this._ymuLink);
                        InitTsk.this.computeGradients();
                    }
                    return;
                }
                InitTsk.this._likelihood = glmIterationTask._likelihood;
                InitTsk.this._yMu = new double[]{glmIterationTask._beta[0]};
                double ymu = glmIterationTask._xy[0] / glmIterationTask._gram.get(0, 0);
                if (++InitTsk.this._iter < 50 && Math.abs(ymu - glmIterationTask._beta[0]) > ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon) {
                    InitTsk.this.addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLM.this._key, this._nullDinfo, 0.0, (GLMModel.GLMParameters)GLM.this._parms, false, new double[]{ymu}, 0.0, ((GLMModel.GLMParameters)GLM.this._parms)._intercept, (H2O.H2OCountedCompleter)new NullModelIteration(this._nullDinfo)).asyncExec(this._nullDinfo._adaptedFrame);
                } else {
                    System.out.println("computed null intercept in " + InitTsk.this._iter + " iterations, intercept = " + InitTsk.this._yMu[0]);
                    InitTsk.this._ymuLink = InitTsk.this._yMu[0];
                    InitTsk.this._yMu[0] = ((GLMModel.GLMParameters)GLM.this._parms).linkInv(InitTsk.this._ymuLink);
                    InitTsk.this.computeGradients();
                }
            }
        }
    }

    private static class ScoringHistory {
        private ArrayList<Integer> _scoringIters = new ArrayList();
        private ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _likelihoods = new ArrayList();
        private ArrayList<Double> _objectives = new ArrayList();
        private ArrayList<Double> _lambdas = new ArrayList();
        private ArrayList<Integer> _lambdaIters = new ArrayList();
        private ArrayList<Integer> _lambdaPredictors = new ArrayList();
        private ArrayList<Double> _lambdaDevTrain = new ArrayList();
        private ArrayList<Double> _lambdaDevTest = new ArrayList();

        private ScoringHistory() {
        }

        public synchronized void addIterationScore(int iter, double likelihood, double obj) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) == iter) {
                return;
            }
            this._scoringIters.add(iter);
            this._scoringTimes.add(System.currentTimeMillis());
            this._likelihoods.add(likelihood);
            this._objectives.add(obj);
        }

        public synchronized void addLambdaScore(int iter, double lambda, int preds, double devExpTrain, double devExpTest) {
            this._lambdaIters.add(iter);
            this._lambdas.add(lambda);
            this._lambdaPredictors.add(preds);
            this._lambdaDevTrain.add(devExpTrain);
            if (!Double.isNaN(devExpTest)) {
                this._lambdaDevTest.add(devExpTest);
            }
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iteration", "log_likelihood", "objective"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            if (this._lambdaIters.size() > 1) {
                cnames = ArrayUtils.append((String[])cnames, (String[])new String[]{"lambda", "Number of Predictors", "Explained Deviance (train)", "Explained Deviance (test)"});
                ctypes = ArrayUtils.append((String[])ctypes, (String[])new String[]{"double", "int", "double", "double"});
                cformats = ArrayUtils.append((String[])cformats, (String[])new String[]{"%.3f", "%d", "%.3f", "%.3f"});
            }
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            int j = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._scoringIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._scoringIters.get(i));
                res.set(i, col++, (Object)this._likelihoods.get(i));
                res.set(i, col++, (Object)this._objectives.get(i));
                if (this._lambdaIters.size() <= 1 || j >= this._lambdaIters.size() || !this._scoringIters.get(i).equals(this._lambdaIters.get(j))) continue;
                res.set(i, col++, (Object)this._lambdas.get(j));
                res.set(i, col++, (Object)this._lambdaPredictors.get(j));
                res.set(i, col++, (Object)this._lambdaDevTrain.get(j));
                if (j < this._lambdaDevTest.size()) {
                    res.set(i, col++, (Object)this._lambdaDevTest.get(j));
                }
                ++j;
            }
            return res;
        }
    }

    static class TooManyPredictorsException
    extends RuntimeException {
        TooManyPredictorsException() {
        }
    }
}

