/*
 * Decompiled with CFR 0.152.
 */
package hex.api;

import hex.DataInfo;
import hex.glm.GLMModel;
import hex.schemas.GLMModelV3;
import hex.schemas.MakeGLMModelV3;
import java.util.HashMap;
import water.DKV;
import water.Iced;
import water.Key;
import water.api.Handler;

public class MakeGLMModelHandler
extends Handler {
    public GLMModelV3 make_model(int version, MakeGLMModelV3 args) {
        GLMModel model = (GLMModel)DKV.getGet((Key)args.model.key());
        if (model == null) {
            throw new IllegalArgumentException("missing source model " + args.model);
        }
        String[] names = ((GLMModel.GLMOutput)model._output).coefficientNames();
        HashMap<String, Double> coefs = model.coefficients();
        for (int i = 0; i < args.names.length; ++i) {
            coefs.put(args.names[i], args.beta[i]);
        }
        double[] beta = (double[])model.beta().clone();
        for (int i = 0; i < beta.length; ++i) {
            beta[i] = (Double)coefs.get(names[i]);
        }
        GLMModel m = new GLMModel(args.dest != null ? args.dest.key() : Key.make(), (GLMModel.GLMParameters)model._parms, null, new double[]{0.5}, Double.NaN, Double.NaN, -1L, false, false);
        DataInfo dinfo = model.dinfo();
        dinfo.setPredictorTransform(DataInfo.TransformType.NONE);
        m._output = new GLMModel.GLMOutput(model.dinfo(), ((GLMModel.GLMOutput)model._output)._names, ((GLMModel.GLMOutput)model._output)._domains, ((GLMModel.GLMOutput)model._output).coefficientNames(), ((GLMModel.GLMOutput)model._output)._binomial, beta);
        DKV.put((Key)m._key, (Iced)m);
        GLMModelV3 res = new GLMModelV3();
        res.fillFromImpl(m);
        return res;
    }
}

