/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionGLM;
import hex.ModelMetricsSupervised;
import hex.glm.GLMModel;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class GLMValidation
extends ModelMetricsSupervised.MetricBuilderSupervised<GLMValidation> {
    double residual_deviance;
    double null_deviance;
    final double _ymu;
    final double _ymuLink;
    final double[] _ymus;
    long _nobs;
    double _aic;
    private double _aic2;
    final GLMModel.GLMParameters _parms;
    private final int _rank;
    final double _threshold;
    ModelMetrics.MetricBuilder _metricBuilder;
    final boolean _intercept;
    final boolean _computeMetrics;
    transient double[] _ds = new double[3];
    transient float[] _yact = new float[1];

    public GLMValidation(String[] domain, double[] ymu, GLMModel.GLMParameters parms, int rank, double threshold, boolean computeMetrics, boolean intercept) {
        super(domain == null ? 1 : domain.length, domain);
        this._rank = rank;
        this._parms = parms;
        this._threshold = threshold;
        this._computeMetrics = computeMetrics;
        this._intercept = intercept;
        if (parms._family == GLMModel.GLMParameters.Family.multinomial) {
            this._ymus = ymu;
            assert (this._ymus.length == domain.length);
            this._ymu = Double.NaN;
            this._ymuLink = Double.NaN;
        } else {
            this._ymu = parms._intercept ? ymu[0] : (parms._family == GLMModel.GLMParameters.Family.binomial ? 0.5 : 0.0);
            this._ymuLink = this._parms.link(this._ymu);
            this._ymus = null;
        }
        if (this._computeMetrics) {
            switch (this._parms._family) {
                case binomial: {
                    this._metricBuilder = new ModelMetricsBinomial.MetricBuilderBinomial(domain);
                    break;
                }
                case multinomial: {
                    this._metricBuilder = new ModelMetricsMultinomial.MetricBuilderMultinomial(domain.length, domain);
                    ((ModelMetricsMultinomial.MetricBuilderMultinomial)this._metricBuilder)._priorDistribution = this._ymus;
                    break;
                }
                default: {
                    this._metricBuilder = new ModelMetricsRegression.MetricBuilderRegression();
                }
            }
        }
    }

    public double explainedDev() {
        return 1.0 - this.residualDeviance() / this.nullDeviance();
    }

    public double[] perRow(double[] ds, float[] yact, Model m) {
        return this.perRow(ds, yact, 1.0, 0.0, m);
    }

    public double[] perRow(double[] ds, float[] yact, double weight, double offset, Model m) {
        if (weight == 0.0) {
            return ds;
        }
        this._metricBuilder.perRow(ds, yact, weight, offset, m);
        if (!ArrayUtils.hasNaNsOrInfs((double[])ds) && !ArrayUtils.hasNaNsOrInfs((float[])yact)) {
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial) {
                this.add2((double)yact[0], ds, weight, offset);
            } else if (this._parms._family == GLMModel.GLMParameters.Family.binomial) {
                this.add2((double)yact[0], ds[2], weight, offset);
            } else {
                this.add2((double)yact[0], ds[0], weight, offset);
            }
        }
        return ds;
    }

    public void add(double yreal, double[] ymodel, double weight, double offset) {
        if (weight == 0.0) {
            return;
        }
        this._yact[0] = (float)yreal;
        if (this._computeMetrics) {
            this._metricBuilder.perRow(ymodel, this._yact, weight, offset, null);
        }
        this.add2(yreal, ymodel, weight, offset);
    }

    public void add(double yreal, double ymodel, double weight, double offset) {
        if (weight == 0.0) {
            return;
        }
        this._yact[0] = (float)yreal;
        if (this._parms._family == GLMModel.GLMParameters.Family.binomial) {
            this._ds[0] = ymodel > this._threshold ? 1.0 : 0.0;
            this._ds[1] = 1.0 - ymodel;
            this._ds[2] = ymodel;
        } else {
            this._ds[0] = ymodel;
        }
        if (this._computeMetrics) {
            assert (!(this._metricBuilder instanceof ModelMetricsMultinomial.MetricBuilderMultinomial)) : "using incorrect add call fro multinomial";
            this._metricBuilder.perRow(this._ds, this._yact, weight, offset, null);
        }
        this.add2(yreal, ymodel, weight, offset);
    }

    private void add2(double yreal, double[] ymodel, double weight, double offset) {
        this._wcount += weight;
        ++this._nobs;
        int c = (int)yreal;
        this.residual_deviance -= 2.0 * weight * Math.log(ymodel[c + 1]);
        this.null_deviance = offset != 0.0 ? (this.null_deviance -= 2.0 * weight * Math.log(offset + (this._intercept ? Math.exp(this._ymus[c]) : 0.0))) : (this.null_deviance -= 2.0 * weight * Math.log(this._intercept ? this._ymus[c] : 0.0));
    }

    private void add2(double yreal, double ymodel, double weight, double offset) {
        this._wcount += weight;
        ++this._nobs;
        this.residual_deviance += weight * this._parms.deviance(yreal, ymodel);
        double ynull = offset == 0.0 ? this._ymu : this._parms.linkInv(offset + this._ymuLink);
        this.null_deviance += weight * this._parms.deviance(yreal, ynull);
        if (this._parms._family == GLMModel.GLMParameters.Family.poisson) {
            long y = Math.round(yreal);
            double logfactorial = 0.0;
            for (long i = 2L; i <= y; ++i) {
                logfactorial += Math.log(i);
            }
            this._aic2 += weight * (yreal * Math.log(ymodel) - logfactorial - ymodel);
        }
    }

    public void reduce(GLMValidation v) {
        if (this._computeMetrics) {
            this._metricBuilder.reduce(v._metricBuilder);
        }
        this.residual_deviance += v.residual_deviance;
        this.null_deviance += v.null_deviance;
        this._nobs += v._nobs;
        this._aic2 += v._aic2;
        this._wcount += v._wcount;
    }

    public final double nullDeviance() {
        return this.null_deviance;
    }

    public final double residualDeviance() {
        return this.residual_deviance;
    }

    public final long nullDOF() {
        return this._nobs - (long)(this._intercept ? 1 : 0);
    }

    public final long resDOF() {
        return this._nobs - (long)this._rank;
    }

    protected void computeAIC() {
        this._aic = 0.0;
        switch (this._parms._family) {
            case gaussian: {
                this._aic = (double)this._nobs * (Math.log(this.residual_deviance / (double)this._nobs * 2.0 * Math.PI) + 1.0) + 2.0;
                break;
            }
            case binomial: {
                this._aic = this.residual_deviance;
                break;
            }
            case poisson: {
                this._aic = -2.0 * this._aic2;
                break;
            }
            case gamma: {
                this._aic = Double.NaN;
                break;
            }
            case multinomial: 
            case tweedie: {
                this._aic = Double.NaN;
                break;
            }
            default: {
                assert (false) : "missing implementation for family " + (Object)((Object)this._parms._family);
                break;
            }
        }
        this._aic += (double)(2 * this._rank);
    }

    public String toString() {
        if (this._metricBuilder != null) {
            return this._metricBuilder.toString() + ", explained_dev = " + MathUtils.roundToNDigits((double)(1.0 - this.residual_deviance / this.null_deviance), (int)5);
        }
        return "explained dev = " + MathUtils.roundToNDigits((double)(1.0 - this.residual_deviance / this.null_deviance), (int)5);
    }

    public ModelMetrics makeModelMetrics(Model m, Frame f) {
        GLMModel gm = (GLMModel)m;
        this.computeAIC();
        ModelMetrics metrics = this._metricBuilder.makeModelMetrics((Model)gm, f);
        if (this._parms._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomial metricsBinommial = (ModelMetricsBinomial)metrics;
            metrics = new ModelMetricsBinomialGLM(m, f, metrics._MSE, this._domain, metricsBinommial._sigma, metricsBinommial._auc, metricsBinommial._logloss, this.residualDeviance(), this.nullDeviance(), this._aic, this.nullDOF(), this.resDOF());
        } else if (this._parms._family == GLMModel.GLMParameters.Family.multinomial) {
            ModelMetricsMultinomial metricsMultinomial = (ModelMetricsMultinomial)metrics;
            metrics = new ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM(m, f, metricsMultinomial._MSE, metricsMultinomial._domain, metricsMultinomial._sigma, metricsMultinomial._cm, metricsMultinomial._hit_ratios, metricsMultinomial._logloss, this.residualDeviance(), this.nullDeviance(), this._aic, this.nullDOF(), this.resDOF());
        } else {
            ModelMetricsRegression metricsRegression = (ModelMetricsRegression)metrics;
            metrics = new ModelMetricsRegressionGLM(m, f, metricsRegression._MSE, metricsRegression._sigma, this.residualDeviance(), this.residualDeviance() / this._wcount, this.nullDeviance(), this._aic, this.nullDOF(), this.resDOF());
        }
        return ((GLMModel.GLMOutput)gm._output).addModelMetrics(metrics);
    }
}

