/*
 * Decompiled with CFR 0.152.
 */
package hex.optimization;

import java.util.Arrays;
import water.Iced;
import water.util.ArrayUtils;

public class OptimizationUtils {

    public static final class MoreThuente
    implements LineSearchSolver {
        double _stMin;
        double _stMax;
        double _initialStep = 1.0;
        double _minRelativeImprovement = 1.0E-8;
        double _xtol = 0.01;
        double _ftol = 0.1;
        double _gtol = 0.1;
        double _xtrapf = 4.0;
        double _fvx;
        double _dgx;
        double _stx;
        double _bestStep;
        GradientInfo _betGradient;
        double _bestPsiVal;
        GradientInfo _ginfox;
        double _fvy;
        double _dgy;
        double _sty;
        boolean _brackt;
        boolean _bound;
        int _returnStatus;
        public final String[] messages = new String[]{"In progress or not evaluated", "The sufficient decrease condition and the directional derivative condition hold.", "Relative width of the interval of uncertainty is at most xtol.", "Number of calls to gradient solver has reached the limit.", "The step is at the lower bound stpmin.", "The step is at the upper bound stpmax.", "Rounding errors prevent further progress, ftol/gtol tolerances may be too small."};
        private int _iter;
        private double[] _beta;

        public MoreThuente() {
        }

        public MoreThuente(double ftol, double gtol, double xtol) {
            this._ftol = ftol;
            this._gtol = gtol;
            this._xtol = xtol;
        }

        public MoreThuente setXtol(double xtol) {
            this._xtol = xtol;
            return this;
        }

        public MoreThuente setFtol(double ftol) {
            this._ftol = ftol;
            return this;
        }

        public MoreThuente setGtol(double gtol) {
            this._gtol = gtol;
            return this;
        }

        @Override
        public MoreThuente setInitialStep(double t) {
            this._initialStep = t;
            return this;
        }

        @Override
        public int nfeval() {
            return this._iter;
        }

        private double nextStep(GradientInfo ginfo, double dg, double stp, double off) {
            double nextStep;
            double fvp = ginfo._objVal - stp * off;
            double dgp = dg - off;
            double fvx = this._fvx - this._stx * off;
            double fvy = this._fvy - this._sty * off;
            double stx = this._stx;
            double sty = this._sty;
            double dgx = this._dgx - off;
            double dgy = this._dgy - off;
            if (this._brackt && (stp <= Math.min(stx, sty) || stp >= Math.max(stx, sty)) || dgx * (stp - stx) >= 0.0) {
                return Double.NaN;
            }
            double theta = 3.0 * (fvx - fvp) / (stp - stx) + dgx + dgp;
            double s = Math.max(Math.max(Math.abs(theta), Math.abs(dgx)), Math.abs(dgp));
            double sInv = 1.0 / s;
            double ts = theta * sInv;
            double gamma = s * Math.sqrt(Math.max(0.0, ts * ts - dgx * sInv * (dgp * sInv)));
            int info = 0;
            if (fvp > fvx) {
                info = 1;
                if (stp < stx) {
                    gamma = -gamma;
                }
                this._bound = true;
                this._brackt = true;
                double p = gamma - dgx + theta;
                double q = gamma - dgx + gamma + dgp;
                double r = p / q;
                double stpc = stx + r * (stp - stx);
                double stpq = stx + dgx / ((fvx - fvp) / (stp - stx) + dgx) / 2.0 * (stp - stx);
                nextStep = Math.abs(stpc - stx) < Math.abs(stpq - stx) ? stpc : stpc + (stpq - stpc) / 2.0;
            } else if (dgp * dgx < 0.0) {
                info = 2;
                if (stp > stx) {
                    gamma = -gamma;
                }
                this._bound = false;
                this._brackt = true;
                double p = gamma - dgp + theta;
                double q = gamma - dgp + gamma + dgx;
                double r = p / q;
                double stpc = stp + r * (stx - stp);
                double stpq = stp + dgp / (dgp - dgx) * (stx - stp);
                nextStep = Math.abs(stpc - stp) > Math.abs(stpq - stp) ? stpc : stpq;
            } else if (Math.abs(dgp) < Math.abs(dgx)) {
                info = 3;
                if (stp > stx) {
                    gamma = -gamma;
                }
                this._bound = true;
                double p = gamma - dgp + theta;
                double q = gamma + dgx - dgp + gamma;
                double r = p / q;
                double stpc = r < 0.0 && gamma != 0.0 ? stp + r * (stx - stp) : (stp > stx ? this._stMax : this._stMin);
                double stpq = stp + dgp / (dgp - dgx) * (stx - stp);
                nextStep = this._brackt ? (Math.abs(stp - stpc) < Math.abs(stp - stpq) ? stpc : stpq) : (Math.abs(stp - stpc) > Math.abs(stp - stpq) ? stpc : stpq);
            } else {
                info = 4;
                this._bound = false;
                if (this._brackt) {
                    theta = 3.0 * (fvp - fvy) / (sty - stp) + dgy + dgp;
                    gamma = Math.sqrt(theta * theta - dgy * dgp);
                    if (stp > sty) {
                        gamma = -gamma;
                    }
                    double p = gamma - dgp + theta;
                    double q = gamma - dgp + gamma + dgy;
                    double r = p / q;
                    nextStep = stp + r * (sty - stp);
                } else {
                    double d = nextStep = stp > stx ? this._stMax : this._stMin;
                }
            }
            if (fvp > fvx) {
                this._sty = stp;
                this._fvy = ginfo._objVal;
                this._dgy = dg;
            } else {
                if (dgp * dgx < 0.0) {
                    this._sty = this._stx;
                    this._fvy = this._fvx;
                    this._dgy = this._dgx;
                }
                this._stx = stp;
                this._fvx = ginfo._objVal;
                this._dgx = dg;
                this._ginfox = ginfo;
            }
            if (nextStep > this._stMax) {
                nextStep = this._stMax;
            }
            if (nextStep < this._stMin) {
                nextStep = this._stMin;
            }
            if (this._brackt & this._bound) {
                nextStep = this._sty > this._stx ? Math.min(this._stx + 0.66 * (this._sty - this._stx), nextStep) : Math.max(this._stx + 0.66 * (this._sty - this._stx), nextStep);
            }
            return nextStep;
        }

        public String toString() {
            return "MoreThuente line search, iter = " + this._iter + ", status = " + this.messages[this._returnStatus] + ", step = " + this._stx + ", I = " + "[" + this._stMin + ", " + this._stMax + "], grad = " + this._dgx + ", bestObj = " + this._fvx;
        }

        @Override
        public boolean evaluate(GradientSolver slvr, GradientInfo ginfo, double[] betaStart, double[] direction, double minStep, double maxStep, int maxfev) {
            double step = this._initialStep;
            this._bound = false;
            this._brackt = false;
            this._sty = 0.0;
            this._stx = 0.0;
            this._stMax = 0.0;
            this._stMin = 0.0;
            this._betGradient = null;
            this._bestPsiVal = Double.POSITIVE_INFINITY;
            this._bestStep = 0.0;
            double maxObj = ginfo._objVal - this._minRelativeImprovement * ginfo._objVal;
            double dgInit = ArrayUtils.innerProduct((double[])ginfo._gradient, (double[])direction);
            double dgtest = dgInit * this._ftol;
            if (dgtest >= 0.0) {
                return false;
            }
            if (this._beta == null) {
                this._beta = new double[betaStart.length];
            }
            double width = maxStep - minStep;
            double oldWidth = 2.0 * width;
            boolean stage1 = true;
            this._ginfox = ginfo;
            this._fvx = this._fvy = ginfo._objVal;
            this._dgx = this._dgy = dgInit;
            this._iter = 0;
            while (true) {
                if (this._brackt) {
                    this._stMin = Math.min(this._stx, this._sty);
                    this._stMax = Math.max(this._stx, this._sty);
                } else {
                    this._stMin = this._stx;
                    this._stMax = step + this._xtrapf * (step - this._stx);
                }
                step = Math.min(step, maxStep);
                step = Math.max(step, minStep);
                double maxFval = ginfo._objVal + step * dgtest;
                for (int i = 0; i < this._beta.length; ++i) {
                    this._beta[i] = betaStart[i] + step * direction[i];
                }
                GradientInfo newGinfo = slvr.getGradient(this._beta);
                if (newGinfo._objVal < maxObj && (this._betGradient == null || newGinfo._objVal - maxFval < this._bestPsiVal)) {
                    this._bestPsiVal = newGinfo._objVal - maxFval;
                    this._betGradient = newGinfo;
                    this._bestStep = step;
                }
                ++this._iter;
                if (!Double.isNaN(step) && (Double.isNaN(newGinfo._objVal) || Double.isInfinite(newGinfo._objVal) || ArrayUtils.hasNaNsOrInfs((double[])newGinfo._gradient))) {
                    this._brackt = true;
                    this._sty = step;
                    maxStep = step;
                    this._fvy = Double.POSITIVE_INFINITY;
                    this._dgy = Double.MAX_VALUE;
                    step *= 0.5;
                    continue;
                }
                double dgp = ArrayUtils.innerProduct((double[])newGinfo._gradient, (double[])direction);
                if (Double.isNaN(step) || this._brackt && (step <= this._stMin || step >= this._stMax)) {
                    this._returnStatus = 6;
                    break;
                }
                if (step == maxStep && newGinfo._objVal <= maxFval & dgp <= dgtest) {
                    this._returnStatus = 5;
                    this._stx = step;
                    this._ginfox = newGinfo;
                    break;
                }
                if (step == minStep && newGinfo._objVal > maxFval | dgp >= dgtest) {
                    this._returnStatus = 4;
                    if (this._betGradient != null) {
                        this._stx = this._bestStep;
                        this._ginfox = this._betGradient;
                        break;
                    }
                    this._stx = step;
                    this._ginfox = newGinfo;
                    break;
                }
                if (this._iter >= maxfev) {
                    this._returnStatus = 3;
                    if (this._betGradient != null) {
                        this._stx = this._bestStep;
                        this._ginfox = this._betGradient;
                        break;
                    }
                    this._stx = step;
                    this._ginfox = newGinfo;
                    break;
                }
                if (this._brackt && this._stMax - this._stMin <= this._xtol * this._stMax) {
                    this._ginfox = newGinfo;
                    this._returnStatus = 2;
                    break;
                }
                if (newGinfo._objVal < maxFval && Math.abs(dgp) <= -this._gtol * dgInit) {
                    this._stx = step;
                    this._dgx = dgp;
                    this._fvx = newGinfo._objVal;
                    this._ginfox = newGinfo;
                    this._returnStatus = 1;
                    break;
                }
                stage1 = stage1 && (newGinfo._objVal > maxFval || dgp < dgtest);
                boolean useAugmentedFuntcion = stage1 && newGinfo._objVal <= this._fvx && newGinfo._objVal > maxFval;
                double off = useAugmentedFuntcion ? dgtest : 0.0;
                double nextStep = this.nextStep(newGinfo, dgp, step, off);
                if (this._brackt) {
                    if (Math.abs(this._sty - this._stx) >= 0.66 * oldWidth) {
                        nextStep = this._stx + 0.5 * (this._sty - this._stx);
                    }
                    oldWidth = width;
                    width = Math.abs(this._sty - this._stx);
                }
                step = nextStep;
            }
            boolean succ = this._ginfox._objVal < ginfo._objVal;
            return succ;
        }

        @Override
        public double step() {
            return this._stx;
        }

        @Override
        public GradientInfo ginfo() {
            return this._ginfox;
        }
    }

    public static final class BacktrackingLS
    implements LineSearchSolver {
        double[] _beta;
        final double _stepDec;
        final double _ftol = 0.1;
        final double _gtol = 0.9;
        double _step;
        GradientInfo _ginfo;

        public BacktrackingLS(double stepDec) {
            this._stepDec = stepDec;
        }

        @Override
        public int nfeval() {
            return -1;
        }

        @Override
        public LineSearchSolver setInitialStep(double s) {
            return this;
        }

        @Override
        public boolean evaluate(GradientSolver slvr, GradientInfo ginfo, double[] betaStart, double[] direction, double minStep, double maxStep, int maxfev) {
            if (this._beta == null) {
                this._beta = new double[betaStart.length];
            }
            double dg = ArrayUtils.innerProduct((double[])ginfo._gradient, (double[])direction);
            double fhat = 0.1 * dg;
            double ghat = -0.9 * dg;
            assert (fhat < 0.0);
            for (double step = maxStep; step >= minStep && --maxfev >= 0; step *= this._stepDec) {
                for (int i = 0; i < betaStart.length; ++i) {
                    this._beta[i] = betaStart[i] + step * direction[i];
                }
                GradientInfo newGinfo = slvr.getGradient(this._beta);
                double dgp = Math.abs(ArrayUtils.innerProduct((double[])newGinfo._gradient, (double[])direction));
                if (!(newGinfo._objVal < ginfo._objVal + step * fhat) || !(Math.abs(ArrayUtils.innerProduct((double[])newGinfo._gradient, (double[])direction)) < ghat)) continue;
                this._ginfo = newGinfo;
                this._step = step;
                return true;
            }
            return false;
        }

        @Override
        public double step() {
            return this._step;
        }

        @Override
        public GradientInfo ginfo() {
            return this._ginfo;
        }
    }

    public static interface LineSearchSolver {
        public boolean evaluate(GradientSolver var1, GradientInfo var2, double[] var3, double[] var4, double var5, double var7, int var9);

        public double step();

        public GradientInfo ginfo();

        public LineSearchSolver setInitialStep(double var1);

        public int nfeval();
    }

    public static interface GradientSolver {
        public GradientInfo getGradient(double[] var1);
    }

    public static class GradientInfo
    extends Iced {
        public double _objVal;
        public final double[] _gradient;

        public GradientInfo(double objVal, double[] grad) {
            this._objVal = objVal;
            this._gradient = grad;
        }

        public boolean isValid() {
            if (Double.isNaN(this._objVal)) {
                return false;
            }
            return !ArrayUtils.hasNaNsOrInfs((double[])this._gradient);
        }

        public String toString() {
            return " objVal = " + this._objVal + ", " + Arrays.toString(this._gradient);
        }

        public boolean hasNaNsOrInfs() {
            return Double.isNaN(this._objVal) || ArrayUtils.hasNaNsOrInfs((double[])this._gradient);
        }
    }
}

