/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DTree;
import sun.misc.Unsafe;
import water.H2O;
import water.Iced;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.IcedBitSet;
import water.util.Log;
import water.util.MathUtils;

public final class DHistogram
extends Iced {
    public final transient String _name;
    public final byte _isInt;
    public final char _nbin;
    public final float _step;
    public final float _min;
    public final float _maxEx;
    public double[] _bins;
    private double[] _sums;
    private double[] _ssqs;
    protected float _min2;
    protected float _maxIn;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _min2Offset;
    private static final long _max2Offset;

    void setMin(float min) {
        int imin = Float.floatToRawIntBits(min);
        float old = this._min2;
        while (min < old && !_unsafe.compareAndSwapInt((Object)this, _min2Offset, Float.floatToRawIntBits(old), imin)) {
            old = this._min2;
        }
    }

    void setMax(float max) {
        int imax = Float.floatToRawIntBits(max);
        float old = this._maxIn;
        while (max > old && !_unsafe.compareAndSwapInt((Object)this, _max2Offset, Float.floatToRawIntBits(old), imax)) {
            old = this._maxIn;
        }
    }

    public DHistogram(String name, int nbins, int nbins_cats, byte isInt, float min, float maxEx) {
        int xbins;
        assert (nbins > 1);
        assert (nbins_cats > 1);
        assert (maxEx > min) : "Caller ensures " + maxEx + ">" + min + ", since if max==min== the column " + name + " is all constants";
        this._isInt = isInt;
        this._name = name;
        this._min = min;
        this._maxEx = maxEx;
        this._min2 = Float.MAX_VALUE;
        this._maxIn = -3.4028235E38f;
        int n = xbins = isInt == 2 ? nbins_cats : nbins;
        if (isInt > 0 && maxEx - min <= (float)xbins) {
            assert ((float)((long)min) == min);
            xbins = (char)((long)maxEx - (long)min);
            this._step = 1.0f;
        } else {
            this._step = (float)xbins / (maxEx - min);
            assert (this._step > 0.0f && !Float.isInfinite(this._step));
        }
        this._nbin = (char)xbins;
    }

    int bin(float col_data) {
        if (Float.isNaN(col_data)) {
            return 0;
        }
        if (Float.isInfinite(col_data)) {
            if (col_data < 0.0f) {
                return 0;
            }
            return this._bins.length - 1;
        }
        assert (this._min <= col_data && col_data < this._maxEx) : "Coldata " + col_data + " out of range " + (Object)((Object)this);
        int idx1 = (int)((col_data - this._min) * this._step);
        assert (0 <= idx1 && idx1 <= this._bins.length) : idx1 + " " + this._bins.length;
        if (idx1 == this._bins.length) {
            --idx1;
        }
        return idx1;
    }

    float binAt(int b) {
        return this._min + (float)b / this._step;
    }

    public int nbins() {
        return this._nbin;
    }

    public double bins(int b) {
        return this._bins[b];
    }

    void init() {
        assert (this._bins == null);
        this._bins = MemoryManager.malloc8d((int)this._nbin);
        this.init0();
    }

    void incr(float col_data, double y, double w) {
        assert (Float.isNaN(col_data) || Float.isInfinite(col_data) || this._min <= col_data && col_data < this._maxEx) : "col_data " + col_data + " out of range " + (Object)((Object)this);
        int b = this.bin(col_data);
        AtomicUtils.DoubleArray.add((double[])this._bins, (int)b, (double)w);
        if (!Float.isInfinite(col_data)) {
            this.setMin(col_data);
            this.setMax(col_data);
        }
        if (y != 0.0 && w != 0.0) {
            this.incr0(b, y, w);
        }
    }

    void add(DHistogram dsh) {
        assert (this._isInt == dsh._isInt && this._nbin == dsh._nbin && this._step == dsh._step && this._min == dsh._min && this._maxEx == dsh._maxEx);
        assert (this._bins == null && dsh._bins == null || this._bins != null && dsh._bins != null);
        if (this._bins == null) {
            return;
        }
        ArrayUtils.add((double[])this._bins, (double[])dsh._bins);
        if (this._min2 > dsh._min2) {
            this._min2 = dsh._min2;
        }
        if (this._maxIn < dsh._maxIn) {
            this._maxIn = dsh._maxIn;
        }
        this.add0(dsh);
    }

    float find_min() {
        return this._min2;
    }

    float find_maxIn() {
        return this._maxIn;
    }

    float find_maxEx() {
        return DHistogram.find_maxEx(this._maxIn, this._isInt);
    }

    private static float find_maxEx(float maxIn, int isInt) {
        float res;
        float ulp = Math.ulp(maxIn);
        if (isInt > 0 && 1.0f > ulp) {
            ulp = 1.0f;
        }
        return Float.isInfinite(res = maxIn + ulp) ? maxIn : res;
    }

    public static DHistogram[] initialHist(Frame fr, int ncols, int nbins, int nbins_cats, DHistogram[] hs) {
        Vec[] vecs = fr.vecs();
        for (int c = 0; c < ncols; ++c) {
            Vec v = vecs[c];
            float minIn = (float)Math.max(v.min(), -3.4028234663852886E38);
            float maxIn = (float)Math.min(v.max(), 3.4028234663852886E38);
            float maxEx = DHistogram.find_maxEx(maxIn, v.isInt() ? 1 : 0);
            long vlen = v.length();
            DHistogram dHistogram = v.naCnt() == vlen || v.min() == v.max() ? null : (hs[c] = DHistogram.make(fr._names[c], nbins, nbins_cats, (byte)(v.isCategorical() ? 2 : (v.isInt() ? 1 : 0)), minIn, maxEx));
            assert (hs[c] == null || vlen > 0L);
        }
        return hs;
    }

    public static DHistogram make(String name, int nbins, int nbins_cats, byte isInt, float min, float maxEx) {
        return new DHistogram(name, nbins, nbins_cats, isInt, min, maxEx);
    }

    private boolean isConstantResponse() {
        double m = Double.NaN;
        for (int b = 0; b < this._bins.length; ++b) {
            if (this._bins[b] == 0.0) continue;
            if (this.var(b) > 1.0E-6) {
                Log.warn((Object[])new Object[]{"Response should be constant, but variance of bin " + b + " (out of " + this._bins.length + ") is " + this.var(b)});
                return false;
            }
            double mean = this.mean(b);
            if (mean == m) continue;
            if (Double.isNaN(m)) {
                m = mean;
                continue;
            }
            if (MathUtils.compare((double)m, (double)mean, (double)1.0E-5, (double)1.0E-5)) continue;
            Log.warn((Object[])new Object[]{"Response should be constant, but mean of first non-empty bin is " + m + ", but another bin (" + b + ") has mean(b) = " + mean});
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name).append(":").append(this._min).append("-").append(this._maxEx).append(" step=" + 1.0f / this._step + " nbins=" + this.nbins() + " isInt=" + this._isInt);
        if (this._bins != null) {
            for (int b = 0; b < this._bins.length; ++b) {
                sb.append(String.format("\ncnt=%d, [%f - %f], mean/var=", this._bins[b], Float.valueOf(this._min + (float)b / this._step), Float.valueOf(this._min + (float)(b + 1) / this._step)));
                sb.append(String.format("%6.2f/%6.2f,", this.mean(b), this.var(b)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    double mean(int b) {
        double n = this._bins[b];
        return n > 0.0 ? this._sums[b] / n : 0.0;
    }

    double var(int b) {
        double n = this._bins[b];
        if (n <= 1.0) {
            return 0.0;
        }
        return Math.max(0.0, (this._ssqs[b] - this._sums[b] * this._sums[b] / n) / (n - 1.0));
    }

    void init0() {
        this._sums = MemoryManager.malloc8d((int)this._nbin);
        this._ssqs = MemoryManager.malloc8d((int)this._nbin);
    }

    void incr0(int b, double y, double w) {
        AtomicUtils.DoubleArray.add((double[])this._sums, (int)b, (double)((float)(w * y)));
        AtomicUtils.DoubleArray.add((double[])this._ssqs, (int)b, (double)((float)(w * y * y)));
    }

    void incr1(int b, double y, double yy) {
        AtomicUtils.DoubleArray.add((double[])this._sums, (int)b, (double)((float)y));
        AtomicUtils.DoubleArray.add((double[])this._ssqs, (int)b, (double)((float)yy));
    }

    void add0(DHistogram dsh) {
        ArrayUtils.add((double[])this._sums, (double[])dsh._sums);
        ArrayUtils.add((double[])this._ssqs, (double[])dsh._ssqs);
    }

    public DTree.Split scoreMSE(int col, double min_rows) {
        double p1;
        int b;
        int nbins = this.nbins();
        assert (nbins > 1);
        double[] sums = this._sums;
        double[] ssqs = this._ssqs;
        double[] bins = this._bins;
        int[] idxs = null;
        if (this._isInt == 2 && this._step == 1.0f && nbins >= 4) {
            int i;
            idxs = MemoryManager.malloc4((int)(nbins + 1));
            for (int i2 = 0; i2 < nbins + 1; ++i2) {
                idxs[i2] = i2;
            }
            double[] avgs = MemoryManager.malloc8d((int)(nbins + 1));
            for (i = 0; i < nbins; ++i) {
                avgs[i] = this._bins[i] == 0.0 ? 0.0 : this._sums[i] / this._bins[i];
            }
            avgs[nbins] = Double.MAX_VALUE;
            ArrayUtils.sort((int[])idxs, (double[])avgs);
            sums = MemoryManager.malloc8d((int)nbins);
            ssqs = MemoryManager.malloc8d((int)nbins);
            bins = MemoryManager.malloc8d((int)nbins);
            for (i = 0; i < nbins; ++i) {
                sums[i] = this._sums[idxs[i]];
                ssqs[i] = this._ssqs[idxs[i]];
                bins[i] = this._bins[idxs[i]];
            }
        }
        double[] sums0 = MemoryManager.malloc8d((int)(nbins + 1));
        double[] ssqs0 = MemoryManager.malloc8d((int)(nbins + 1));
        double[] ns0 = MemoryManager.malloc8d((int)(nbins + 1));
        for (int b2 = 1; b2 <= nbins; ++b2) {
            double m0 = sums0[b2 - 1];
            double m1 = sums[b2 - 1];
            double s0 = ssqs0[b2 - 1];
            double s1 = ssqs[b2 - 1];
            double k0 = ns0[b2 - 1];
            double k1 = bins[b2 - 1];
            if (k0 == 0.0 && k1 == 0.0) continue;
            sums0[b2] = m0 + m1;
            ssqs0[b2] = s0 + s1;
            ns0[b2] = k0 + k1;
        }
        double tot = ns0[nbins];
        if (tot < 2.0 * min_rows) {
            return null;
        }
        double var = ssqs0[nbins] * tot - sums0[nbins] * sums0[nbins];
        if (var == 0.0) {
            assert (this.isConstantResponse());
            return null;
        }
        if ((float)var == 0.0f) {
            return null;
        }
        double[] sums1 = MemoryManager.malloc8d((int)(nbins + 1));
        double[] ssqs1 = MemoryManager.malloc8d((int)(nbins + 1));
        double[] ns1 = MemoryManager.malloc8d((int)(nbins + 1));
        for (int b3 = nbins - 1; b3 >= 0; --b3) {
            double m0 = sums1[b3 + 1];
            double m1 = sums[b3];
            double s0 = ssqs1[b3 + 1];
            double s1 = ssqs[b3];
            double k0 = ns1[b3 + 1];
            double k1 = bins[b3];
            if (k0 == 0.0 && k1 == 0.0) continue;
            sums1[b3] = m0 + m1;
            ssqs1[b3] = s0 + s1;
            ns1[b3] = k0 + k1;
            assert (MathUtils.compare((double)(ns0[b3] + ns1[b3]), (double)tot, (double)1.0E-5, (double)1.0E-5));
        }
        int best = 0;
        double best_se0 = Double.MAX_VALUE;
        double best_se1 = Double.MAX_VALUE;
        byte equal = 0;
        for (b = 1; b <= nbins - 1; ++b) {
            if (bins[b] == 0.0 || ns0[b] < min_rows) continue;
            if (ns1[b] < min_rows) break;
            double se0 = ssqs0[b] - sums0[b] * sums0[b] / ns0[b];
            double se1 = ssqs1[b] - sums1[b] * sums1[b] / ns1[b];
            if (se0 < 0.0) {
                se0 = 0.0;
            }
            if (se1 < 0.0) {
                se1 = 0.0;
            }
            if (!(se0 + se1 < best_se0 + best_se1) && (se0 + se1 != best_se0 + best_se1 || Math.abs(b - (nbins >> 1)) >= Math.abs(best - (nbins >> 1)))) continue;
            best_se0 = se0;
            best_se1 = se1;
            best = b;
        }
        if (this._isInt > 0 && this._step == 1.0f && this._maxEx - this._min > 2.0f && idxs == null) {
            for (b = 1; b <= nbins - 1; ++b) {
                double N;
                if (bins[b] < min_rows || (N = ns0[b] + ns1[b + 1]) < min_rows) continue;
                double sums2 = sums0[b] + sums1[b + 1];
                double ssqs2 = ssqs0[b] + ssqs1[b + 1];
                double si = ssqs2 - sums2 * sums2 / N;
                double sx = ssqs[b] - sums[b] * sums[b] / bins[b];
                if (si < 0.0) {
                    si = 0.0;
                }
                if (sx < 0.0) {
                    sx = 0.0;
                }
                if (!(si + sx < best_se0 + best_se1)) continue;
                best_se0 = si;
                best_se1 = sx;
                best = b;
                equal = 1;
            }
        }
        IcedBitSet bs = null;
        if (idxs != null) {
            int i;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (i = best; i < nbins; ++i) {
                min = Math.min(min, idxs[i]);
                max = Math.max(max, idxs[i]);
            }
            bs = new IcedBitSet(max - min + 1, min);
            for (i = best; i < nbins; ++i) {
                bs.set(idxs[i]);
            }
            equal = (byte)(bs.max() <= 32 ? 2 : 3);
        }
        if (best == 0) {
            return null;
        }
        double se = ssqs1[0] - sums1[0] * sums1[0] / ns1[0];
        if (se <= best_se0 + best_se1) {
            return null;
        }
        double n0 = equal != 1 ? ns0[best] : ns0[best] + ns1[best + 1];
        double n1 = equal != 1 ? ns1[best] : bins[best];
        double p0 = equal != 1 ? sums0[best] : sums0[best] + sums1[best + 1];
        double d = p1 = equal != 1 ? sums1[best] : sums[best];
        if (MathUtils.equalsWithinOneSmallUlp((float)((float)(p0 / n0)), (float)((float)(p1 / n1)))) {
            return null;
        }
        return new DTree.Split(col, best, bs, equal, se, best_se0, best_se1, n0, n1, p0 / n0, p1 / n1);
    }

    static {
        try {
            _min2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_min2"));
            _max2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_maxIn"));
        }
        catch (Exception e) {
            throw H2O.fail();
        }
    }
}

