/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import hex.tree.DHistogram;
import hex.tree.SharedTree;
import java.util.Arrays;
import java.util.Random;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.IcedBitSet;
import water.util.Log;
import water.util.MathUtils;

public class DTree
extends Iced {
    final String[] _names;
    final int _ncols;
    final char _nbins;
    final char _nbins_cats;
    final char _nclass;
    public final double _min_rows;
    final long _seed;
    private Node[] _ns;
    public int _len;
    public int _leaves;
    public int _depth;
    public final int _mtrys;
    final long[] _seeds;
    public final transient Random _rand;

    public DTree(Frame fr, int ncols, char nbins, char nbins_cats, char nclass, double min_rows, int mtrys, long seed) {
        this._names = fr.names();
        this._ncols = ncols;
        this._nbins = nbins;
        this._nbins_cats = nbins_cats;
        this._nclass = nclass;
        this._min_rows = min_rows;
        this._ns = new Node[1];
        this._mtrys = mtrys;
        this._seed = seed;
        this._rand = SharedTree.createRNG(seed);
        this._seeds = new long[fr.vecs()[0].nChunks()];
        for (int i = 0; i < this._seeds.length; ++i) {
            this._seeds[i] = this._rand.nextLong();
        }
    }

    public Random rngForChunk(int cidx) {
        long seed = this._seeds[cidx];
        return SharedTree.createRNG(seed);
    }

    public final Node root() {
        return this._ns[0];
    }

    void init_tree() {
        for (int j = 0; j < this._len; ++j) {
            this._ns[j]._tree = this;
        }
    }

    public final Node node(int i) {
        if (i >= this._len) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this._ns[i];
    }

    public final UndecidedNode undecided(int i) {
        return (UndecidedNode)this.node(i);
    }

    public final DecidedNode decided(int i) {
        return (DecidedNode)this.node(i);
    }

    private synchronized int newIdx(Node n) {
        if (this._len == this._ns.length) {
            this._ns = Arrays.copyOf(this._ns, this._len << 1);
        }
        this._ns[this._len] = n;
        return this._len++;
    }

    public final int len() {
        return this._len;
    }

    public static boolean isRootNode(Node n) {
        return n._pid == -1;
    }

    public CompressedTree compress(int tid, int cls) {
        int sz = this.root().size();
        if (this.root() instanceof LeafNode) {
            sz += 3;
        }
        AutoBuffer ab = new AutoBuffer(sz);
        if (this.root() instanceof LeafNode) {
            ab.put1(0).put2('\uffff');
        }
        this.root().compress(ab);
        assert (ab.position() == sz);
        return new CompressedTree(ab.buf(), this._nclass, this._seed, tid, cls);
    }

    public static final class LeafNode
    extends Node {
        public float _pred;

        public LeafNode(DTree tree, int pid) {
            super(tree, pid);
            ++tree._leaves;
        }

        public LeafNode(DTree tree, int pid, int nid) {
            super(tree, pid, nid);
            ++tree._leaves;
        }

        public String toString() {
            return "Leaf#" + this._nid + " = " + this._pred;
        }

        @Override
        public final StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d = 0; d < depth; ++d) {
                sb.append("  ");
            }
            sb.append(this._nid).append(" ");
            return sb.append("pred=").append(this._pred).append("\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab) {
            assert (!Double.isNaN(this._pred));
            return ab.put4f(this._pred);
        }

        @Override
        protected int size() {
            return 4;
        }

        public final double pred() {
            return this._pred;
        }
    }

    public static class DecidedNode
    extends Node {
        public final Split _split;
        public final float _splat;
        public final int[] _nids = new int[2];
        transient byte _nodeType;
        transient int _size = 0;

        public UndecidedNode makeUndecidedNode(DHistogram[] hs) {
            return new UndecidedNode(this._tree, this._nid, hs);
        }

        public Split bestCol(UndecidedNode u, DHistogram[] hs) {
            int i;
            Split best = new Split(-1, -1, null, 0, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0, 0.0, 0.0);
            if (hs == null) {
                return best;
            }
            int maxCols = u._scoreCols == null ? hs.length : u._scoreCols.length;
            FindSplits[] findSplits = new FindSplits[maxCols];
            long nbinsSum = 0L;
            for (int i2 = 0; i2 < maxCols; ++i2) {
                int col;
                int n = col = u._scoreCols == null ? i2 : u._scoreCols[i2];
                if (hs[col] == null || hs[col].nbins() <= 1) continue;
                nbinsSum += (long)hs[col].nbins();
            }
            boolean isSmall = nbinsSum <= 1024L;
            for (i = 0; i < maxCols; ++i) {
                int col;
                int n = col = u._scoreCols == null ? i : u._scoreCols[i];
                if (hs[col] == null || hs[col].nbins() <= 1) continue;
                findSplits[i] = new FindSplits(hs, col);
                if (isSmall) {
                    findSplits[i].compute2();
                    continue;
                }
                H2O.submitTask((H2O.H2OCountedCompleter)findSplits[i]);
            }
            for (i = 0; i < maxCols; ++i) {
                if (findSplits[i] == null) continue;
                findSplits[i].join();
                Split s = findSplits[i]._s;
                if (s == null || !(s.se() < best.se())) continue;
                best = s;
            }
            return best;
        }

        public DecidedNode(UndecidedNode n, DHistogram[] hs) {
            super(n._tree, n._pid, n._nid);
            this._split = this.bestCol(n, hs);
            if (this._split._col == -1) {
                this._splat = Float.NaN;
                Arrays.fill(this._nids, -1);
                return;
            }
            this._splat = this._split._equal == 0 || this._split._equal == 1 ? this._split.splat(hs) : -1.0f;
            char nbins = this._tree._nbins;
            char nbins_cats = this._tree._nbins_cats;
            double min_rows = this._tree._min_rows;
            for (int b = 0; b < 2; ++b) {
                DHistogram[] nhists = this._split.split(b, nbins, nbins_cats, min_rows, hs, this._splat);
                assert (nhists == null || nhists.length == this._tree._ncols);
                this._nids[b] = nhists == null ? -1 : this.makeUndecidedNode((DHistogram[])nhists)._nid;
            }
        }

        public int ns(Chunk[] chks, int row) {
            float d = (float)chks[this._split._col].atd(row);
            int bin = this._split._equal == 0 ? (d >= this._splat ? 1 : 0) : (this._split._equal == 1 ? (d == this._splat ? 1 : 0) : (this._split._bs.contains((int)d) ? 1 : 0));
            return this._nids[bin];
        }

        public double pred(int nid) {
            return nid == 0 ? this._split._p0 : this._split._p1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DecidedNode:\n");
            sb.append("_nid: " + this._nid);
            sb.append("_nids (children): " + Arrays.toString(this._nids));
            sb.append("_split:" + this._split.toString());
            sb.append("_splat:" + this._splat);
            if (this._split._col == -1) {
                sb.append(" col = -1 ");
            } else {
                int col = this._split._col;
                if (this._split._equal == 1) {
                    sb.append(this._tree._names[col] + " != " + this._splat + "\n" + this._tree._names[col] + " == " + this._splat + "\n");
                } else if (this._split._equal == 2 || this._split._equal == 3) {
                    sb.append(this._tree._names[col] + " not in " + this._split._bs.toString() + "\n" + this._tree._names[col] + "  is in " + this._split._bs.toString() + "\n");
                } else {
                    sb.append(this._tree._names[col] + " < " + this._splat + "\n" + this._splat + " >=" + this._tree._names[col] + "\n");
                }
            }
            return sb.toString();
        }

        StringBuilder printChild(StringBuilder sb, int nid) {
            int i;
            int n = i = this._nids[0] == nid ? 0 : 1;
            assert (this._nids[i] == nid) : "No child nid " + nid + "? " + Arrays.toString(this._nids);
            sb.append("[").append(this._tree._names[this._split._col]);
            sb.append(this._split._equal != 0 ? (i == 0 ? " != " : " == ") : (i == 0 ? " <  " : " >= "));
            sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("]");
            return sb;
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            for (int i = 0; i < this._nids.length; ++i) {
                for (int d = 0; d < depth; ++d) {
                    sb.append("  ");
                }
                sb.append(this._nid).append(" ");
                if (this._split._col < 0) {
                    sb.append("init");
                } else {
                    sb.append(this._tree._names[this._split._col]);
                    if (this._split._equal < 2) {
                        sb.append(this._split._equal != 0 ? (i == 0 ? " != " : " == ") : (i == 0 ? " <  " : " >= "));
                    } else {
                        sb.append(i == 0 ? " not in " : "  is in ");
                    }
                    sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("\n");
                }
                if (this._nids[i] < 0 || this._nids[i] >= this._tree._len) continue;
                this._tree.node(this._nids[i]).toString2(sb, depth + 1);
            }
            return sb;
        }

        @Override
        public final int size() {
            if (this._size != 0) {
                return this._size;
            }
            assert (this._nodeType == 0) : "unexpected node type: " + this._nodeType;
            if (this._split._equal != 0) {
                this._nodeType = (byte)(this._nodeType | (this._split._equal == 1 ? 4 : (this._split._equal == 2 ? 8 : 12)));
            }
            int res = this._split._equal == 3 ? 7 + this._split._bs.numBytes() : 7;
            Node left = this._tree.node(this._nids[0]);
            int lsz = left.size();
            res += lsz;
            if (left instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0x30);
            } else {
                int slen = lsz < 256 ? 0 : (lsz < 65535 ? 1 : (lsz < 0x1000000 ? 2 : 3));
                this._nodeType = (byte)(this._nodeType | slen);
                res += slen + 1;
            }
            Node rite = this._tree.node(this._nids[1]);
            if (rite instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0xFFFFFFC0);
            }
            res += rite.size();
            assert ((this._nodeType & 0x33) != 51);
            assert (res != 0);
            this._size = res;
            return this._size;
        }

        @Override
        public AutoBuffer compress(AutoBuffer ab) {
            int pos = ab.position();
            if (this._nodeType == 0) {
                this.size();
            }
            ab.put1((int)this._nodeType);
            assert (this._split._col != -1);
            ab.put2((short)this._split._col);
            if (this._split._equal == 0 || this._split._equal == 1) {
                ab.put4f(this._splat);
            } else if (this._split._equal == 2) {
                this._split._bs.compress2(ab);
            } else {
                this._split._bs.compress3(ab);
            }
            Node left = this._tree.node(this._nids[0]);
            if ((this._nodeType & 0x30) == 0) {
                int sz = left.size();
                if (sz < 256) {
                    ab.put1(sz);
                } else if (sz < 65535) {
                    ab.put2((short)sz);
                } else if (sz < 0x1000000) {
                    ab.put3(sz);
                } else {
                    ab.put4(sz);
                }
            }
            left.compress(ab);
            Node rite = this._tree.node(this._nids[1]);
            rite.compress(ab);
            assert (this._size == ab.position() - pos) : "reported size = " + this._size + " , real size = " + (ab.position() - pos);
            return ab;
        }

        class FindSplits
        extends H2O.H2OCountedCompleter<FindSplits> {
            final DHistogram[] _hs;
            final int _col;
            Split _s;

            FindSplits(DHistogram[] hs, int col) {
                this._hs = hs;
                this._col = col;
            }

            protected void compute2() {
                this._s = this._hs[this._col].scoreMSE(this._col, DecidedNode.this._tree._min_rows);
                this.tryComplete();
            }
        }
    }

    public static class UndecidedNode
    extends Node {
        public transient DHistogram[] _hs;
        public final int[] _scoreCols;

        public UndecidedNode(DTree tree, int pid, DHistogram[] hs) {
            super(tree, pid);
            assert (hs.length == tree._ncols);
            this._hs = hs;
            this._scoreCols = this.scoreCols();
        }

        public int[] scoreCols() {
            DTree tree = this._tree;
            if (tree._mtrys == this._hs.length) {
                return null;
            }
            int[] cols = new int[this._hs.length];
            int len = 0;
            for (int i = 0; i < this._hs.length; ++i) {
                if (this._hs[i] == null) continue;
                assert (this._hs[i]._min < this._hs[i]._maxEx && this._hs[i].nbins() > 1) : "broken histo range " + (Object)((Object)this._hs[i]);
                cols[len++] = i;
            }
            int choices = len;
            assert (choices > 0);
            for (int i = 0; i < tree._mtrys && len != 0; ++i) {
                int idx2 = tree._rand.nextInt(len);
                int col = cols[idx2];
                cols[idx2] = cols[--len];
                cols[len] = col;
            }
            assert (choices - len > 0);
            return Arrays.copyOfRange(cols, len, choices);
        }

        public void do_not_split() {
            if (this._pid == -1) {
                return;
            }
            DecidedNode dn = this._tree.decided(this._pid);
            for (int i = 0; i < dn._nids.length; ++i) {
                if (dn._nids[i] != this._nid) continue;
                dn._nids[i] = -1;
                return;
            }
            throw H2O.fail();
        }

        public String toString() {
            String colPad = "  ";
            int cntW = 4;
            int mmmW = 4;
            int menW = 5;
            int varW = 5;
            int colW = 26;
            StringBuilder sb = new StringBuilder();
            sb.append("Nid# ").append(this._nid).append(", ");
            this.printLine(sb).append("\n");
            if (this._hs == null) {
                return sb.append("_hs==null").toString();
            }
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, hs._name + String.format(", %4.1f-%4.1f", Float.valueOf(hs._min), Float.valueOf(hs._maxEx)), 26).append("  ");
            }
            sb.append('\n');
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, "cnt", 4).append('/');
                UndecidedNode.p(sb, "min", 4).append('/');
                UndecidedNode.p(sb, "max", 4).append('/');
                UndecidedNode.p(sb, "mean", 5).append('/');
                UndecidedNode.p(sb, "var", 5).append("  ");
            }
            sb.append('\n');
            int nbins = 0;
            for (DHistogram hs : this._hs) {
                if (hs == null || hs.nbins() <= nbins) continue;
                nbins = hs.nbins();
            }
            for (int i = 0; i < nbins; ++i) {
                for (DHistogram h : this._hs) {
                    if (h == null) continue;
                    if (i < h.nbins() && h._bins != null) {
                        UndecidedNode.p(sb, h.bins(i), 4).append('/');
                        UndecidedNode.p(sb, h.binAt(i), 4).append('/');
                        UndecidedNode.p(sb, h.binAt(i + 1), 4).append('/');
                        UndecidedNode.p(sb, h.mean(i), 5).append('/');
                        UndecidedNode.p(sb, h.var(i), 5).append("  ");
                        continue;
                    }
                    UndecidedNode.p(sb, "", 26).append("  ");
                }
                sb.append('\n');
            }
            sb.append("Nid# ").append(this._nid);
            return sb.toString();
        }

        private static StringBuilder p(StringBuilder sb, String s, int w) {
            return sb.append(Log.fixedLength((String)s, (int)w));
        }

        private static StringBuilder p(StringBuilder sb, long l, int w) {
            return UndecidedNode.p(sb, Long.toString(l), w);
        }

        private static StringBuilder p(StringBuilder sb, double d, int w) {
            String s;
            String string = Double.isNaN(d) ? "NaN" : (d == 3.4028234663852886E38 || d == -3.4028234663852886E38 || d == Double.MAX_VALUE || d == -1.7976931348623157E308 ? " -" : (s = d == 0.0 ? " 0" : Double.toString(d)));
            if (s.length() <= w) {
                return UndecidedNode.p(sb, s, w);
            }
            s = String.format("% 4.2f", d);
            if (s.length() > w) {
                s = String.format("%4.1f", d);
            }
            if (s.length() > w) {
                s = String.format("%4.0f", d);
            }
            return UndecidedNode.p(sb, s, w);
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d = 0; d < depth; ++d) {
                sb.append("  ");
            }
            return sb.append("Undecided\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab) {
            throw H2O.fail();
        }

        @Override
        protected int size() {
            throw H2O.fail();
        }
    }

    public static class Split
    extends Iced {
        public final int _col;
        public final int _bin;
        final IcedBitSet _bs;
        final byte _equal;
        final double _se;
        final double _se0;
        final double _se1;
        final double _n0;
        final double _n1;
        final double _p0;
        final double _p1;

        public Split(int col, int bin, IcedBitSet bs, byte equal, double se, double se0, double se1, double n0, double n1, double p0, double p1) {
            this._col = col;
            this._bin = bin;
            this._bs = bs;
            this._equal = equal;
            this._se = se;
            this._n0 = n0;
            this._n1 = n1;
            this._se0 = se0;
            this._se1 = se1;
            this._p0 = p0;
            this._p1 = p1;
            assert (se > se0 + se1 || se == Double.MAX_VALUE);
        }

        public final double pre_split_se() {
            return this._se;
        }

        public final double se() {
            return this._se0 + this._se1;
        }

        public final int col() {
            return this._col;
        }

        public final int bin() {
            return this._bin;
        }

        float splat(DHistogram[] hs) {
            int n;
            int x;
            DHistogram h = hs[this._col];
            assert (this._bin > 0 && this._bin < h.nbins());
            assert (this._bs == null) : "Dividing point is a bitset, not a bin#, so dont call splat() as result is meaningless";
            if (this._equal == 1) {
                assert (h.bins(this._bin) != 0.0);
                return h.binAt(this._bin);
            }
            assert (this._equal == 0);
            for (x = this._bin - 1; x >= 0 && h.bins(x) == 0.0; --x) {
            }
            for (n = this._bin; n < h.nbins() && h.bins(n) == 0.0; ++n) {
            }
            float lo = h.binAt(x + 1);
            float hi = h.binAt(n);
            if (h._isInt > 0) {
                float f = lo = h._step == 1.0f ? lo - 1.0f : (float)Math.floor(lo);
            }
            if (h._isInt > 0) {
                hi = h._step == 1.0f ? hi : (float)Math.ceil(hi);
            }
            return (lo + hi) / 2.0f;
        }

        public DHistogram[] split(int way, char nbins, char nbins_cats, double min_rows, DHistogram[] hs, float splat) {
            double se;
            double n;
            double d = n = way == 0 ? this._n0 : this._n1;
            if (n < min_rows || n <= 1.0) {
                return null;
            }
            double d2 = se = way == 0 ? this._se0 : this._se1;
            if (se <= 1.0E-30) {
                return null;
            }
            int cnt = 0;
            DHistogram[] nhists = new DHistogram[hs.length];
            block5: for (int j = 0; j < hs.length; ++j) {
                float maxEx;
                float min;
                DHistogram h = hs[j];
                if (h == null) continue;
                int adj_nbins = Math.max(h.nbins() >> 1, nbins);
                if (h._bins == null) {
                    min = h._min;
                    maxEx = h._maxEx;
                } else {
                    min = h.find_min();
                    if (h.find_maxIn() == min) continue;
                    maxEx = h.find_maxEx();
                }
                if (this._col == j) {
                    switch (this._equal) {
                        case 0: {
                            if (h._bins[this._bin] == 0.0) {
                                throw H2O.unimpl();
                            }
                            assert (this._bs == null) : "splat not defined for BitSet splits";
                            float split = splat;
                            if (h._isInt > 0) {
                                split = (float)Math.ceil(split);
                            }
                            if (way == 0) {
                                maxEx = split;
                                break;
                            }
                            min = split;
                            break;
                        }
                        case 1: {
                            if (way != 1) break;
                            continue block5;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                        default: {
                            throw H2O.fail();
                        }
                    }
                }
                if (min > maxEx || MathUtils.equalsWithinOneSmallUlp((float)min, (float)maxEx) || Float.isInfinite((float)adj_nbins / (maxEx - min)) || h._isInt > 0 && !(min + 1.0f < maxEx)) continue;
                assert (min < maxEx && adj_nbins > 1) : "" + min + "<" + maxEx + " nbins=" + adj_nbins;
                nhists[j] = DHistogram.make(h._name, adj_nbins, nbins_cats, h._isInt, min, maxEx);
                ++cnt;
            }
            return cnt == 0 ? null : nhists;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(this._col).append("/");
            UndecidedNode.p(sb, this._bin, 2);
            sb.append(", se0=").append(this._se0);
            sb.append(", se1=").append(this._se1);
            sb.append(", n0=").append(this._n0);
            sb.append(", n1=").append(this._n1);
            return sb.append("}").toString();
        }
    }

    public static abstract class Node
    extends Iced {
        protected transient DTree _tree;
        public final int _pid;
        protected final int _nid;

        Node(DTree tree, int pid, int nid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = nid;
            ((DTree)tree)._ns[this._nid] = this;
        }

        Node(DTree tree, int pid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = tree.newIdx(this);
        }

        StringBuilder printLine(StringBuilder sb) {
            if (this._pid == -1) {
                return sb.append("[root]");
            }
            DecidedNode parent = this._tree.decided(this._pid);
            parent.printLine(sb).append(" to ");
            return parent.printChild(sb, this._nid);
        }

        public abstract StringBuilder toString2(StringBuilder var1, int var2);

        protected abstract AutoBuffer compress(AutoBuffer var1);

        protected abstract int size();

        public final int nid() {
            return this._nid;
        }

        public final int pid() {
            return this._pid;
        }
    }
}

