/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.Distribution;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.schemas.GBMV3;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.Sample;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTree;
import hex.tree.gbm.GBMModel;
import java.util.Arrays;
import java.util.Random;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;

public class GBM
extends SharedTree<GBMModel, GBMModel.GBMParameters, GBMModel.GBMOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public GBM(GBMModel.GBMParameters parms) {
        super("GBM", parms);
        this.init(false);
    }

    public GBMV3 schema() {
        return new GBMV3();
    }

    protected Job<GBMModel> trainModelImpl(long work, boolean restartTimer) {
        return this.start(new GBMDriver(), work, restartTimer);
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            if (this.error_count() > 0) {
                this.updateValidationMessages();
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            if (((GBMModel.GBMParameters)this._parms)._distribution == Distribution.Family.AUTO) {
                if (this._nclass == 1) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = Distribution.Family.gaussian;
                }
                if (this._nclass == 2) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = Distribution.Family.bernoulli;
                }
                if (this._nclass >= 3) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = Distribution.Family.multinomial;
                }
            }
            this.checkDistributions();
            if (this.hasOffsetCol() && this.isClassifier() && ((GBMModel.GBMParameters)this._parms)._distribution == Distribution.Family.multinomial) {
                this.error("_offset_column", "Offset is not supported for multinomial distribution.");
            }
            if (this.hasOffsetCol() && ((GBMModel.GBMParameters)this._parms)._distribution == Distribution.Family.bernoulli && this._offset.max() > 1.0) {
                this.error("_offset_column", "Offset cannot be larger than 1 for Bernoulli distribution.");
            }
        }
        switch (((GBMModel.GBMParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Multinomial requires an categorical response."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote((int)2, (String)"Gaussian requires the response to be numeric."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + ((GBMModel.GBMParameters)this._parms)._distribution);
            }
        }
        if (!(0.0 < (double)((GBMModel.GBMParameters)this._parms)._learn_rate) || !((double)((GBMModel.GBMParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < (double)((GBMModel.GBMParameters)this._parms)._col_sample_rate) || !((double)((GBMModel.GBMParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
    }

    @Override
    protected double score1(Chunk[] chks, double weight, double offset, double[] fs, int row) {
        double f = this.chk_tree(chks, 0).atd(row) + offset;
        double p = new Distribution(((GBMModel.GBMParameters)this._parms)._distribution, ((GBMModel.GBMParameters)this._parms)._tweedie_power).linkInv(f);
        if (((GBMModel.GBMParameters)this._parms)._distribution == Distribution.Family.bernoulli) {
            fs[2] = p;
            fs[1] = 1.0 - p;
            return 1.0;
        }
        if (((GBMModel.GBMParameters)this._parms)._distribution == Distribution.Family.multinomial) {
            if (this._nclass == 2) {
                fs[1] = p;
                fs[2] = 1.0 / p;
                return fs[1] + fs[2];
            }
            for (int k = 0; k < this._nclass; ++k) {
                fs[k + 1] = this.chk_tree(chks, k).atd(row);
            }
            return GenModel.log_rescale((double[])fs);
        }
        fs[0] = p;
        return fs[0];
    }

    private class GBMDriver
    extends SharedTree.Driver {
        private static final double MIN_LOG_TRUNC = -19.0;
        private static final double MAX_LOG_TRUNC = 19.0;

        private GBMDriver() {
        }

        @Override
        protected boolean doOOBScoring() {
            return false;
        }

        @Override
        protected void initializeModelSpecifics() {
            GBM.this._mtry = Math.max(1, (int)(((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate * (float)GBM.this._ncols));
            if (1 > GBM.this._mtry || GBM.this._mtry > GBM.this._ncols) {
                throw new IllegalArgumentException("Computed mtry should be in interval <1," + GBM.this._ncols + "> but it is " + GBM.this._mtry);
            }
            GBM.this._initialPrediction = GBM.this._nclass > 2 ? 0.0 : GBM.this.getInitialValue();
            if (GBM.this.hasOffsetCol() && ((GBMModel.GBMParameters)GBM.this._parms)._distribution == Distribution.Family.bernoulli) {
                GBM.this._initialPrediction = this.getInitialValueBernoulliOffset(GBM.this._train);
            }
            ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._init_f = GBM.this._initialPrediction;
            if (GBM.this._initialPrediction != 0.0) {
                final double init = GBM.this._initialPrediction;
                new MRTask(){

                    public void map(Chunk tree) {
                        for (int i = 0; i < tree._len; ++i) {
                            tree.set(i, init);
                        }
                    }
                }.doAll(GBM.this.vec_tree(GBM.this._train, 0), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            }
        }

        private double getInitialValueBernoulliOffset(Frame train) {
            double delta;
            Log.info((Object[])new Object[]{"Running Newton-Raphson iteration to find the initial value since offsets are specified."});
            int count = 0;
            double tol = 1.0E-4;
            int N = 1;
            double init = 0.0;
            do {
                double newInit = ((NewtonRaphson)new NewtonRaphson(init).doAll(train)).value();
                delta = Math.abs(init - newInit);
                init = newInit;
                Log.info((Object[])new Object[]{"Iteration " + ++count + ": initial value: " + init});
            } while (count < N && delta >= tol);
            if (delta > tol) {
                Log.warn((Object[])new Object[]{"Not fully converged."});
            }
            Log.info((Object[])new Object[]{"Newton-Raphson iteration ran for " + count + " iteration(s). Final residual: " + delta});
            return init;
        }

        private void truncatePreds(DTree[] ktrees, int[] leafs, Distribution.Family dist, ComputeMinMax minMax) {
            assert (GBM.this._nclass == 1);
            DTree tree = ktrees[0];
            assert (tree != null);
            for (int i = 0; i < tree._len - leafs[0]; ++i) {
                DTree.LeafNode node = (DTree.LeafNode)tree.node(leafs[0] + i);
                int nidx = node.nid();
                float nodeMin = minMax._mins[nidx - leafs[0]];
                float nodeMax = minMax._maxs[nidx - leafs[0]];
                double val = node._pred;
                if (dist == Distribution.Family.gamma || dist == Distribution.Family.tweedie) {
                    val += (double)nodeMax;
                }
                if (val > 19.0) {
                    node._pred = (float)(19.0 - (double)nodeMax);
                }
                val = node._pred;
                if (dist == Distribution.Family.gamma || dist == Distribution.Family.tweedie) {
                    val += (double)nodeMin;
                }
                if (val < -19.0) {
                    node._pred = (float)(-19.0 - (double)nodeMin);
                }
                if (!((double)node._pred < -19.0) || !((double)node._pred > 19.0)) continue;
                Log.warn((Object[])new Object[]{"Terminal node prediction outside of allowed interval in log-space: " + node._pred + " (should be in " + -19.0 + "..." + 19.0 + ")."});
            }
        }

        @Override
        protected void buildNextKTrees() {
            DTree[] ktrees = new DTree[GBM.this._nclass];
            int[] leafs = new int[GBM.this._nclass];
            new ComputePredAndRes().doAll(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            this.growTrees(ktrees, leafs, GBM.this._rand);
            this.fitBestConstants(ktrees, leafs, (GammaPass)new GammaPass(ktrees, leafs, ((GBMModel.GBMParameters)GBM.this._parms)._distribution).doAll(GBM.this._train));
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == Distribution.Family.gamma || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == Distribution.Family.poisson || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == Distribution.Family.tweedie) {
                this.truncatePreds(ktrees, leafs, ((GBMModel.GBMParameters)GBM.this._parms)._distribution, (ComputeMinMax)new ComputeMinMax(leafs[0], ktrees[0].len()).doAll(GBM.this._train));
            }
            new AddTreeContributions(ktrees).doAll(GBM.this._train);
            ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output).addKTrees(ktrees);
        }

        private void growTrees(DTree[] ktrees, int[] leafs, Random rand) {
            int k;
            DHistogram[][][] hcs = new DHistogram[GBM.this._nclass][1][GBM.this._ncols];
            int adj_nbins = Math.max(((GBMModel.GBMParameters)GBM.this._parms)._nbins_top_level, ((GBMModel.GBMParameters)GBM.this._parms)._nbins);
            long rseed = rand.nextLong();
            for (int k2 = 0; k2 < GBM.this._nclass; ++k2) {
                if (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution[k2] == 0.0 || k2 == 1 && GBM.this._nclass == 2) continue;
                ktrees[k2] = new DTree(GBM.this._train, GBM.this._ncols, (char)((GBMModel.GBMParameters)GBM.this._parms)._nbins, (char)((GBMModel.GBMParameters)GBM.this._parms)._nbins_cats, (char)GBM.this._nclass, ((GBMModel.GBMParameters)GBM.this._parms)._min_rows, GBM.this._mtry, rseed);
                new DTree.UndecidedNode(ktrees[k2], -1, DHistogram.initialHist(GBM.this._train, GBM.this._ncols, adj_nbins, ((GBMModel.GBMParameters)GBM.this._parms)._nbins_cats, hcs[k2][0]));
            }
            if (((GBMModel.GBMParameters)GBM.this._parms)._sample_rate < 1.0f) {
                Sample[] ss = new Sample[GBM.this._nclass];
                for (k = 0; k < GBM.this._nclass; ++k) {
                    if (ktrees[k] == null) continue;
                    ss[k] = (Sample)new Sample(ktrees[k], ((GBMModel.GBMParameters)GBM.this._parms)._sample_rate).dfork(null, new Frame(new Vec[]{GBM.this.vec_nids(GBM.this._train, k), GBM.this.vec_resp(GBM.this._train)}), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
                }
                for (k = 0; k < GBM.this._nclass; ++k) {
                    if (ss[k] == null) continue;
                    ss[k].getResult();
                }
            }
            for (int depth = 0; depth < ((GBMModel.GBMParameters)GBM.this._parms)._max_depth; ++depth) {
                if (!GBM.this.isRunning()) {
                    return;
                }
                hcs = GBM.this.buildLayer(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._nbins, ((GBMModel.GBMParameters)GBM.this._parms)._nbins_cats, ktrees, leafs, hcs, GBM.this._mtry < ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output).nfeatures(), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
                if (hcs == null) break;
            }
            for (k = 0; k < GBM.this._nclass; ++k) {
                DTree tree = ktrees[k];
                if (tree == null) continue;
                int leaf = leafs[k] = tree.len();
                for (int nid = 0; nid < leaf; ++nid) {
                    if (!(tree.node(nid) instanceof DTree.DecidedNode)) continue;
                    DTree.DecidedNode dn = tree.decided(nid);
                    if (dn._split._col == -1) {
                        if (nid != 0) continue;
                        new DTree.LeafNode(tree, -1, 0);
                        continue;
                    }
                    for (int i = 0; i < dn._nids.length; ++i) {
                        int cnid = dn._nids[i];
                        if (cnid != -1 && !(tree.node(cnid) instanceof DTree.UndecidedNode) && (!(tree.node(cnid) instanceof DTree.DecidedNode) || ((DTree.DecidedNode)tree.node((int)cnid))._split.col() != -1)) continue;
                        dn._nids[i] = new DTree.LeafNode(tree, nid).nid();
                    }
                }
            }
        }

        private void fitBestConstants(DTree[] ktrees, int[] leafs, GammaPass gp) {
            double m1class = GBM.this._nclass > 1 && ((GBMModel.GBMParameters)GBM.this._parms)._distribution != Distribution.Family.bernoulli ? (double)(GBM.this._nclass - 1) / (double)GBM.this._nclass : 1.0;
            for (int k = 0; k < GBM.this._nclass; ++k) {
                DTree tree = ktrees[k];
                if (tree == null) continue;
                for (int i = 0; i < tree._len - leafs[k]; ++i) {
                    float gf = (float)((double)((GBMModel.GBMParameters)GBM.this._parms)._learn_rate * m1class * gp.gamma(k, i));
                    if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == Distribution.Family.multinomial) {
                        if ((double)gf > 10000.0) {
                            gf = 10000.0f;
                        } else if ((double)gf < -10000.0) {
                            gf = -10000.0f;
                        }
                    }
                    assert (!Float.isNaN(gf) && !Float.isInfinite(gf));
                    ((DTree.LeafNode)tree.node((int)(leafs[k] + i)))._pred = gf;
                }
            }
        }

        protected GBMModel makeModel(Key modelKey, GBMModel.GBMParameters parms, double mse_train, double mse_valid) {
            return new GBMModel(modelKey, parms, new GBMModel.GBMOutput(GBM.this, mse_train, mse_valid));
        }

        private class AddTreeContributions
        extends MRTask<AddTreeContributions> {
            DTree[] _ktrees;

            AddTreeContributions(DTree[] ktrees) {
                this._ktrees = ktrees;
            }

            public void map(Chunk[] chks) {
                for (int k = 0; k < GBM.this._nclass; ++k) {
                    DTree tree = this._ktrees[k];
                    if (tree == null) continue;
                    Chunk nids = GBM.this.chk_nids(chks, k);
                    Chunk ct = GBM.this.chk_tree(chks, k);
                    for (int row = 0; row < nids._len; ++row) {
                        int nid = (int)nids.at8(row);
                        if (nid < 0) continue;
                        ct.set(row, (float)(ct.atd(row) + (double)((DTree.LeafNode)tree.node((int)nid))._pred));
                        nids.set(row, 0L);
                    }
                }
            }
        }

        private class GammaPass
        extends MRTask<GammaPass> {
            final DTree[] _trees;
            final int[] _leafs;
            final Distribution.Family _dist;
            private double[][] _num;
            private double[][] _denom;

            double gamma(int tree, int nid) {
                if (this._denom[tree][nid] == 0.0) {
                    return 0.0;
                }
                double g = this._num[tree][nid] / this._denom[tree][nid];
                assert (!Double.isInfinite(g)) : "numeric overflow";
                assert (!Double.isNaN(g)) : "numeric overflow";
                if (this._dist == Distribution.Family.poisson || this._dist == Distribution.Family.gamma || this._dist == Distribution.Family.tweedie) {
                    return new Distribution(this._dist, ((GBMModel.GBMParameters)GBM.this._parms)._tweedie_power).link(g);
                }
                return g;
            }

            GammaPass(DTree[] trees, int[] leafs, Distribution.Family distribution) {
                this._leafs = leafs;
                this._trees = trees;
                this._dist = distribution;
            }

            public void map(Chunk[] chks) {
                this._denom = new double[GBM.this._nclass][];
                this._num = new double[GBM.this._nclass][];
                Chunk resp = GBM.this.chk_resp(chks);
                for (int k = 0; k < GBM.this._nclass; ++k) {
                    DTree tree = this._trees[k];
                    int leaf = this._leafs[k];
                    if (tree == null) continue;
                    this._denom[k] = new double[tree._len - leaf];
                    double[] denom = this._denom[k];
                    this._num[k] = new double[tree._len - leaf];
                    double[] num = this._num[k];
                    Chunk nids = GBM.this.chk_nids(chks, k);
                    Chunk ress = GBM.this.chk_work(chks, k);
                    C0DChunk offset = GBM.this.hasOffsetCol() ? GBM.this.chk_offset(chks) : new C0DChunk(0.0, chks[0]._len);
                    Chunk preds = GBM.this.chk_tree(chks, k);
                    if (tree.root() instanceof DTree.LeafNode) continue;
                    Distribution dist = new Distribution(((GBMModel.GBMParameters)GBM.this._parms)._distribution, ((GBMModel.GBMParameters)GBM.this._parms)._tweedie_power);
                    for (int row = 0; row < nids._len; ++row) {
                        int idx;
                        int nid = (int)nids.at8(row);
                        boolean wasOOBRow = ScoreBuildHistogram.isOOBRow((int)GBM.this.chk_nids(chks, k).at8(row));
                        if (wasOOBRow) {
                            nid = ScoreBuildHistogram.oob2Nid(nid);
                        }
                        if (nid < 0) continue;
                        if (tree.node(nid) instanceof DTree.UndecidedNode) {
                            nid = tree.node(nid).pid();
                        }
                        DTree.DecidedNode dn = tree.decided(nid);
                        if (dn._split._col == -1) {
                            dn = tree.decided(dn.pid());
                        }
                        int leafnid = dn.ns(chks, row);
                        assert (leaf <= leafnid && leafnid < tree._len) : "leaf: " + leaf + " leafnid: " + leafnid + " tree._len: " + tree._len + "\ndn: " + (Object)((Object)dn);
                        assert (tree.node(leafnid) instanceof DTree.LeafNode);
                        nids.set(row, (long)leafnid);
                        assert (!ress.isNA(row));
                        if (wasOOBRow) continue;
                        double w = GBM.this.hasWeightCol() ? GBM.this.chk_weight(chks).atd(row) : 1.0;
                        double y = resp.atd(row);
                        double z = ress.atd(row);
                        double f = preds.atd(row) + offset.atd(row);
                        int n = idx = leafnid - leaf;
                        num[n] = num[n] + dist.gammaNum(w, y, z, f);
                        int n2 = idx;
                        denom[n2] = denom[n2] + dist.gammaDenom(w, y, z, f);
                    }
                }
            }

            public void reduce(GammaPass gp) {
                ArrayUtils.add((double[][])this._denom, (double[][])gp._denom);
                ArrayUtils.add((double[][])this._num, (double[][])gp._num);
            }
        }

        class ComputeMinMax
        extends MRTask<ComputeMinMax> {
            int _start;
            int _end;
            float[] _mins;
            float[] _maxs;

            public ComputeMinMax(int start, int end) {
                this._start = start;
                this._end = end;
            }

            public void map(Chunk[] chks) {
                int _len = this._end - this._start;
                this._mins = new float[_len];
                this._maxs = new float[_len];
                Arrays.fill(this._mins, Float.MAX_VALUE);
                Arrays.fill(this._maxs, -3.4028235E38f);
                Chunk ys = GBM.this.chk_resp(chks);
                C0DChunk offset = GBM.this.hasOffsetCol() ? GBM.this.chk_offset(chks) : new C0DChunk(0.0, chks[0]._len);
                Chunk preds = GBM.this.chk_tree(chks, 0);
                Chunk nids = GBM.this.chk_nids(chks, 0);
                for (int row = 0; row < preds._len; ++row) {
                    if (ys.isNA(row)) continue;
                    float f = (float)(preds.atd(row) + offset.atd(row));
                    int nidx = (int)nids.at8(row);
                    this._mins[nidx - this._start] = Math.min(this._mins[nidx - this._start], f);
                    this._maxs[nidx - this._start] = Math.max(this._maxs[nidx - this._start], f);
                }
            }

            public void reduce(ComputeMinMax mrt) {
                ArrayUtils.reduceMin((float[])this._mins, (float[])mrt._mins);
                ArrayUtils.reduceMax((float[])this._maxs, (float[])mrt._maxs);
            }
        }

        class ComputePredAndRes
        extends MRTask<ComputePredAndRes> {
            ComputePredAndRes() {
            }

            public void map(Chunk[] chks) {
                Chunk ys = GBM.this.chk_resp(chks);
                C0DChunk offset = GBM.this.hasOffsetCol() ? GBM.this.chk_offset(chks) : new C0DChunk(0.0, chks[0]._len);
                Chunk preds = GBM.this.chk_tree(chks, 0);
                Chunk wk = GBM.this.chk_work(chks, 0);
                double[] fs = GBM.this._nclass > 1 ? new double[GBM.this._nclass + 1] : null;
                Distribution dist = new Distribution(((GBMModel.GBMParameters)GBM.this._parms)._distribution, ((GBMModel.GBMParameters)GBM.this._parms)._tweedie_power);
                for (int row = 0; row < wk._len; ++row) {
                    if (ys.isNA(row)) continue;
                    double f = preds.atd(row) + offset.atd(row);
                    double y = ys.atd(row);
                    if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == Distribution.Family.multinomial) {
                        int k;
                        double weight = GBM.this.hasWeightCol() ? GBM.this.chk_weight(chks).atd(row) : 1.0;
                        double sum = GBM.this.score1(chks, weight, 0.0, fs, row);
                        if (Double.isInfinite(sum)) {
                            for (k = 0; k < GBM.this._nclass; ++k) {
                                wk = GBM.this.chk_work(chks, k);
                                wk.set(row, ((int)y == k ? 1.0f : 0.0f) - (Double.isInfinite(fs[k + 1]) ? 1.0f : 0.0f));
                            }
                            continue;
                        }
                        for (k = 0; k < GBM.this._nclass; ++k) {
                            if (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution[k] == 0.0) continue;
                            wk = GBM.this.chk_work(chks, k);
                            wk.set(row, ((int)y == k ? 1.0f : 0.0f) - (float)(fs[k + 1] / sum));
                        }
                        continue;
                    }
                    wk.set(row, (float)dist.gradient(y, f));
                }
            }
        }

        private class NewtonRaphson
        extends MRTask<NewtonRaphson> {
            double _init;
            double _num;
            double _denom;

            public double value() {
                return this._init + this._num / this._denom;
            }

            NewtonRaphson(double init) {
                this._init = init;
            }

            public void map(Chunk[] chks) {
                Chunk ys = GBM.this.chk_resp(chks);
                Chunk offset = GBM.this.chk_offset(chks);
                C0DChunk weight = GBM.this.hasWeightCol() ? GBM.this.chk_weight(chks) : new C0DChunk(1.0, chks[0]._len);
                Distribution dist = new Distribution(Distribution.Family.bernoulli);
                for (int row = 0; row < ys._len; ++row) {
                    double w = weight.atd(row);
                    if (w == 0.0 || ys.isNA(row)) continue;
                    double y = ys.atd(row);
                    double o = offset.atd(row);
                    double p = dist.linkInv(o + this._init);
                    this._num += w * (y - p);
                    this._denom += w * p * (1.0 - p);
                }
            }

            public void reduce(NewtonRaphson mrt) {
                this._num += mrt._num;
                this._denom += mrt._denom;
            }
        }
    }
}

