/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import java.util.Arrays;
import java.util.Random;
import water.DKV;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.ArrayUtils;
import water.util.RandomUtils;

public abstract class FrameTask<T extends FrameTask<T>>
extends MRTask<T> {
    protected boolean _bulkRead;
    protected boolean _sparse;
    protected transient DataInfo _dinfo;
    final Key _dinfoKey;
    final int[] _activeCols;
    protected final Key _jobKey;
    protected float _useFraction = 1.0f;
    private final long _seed;
    protected boolean _shuffle = false;
    private final int _iteration;

    public DataInfo dinfo() {
        return this._dinfo;
    }

    public FrameTask(Key jobKey, DataInfo dinfo) {
        this(jobKey, dinfo, -557122578L, -1, false);
    }

    public FrameTask(Key jobKey, DataInfo dinfo, long seed, int iteration, boolean sparse) {
        this(jobKey, dinfo._key, dinfo._activeCols, seed, iteration, sparse);
    }

    private FrameTask(Key jobKey, Key dinfoKey, int[] activeCols, long seed, int iteration, boolean sparse) {
        super(null);
        this._jobKey = jobKey;
        this._dinfoKey = dinfoKey;
        this._activeCols = activeCols;
        this._seed = seed;
        this._iteration = iteration;
        this._bulkRead = sparse;
        this._sparse = sparse;
    }

    protected void setupLocal() {
        DataInfo dinfo = (DataInfo)DKV.get((Key)this._dinfoKey).get();
        this._dinfo = this._activeCols == null ? dinfo : dinfo.filterExpandedColumns(this._activeCols);
    }

    protected void closeLocal() {
        this._dinfo = null;
    }

    protected void processRow(long gid, DataInfo.Row r) {
        throw new RuntimeException("should've been overridden!");
    }

    protected void processRow(long gid, DataInfo.Row r, NewChunk[] outputs) {
        throw new RuntimeException("should've been overridden!");
    }

    protected void applyMiniBatchUpdate(int n) {
    }

    protected int getMiniBatchSize() {
        return 1;
    }

    protected boolean chunkInit() {
        return true;
    }

    protected void chunkDone(long n) {
    }

    public final void map(Chunk[] chunks, NewChunk[] outputs) {
        int[] shufIdx;
        if (this._jobKey != null && !Job.isRunning((Key)this._jobKey)) {
            return;
        }
        int nrows = chunks[0]._len;
        long offset = chunks[0].start();
        boolean doWork = this.chunkInit();
        if (!doWork) {
            return;
        }
        boolean obs_weights = this._dinfo._weights && !this._fr.vecs()[this._dinfo.weightChunkId()].isConst();
        double global_weight_sum = obs_weights ? this._fr.vecs()[this._dinfo.weightChunkId()].mean() * (double)this._fr.numRows() : 0.0;
        DataInfo.Row row = null;
        DataInfo.Row[] rows = null;
        if (this._bulkRead) {
            rows = this._sparse ? this._dinfo.extractSparseRows(chunks, 0.0) : this._dinfo.extractDenseRowsVertical(chunks);
        } else {
            row = this._dinfo.newDenseRow();
        }
        double[] weight_map = null;
        double relative_chunk_weight = 1.0;
        if (obs_weights) {
            weight_map = new double[nrows];
            double weight_sum = 0.0;
            for (int i = 0; i < nrows; ++i) {
                row = this._bulkRead ? rows[i] : this._dinfo.extractDenseRow(chunks, i, row);
                weight_map[i] = weight_sum += row.weight;
                assert (i == 0 || row.weight == 0.0 || weight_map[i] > weight_map[i - 1]);
            }
            if (weight_sum > 0.0) {
                ArrayUtils.div((double[])weight_map, (double)weight_sum);
                relative_chunk_weight = global_weight_sum * (double)nrows / (double)this._fr.numRows() / weight_sum;
            } else {
                return;
            }
        }
        int repeats = (int)Math.ceil((double)this._useFraction * relative_chunk_weight);
        float fraction = (float)((double)this._useFraction * relative_chunk_weight) / (float)repeats;
        assert ((double)fraction <= 1.0);
        boolean sample = (double)fraction < 0.999 || obs_weights || this._shuffle;
        long chunkSeed = (-8704322056524490956L + this._seed + offset) * ((long)this._iteration + -7484065362112007133L);
        Random skip_rng = sample ? RandomUtils.getRNG((long[])new long[]{chunkSeed}) : null;
        int[] nArray = shufIdx = skip_rng == null ? null : new int[nrows];
        if (skip_rng != null) {
            for (int i = 0; i < nrows; ++i) {
                shufIdx[i] = i;
            }
            ArrayUtils.shuffleArray((int[])shufIdx, (Random)skip_rng);
        }
        int miniBatchSize = this.getMiniBatchSize();
        long num_processed_rows = 0L;
        int miniBatchCounter = 0;
        for (int rep = 0; rep < repeats; ++rep) {
            for (int row_idx = 0; row_idx < nrows; ++row_idx) {
                int r;
                int n = r = sample ? -1 : 0;
                if (sample && !obs_weights && skip_rng.nextDouble() > (double)fraction) continue;
                if (obs_weights && num_processed_rows % 2L == 0L) {
                    double key = skip_rng.nextDouble();
                    r = Arrays.binarySearch(weight_map, 0, nrows, key);
                    if (r < 0) {
                        r = -r - 1;
                    }
                    assert (r == 0 || weight_map[r] > weight_map[r - 1]);
                } else if (r == -1) {
                    r = shufIdx[row_idx];
                    while (obs_weights && (r == 0 && weight_map[r] == 0.0 || r > 0 && weight_map[r] == weight_map[r - 1])) {
                        r = skip_rng.nextInt(nrows);
                    }
                } else {
                    assert (!obs_weights);
                    r = row_idx;
                }
                assert (r >= 0 && r <= nrows);
                DataInfo.Row row2 = row = this._bulkRead ? rows[r] : this._dinfo.extractDenseRow(chunks, r, row);
                if (!row.bad) {
                    assert (row.weight > 0.0);
                    long seed = offset + (long)(rep * nrows) + (long)r;
                    ++miniBatchCounter;
                    if (outputs != null && outputs.length > 0) {
                        this.processRow(seed++, row, outputs);
                    } else {
                        this.processRow(seed++, row);
                    }
                }
                ++num_processed_rows;
                if (miniBatchCounter <= 0 || miniBatchCounter % miniBatchSize != 0) continue;
                this.applyMiniBatchUpdate(miniBatchCounter);
                miniBatchCounter = 0;
            }
        }
        if (miniBatchCounter > 0) {
            this.applyMiniBatchUpdate(miniBatchCounter);
        }
        assert (fraction != 1.0f || num_processed_rows == (long)(repeats * nrows));
        this.chunkDone(num_processed_rows);
    }

    public static class ExtractDenseRow
    extends MRTask<ExtractDenseRow> {
        private final DataInfo _di;
        private final long _gid;
        public DataInfo.Row _row;

        public ExtractDenseRow(DataInfo di, long globalRowId) {
            this._di = di;
            this._gid = globalRowId;
        }

        public void map(Chunk[] cs) {
            if (cs[0].start() <= this._gid && cs[0].start() + (long)cs[0].len() > this._gid) {
                this._row = this._di.newDenseRow();
                this._di.extractDenseRow(cs, (int)(this._gid - cs[0].start()), this._row);
            }
        }

        public void reduce(ExtractDenseRow mrt) {
            if (mrt._row != null) {
                assert (this._row == null);
                this._row = mrt._row;
            }
        }
    }
}

