/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.Distribution;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.DeepLearningParameters;
import hex.deeplearning.Dropout;
import hex.deeplearning.MurmurHash;
import hex.deeplearning.Storage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import water.H2O;
import water.MemoryManager;
import water.util.ArrayUtils;
import water.util.MathUtils;

public abstract class Neurons {
    short _k;
    int[] _maxIncoming;
    Distribution _dist;
    protected int units;
    protected transient DeepLearningParameters params;
    protected transient int _index;
    public transient Storage.DenseVector _origa;
    public transient Storage.DenseVector _a;
    public transient Storage.DenseVector _e;
    public Neurons _previous;
    public Neurons _input;
    DeepLearningModelInfo _minfo;
    public Storage.DenseRowMatrix _w;
    public Storage.DenseRowMatrix _wEA;
    public Storage.DenseVector _b;
    public Storage.DenseVector _bEA;
    Storage.DenseRowMatrix _wm;
    Storage.DenseVector _bm;
    Storage.DenseRowMatrix _ada_dx_g;
    Storage.DenseVector _bias_ada_dx_g;
    protected Dropout _dropout;
    private boolean _shortcut = false;
    public Storage.DenseVector _avg_a;

    Neurons(int units) {
        this.units = units;
    }

    public String toString() {
        String s = this.getClass().getSimpleName();
        s = s + "\nNumber of Neurons: " + this.units;
        s = s + "\nParameters:\n" + ((Object)((Object)this.params)).toString();
        if (this._dropout != null) {
            s = s + "\nDropout:\n" + this._dropout.toString();
        }
        return s;
    }

    void sanityCheck(boolean training) {
        if (this instanceof Input) {
            assert (this._previous == null);
        } else {
            assert (this._previous != null);
            if (this._minfo.has_momenta()) {
                assert (this._wm != null);
                assert (this._bm != null);
                assert (this._ada_dx_g == null);
            }
            if (this._minfo.adaDelta()) {
                if (this.params._rho == 0.0) {
                    throw new IllegalArgumentException("rho must be > 0 if epsilon is >0.");
                }
                if (this.params._epsilon == 0.0) {
                    throw new IllegalArgumentException("epsilon must be > 0 if rho is >0.");
                }
                assert (this._minfo.adaDelta());
                assert (this._bias_ada_dx_g != null);
                assert (this._wm == null);
                assert (this._bm == null);
            }
            if (this instanceof MaxoutDropout || this instanceof TanhDropout || this instanceof RectifierDropout) assert (!training || this._dropout != null);
        }
    }

    public final void init(Neurons[] neurons, int index, DeepLearningParameters p, DeepLearningModelInfo minfo, boolean training) {
        this._index = index - 1;
        this.params = (DeepLearningParameters)p.clone();
        this.params._hidden_dropout_ratios = minfo.get_params()._hidden_dropout_ratios;
        this.params._rate *= Math.pow(this.params._rate_decay, index - 1);
        this.params._distribution = minfo.get_params()._distribution;
        this._dist = new Distribution(this.params._distribution, this.params._tweedie_power);
        this._a = new Storage.DenseVector(this.units);
        if (!(this instanceof Input)) {
            this._e = new Storage.DenseVector(this.units);
        } else if (this.params._autoencoder && this.params._input_dropout_ratio > 0.0) {
            this._origa = new Storage.DenseVector(this.units);
        }
        if (training && (this instanceof MaxoutDropout || this instanceof TanhDropout || this instanceof RectifierDropout || this instanceof Input)) {
            Object object = this instanceof Input ? (this.params._input_dropout_ratio == 0.0 ? null : new Dropout(this.units, this.params._input_dropout_ratio)) : (this._dropout = new Dropout(this.units, this.params._hidden_dropout_ratios[this._index]));
        }
        if (!(this instanceof Input)) {
            this._previous = neurons[this._index];
            this._minfo = minfo;
            this._w = minfo.get_weights(this._index);
            this._b = minfo.get_biases(this._index);
            if (this.params._autoencoder && this.params._sparsity_beta > 0.0 && this._index < this.params._hidden.length) {
                this._avg_a = minfo.get_avg_activations(this._index);
            }
            if (minfo.has_momenta()) {
                this._wm = minfo.get_weights_momenta(this._index);
                this._bm = minfo.get_biases_momenta(this._index);
            }
            if (minfo.adaDelta()) {
                this._ada_dx_g = minfo.get_ada_dx_g(this._index);
                this._bias_ada_dx_g = minfo.get_biases_ada_dx_g(this._index);
            }
            this._shortcut = this.params._fast_mode || !this.params._adaptive_rate && !this._minfo.has_momenta() && this.params._l1 == 0.0 && this.params._l2 == 0.0;
        }
        this.sanityCheck(training);
    }

    protected abstract void fprop(long var1, boolean var3);

    protected abstract void bprop();

    protected final void bpropOutputLayer() {
        assert (this._index == this.params._hidden.length);
        int rows = this._a.size();
        float m = this._minfo.adaDelta() ? 0.0f : this.momentum();
        float r = this._minfo.adaDelta() ? 0.0f : this.rate(this._minfo.get_processed_total()) * (1.0f - m);
        for (int row = 0; row < rows; ++row) {
            double g = this._e.raw()[row];
            this.bprop(row, g, r, m);
        }
    }

    protected void setOutputLayerGradient(double ignored) {
        assert (this._minfo.get_params()._autoencoder && this._index == this._minfo.get_params()._hidden.length);
        int rows = this._a.size();
        for (int row = 0; row < rows; ++row) {
            this._e.set(row, this.autoEncoderGradient(row));
        }
    }

    final void bprop(int row, double partial_grad, float rate, float momentum) {
        if (this._shortcut && partial_grad == 0.0) {
            return;
        }
        float rho = (float)this.params._rho;
        float eps = (float)this.params._epsilon;
        float l1 = (float)this.params._l1;
        float l2 = (float)this.params._l2;
        float max_w2 = this.params._max_w2;
        boolean have_momenta = this._minfo.has_momenta();
        boolean have_ada = this._minfo.adaDelta();
        boolean nesterov = this.params._nesterov_accelerated_gradient;
        boolean update_prev = this._previous._e != null;
        boolean fast_mode = this.params._fast_mode;
        int cols = this._previous._a.size();
        double avg_grad2 = 0.0;
        int idx = row * cols;
        for (int col = 0; col < cols; ++col) {
            int w = idx + col;
            if (this._k != 0) {
                w = this._k * w + this._maxIncoming[row];
            }
            double weight = this._w.raw()[w];
            if (update_prev) {
                this._previous._e.add(col, partial_grad * weight);
            }
            double previous_a = this._previous._a.get(col);
            if (fast_mode && previous_a == 0.0) continue;
            double grad = partial_grad * previous_a - Math.signum(weight) * (double)l1 - weight * (double)l2;
            if (this._wEA != null) {
                grad -= this.params._elastic_averaging_regularization * (double)(this._w.raw()[w] - this._wEA.raw()[w]);
            }
            if (DeepLearningModelInfo.gradientCheck != null) {
                DeepLearningModelInfo.gradientCheck.apply(this._index, row, col, -grad);
            }
            if (have_ada) {
                double grad2 = grad * grad;
                avg_grad2 += grad2;
                float brate = Neurons.computeAdaDeltaRateForWeight(grad, w, this._ada_dx_g, rho, eps);
                float[] fArray = this._w.raw();
                int n = w;
                fArray[n] = (float)((double)fArray[n] + (double)brate * grad);
                continue;
            }
            if (!nesterov) {
                double delta = (double)rate * grad;
                float[] fArray = this._w.raw();
                int n = w;
                fArray[n] = (float)((double)fArray[n] + delta);
                if (!have_momenta) continue;
                float[] fArray2 = this._w.raw();
                int n2 = w;
                fArray2[n2] = fArray2[n2] + momentum * this._wm.raw()[w];
                this._wm.raw()[w] = (float)delta;
                continue;
            }
            double tmp = grad;
            if (have_momenta) {
                float[] fArray = this._wm.raw();
                int n = w;
                fArray[n] = fArray[n] * momentum;
                float[] fArray3 = this._wm.raw();
                int n3 = w;
                fArray3[n3] = (float)((double)fArray3[n3] + tmp);
                tmp = this._wm.raw()[w];
            }
            float[] fArray = this._w.raw();
            int n = w;
            fArray[n] = (float)((double)fArray[n] + (double)rate * tmp);
        }
        if (max_w2 != Float.POSITIVE_INFINITY) {
            this.rescale_weights(this._w, row, max_w2);
        }
        if (have_ada) {
            avg_grad2 /= (double)cols;
        }
        this.update_bias(this._b, this._bEA, this._bm, row, partial_grad, avg_grad2, rate, momentum);
    }

    private void rescale_weights(Storage.DenseRowMatrix w, int row, float max_w2) {
        int end;
        int start;
        int cols = this._previous._a.size();
        if (this._k != 0) {
            start = this._k * (row * cols) + this._maxIncoming[row];
            end = this._k * (row * cols + (cols - 1)) + this._maxIncoming[row];
        } else {
            start = row * cols;
            end = row * cols + cols;
        }
        float r2 = MathUtils.sumSquares((float[])w.raw(), (int)start, (int)end);
        if (r2 > max_w2) {
            float scale = MathUtils.approxSqrt((float)(max_w2 / r2));
            int c = start;
            while (c < end) {
                float[] fArray = w.raw();
                int n = c++;
                fArray[n] = fArray[n] * scale;
            }
        }
    }

    protected double autoEncoderGradient(int row) {
        assert (this._minfo.get_params()._autoencoder && this._index == this._minfo.get_params()._hidden.length);
        double t = this._input._origa != null ? this._input._origa.get(row) : this._input._a.get(row);
        double y = this._a.get(row);
        return this._dist.gradient(t, y);
    }

    private static float computeAdaDeltaRateForWeight(double grad, int w, Storage.DenseRowMatrix ada_dx_g, float rho, float eps) {
        double grad2 = grad * grad;
        ada_dx_g.raw()[2 * w + 1] = (float)((double)(rho * ada_dx_g.raw()[2 * w + 1]) + (double)(1.0f - rho) * grad2);
        float rate = MathUtils.approxSqrt((float)((ada_dx_g.raw()[2 * w] + eps) / (ada_dx_g.raw()[2 * w + 1] + eps)));
        ada_dx_g.raw()[2 * w] = (float)((double)(rho * ada_dx_g.raw()[2 * w]) + (double)((1.0f - rho) * rate * rate) * grad2);
        return rate;
    }

    private static double computeAdaDeltaRateForBias(double grad2, int row, Storage.DenseVector bias_ada_dx_g, float rho, float eps) {
        bias_ada_dx_g.raw()[2 * row + 1] = (double)rho * bias_ada_dx_g.raw()[2 * row + 1] + (double)(1.0f - rho) * grad2;
        double rate = MathUtils.approxSqrt((double)((bias_ada_dx_g.raw()[2 * row] + (double)eps) / (bias_ada_dx_g.raw()[2 * row + 1] + (double)eps)));
        bias_ada_dx_g.raw()[2 * row] = (double)rho * bias_ada_dx_g.raw()[2 * row] + (double)(1.0f - rho) * rate * rate * grad2;
        return rate;
    }

    void compute_sparsity() {
        if (this._avg_a != null) {
            for (int row = 0; row < this._avg_a.size(); ++row) {
                this._avg_a.set(row, 0.999 * this._avg_a.get(row) + 0.001 * this._a.get(row));
            }
        }
    }

    private void update_bias(Storage.DenseVector _b, Storage.DenseVector _bEA, Storage.DenseVector _bm, int row, double partial_grad, double avg_grad2, double rate, double momentum) {
        boolean have_momenta = this._minfo.has_momenta();
        boolean have_ada = this._minfo.adaDelta();
        float l1 = (float)this.params._l1;
        float l2 = (float)this.params._l2;
        int b = this._k != 0 ? this._k * row + this._maxIncoming[row] : row;
        double bias = _b.get(b);
        partial_grad -= Math.signum(bias) * (double)l1 + bias * (double)l2;
        if (_bEA != null) {
            partial_grad -= (bias - _bEA.get(b)) * this.params._elastic_averaging_regularization;
        }
        if (have_ada) {
            float rho = (float)this.params._rho;
            float eps = (float)this.params._epsilon;
            rate = Neurons.computeAdaDeltaRateForBias(avg_grad2, b, this._bias_ada_dx_g, rho, eps);
        }
        if (!this.params._nesterov_accelerated_gradient) {
            double delta = rate * partial_grad;
            _b.add(b, delta);
            if (have_momenta) {
                _b.add(b, momentum * _bm.get(b));
                _bm.set(b, delta);
            }
        } else {
            double d = partial_grad;
            if (have_momenta) {
                _bm.set(b, _bm.get(b) * momentum);
                _bm.add(b, d);
                d = _bm.get(b);
            }
            _b.add(b, rate * d);
        }
        if (this.params._autoencoder && this.params._sparsity_beta > 0.0 && !(this instanceof Output) && !(this instanceof Input) && this._index != this.params._hidden.length) {
            _b.add(b, -(rate * this.params._sparsity_beta * (this._avg_a.raw()[b] - this.params._average_activation)));
        }
        if (Double.isInfinite(_b.get(b))) {
            this._minfo.setUnstable();
        }
    }

    public float rate(double n) {
        return (float)(this.params._rate / (1.0 + this.params._rate_annealing * n));
    }

    protected float momentum() {
        return this.momentum(-1.0);
    }

    public final float momentum(double n) {
        double m = this.params._momentum_start;
        if (this.params._momentum_ramp > 0.0) {
            double num;
            double d = num = n != -1.0 ? (double)this._minfo.get_processed_total() : n;
            m = num >= this.params._momentum_ramp ? this.params._momentum_stable : (m += (this.params._momentum_stable - this.params._momentum_start) * num / this.params._momentum_ramp);
        }
        return (float)m;
    }

    static void gemv_naive(double[] res, float[] a, double[] x, double[] y, byte[] row_bits) {
        int cols = x.length;
        int rows = y.length;
        assert (res.length == rows);
        for (int row = 0; row < rows; ++row) {
            res[row] = 0.0;
            if (row_bits != null && (row_bits[row / 8] & 1 << row % 8) == 0) continue;
            for (int col = 0; col < cols; ++col) {
                int n = row;
                res[n] = res[n] + (double)a[row * cols + col] * x[col];
            }
            int n = row;
            res[n] = res[n] + y[row];
        }
    }

    static void gemv_row_optimized(double[] res, float[] a, double[] x, double[] y, byte[] row_bits) {
        int cols = x.length;
        int rows = y.length;
        assert (res.length == rows);
        int extra = cols - cols % 8;
        int multiple = cols / 8 * 8 - 1;
        int idx = 0;
        for (int row = 0; row < rows; ++row) {
            res[row] = 0.0;
            if (row_bits == null || (row_bits[row / 8] & 1 << row % 8) != 0) {
                int col;
                double psum0 = 0.0;
                double psum1 = 0.0;
                double psum2 = 0.0;
                double psum3 = 0.0;
                double psum4 = 0.0;
                double psum5 = 0.0;
                double psum6 = 0.0;
                double psum7 = 0.0;
                for (col = 0; col < multiple; col += 8) {
                    int off = idx + col;
                    psum0 += (double)a[off] * x[col];
                    psum1 += (double)a[off + 1] * x[col + 1];
                    psum2 += (double)a[off + 2] * x[col + 2];
                    psum3 += (double)a[off + 3] * x[col + 3];
                    psum4 += (double)a[off + 4] * x[col + 4];
                    psum5 += (double)a[off + 5] * x[col + 5];
                    psum6 += (double)a[off + 6] * x[col + 6];
                    psum7 += (double)a[off + 7] * x[col + 7];
                }
                int n = row;
                res[n] = res[n] + (psum0 + psum1 + psum2 + psum3);
                int n2 = row;
                res[n2] = res[n2] + (psum4 + psum5 + psum6 + psum7);
                for (col = extra; col < cols; ++col) {
                    int n3 = row;
                    res[n3] = res[n3] + (double)a[idx + col] * x[col];
                }
                int n4 = row;
                res[n4] = res[n4] + y[row];
            }
            idx += cols;
        }
    }

    static void gemv(Storage.DenseVector res, Storage.DenseRowMatrix a, Storage.DenseVector x, Storage.DenseVector y, byte[] row_bits) {
        Neurons.gemv_row_optimized(res.raw(), a.raw(), x.raw(), y.raw(), row_bits);
    }

    static void gemv_naive(Storage.DenseVector res, Storage.DenseRowMatrix a, Storage.DenseVector x, Storage.DenseVector y, byte[] row_bits) {
        Neurons.gemv_naive(res.raw(), a.raw(), x.raw(), y.raw(), row_bits);
    }

    public static class Linear
    extends Output {
        public Linear() {
            super(1);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            Linear.gemv(this._a, this._w, this._previous._a, this._b, this._dropout != null ? this._dropout.bits() : null);
        }

        @Override
        protected void setOutputLayerGradient(double target) {
            boolean row = false;
            double y = this._a.get(0);
            double g = this._dist.gradient(target, y);
            this._e.set(0, g);
        }
    }

    public static class Softmax
    extends Output {
        public Softmax(int units) {
            super(units);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            int row;
            Softmax.gemv(this._a, this._w, this._previous._a, this._b, null);
            double max = ArrayUtils.maxValue((double[])this._a.raw());
            double scaling = 0.0;
            int rows = this._a.size();
            for (row = 0; row < rows; ++row) {
                this._a.set(row, Math.exp(this._a.get(row) - max));
                scaling += this._a.get(row);
            }
            row = 0;
            while (row < rows) {
                double[] dArray = this._a.raw();
                int n = row++;
                dArray[n] = dArray[n] / scaling;
            }
        }

        @Override
        protected void setOutputLayerGradient(double target) {
            assert (target == (double)((int)target));
            int rows = this._a.size();
            for (int row = 0; row < rows; ++row) {
                double g;
                double t = row == (int)target ? 1 : 0;
                double y = this._a.get(row);
                switch (this.params._loss) {
                    case Automatic: 
                    case CrossEntropy: {
                        g = t - y;
                        break;
                    }
                    case Absolute: {
                        g = (2.0 * t - 1.0) * (1.0 - y) * y;
                        break;
                    }
                    case Quadratic: {
                        g = (t - y) * (1.0 - y) * y;
                        break;
                    }
                    case Huber: {
                        g = t == 0.0 ? (y < 0.5 ? -4.0 * y : -2.0) : (y > 0.5 ? 4.0 * (1.0 - y) : 2.0);
                        g *= (1.0 - y) * y;
                        break;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
                this._e.set(row, g);
            }
        }
    }

    public static abstract class Output
    extends Neurons {
        Output(int units) {
            super(units);
        }

        @Override
        protected void bprop() {
            throw new UnsupportedOperationException();
        }
    }

    public static class RectifierDropout
    extends Rectifier {
        public RectifierDropout(int units) {
            super(units);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            if (training) {
                this._dropout.fillBytes(seed += this.params._seed + 1014100461L);
                super.fprop(seed, true);
            } else {
                super.fprop(seed, false);
                ArrayUtils.mult((double[])this._a.raw(), (double)(1.0 - this.params._hidden_dropout_ratios[this._index]));
            }
        }
    }

    public static class Rectifier
    extends Neurons {
        public Rectifier(int units) {
            super(units);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            Rectifier.gemv(this._a, this._w, this._previous._a, this._b, this._dropout != null ? this._dropout.bits() : null);
            int rows = this._a.size();
            for (int row = 0; row < rows; ++row) {
                this._a.set(row, 0.5 * (this._a.get(row) + Math.abs(this._a.get(row))));
                this.compute_sparsity();
            }
        }

        @Override
        protected void bprop() {
            assert (this._index < this._minfo.get_params()._hidden.length);
            float m = this._minfo.adaDelta() ? 0.0f : this.momentum();
            float r = this._minfo.adaDelta() ? 0.0f : this.rate(this._minfo.get_processed_total()) * (1.0f - m);
            int rows = this._a.size();
            for (int row = 0; row < rows; ++row) {
                double g = this._a.get(row) > 0.0 ? this._e.get(row) : 0.0;
                this.bprop(row, g, r, m);
            }
        }
    }

    public static class MaxoutDropout
    extends Maxout {
        public MaxoutDropout(short k, int units) {
            super(k, units);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            if (training) {
                this._dropout.fillBytes(seed += this.params._seed + 1372114957L);
                super.fprop(seed, true);
            } else {
                super.fprop(seed, false);
                ArrayUtils.mult((double[])this._a.raw(), (double)(1.0 - this.params._hidden_dropout_ratios[this._index]));
            }
        }
    }

    public static class Maxout
    extends Neurons {
        public Maxout(short k, int units) {
            super(units);
            this._k = k;
            this._maxIncoming = new int[units];
            if (this._k != 2) {
                throw H2O.unimpl((String)"Maxout is currently hardcoded for 2 channels. Trivial to enable k > 2 though.");
            }
        }

        @Override
        protected void fprop(long seed, boolean training) {
            assert (this._b.size() == this._a.size() * this._k);
            assert (this._w.size() == (long)(this._a.size() * this._previous._a.size() * this._k));
            int rows = this._a.size();
            double[] channel = new double[this._k];
            for (int row = 0; row < rows; ++row) {
                this._a.set(row, 0.0);
                if (training && this._dropout != null && !this._dropout.unit_active(row)) continue;
                int cols = this._previous._a.size();
                int maxK = 0;
                for (short k = 0; k < this._k; k = (short)(k + 1)) {
                    channel[k] = 0.0;
                    for (int col = 0; col < cols; ++col) {
                        short s = k;
                        channel[s] = channel[s] + (double)this._w.raw()[this._k * (row * cols + col) + k] * this._previous._a.get(col);
                    }
                    short s = k;
                    channel[s] = channel[s] + this._b.raw()[this._k * row + k];
                    if (!(channel[k] > channel[maxK])) continue;
                    maxK = k;
                }
                this._maxIncoming[row] = maxK;
                this._a.set(row, channel[maxK]);
            }
            this.compute_sparsity();
        }

        @Override
        protected void bprop() {
            assert (this._index != this.params._hidden.length);
            float m = this._minfo.adaDelta() ? 0.0f : this.momentum();
            float r = this._minfo.adaDelta() ? 0.0f : this.rate(this._minfo.get_processed_total()) * (1.0f - m);
            int rows = this._a.size();
            for (int row = 0; row < rows; ++row) {
                double g = this._e.get(row);
                this.bprop(row, g, r, m);
            }
        }
    }

    public static class TanhDropout
    extends Tanh {
        public TanhDropout(int units) {
            super(units);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            if (training) {
                this._dropout.fillBytes(seed += this.params._seed + -629514240L);
                super.fprop(seed, true);
            } else {
                super.fprop(seed, false);
                ArrayUtils.mult((double[])this._a.raw(), (double)(1.0 - this.params._hidden_dropout_ratios[this._index]));
            }
        }
    }

    public static class Tanh
    extends Neurons {
        public Tanh(int units) {
            super(units);
        }

        @Override
        protected void fprop(long seed, boolean training) {
            Tanh.gemv(this._a, this._w, this._previous._a, this._b, this._dropout != null ? this._dropout.bits() : null);
            int rows = this._a.size();
            for (int row = 0; row < rows; ++row) {
                this._a.set(row, 1.0 - 2.0 / (1.0 + Math.exp(2.0 * this._a.get(row))));
            }
            this.compute_sparsity();
        }

        @Override
        protected void bprop() {
            assert (this._index < this._minfo.get_params()._hidden.length);
            float m = this._minfo.adaDelta() ? 0.0f : this.momentum();
            float r = this._minfo.adaDelta() ? 0.0f : this.rate(this._minfo.get_processed_total()) * (1.0f - m);
            int rows = this._a.size();
            for (int row = 0; row < rows; ++row) {
                double g = this._e.get(row) * (1.0 - this._a.get(row) * this._a.get(row));
                this.bprop(row, g, r, m);
            }
        }
    }

    public static class Input
    extends Neurons {
        private DataInfo _dinfo;

        Input(int units, DataInfo d) {
            super(units);
            this._dinfo = d;
            this._a = new Storage.DenseVector(units);
        }

        @Override
        protected void bprop() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void fprop(long seed, boolean training) {
            throw new UnsupportedOperationException();
        }

        public void setInput(long seed, double[] data) {
            int i;
            assert (this._dinfo != null);
            double[] nums = MemoryManager.malloc8d((int)this._dinfo._nums);
            int[] cats = MemoryManager.malloc4((int)this._dinfo._cats);
            int ncats = 0;
            for (i = 0; i < this._dinfo._cats; ++i) {
                assert (this._dinfo._catMissing[i] != 0);
                if (Double.isNaN(data[i])) {
                    cats[ncats] = this._dinfo._catOffsets[i + 1] - 1;
                } else {
                    int c = (int)data[i];
                    if (this._dinfo._useAllFactorLevels) {
                        cats[ncats] = c + this._dinfo._catOffsets[i];
                    } else if (c != 0) {
                        cats[ncats] = c + this._dinfo._catOffsets[i] - 1;
                    }
                    if (cats[ncats] >= this._dinfo._catOffsets[i + 1]) {
                        cats[ncats] = this._dinfo._catOffsets[i + 1] - 1;
                    }
                }
                ++ncats;
            }
            int n = data.length - (this._dinfo._weights ? 1 : 0) - (this._dinfo._offset ? 1 : 0);
            while (i < n) {
                double d = data[i];
                if (this._dinfo._normMul != null) {
                    d = (d - this._dinfo._normSub[i - this._dinfo._cats]) * this._dinfo._normMul[i - this._dinfo._cats];
                }
                nums[i - this._dinfo._cats] = d;
                ++i;
            }
            this.setInput(seed, null, nums, ncats, cats);
        }

        public void setInput(long seed, int[] numIds, double[] nums, int numcat, int[] cats) {
            Arrays.fill(this._a.raw(), 0.0);
            if (this.params._max_categorical_features < this._dinfo.fullN() - this._dinfo._nums) {
                int i;
                assert (nums.length == this._dinfo._nums);
                int M = nums.length + this.params._max_categorical_features;
                assert (this._a.size() == M);
                int cM = this.params._max_categorical_features;
                assert (this._a.size() == M);
                MurmurHash murmur = MurmurHash.getInstance();
                for (i = 0; i < numcat; ++i) {
                    ByteBuffer buf = ByteBuffer.allocate(4);
                    int hashval = murmur.hash(buf.putInt(cats[i]).array(), 4, (int)this.params._seed);
                    this._a.add(Math.abs(hashval % cM), 1.0);
                }
                for (i = 0; i < nums.length; ++i) {
                    this._a.set(cM + i, Double.isNaN(nums[i]) ? 0.0 : nums[i]);
                }
            } else {
                int i;
                assert (this._a.size() == this._dinfo.fullN());
                for (i = 0; i < numcat; ++i) {
                    this._a.set(cats[i], 1.0);
                }
                if (numIds != null) {
                    for (i = 0; i < numIds.length; ++i) {
                        this._a.set(numIds[i], Double.isNaN(nums[i]) ? 0.0 : nums[i]);
                    }
                } else {
                    for (i = 0; i < nums.length; ++i) {
                        this._a.set(this._dinfo.numStart() + i, Double.isNaN(nums[i]) ? 0.0 : nums[i]);
                    }
                }
            }
            if (this._dropout == null) {
                return;
            }
            if (this.params._autoencoder && this.params._input_dropout_ratio > 0.0) {
                System.arraycopy(this._a.raw(), 0, this._origa.raw(), 0, this._a.raw().length);
            }
            this._dropout.randomlySparsifyActivation((Storage.Vector)this._a, seed += this.params._seed + 322417854L);
        }
    }
}

