/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUC2;
import hex.Model;
import hex.ModelCategory;
import hex.ScoreKeeper;
import hex.VarImp;
import hex.deeplearning.DeepLearningScoringInfo;
import java.util.ArrayList;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.AutoBuffer;
import water.Iced;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class ScoringInfo
extends Iced {
    public long time_stamp_ms;
    public long total_training_time_ms;
    public long total_scoring_time_ms;
    public long total_setup_time_ms;
    public long this_scoring_time_ms;
    public boolean classification;
    public AUC2 training_AUC;
    public AUC2 validation_AUC;
    public boolean validation;
    public VarImp variable_importances;
    public ScoreKeeper scored_train = new ScoreKeeper();
    public ScoreKeeper scored_valid = new ScoreKeeper();

    public static TwoDimTable createScoringHistoryTable(ScoringInfo[] scoringInfo, Model.Parameters params, Model.Output output, boolean autoencoder) {
        boolean hasSpeed = scoringInfo instanceof DeepLearningScoringInfo[];
        boolean hasEpochs = scoringInfo instanceof DeepLearningScoringInfo[];
        boolean hasSamples = scoringInfo instanceof DeepLearningScoringInfo[];
        boolean hasIterations = scoringInfo instanceof DeepLearningScoringInfo[];
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        if (hasSpeed) {
            colHeaders.add("Training Speed");
        }
        colTypes.add("string");
        colFormat.add("%s");
        if (hasEpochs) {
            colHeaders.add("Epochs");
        }
        colTypes.add("double");
        colFormat.add("%.5f");
        if (hasIterations) {
            colHeaders.add("Iterations");
        }
        colTypes.add("int");
        colFormat.add("%d");
        if (hasSamples) {
            colHeaders.add("Samples");
        }
        colTypes.add("double");
        colFormat.add("%f");
        colHeaders.add("Training MSE");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (output.getModelCategory() == ModelCategory.Regression) {
            colHeaders.add("Training Deviance");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (!autoencoder) {
            colHeaders.add("Training R^2");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (output.isClassifier()) {
            colHeaders.add("Training LogLoss");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (output.getModelCategory() == ModelCategory.Binomial) {
            colHeaders.add("Training AUC");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (output.getModelCategory() == ModelCategory.Binomial) {
            colHeaders.add("Training Lift");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (output.getModelCategory() == ModelCategory.Binomial || output.getModelCategory() == ModelCategory.Multinomial) {
            colHeaders.add("Training Classification Error");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (params._valid != null) {
            colHeaders.add("Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (output.getModelCategory() == ModelCategory.Regression) {
                colHeaders.add("Validation Deviance");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (!autoencoder) {
                colHeaders.add("Validation R^2");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (output.isClassifier()) {
                colHeaders.add("Validation LogLoss");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (output.getModelCategory() == ModelCategory.Binomial) {
                colHeaders.add("Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (output.getModelCategory() == ModelCategory.Binomial) {
                colHeaders.add("Validation Lift");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (output.isClassifier()) {
                colHeaders.add("Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        }
        int rows = scoringInfo.length;
        String[] s = new String[]{};
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(s), colTypes.toArray(s), colFormat.toArray(s), "");
        int row = 0;
        for (ScoringInfo si : scoringInfo) {
            int col = 0;
            assert (row < table.getRowDim());
            assert (col < table.getColDim());
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(si.time_stamp_ms));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)si.total_training_time_ms, (boolean)true));
            if (hasSpeed) {
                int speed = (int)(((DeepLearningScoringInfo)si).training_samples / ((double)(si.total_training_time_ms - si.total_scoring_time_ms - si.total_setup_time_ms) / 1000.0));
                assert (speed >= 0) : "Speed should not be negative! " + speed + " = (int)(" + ((DeepLearningScoringInfo)si).training_samples + "/((" + si.total_training_time_ms + "-" + si.total_scoring_time_ms + "-" + si.total_setup_time_ms + ")/1e3)";
                table.set(row, col++, si.total_training_time_ms == 0L ? null : String.format("%d", speed) + " rows/sec");
            }
            if (hasEpochs) {
                table.set(row, col++, (Object)((DeepLearningScoringInfo)si).epoch_counter);
            }
            if (hasIterations) {
                table.set(row, col++, (Object)((DeepLearningScoringInfo)si).iterations);
            }
            if (hasSamples) {
                table.set(row, col++, (Object)((DeepLearningScoringInfo)si).training_samples);
            }
            table.set(row, col++, (Object)(si.scored_train != null ? si.scored_train._mse : Double.NaN));
            if (output.getModelCategory() == ModelCategory.Regression) {
                table.set(row, col++, (Object)(si.scored_train != null ? si.scored_train._mean_residual_deviance : Double.NaN));
            }
            if (!autoencoder) {
                table.set(row, col++, (Object)(si.scored_train != null ? si.scored_train._r2 : Double.NaN));
            }
            if (output.isClassifier()) {
                table.set(row, col++, (Object)(si.scored_train != null ? si.scored_train._logloss : Double.NaN));
            }
            if (output.getModelCategory() == ModelCategory.Binomial) {
                table.set(row, col++, (Object)(si.training_AUC != null ? si.training_AUC._auc : Double.NaN));
                table.set(row, col++, (Object)(si.scored_train != null ? si.scored_train._lift : Double.NaN));
            }
            if (output.isClassifier()) {
                table.set(row, col++, (Object)(si.scored_train != null ? si.scored_train._classError : Double.NaN));
            }
            if (params._valid != null) {
                table.set(row, col++, (Object)(si.scored_valid != null ? si.scored_valid._mse : Double.NaN));
                if (output.getModelCategory() == ModelCategory.Regression) {
                    table.set(row, col++, (Object)(si.scored_valid != null ? si.scored_valid._mean_residual_deviance : Double.NaN));
                }
                if (!autoencoder) {
                    table.set(row, col++, (Object)(si.scored_valid != null ? si.scored_valid._r2 : Double.NaN));
                }
                if (output.isClassifier()) {
                    table.set(row, col++, (Object)(si.scored_valid != null ? si.scored_valid._logloss : Double.NaN));
                }
                if (output.getModelCategory() == ModelCategory.Binomial) {
                    table.set(row, col++, (Object)(si.validation_AUC != null ? si.validation_AUC._auc : Double.NaN));
                    table.set(row, col++, (Object)(si.scored_valid != null ? si.scored_valid._lift : Double.NaN));
                }
                if (output.isClassifier()) {
                    table.set(row, col, (Object)(si.scored_valid != null ? si.scored_valid._classError : Double.NaN));
                }
            }
            ++row;
        }
        return table;
    }

    ScoringInfo deep_clone() {
        AutoBuffer ab = new AutoBuffer();
        this.write(ab);
        ab.flipForReading();
        return (ScoringInfo)new ScoringInfo().read(ab);
    }
}

