/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.deeplearning.DeepLearningModel;
import hex.glm.ComputationState;
import hex.glm.GLMMetricBuilder;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.optimization.OptimizationUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class GLM
extends ModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    static NumberFormat lambdaFormatter = new DecimalFormat(".##E0");
    static NumberFormat devFormatter = new DecimalFormat(".##");
    public static final int SCORING_INTERVAL_MSEC = 15000;
    public String _generatedWeights = null;
    DataInfo _dinfo;
    private int _lambdaId;
    private transient DataInfo _validDinfo;
    private transient ScoringHistory _sc;
    private transient LambdaSearchScoringHistory _lsc;
    long _t0 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private transient OptimizationUtils.GradientInfo _ginfo;
    private double _lmax;
    private transient long _nobs;
    private transient GLMModel _model;
    private static final String _wName = "__glm_irlsm_wvec";
    private static final String _zName = "__glm_irlsm_zvec";
    private transient Vec _w;
    private transient Vec _z;
    private transient double[] _nullBeta;
    private transient GLMMetricBuilder _nullValidation;
    protected static final long WORK_TOTAL = 1000000L;
    private transient ComputationState _state;

    public GLM(boolean startup_once) {
        super((Model.Parameters)new GLMModel.GLMParameters(), startup_once);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms, Key dest) {
        super((Model.Parameters)parms, dest);
        this.init(false);
    }

    public boolean isSupervised() {
        return true;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial};
    }

    protected void checkMemoryFootPrint() {
    }

    protected void checkMemoryFootPrint(DataInfo dinfo) {
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM && !((GLMModel.GLMParameters)this._parms)._lambda_search) {
            long max_mem;
            HeartBeat hb = H2O.SELF._heartbeat;
            double p = dinfo.fullN() - dinfo.largestCat();
            long mem_usage = (long)((double)hb._cpus_allowed * (p * p + (double)dinfo.largestCat()) * 8.0 * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            if (mem_usage > (max_mem = hb.get_free_mem())) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
                this.error("_train", msg);
            }
        }
    }

    public int nclasses() {
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
            return this._nclass;
        }
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial) {
            return 2;
        }
        return 1;
    }

    private boolean doingIRLSM() {
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.gaussian && ((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.identity) {
            return false;
        }
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM) {
            return true;
        }
        return ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.AUTO;
    }

    private double[] getNullPrediction() {
        double[] nb = this.getNullBeta();
        if (((GLMModel.GLMParameters)this._parms)._family != GLMModel.GLMParameters.Family.multinomial) {
            return new double[]{((GLMModel.GLMParameters)this._parms).linkInv(nb[nb.length - 1])};
        }
        double[] res = new double[this._nclass];
        if (((GLMModel.GLMParameters)this._parms)._intercept) {
            int N = this._dinfo.fullN() + 1;
            for (int i = 0; i < res.length; ++i) {
                res[i] = Math.exp(nb[this._dinfo.fullN() + i * N]);
            }
        }
        return res;
    }

    private double[] getNullBeta() {
        if (this._nullBeta == null) {
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                this._nullBeta = MemoryManager.malloc8d((int)((this._dinfo.fullN() + 1) * this.nclasses()));
                int N = this._dinfo.fullN() + 1;
                for (int i = 0; i < this.nclasses(); ++i) {
                    this._nullBeta[this._dinfo.fullN() + i * N] = Math.log(this._state._ymu[i]);
                }
            } else {
                this._nullBeta = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                this._nullBeta[this._dinfo.fullN()] = ((GLMModel.GLMParameters)this._parms)._intercept ? new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)this._parms).link(this._state._ymu[0]) : 0.0;
            }
        }
        return this._nullBeta;
    }

    private static GLMMetricBuilder getNullValidation(GLM glm) {
        return null;
    }

    protected boolean computePriorClassDistribution() {
        return ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (this._response != null) {
            switch (((GLMModel.GLMParameters)this._parms)._family) {
                case binomial: {
                    if (this._response.isBinary() || this._nclass == 2) break;
                    this.error("_family", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical or a binary column (0/1)"));
                    break;
                }
                case multinomial: {
                    if (this._nclass > 2) break;
                    this.error("_family", H2O.technote((int)2, (String)"Multinomial requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    break;
                }
                case poisson: {
                    if (this._nclass != 1) {
                        this.error("_family", "Poisson requires the response to be numeric.");
                    }
                    if (this._response.min() < 0.0) {
                        this.error("_family", "Poisson requires response >= 0");
                    }
                    if (this._response.isInt()) break;
                    this.warn("_family", "Poisson expects non-negative integer response, got floats.");
                    break;
                }
                case gamma: {
                    if (this._nclass != 1) {
                        this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                    }
                    if (!(this._response.min() <= 0.0)) break;
                    this.error("_family", "Gamma requires positive respone");
                    break;
                }
                case tweedie: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                    break;
                }
                case gaussian: {
                    break;
                }
                default: {
                    this.error("_family", "Invalid distribution: " + ((GLMModel.GLMParameters)this._parms)._distribution);
                }
            }
        }
        if (expensive) {
            String[] warns;
            BetaConstraint bc;
            double[] dArray;
            boolean setWeights;
            if (this.error_count() > 0) {
                return;
            }
            this._lsc = new LambdaSearchScoringHistory();
            this._sc = new ScoringHistory();
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM || ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT_NAIVE ? 0.5 : 0.0};
            }
            this._train.bulkRollups();
            this._sc = new ScoringHistory();
            this._t0 = System.currentTimeMillis();
            if (((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept || ((GLMModel.GLMParameters)this._parms)._lambda == null || ((GLMModel.GLMParameters)this._parms)._lambda[0] > 0.0) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
                int n = ((GLMModel.GLMParameters)this._parms)._max_active_predictors = ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM ? 7000 : 100000000;
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            this._dinfo = new DataInfo((Frame)this._train.clone(), this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, ((GLMModel.GLMParameters)this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GLMModel.GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip, false, ((GLMModel.GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol());
            this.checkMemoryFootPrint(this._dinfo);
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                int numclasses;
                int n = numclasses = ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this.nclasses() : 1;
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM) {
                    ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? numclasses * 10 * ((GLMModel.GLMParameters)this._parms)._nlambdas : numclasses * 50;
                } else {
                    ((GLMModel.GLMParameters)this._parms)._max_iterations = numclasses * Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                        ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._nlambdas * 100 * numclasses;
                    }
                }
            }
            if (this._valid != null) {
                this._validDinfo = this._dinfo.validDinfo(this._valid);
            }
            this._state = new ComputationState(this._job._key, (GLMModel.GLMParameters)this._parms, this._dinfo, null, this.nclasses());
            boolean skippingRows = ((GLMModel.GLMParameters)this._parms)._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip && this._train.hasNAs();
            boolean bl = setWeights = skippingRows && ((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._alpha[0] > 0.0;
            if (setWeights) {
                Vec wc = this._weights == null ? this._dinfo._adaptedFrame.anyVec().makeCon(1.0) : this._weights.makeCopy();
                this._generatedWeights = "__glm_gen_weights";
                this._dinfo.setWeights("__glm_gen_weights", wc);
            }
            GLMTask.YMUTask ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(this._dinfo, ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? this.nclasses() : 1, !((GLMModel.GLMParameters)this._parms)._stdOverride, setWeights, skippingRows, true).doAll(this._dinfo._adaptedFrame);
            if (ymt._wsum == 0.0) {
                throw new IllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or impute your missing values prior to calling glm.");
            }
            Log.info((Object[])new Object[]{this.LogMsg("using " + ymt._nobs + " nobs out of " + this._dinfo._adaptedFrame.numRows() + " total")});
            this._nobs = ymt._nobs;
            if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / ymt._wsum;
            }
            this._dinfo.updateWeightedSigmaAndMean(ymt._basicStats.sigma(), ymt._basicStats.mean());
            if (((GLMModel.GLMParameters)this._parms)._intercept) {
                dArray = ymt._yMu;
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(0.0);
            }
            this._state._ymu = dArray;
            BetaConstraint betaConstraint = bc = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null ? new BetaConstraint((Frame)((GLMModel.GLMParameters)this._parms)._beta_constraints.get()) : new BetaConstraint();
            if ((bc.hasBounds() || bc.hasProximalPenalty()) && ((GLMModel.GLMParameters)this._parms)._compute_p_values) {
                this.error("_compute_p_values", "P-values can not be computed for constrained problems");
            }
            this._state.setBC(bc);
            if (this.hasOffsetCol() && ((GLMModel.GLMParameters)this._parms)._intercept) {
                GLMGradientSolver gslvr = new GLMGradientSolver(this._job._key, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC());
                double[] x = new L_BFGS().solve((OptimizationUtils.GradientSolver)gslvr, (double[])new double[]{-this._offset.mean()}).coefs;
                x[0] = ((GLMModel.GLMParameters)this._parms).linkInv(x[0]);
                this._state._ymu = x;
                Log.info((Object[])new Object[]{this.LogMsg("fitted intercept = " + x[0])});
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(this._state._ymu[0] * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - this._state._ymu[0])));
            }
            ArrayList<Vec> vecs = new ArrayList<Vec>();
            if (this._weights != null) {
                vecs.add(this._weights);
            }
            if (this._offset != null) {
                vecs.add(this._offset);
            }
            vecs.add(this._response);
            if (this._valid != null) {
                ArrayList<Vec> testVecs = new ArrayList<Vec>();
                boolean testWeights = false;
                boolean testOffset = false;
                testVecs.add(this._valid.vec(((GLMModel.GLMParameters)this._parms)._response_column));
            }
            this._model = new GLMModel(this._result, (GLMModel.GLMParameters)this._parms, this, this._state._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._lmax, this._nobs);
            for (String s : warns = this._model.adaptTestForTrain(this._valid, true, true)) {
                this.warn("_validation_frame", s);
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._nobs >> 4 > (long)this._dinfo.fullN() ? 1.0E-4 : 0.01;
            }
            double[] beta = this.getNullBeta();
            GLMGradientInfo ginfo = new GLMGradientSolver(this._job._key, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC()).getGradient(beta);
            this._state.updateState(beta, ginfo);
            if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                this._lmax = this.lmax(ginfo._gradient);
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    if (((GLMModel.GLMParameters)this._parms)._nlambdas == -1) {
                        ((GLMModel.GLMParameters)this._parms)._nlambdas = 100;
                    }
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[((GLMModel.GLMParameters)this._parms)._nlambdas];
                    double dec = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                    ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._lmax;
                    double l = this._lmax;
                    for (int i = 1; i < ((GLMModel.GLMParameters)this._parms)._nlambdas; ++i) {
                        ((GLMModel.GLMParameters)this._parms)._lambda[i] = l *= dec;
                    }
                } else {
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{10.0 * ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio * this._lmax};
                }
            }
            this._model.clone2().delete_and_lock(this._job._key);
        }
    }

    protected GLMDriver trainModelImpl() {
        return new GLMDriver();
    }

    private final double lmax(double[] grad) {
        return Math.max(ArrayUtils.maxValue((double[])grad), -ArrayUtils.minValue((double[])grad)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private GLMModel.GLMParameters.Solver defaultSolver() {
        return GLMModel.GLMParameters.Solver.IRLSM;
    }

    private double currentLambda() {
        return ((GLMModel.GLMParameters)this._parms)._lambda[this._lambdaId];
    }

    double objVal(double likelihood, double[] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        BetaConstraint bc = this._state.activeBC();
        if (this._state.activeBC()._betaGiven != null && bc._rho != null) {
            for (int i = 0; i < bc._betaGiven.length; ++i) {
                double diff = beta[i] - bc._betaGiven[i];
                proximalPen += diff * diff * bc._rho[i];
            }
        }
        return likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + 0.5 * proximalPen + lambda * (alpha * ArrayUtils.l1norm((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept));
    }

    private String LogMsg(String msg) {
        return "GLM[dest=" + this.dest() + ", " + this._state + "] " + msg;
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        return GLM.expandVec(beta, activeCols, fullN, 0.0);
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN, double filler) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d((int)fullN);
        Arrays.fill(res, filler);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static void doUpdateCD(double[] grads, double[][] xx, double[] betaold, double[] betanew, int variable) {
        int i;
        double diff = betaold[variable] - betanew[variable];
        double[] ary = xx[variable];
        for (i = 0; i < variable; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        for (i = variable + 1; i < grads.length; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
    }

    public static double[] COD_solve(GLMTask.GLMIterationTask gt, double alpha, double lambda) {
        double wsumuInv = 1.0 / gt.wsumu;
        double wsumInv = 1.0 / gt.wsum;
        double l1pen = lambda * alpha;
        double l2pen = lambda * (1.0 - alpha);
        double[][] xx = gt._gram.getXX();
        double[] grads = (double[])gt._xy.clone();
        double[] beta = (double[])gt._beta.clone();
        double[] betaold = (double[])gt._beta.clone();
        for (int i = 0; i < grads.length; ++i) {
            double ip = 0.0;
            for (int j = 0; j < beta.length; ++j) {
                ip += beta[j] * xx[i][j];
            }
            grads[i] = grads[i] - ip + beta[i] * xx[i][i];
        }
        double[] diagInv = MemoryManager.malloc8d((int)xx.length);
        for (int i = 0; i < diagInv.length; ++i) {
            diagInv[i] = 1.0 / (xx[i][i] * wsumuInv + l2pen);
        }
        int iter1 = 0;
        int P = gt._xy.length - 1;
        while (iter1++ < 1000) {
            for (int i = 0; i < P; ++i) {
                beta[i] = ADMM.shrinkage(grads[i] * wsumuInv, l1pen) * diagInv[i];
                GLM.doUpdateCD(grads, xx, betaold, beta, i);
            }
            beta[P] = grads[P] * wsumInv;
            if (beta[P] != 0.0) {
                GLM.doUpdateCD(grads, xx, betaold, beta, P);
            }
            double linf = ArrayUtils.linfnorm((double[])ArrayUtils.subtract((double[])beta, (double[])betaold), (boolean)false);
            System.arraycopy(beta, 0, betaold, 0, beta.length);
            if (!(linf < 1.0E-4)) continue;
            break;
        }
        System.out.println("iter1 = " + iter1);
        return beta;
    }

    protected static double sparseOffset(double[] beta, DataInfo dinfo) {
        double etaOffset = 0.0;
        if (dinfo._normMul != null && dinfo._normSub != null && beta != null) {
            int ns = dinfo.numStart();
            for (int i = 0; i < dinfo._nums; ++i) {
                etaOffset -= beta[i + ns] * dinfo._normSub[i] * dinfo._normMul[i];
            }
        }
        return etaOffset;
    }

    public class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
        }

        public void setNonNegative() {
            if (this._betaLB == null) {
                this._betaLB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                this._betaLB[GLM.this._dinfo.fullN()] = Double.NEGATIVE_INFINITY;
            } else {
                for (int i = 0; i < this._betaLB.length - 1; ++i) {
                    this._betaLB[i] = Math.max(0.0, this._betaLB[i]);
                }
            }
            if (this._betaUB == null) {
                this._betaUB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
            }
        }

        public BetaConstraint(Frame beta_constraints) {
            int idx;
            Object[] names;
            int i;
            int[] map;
            Object[] dom;
            Vec v = beta_constraints.vec("names");
            if (v.isString()) {
                dom = new String[(int)v.length()];
                map = new int[dom.length];
                BufferedString tmpStr = new BufferedString();
                for (int i2 = 0; i2 < dom.length; ++i2) {
                    dom[i2] = v.atStr(tmpStr, (long)i2).toString();
                    map[i2] = i2;
                }
                Object[] sortedDom = (String[])dom.clone();
                Arrays.sort(sortedDom);
                for (i = 1; i < sortedDom.length; ++i) {
                    if (!((String)sortedDom[i - 1]).equals(sortedDom[i])) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)sortedDom[i - 1] + "'!");
                }
            } else if (v.isCategorical()) {
                dom = v.domain();
                map = FrameUtils.asInts((Vec)v);
                int[] sortedMap = MemoryManager.arrayCopyOf((int[])map, (int)map.length);
                Arrays.sort(sortedMap);
                for (int i3 = 1; i3 < sortedMap.length; ++i3) {
                    if (sortedMap[i3 - 1] != sortedMap[i3]) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)dom[sortedMap[i3 - 1]] + "'!");
                }
            } else {
                throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
            }
            if (!Arrays.deepEquals(dom, names = (String[])ArrayUtils.append((Object[])GLM.this._dinfo.coefNames(), (Object[])new String[]{"Intercept"}))) {
                HashMap<Object, Integer> m = new HashMap<Object, Integer>();
                for (i = 0; i < names.length; ++i) {
                    m.put(names[i], i);
                }
                int[] newMap = MemoryManager.malloc4((int)dom.length);
                for (int i4 = 0; i4 < map.length; ++i4) {
                    if (GLM.this._removedCols.contains(dom[map[i4]])) {
                        newMap[i4] = -1;
                        continue;
                    }
                    Integer I = (Integer)m.get(dom[map[i4]]);
                    if (I == null) {
                        throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i4]] + "'");
                    }
                    newMap[i4] = I;
                }
                map = newMap;
            }
            int numoff = GLM.this._dinfo.numStart();
            Object[] valid_col_names = new String[]{"names", "beta_given", "beta_start", "lower_bounds", "upper_bounds", "rho", "mean", "std_dev"};
            Arrays.sort(valid_col_names);
            for (String s : beta_constraints.names()) {
                if (Arrays.binarySearch(valid_col_names, s) >= 0) continue;
                GLM.this.error("beta_constraints", "Unknown column name '" + s + "'");
            }
            v = beta_constraints.vec("beta_start");
            if (v != null) {
                this._betaStart = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i5 = 0; i5 < (int)v.length(); ++i5) {
                    if (map[i5] == -1) continue;
                    this._betaStart[map[i5]] = v.at((long)i5);
                }
            }
            if ((v = beta_constraints.vec("beta_given")) != null) {
                this._betaGiven = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i6 = 0; i6 < (int)v.length(); ++i6) {
                    if (map[i6] == -1) continue;
                    this._betaGiven[map[i6]] = v.at((long)i6);
                }
            }
            if ((v = beta_constraints.vec("upper_bounds")) != null) {
                this._betaUB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
                for (int i7 = 0; i7 < (int)v.length(); ++i7) {
                    if (map[i7] == -1) continue;
                    this._betaUB[map[i7]] = v.at((long)i7);
                }
            }
            if ((v = beta_constraints.vec("lower_bounds")) != null) {
                this._betaLB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                Arrays.fill(this._betaLB, Double.NEGATIVE_INFINITY);
                for (int i8 = 0; i8 < (int)v.length(); ++i8) {
                    if (map[i8] == -1) continue;
                    this._betaLB[map[i8]] = v.at((long)i8);
                }
            }
            if ((v = beta_constraints.vec("rho")) != null) {
                this._rho = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i9 = 0; i9 < (int)v.length(); ++i9) {
                    if (map[i9] == -1) continue;
                    this._rho[map[i9]] = v.at((long)i9);
                }
            }
            if ((v = beta_constraints.vec("mean")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i10 = 0;
                while ((long)i10 < v.length()) {
                    if (!v.isNA((long)i10) && map[i10] != -1) {
                        int n = idx = map == null ? i10 : map[i10];
                        if (idx > GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normSub[idx - GLM.this._dinfo.numStart()] = v.at((long)i10);
                        }
                    }
                    ++i10;
                }
            }
            if ((v = beta_constraints.vec("std_dev")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i11 = 0;
                while ((long)i11 < v.length()) {
                    if (!v.isNA((long)i11) && map[i11] != -1) {
                        int n = idx = map == null ? i11 : map[i11];
                        if (idx > GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normMul[idx - GLM.this._dinfo.numStart()] = 1.0 / v.at((long)i11);
                        }
                    }
                    ++i11;
                }
            }
            if (GLM.this._dinfo._normMul != null) {
                double normG = 0.0;
                double normS = 0.0;
                double normLB = 0.0;
                double normUB = 0.0;
                for (int i12 = numoff; i12 < GLM.this._dinfo.fullN(); ++i12) {
                    double s = GLM.this._dinfo._normSub[i12 - numoff];
                    double d = 1.0 / GLM.this._dinfo._normMul[i12 - numoff];
                    if (this._betaUB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normUB *= s;
                        int n = i12;
                        this._betaUB[n] = this._betaUB[n] * d;
                    }
                    if (this._betaLB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normLB *= s;
                        int n = i12;
                        this._betaLB[n] = this._betaLB[n] * d;
                    }
                    if (this._betaGiven != null) {
                        normG += this._betaGiven[i12] * s;
                        int n = i12;
                        this._betaGiven[n] = this._betaGiven[n] * d;
                    }
                    if (this._betaStart == null) continue;
                    normS += this._betaStart[i12] * s;
                    int n = i12;
                    this._betaStart[n] = this._betaStart[n] * d;
                }
                if (GLM.this._dinfo._intercept) {
                    int n = GLM.this._dinfo.fullN();
                    if (this._betaGiven != null) {
                        int n2 = n;
                        this._betaGiven[n2] = this._betaGiven[n2] + normG;
                    }
                    if (this._betaStart != null) {
                        int n3 = n;
                        this._betaStart[n3] = this._betaStart[n3] + normS;
                    }
                    if (this._betaLB != null) {
                        int n4 = n;
                        this._betaLB[n4] = this._betaLB[n4] + normLB;
                    }
                    if (this._betaUB != null) {
                        int n5 = n;
                        this._betaUB[n5] = this._betaUB[n5] + normUB;
                    }
                }
            }
            if (this._betaStart == null && this._betaGiven != null) {
                this._betaStart = (double[])this._betaGiven.clone();
            }
            if (this._betaStart != null && (this._betaLB != null || this._betaUB != null)) {
                for (int i13 = 0; i13 < this._betaStart.length; ++i13) {
                    if (this._betaLB != null && this._betaLB[i13] > this._betaStart[i13]) {
                        this._betaStart[i13] = this._betaLB[i13];
                    }
                    if (this._betaUB == null || !(this._betaUB[i13] < this._betaStart[i13])) continue;
                    this._betaStart[i13] = this._betaUB[i13];
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
            this.check();
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i = 0; i < this._betaGiven.length; ++i) {
                ary[i][0] = this._betaGiven[i];
                ary[i][1] = this._betaLB[i];
                ary[i][2] = this._betaUB[i];
            }
            return ArrayUtils.pprint((double[][])ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d : this._betaLB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d : this._betaUB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasProximalPenalty() {
            return this._betaGiven != null && this._rho != null && ArrayUtils.countNonzeros((double[])this._rho) > 0;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    int n = i;
                    grad[n] = grad[n] + this._rho[i] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    res += this._rho[i] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }

        public void check() {
            if (this._betaLB != null && this._betaUB != null) {
                for (int i = 0; i < this._betaLB.length; ++i) {
                    if (this._betaLB[i] <= this._betaUB[i]) continue;
                    throw new IllegalArgumentException("lower bounds myst be <= upper bounds, " + this._betaLB[i] + " !<= " + this._betaUB[i]);
                }
            }
        }

        public BetaConstraint filterExpandedColumns(int[] activeCols) {
            BetaConstraint res = new BetaConstraint();
            if (this._betaLB != null) {
                res._betaLB = ArrayUtils.select((double[])this._betaLB, (int[])activeCols);
            }
            if (this._betaUB != null) {
                res._betaUB = ArrayUtils.select((double[])this._betaUB, (int[])activeCols);
            }
            if (this._betaGiven != null) {
                res._betaGiven = ArrayUtils.select((double[])this._betaGiven, (int[])activeCols);
            }
            if (this._rho != null) {
                res._rho = ArrayUtils.select((double[])this._rho, (int[])activeCols);
            }
            if (this._betaStart != null) {
                res._betaStart = ArrayUtils.select((double[])this._betaStart, (int[])activeCols);
            }
            return res;
        }
    }

    public static final class GLMGradientSolver
    implements OptimizationUtils.GradientSolver {
        final GLMModel.GLMParameters _parms;
        final DataInfo _dinfo;
        final BetaConstraint _bc;
        final double _l2pen;
        double[][] _betaMultinomial;
        final Key _jobKey;

        public GLMGradientSolver(Key jobKey, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc) {
            this._jobKey = jobKey;
            this._bc = bc;
            this._parms = glmp;
            this._dinfo = dinfo;
            this._l2pen = l2pen;
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial) {
                int i;
                if (this._betaMultinomial == null) {
                    int nclasses = beta.length / (this._dinfo.fullN() + 1);
                    assert (beta.length % (this._dinfo.fullN() + 1) == 0) : "beta len = " + beta.length + ", fullN +1  == " + (this._dinfo.fullN() + 1);
                    this._betaMultinomial = new double[nclasses][];
                    for (i = 0; i < nclasses; ++i) {
                        this._betaMultinomial[i] = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                    }
                }
                int off = 0;
                for (i = 0; i < this._betaMultinomial.length; ++i) {
                    System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                    off += this._betaMultinomial[i].length;
                }
                GLMTask.GLMMultinomialGradientTask gt = (GLMTask.GLMMultinomialGradientTask)new GLMTask.GLMMultinomialGradientTask(this._jobKey, this._dinfo, this._l2pen, this._betaMultinomial, this._parms._obj_reg, false, null).doAll(this._dinfo._adaptedFrame);
                double l2pen = 0.0;
                for (double[] b : this._betaMultinomial) {
                    l2pen += ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
                }
                return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen, gt._gradient);
            }
            assert (beta.length == this._dinfo.fullN() + 1);
            assert (this._parms._intercept || beta[beta.length - 1] == 0.0);
            GLMTask.GLMGradientTask gt = this._parms._family == GLMModel.GLMParameters.Family.binomial && this._parms._link == GLMModel.GLMParameters.Link.logit ? (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(this._jobKey, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.gaussian && this._parms._link == GLMModel.GLMParameters.Link.identity ? (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(this._jobKey, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(this._jobKey, this._dinfo, this._parms, this._l2pen, beta).doAll(this._dinfo._adaptedFrame));
            double[] gradient = gt._gradient;
            double likelihood = gt._likelihood;
            if (!this._parms._intercept) {
                gradient[gradient.length - 1] = 0.0;
            }
            double obj = likelihood * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2((double[])beta, (boolean)true);
            if (this._bc != null && this._bc._betaGiven != null && this._bc._rho != null) {
                obj = ProximalGradientSolver.proximal_gradient(gradient, obj, beta, this._bc._betaGiven, this._bc._rho);
            }
            return new GLMGradientInfo(likelihood, obj, gradient);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            double l = ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)this._jobKey, (DataInfo)this._dinfo, (GLMModel.GLMParameters)this._parms, (double[])beta).doAll((Frame)this._dinfo._adaptedFrame))._likelihood;
            return new GLMGradientInfo(l, l * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2((double[])beta, (boolean)true), null);
        }
    }

    public static class GLMGradientInfo
    extends OptimizationUtils.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }

        @Override
        public String toString() {
            return "GLM grad info: likelihood = " + this._likelihood + ", obj = " + this._objVal + ", gradient = " + Arrays.toString(this._gradient);
        }
    }

    public static class ProximalGradientSolver
    implements OptimizationUtils.GradientSolver,
    ADMM.ProximalSolver {
        final OptimizationUtils.GradientSolver _solver;
        double[] _betaGiven;
        double[] _beta;
        private ProximalGradientInfo _ginfo;
        private final L_BFGS.ProgressMonitor _pm;
        final double[] _rho;
        private final double _objEps;
        private final double _gradEps;
        private int _iter;

        public ProximalGradientSolver(OptimizationUtils.GradientSolver s, double[] betaStart, double[] rho, double objEps, double gradEps, L_BFGS.ProgressMonitor pm) {
            this._solver = s;
            this._rho = rho;
            this._objEps = objEps;
            this._gradEps = gradEps;
            this._pm = pm;
            this._beta = betaStart;
            this._betaGiven = MemoryManager.malloc8d((int)betaStart.length);
        }

        public static double proximal_gradient(double[] grad, double obj, double[] beta, double[] beta_given, double[] rho) {
            for (int i = 0; i < beta.length; ++i) {
                double diff = beta[i] - beta_given[i];
                double pen = rho[i] * diff;
                if (grad != null) {
                    int n = i;
                    grad[n] = grad[n] + pen;
                }
                obj += 0.5 * pen * diff;
            }
            return obj;
        }

        @Override
        public ProximalGradientInfo getGradient(double[] beta) {
            OptimizationUtils.GradientInfo ginfo = this._solver.getGradient(beta);
            double[] gradient = (double[])ginfo._gradient.clone();
            double obj = ProximalGradientSolver.proximal_gradient(gradient, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, gradient);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            OptimizationUtils.GradientInfo ginfo = this._solver.getObjective(beta);
            double obj = ProximalGradientSolver.proximal_gradient(null, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, null);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] beta) {
            if (this._ginfo == null || beta != this._beta) {
                this._ginfo = this.getGradient(beta);
                this._beta = beta;
            }
            double[] gradient = this._ginfo._gradient;
            System.arraycopy(this._ginfo._origGinfo._gradient, 0, gradient, 0, gradient.length);
            double obj = ProximalGradientSolver.proximal_gradient(gradient, this._ginfo._origGinfo._objVal, beta, beta_given, this._rho);
            this._ginfo = new ProximalGradientInfo(this._ginfo._origGinfo, obj, gradient);
            System.arraycopy(beta_given, 0, this._betaGiven, 0, this._betaGiven.length);
            L_BFGS.Result r = new L_BFGS().setObjEps(this._objEps).setGradEps(this._gradEps).solve(this, beta, this._ginfo, this._pm);
            System.arraycopy(r.coefs, 0, beta, 0, r.coefs.length);
            this._iter += r.iter;
            this._ginfo = (ProximalGradientInfo)r.ginfo;
            return r.converged;
        }

        @Override
        public boolean hasGradient() {
            return true;
        }

        @Override
        public double[] gradient(double[] beta) {
            return this.getGradient((double[])beta)._origGinfo._gradient;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static class ProximalGradientInfo
    extends OptimizationUtils.GradientInfo {
        final OptimizationUtils.GradientInfo _origGinfo;

        public ProximalGradientInfo(OptimizationUtils.GradientInfo origGinfo, double objVal, double[] gradient) {
            super(objVal, gradient);
            this._origGinfo = origGinfo;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x, double lb, double ub) {
            if (x < lb) {
                x = lb;
            }
            if (x > ub) {
                x = ub;
            }
            return x;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf((double[])result, (int)result.length);
                for (int i = 0; i < 1000; ++i) {
                    this.solve(oldRes, result);
                    double[] g = this.gradient(result);
                    gerr = Math.max(-ArrayUtils.minValue((double[])g), ArrayUtils.maxValue((double[])g));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn((Object[])new Object[]{"Gram solver did not converge, gerr = " + gerr});
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double[] lb, double[] ub) {
            int i;
            if (ub != null && lb != null) {
                for (int i2 = 0; i2 < ub.length; ++i2) {
                    assert (ub[i2] >= lb[i2]) : i2 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = xy.length - 1;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            double min = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < xy.length - ii; ++i3) {
                double d = xy[i3];
                double d2 = d = d >= 0.0 ? d : -d;
                if (!(d < min) || d == 0.0) continue;
                min = d;
            }
            double ybar = xy[icptCol];
            for (i = 0; i < rhos.length - ii; ++i) {
                double y = xy[i];
                if (y == 0.0) {
                    y = min;
                }
                double xbar = gram.get(icptCol, i);
                double x = (y - ybar * xbar) / (gram.get(i, i) - xbar * xbar + l2pen);
                rhos[i] = ADMM.L1Solver.estimateRho(x, l1pen, lb == null ? Double.NEGATIVE_INFINITY : lb[i], ub == null ? Double.POSITIVE_INFINITY : ub[i]);
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i = 0; i < xy.length; ++i) {
                    int n = i;
                    xy[n] = xy[n] + proxPen[i] * beta_given[i];
                }
            }
            this.computeCholesky(gram, rhos, 1.0E-5);
            this._rho = rhos;
            this._xy = xy;
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd) {
            gram.addDiag(rhos);
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                ArrayUtils.mult((double[])rhos, (double)-1.0);
                int i = 0;
                while (i < rhos.length) {
                    int n = i++;
                    rhos[n] = rhos[n] + rhoAdd;
                }
                Log.info((Object[])new Object[]{"Got NonSPD matrix with original rho, re-computing with rho = " + rhos[0]});
                this._gram.addDiag(rhos);
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                    ArrayUtils.mult((double[])rhos, (double)-1.0);
                    int i2 = 0;
                    while (i2 < rhos.length) {
                        int n = i2++;
                        rhos[n] = rhos[n] * 100.0;
                    }
                    Log.warn((Object[])new Object[]{"Still NonSPD matrix, re-computing with rho = " + rhos[0]});
                    this._gram.addDiag(rhos);
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
            ArrayUtils.mult((double[])rhos, (double)-1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i = 0; i < this._xy.length; ++i) {
                    result[i] = this._xy[i] + this._rho[i] * beta_given[i];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
            return true;
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public double[] gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i = 0; i < this._xy.length; ++i) {
                int n = i;
                grad[n] = grad[n] - this._xy[i];
            }
            return grad;
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMDriver
    extends ModelBuilder.Driver
    implements L_BFGS.ProgressMonitor {
        private long _workPerIteration;
        private transient Gram.Cholesky _chol;
        private transient ADMM.L1Solver _lslvr;
        private long _lastScore;
        private transient HashMap<String, Key> _keys2Keep;
        private transient long _scoringInterval;

        public GLMDriver() {
            super((ModelBuilder)GLM.this);
            this._lastScore = System.currentTimeMillis();
            this._keys2Keep = new HashMap();
            this._scoringInterval = 15000L;
        }

        private void doCleanup() {
            try {
                GLM.this._model.unlock(GLM.this._job);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                ((GLMModel.GLMParameters)GLM.this._parms).read_unlock_frames(GLM.this._job);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Scope.exit((Key[])this._keys2Keep.values().toArray(new Key[0]));
        }

        private double[] solveGram(Gram gram, double[] xy) {
            if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                gram.dropIntercept();
                xy = Arrays.copyOf(xy, xy.length - 1);
            }
            int[] zeros = gram.dropZeroCols();
            assert (zeros.length == 0) : "zero column(s) in gram matrix";
            gram.mul(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
            ArrayUtils.mult((double[])xy, (double)((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
            if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns || ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                Gram.Cholesky chol;
                ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
                Gram.Cholesky cholesky = chol = ((GLM)GLM.this)._state._iter == 0 ? gram.qrCholesky(ignoredCols) : gram.cholesky(null);
                if (!ignoredCols.isEmpty() && !((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinear_cols.length; ++i) {
                        collinear_cols[i] = ignoredCols.get(i);
                    }
                    throw new Gram.CollinearColumnsException("Found collinear columns in the dataset. P-values can not be computed with collinear columns in the dataset. Set remove_collinear_columns flag to true to remove collinear columns automatically. Found collinear columns " + Arrays.toString(ArrayUtils.select((String[])GLM.this._dinfo.coefNames(), (int[])collinear_cols)));
                }
                if (!chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
                this._chol = chol;
                if (!ignoredCols.isEmpty()) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinear_cols.length; ++i) {
                        collinear_cols[i] = ignoredCols.get(i);
                    }
                    Object[] collinear_col_names = ArrayUtils.select((String[])GLM.this._state.activeData().coefNames(), (int[])collinear_cols);
                    GLM.this._model.addWarning("Removed collinear columns " + Arrays.toString(collinear_col_names));
                    Log.warn((Object[])new Object[]{"Removed collinear columns " + Arrays.toString(collinear_col_names)});
                    GLM.this._state.removeCols(collinear_cols);
                    xy = ArrayUtils.removeIds((double[])xy, (int[])collinear_cols);
                }
                chol.solve(xy);
            } else {
                GramSolver slvr = new GramSolver((Gram)gram.clone(), (double[])xy.clone(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, GLM.this._state.l2pen(), GLM.this._state.l1pen(), ((GLM)GLM.this)._state.activeBC()._betaGiven, ((GLM)GLM.this)._state.activeBC()._rho, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                this._chol = slvr._chol;
                if (GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds()) {
                    slvr.solve(xy);
                } else {
                    xy = MemoryManager.malloc8d((int)xy.length);
                    this._lslvr = new ADMM.L1Solver(1.0E-4, 10000);
                    this._lslvr.solve(slvr, xy, GLM.this._state.l1pen(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                }
            }
            return ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? xy : Arrays.copyOf(xy, xy.length + 1);
        }

        private void fitIRLSM_multinomial() {
            assert (GLM.this._dinfo._responses == 3);
            double relImprovement = 1.0;
            double obj = GLM.this._state.objVal();
            while (((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && relImprovement > ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon) {
                for (int c = 0; c < GLM.this._nclass; ++c) {
                    if (GLM.this._state.activeDataMultinomial(c).fullN() == 0) continue;
                    OptimizationUtils.LineSearchSolver ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c), GLM.this._state.ginfoMultinomial(c)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c), GLM.this._state.l1pen());
                    GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
                    double bdiff = ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon + 1.0;
                    ++((GLM)GLM.this)._state._iter;
                    long t1 = System.currentTimeMillis();
                    new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeData(), GLM.this._job._key, GLM.this._state.beta(), c).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                    long t2 = System.currentTimeMillis();
                    GLMTask.GLMIterationTask t = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._job._key, GLM.this._state.activeDataMultinomial(c), glmw, ls.getX(), c).doAll(((GLM)GLM.this)._state.activeDataMultinomial((int)c)._adaptedFrame);
                    long t3 = System.currentTimeMillis();
                    double[] betaCnd = this.solveGram(t._gram, t._xy);
                    long t4 = System.currentTimeMillis();
                    if (!ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                        continue;
                    }
                    long t5 = System.currentTimeMillis();
                    GLM.this._state.setBetaMultinomial(c, ls.getX(), (ComputationState.GLMSubsetGinfo)ls.ginfo());
                    bdiff = this.betaDiff(t._beta, ls.getX());
                    if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                        this.updateProgress();
                    }
                    Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "+" + (t5 - t4) + "=" + (t5 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : "") + " bdiff = " + bdiff)});
                }
                relImprovement = (obj - GLM.this._state.objVal()) / obj;
                obj = GLM.this._state.objVal();
            }
        }

        private void fitLSM() {
            GLMTask.GLMIterationTask t = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._job._key, GLM.this._state.activeData(), new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms), null).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
            GLM.this._state.updateState(this.solveGram(t._gram, t._xy), -1.0);
        }

        private void fitIRLSM() {
            OptimizationUtils.LineSearchSolver ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            try {
                while (true) {
                    double[] betaCnd;
                    long t1 = System.currentTimeMillis();
                    GLMTask.GLMIterationTask t = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._job._key, GLM.this._state.activeData(), glmw, ls.getX()).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                    long t2 = System.currentTimeMillis();
                    double[] dArray = betaCnd = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.COD_solve(t, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.solveGram(t._gram, t._xy);
                    if (betaCnd.length < ls.getX().length) {
                        ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
                    }
                    long t3 = System.currentTimeMillis();
                    if (!ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                    } else {
                        long t4 = System.currentTimeMillis();
                        if (this.progress(ls.getX(), ls.ginfo())) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "=" + (t4 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn((Object[])new Object[]{GLM.this.LogMsg("Got Non SPD matrix, stopped.")});
            }
        }

        private void fitLBFGS() {
            double[] beta = GLM.this._state.beta();
            double lambda = GLM.this._state.lambda();
            double l1pen = GLM.this._state.l1pen();
            double l2pen = GLM.this._state.l2pen();
            GLMGradientSolver gslvr = GLM.this._state.gslvr();
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                beta = MemoryManager.malloc8d((int)((GLM.this._state.activeData().fullN() + 1) * GLM.this._nclass));
                int P = GLM.this._state.activeData().fullN() + 1;
                for (int i = 0; i < GLM.this._nclass; ++i) {
                    beta[i * P + P - 1] = glmw.link(((GLM)GLM.this)._state._ymu[i]);
                }
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    beta[beta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                }
            }
            L_BFGS lbfgs = new L_BFGS().setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon).setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
            assert (beta.length == ((GLM)GLM.this)._state.ginfo()._gradient.length);
            int P = GLM.this._dinfo.fullN();
            if (l1pen > 0.0 || GLM.this._state.activeBC().hasBounds()) {
                double[] nullBeta = MemoryManager.malloc8d((int)beta.length);
                if (GLM.this._dinfo._intercept) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            nullBeta[(c + 1) * (P + 1) - 1] = glmw.link(((GLM)GLM.this)._state._ymu[c]);
                        }
                    } else {
                        nullBeta[nullBeta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                    }
                }
                GLMGradientInfo ginfo = gslvr.getGradient(nullBeta);
                double[] direction = ArrayUtils.mult((double[])((double[])ginfo._gradient.clone()), (double)-1.0);
                double t = 1.0;
                if (l1pen > 0.0) {
                    OptimizationUtils.MoreThuente mt = new OptimizationUtils.MoreThuente(gslvr, nullBeta);
                    mt.evaluate(direction);
                    t = mt.step();
                }
                double[] rho = MemoryManager.malloc8d((int)beta.length);
                double r = GLM.this._state.activeBC().hasBounds() ? 1.0 : 0.1;
                BetaConstraint bc = GLM.this._state.activeBC();
                for (int i = 0; i < rho.length - 1; ++i) {
                    rho[i] = r * ADMM.L1Solver.estimateRho(nullBeta[i] + t * direction[i], l1pen, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[i], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[i]);
                }
                for (int ii = P; ii < rho.length; ii += P + 1) {
                    rho[ii] = r * ADMM.L1Solver.estimateRho(nullBeta[ii] + t * direction[ii], 0.0, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[ii], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[ii]);
                }
                double[] objvals = new double[2];
                objvals[1] = Double.POSITIVE_INFINITY;
                double reltol = ADMM.L1Solver.DEFAULT_RELTOL;
                double abstol = ADMM.L1Solver.DEFAULT_ABSTOL;
                double ADMM_gradEps = 0.001;
                ProximalGradientSolver innerSolver = new ProximalGradientSolver(gslvr, beta, rho, ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * 0.1, ((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon, new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(double[] betaDiff, OptimizationUtils.GradientInfo ginfo) {
                        return ++((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
                    }
                });
                new ADMM.L1Solver(ADMM_gradEps, 250, reltol, abstol).solve(innerSolver, beta, l1pen, true, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                GLM.this._state.updateState(beta, gslvr.getGradient(beta));
            } else {
                L_BFGS.Result r = lbfgs.solve(gslvr, beta, GLM.this._state.ginfo(), new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
                        if (((GLM)GLM.this)._state._iter < 4 || (((GLM)GLM.this)._state._iter & 3) == 0) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("LBFGS, gradient norm = " + ArrayUtils.linfnorm((double[])ginfo._gradient, (boolean)false))});
                        }
                        return GLMDriver.this.progress(beta, ginfo);
                    }
                });
                Log.info((Object[])new Object[]{GLM.this.LogMsg(r.toString())});
                GLM.this._state.updateState(r.coefs, (GLMGradientInfo)r.ginfo);
            }
        }

        private void fitCOD() {
            double[] beta = GLM.this._state.beta();
            int p = GLM.this._state.activeData().fullN() + 1;
            boolean skipFirstLevel = !((GLM)GLM.this)._state.activeData()._useAllFactorLevels;
            double[] betaold = (double[])beta.clone();
            double objold = GLM.this._state.objVal();
            int iter2 = 0;
            Vec[] newVecs = ((GLM)GLM.this)._state.activeData()._adaptedFrame.anyVec().makeZeros(3);
            Vec w = newVecs[0];
            Vec z = newVecs[1];
            Vec zTilda = newVecs[2];
            long startTimeTotalNaive = System.currentTimeMillis();
            while (iter2++ < 30) {
                double percdiff;
                Frame fr = new Frame(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                fr.add("w", w);
                fr.add("z", z);
                fr.add("zTilda", zTilda);
                GLMTask.GLMGenerateWeightsTask gt = (GLMTask.GLMGenerateWeightsTask)new GLMTask.GLMGenerateWeightsTask(GLM.this._job._key, GLM.this._state.activeData(), (GLMModel.GLMParameters)GLM.this._parms, beta).doAll(fr);
                double objVal = GLM.this.objVal(gt._likelihood, gt._betaw, GLM.this._state.lambda());
                double[] denums = gt.denums;
                double wsum = gt.wsum;
                double wsumu = gt.wsumu;
                int iter1 = 0;
                while (iter1++ < 100) {
                    boolean intercept;
                    Frame fr2 = new Frame(new Vec[0]);
                    fr2.add("w", w);
                    fr2.add("z", z);
                    fr2.add("zTilda", zTilda);
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._cats; ++i) {
                        Frame fr3 = new Frame(fr2);
                        int level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i + 1] - ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        int prev_level_num = 0;
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i));
                        boolean bl = intercept = i == 0;
                        if (!intercept) {
                            prev_level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i] - ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1];
                            fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1));
                        }
                        int start_old = ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate = intercept ? (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 4, Arrays.copyOfRange(betaold, start_old, start_old + level_num), new double[]{beta[p - 1]}, ((GLM)GLM.this)._state.activeData()._catLvls[i], null, null, null, null, null, skipFirstLevel).doAll(fr3) : (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 1, Arrays.copyOfRange(betaold, start_old, start_old + level_num), Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[i]), ((GLM)GLM.this)._state.activeData()._catLvls[i], ((GLM)GLM.this)._state.activeData()._catLvls[i - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        for (int j = 0; j < level_num; ++j) {
                            beta[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] = ADMM.shrinkage(stupdate._temp[j] / wsumu, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] / wsumu + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                        }
                    }
                    int cat_num = 2;
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._nums; ++i) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i + ((GLM)GLM.this)._state.activeData()._cats));
                        intercept = i == 0 && GLM.this._state.activeData().numStart() == 0;
                        double[] meannew = null;
                        double[] meanold = null;
                        double[] varnew = null;
                        double[] varold = null;
                        if (i > 0 || intercept) {
                            cat_num = 3;
                            if (!intercept) {
                                fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1 + ((GLM)GLM.this)._state.activeData()._cats));
                            }
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                                meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                                if (i != 0) {
                                    varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i - 1]};
                                    meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i - 1]};
                                }
                            }
                            stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart() + i]}, new double[]{beta[(GLM.this._state.activeData().numStart() + i - 1 + p) % p]}, null, null, varold, meanold, varnew, meannew, skipFirstLevel).doAll(fr3);
                            beta[i + ((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[i + GLM.this._state.activeData().numStart()] / wsumu + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                            continue;
                        }
                        if (i != 0 || intercept) continue;
                        int prev_level_num = GLM.this._state.activeData().numStart() - ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1];
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats - 1));
                        if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                            varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                            meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                        }
                        stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart()]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], GLM.this._state.activeData().numStart()), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], varold, meanold, null, null, skipFirstLevel).doAll(fr3);
                        beta[((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[GLM.this._state.activeData().numStart()] / wsumu + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                    }
                    if (((GLM)GLM.this)._state.activeData()._nums + ((GLM)GLM.this)._state.activeData()._cats > 0) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive iupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1));
                        if (((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1).isCategorical()) {
                            cat_num = 2;
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats]), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        } else {
                            cat_num = 3;
                            double[] meannew = null;
                            double[] varnew = null;
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[((GLM)GLM.this)._state.activeData()._normMul.length - 1]};
                                meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[((GLM)GLM.this)._state.activeData()._normSub.length - 1]};
                            }
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, new double[]{beta[beta.length - 2]}, null, null, null, null, varnew, meannew, skipFirstLevel).doAll(fr3);
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                            beta[beta.length - 1] = iupdate._temp[0] / wsum;
                        }
                    }
                    double maxdiff = ArrayUtils.linfnorm((double[])ArrayUtils.subtract((double[])beta, (double[])betaold), (boolean)false);
                    System.arraycopy(beta, 0, betaold, 0, beta.length);
                    if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                    break;
                }
                if ((percdiff = Math.abs((objold - objVal) / objold)) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1) break;
                objold = objVal;
                System.out.println("iter1 = " + iter1);
            }
            System.out.println("iter2 = " + iter2);
            long endTimeTotalNaive = System.currentTimeMillis();
            long durationTotalNaive = (endTimeTotalNaive - startTimeTotalNaive) / 1000L;
            System.out.println("Time to run Naive Coordinate Descent " + durationTotalNaive);
            ((GLM)GLM.this)._state._iter = iter2;
            for (Vec v : newVecs) {
                v.remove();
            }
            GLM.this._state.updateState(beta, objold);
        }

        private void fitModel() {
            GLMModel.GLMParameters.Solver solver = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.AUTO ? GLM.this.defaultSolver() : ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            switch (solver) {
                case COORDINATE_DESCENT: 
                case IRLSM: {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        this.fitIRLSM_multinomial();
                        break;
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian && ((GLMModel.GLMParameters)GLM.this._parms)._link == GLMModel.GLMParameters.Link.identity) {
                        this.fitLSM();
                        break;
                    }
                    this.fitIRLSM();
                    break;
                }
                case L_BFGS: {
                    this.fitLBFGS();
                    break;
                }
                case COORDINATE_DESCENT_NAIVE: {
                    this.fitCOD();
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                double se = 1.0;
                boolean seEst = false;
                double[] beta = GLM.this._state.beta();
                if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.binomial && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.poisson) {
                    seEst = true;
                    GLMTask.ComputeSETsk ct = (GLMTask.ComputeSETsk)new GLMTask.ComputeSETsk(null, GLM.this._state.activeData(), GLM.this._job._key, beta, (GLMModel.GLMParameters)GLM.this._parms).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                    se = ct._sumsqe / (double)(GLM.this._nobs - 1L - (long)GLM.this._state.activeData().fullN());
                }
                double[] zvalues = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                double[] gInvDiag = this._chol.getInvDiag();
                for (int i = 0; i < zvalues.length; ++i) {
                    zvalues[i] = beta[i] / Math.sqrt(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg * gInvDiag[i] * se);
                }
                GLM.this._model.setZValues(GLM.expandVec(zvalues, ((GLM)GLM.this)._state.activeData()._activeCols, GLM.this._dinfo.fullN() + 1, Double.NaN), se, seEst);
            }
        }

        private long timeSinceLastScoring() {
            return System.currentTimeMillis() - this._lastScore;
        }

        private void scoreAndUpdateModel() {
            ModelMetrics mtrain;
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms")});
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._train);
            GLM.this._model.score(train).delete();
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = mtrain = ModelMetrics.getFromDKV((Model)GLM.this._model, (Frame)train);
            long t2 = System.currentTimeMillis();
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Training metrics computed in " + (t2 - t1) + "ms")});
            Log.info((Object[])new Object[]{GLM.this.LogMsg(mtrain.toString())});
            this._keys2Keep.put("training_metrics", mtrain._key);
            if (GLM.this._valid != null) {
                Frame valid = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._valid);
                GLM.this._model.score(valid).delete();
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = ModelMetrics.getFromDKV((Model)GLM.this._model, (Frame)valid);
                this._keys2Keep.put("validation_metrics", ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics._key);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = ((GLMModel.GLMParameters)GLM.this._parms)._lambda_search ? GLM.this._lsc.to2dTable() : GLM.this._sc.to2dTable();
            GLM.this._model.update(GLM.this._job._key);
            GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            this._lastScore = System.currentTimeMillis();
            long scoringTime = System.currentTimeMillis() - t1;
            this._scoringInterval = Math.max(this._scoringInterval, 20L * scoringTime);
        }

        public void compute2() {
            Scope.enter();
            this._keys2Keep.put("dest", GLM.this.dest());
            ((GLMModel.GLMParameters)GLM.this._parms).read_lock_frames(GLM.this._job);
            GLM.this.init(true);
            if (GLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GLM.this);
            }
            double nullDevTrain = Double.NaN;
            double nullDevTest = Double.NaN;
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                double d = nullDevTrain = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._state._dinfo, (double[])((GLM)GLM.this).getNullBeta(), (int)((GLM)GLM.this)._nclass).doAll((Frame)((GLM)GLM.this)._state._dinfo._adaptedFrame))._likelihood * 2.0 : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._state._dinfo, (GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms), (double[])((GLM)GLM.this).getNullBeta()).doAll((Frame)((GLM)GLM.this)._state._dinfo._adaptedFrame))._resDev;
                if (GLM.this._validDinfo != null) {
                    nullDevTest = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._validDinfo, (double[])((GLM)GLM.this).getNullBeta(), (int)((GLM)GLM.this)._nclass).doAll((Frame)((GLM)GLM.this)._validDinfo._adaptedFrame))._likelihood * 2.0 : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._validDinfo, (GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms), (double[])((GLM)GLM.this).getNullBeta()).doAll((Frame)((GLM)GLM.this)._validDinfo._adaptedFrame))._resDev;
                }
                this._workPerIteration = 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._nlambdas;
            } else {
                this._workPerIteration = 1L + 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial && ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM) {
                double[] nb = GLM.this.getNullBeta();
                double maxRow = ArrayUtils.maxValue((double[])nb);
                double sumExp = 0.0;
                int P = GLM.this._dinfo.fullN();
                int N = GLM.this._dinfo.fullN() + 1;
                for (int i = 1; i < GLM.this._nclass; ++i) {
                    sumExp += Math.exp(nb[i * N + P] - maxRow);
                }
                GLM.this._dinfo.addResponse(new String[]{"__glm_sumExp", "__glm_maxRow"}, GLM.this._dinfo._adaptedFrame.anyVec().makeDoubles(2, new double[]{sumExp, maxRow}));
            }
            double testDevOld = Double.NaN;
            double trainDevOld = Double.NaN;
            boolean impcnt = false;
            for (int i = 0; i < ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length; ++i) {
                GLM.this._model.addSubmodel(GLM.this._state.beta(), ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i], ((GLM)GLM.this)._state._iter);
                GLM.this._state.setLambda(((GLMModel.GLMParameters)GLM.this._parms)._lambda[i]);
                do {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Class " + c + " got " + GLM.this._state.activeDataMultinomial(c).fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total")});
                        }
                    } else {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Got " + GLM.this._state.activeData().fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total")});
                    }
                    this.fitModel();
                } while (!GLM.this._state.checkKKTs());
                Log.info((Object[])new Object[]{GLM.this.LogMsg("solution has " + ArrayUtils.countNonzeros((double[])GLM.this._state.beta()) + " nonzeros")});
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    double trainDev = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._state._dinfo, (double[])((GLM)GLM.this)._state.beta(), (int)((GLM)GLM.this)._nclass).doAll((Frame)((GLM)GLM.this)._state._dinfo._adaptedFrame))._likelihood * 2.0 : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._state._dinfo, (GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms), (double[])((GLM)GLM.this)._state.beta()).doAll((Frame)((GLM)GLM.this)._state._dinfo._adaptedFrame))._resDev;
                    double testDev = -1.0;
                    if (GLM.this._validDinfo != null) {
                        testDev = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._validDinfo, (double[])GLM.this._dinfo.denormalizeBeta((double[])((GLM)GLM.this)._state.beta()), (int)((GLM)GLM.this)._nclass).doAll((Frame)((GLM)GLM.this)._validDinfo._adaptedFrame))._likelihood * 2.0 : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)GLM.this._job._key, (DataInfo)((GLM)GLM.this)._validDinfo, (GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms), (double[])GLM.this._dinfo.denormalizeBeta((double[])((GLM)GLM.this)._state.beta())).doAll((Frame)((GLM)GLM.this)._validDinfo._adaptedFrame))._resDev;
                    }
                    Log.info((Object[])new Object[]{GLM.this.LogMsg("train deviance = " + trainDev + ", test deviance = " + testDev)});
                    GLM.this._lsc.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros((double[])GLM.this._state.beta()), GLM.this._state.lambda(), 1.0 - trainDev / nullDevTrain, 1.0 - testDev / nullDevTest);
                    GLM.this._model.update(GLM.this._state.beta(), trainDev, testDev, ((GLM)GLM.this)._state._iter);
                    if (testDev > testDevOld) break;
                    testDevOld = testDev;
                    if (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval) {
                        this.scoreAndUpdateModel();
                    }
                    GLM.this._job.update(this._workPerIteration, "iter=" + ((GLM)GLM.this)._state._iter + " lmb=" + lambdaFormatter.format(GLM.this._state.lambda()) + "exp.dev.ratio trn/tst= " + devFormatter.format(1.0 - trainDev / nullDevTrain) + "/" + devFormatter.format(1.0 - testDev / nullDevTest) + " P=" + ArrayUtils.countNonzeros((double[])GLM.this._state.beta()));
                    continue;
                }
                GLM.this._model.update(GLM.this._state.beta(), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
            this.scoreAndUpdateModel();
            if (GLM.this._iceptAdjust != 0.0) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept);
                double[] b = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._global_beta;
                int n = b.length - 1;
                b[n] = b[n] + GLM.this._iceptAdjust;
                for (GLMModel.Submodel sm : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels) {
                    int n2 = sm.beta.length - 1;
                    sm.beta[n2] = sm.beta[n2] + GLM.this._iceptAdjust;
                }
                GLM.this._model.update(GLM.this._job._key);
            }
            this.doCleanup();
            this.tryComplete();
        }

        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this._keys2Keep.clear();
            this.doCleanup();
            return true;
        }

        private double betaDiff(double[] b1, double[] b2) {
            double res = Math.abs(b1[0] - b2[0]);
            for (int i = 0; i < b1.length; ++i) {
                double diff = b1[i] - b2[i];
                if (diff > res) {
                    res = diff;
                    continue;
                }
                if (!(-diff > res)) continue;
                res = -diff;
            }
            return res;
        }

        @Override
        public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
            GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
            GLM.this._state.updateState(beta, gginfo);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress();
            }
            return GLM.this._job.isRunning() && ((GLM)GLM.this)._state._iter++ < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._state.converged();
        }

        protected void updateProgress() {
            assert (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search);
            GLM.this._sc.addIterationScore(((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objVal());
            GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            if (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModel();
            }
        }
    }

    private static class LambdaSearchScoringHistory {
        ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _lambdas = new ArrayList();
        private ArrayList<Integer> _lambdaIters = new ArrayList();
        private ArrayList<Integer> _lambdaPredictors = new ArrayList();
        private ArrayList<Double> _lambdaDevTrain = new ArrayList();
        private ArrayList<Double> _lambdaDevTest = new ArrayList();

        private LambdaSearchScoringHistory() {
        }

        public synchronized void addLambdaScore(int iter, int predictors, double lambda, double devRatioTrain, double devRatioTest) {
            this._scoringTimes.add(System.currentTimeMillis());
            this._lambdaIters.add(iter);
            this._lambdas.add(lambda);
            this._lambdaPredictors.add(predictors);
            this._lambdaDevTrain.add(devRatioTrain);
            this._lambdaDevTest.add(devRatioTest);
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iteration", "lambda", "predictors", "Explained Deviance (train)", "Explained Deviance (test)"};
            String[] ctypes = new String[]{"string", "string", "int", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%s", "%d", "%.3f", "%.3f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._lambdaIters.size()], cnames, ctypes, cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._lambdaIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._lambdaIters.get(i));
                res.set(i, col++, (Object)lambdaFormatter.format(this._lambdas.get(i)));
                res.set(i, col++, (Object)this._lambdaPredictors.get(i));
                res.set(i, col++, (Object)this._lambdaDevTrain.get(i));
                if (this._lambdaDevTest.size() <= i) continue;
                res.set(i, col++, (Object)this._lambdaDevTest.get(i));
            }
            return res;
        }
    }

    private static class ScoringHistory {
        private ArrayList<Integer> _scoringIters = new ArrayList();
        private ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _likelihoods = new ArrayList();
        private ArrayList<Double> _objectives = new ArrayList();

        private ScoringHistory() {
        }

        public synchronized void addIterationScore(int iter, double likelihood, double obj) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) == iter) {
                return;
            }
            this._scoringIters.add(iter);
            this._scoringTimes.add(System.currentTimeMillis());
            this._likelihoods.add(likelihood);
            this._objectives.add(obj);
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iteration", "negative_log_likelihood", "objective"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._scoringIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._scoringIters.get(i));
                res.set(i, col++, (Object)this._likelihoods.get(i));
                res.set(i, col++, (Object)this._objectives.get(i));
            }
            return res;
        }
    }

    static class TooManyPredictorsException
    extends RuntimeException {
        TooManyPredictorsException() {
        }
    }
}

