/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.glrm.GLRMModel;
import water.fvec.Frame;

public class ModelMetricsGLRM
extends ModelMetricsUnsupervised {
    public double _numerr;
    public double _caterr;
    public long _numcnt;
    public long _catcnt;

    public ModelMetricsGLRM(Model model, Frame frame, double numerr, double caterr) {
        super(model, frame, Double.NaN);
        this._numerr = numerr;
        this._caterr = caterr;
    }

    public ModelMetricsGLRM(Model model, Frame frame, double numerr, double caterr, long numcnt, long catcnt) {
        this(model, frame, numerr, caterr);
        this._numcnt = numcnt;
        this._catcnt = catcnt;
    }

    public static class GLRMModelMetrics
    extends ModelMetricsUnsupervised.MetricBuilderUnsupervised {
        public double _miscls;
        public long _numcnt;
        public long _catcnt;
        public int[] _permutation;
        public boolean _impute_original;

        public GLRMModelMetrics(int dims, int[] permutation) {
            this(dims, permutation, false);
        }

        public GLRMModelMetrics(int dims, int[] permutation, boolean impute_original) {
            this._work = new double[dims];
            this._catcnt = 0L;
            this._numcnt = 0L;
            this._miscls = 0L;
            this._permutation = permutation;
            this._impute_original = impute_original;
        }

        public double[] perRow(double[] preds, float[] dataRow, Model m) {
            assert (m instanceof GLRMModel);
            GLRMModel gm = (GLRMModel)m;
            assert (((GLRMModel.GLRMOutput)gm._output)._ncats + ((GLRMModel.GLRMOutput)gm._output)._nnums == dataRow.length);
            int ncats = ((GLRMModel.GLRMOutput)gm._output)._ncats;
            double[] sub = ((GLRMModel.GLRMOutput)gm._output)._normSub;
            double[] mul = ((GLRMModel.GLRMOutput)gm._output)._normMul;
            for (int i = 0; i < ncats; ++i) {
                int idx = this._permutation[i];
                if (Double.isNaN(dataRow[idx])) continue;
                if ((double)dataRow[idx] != preds[idx]) {
                    this._miscls += 1.0;
                }
                ++this._catcnt;
            }
            int c = 0;
            for (int i = ncats; i < dataRow.length; ++i) {
                int idx = this._permutation[i];
                if (Double.isNaN(dataRow[idx])) {
                    ++c;
                    continue;
                }
                double diff = (this._impute_original ? (double)dataRow[idx] : ((double)dataRow[idx] - sub[c]) * mul[c]) - preds[idx];
                this._sumsqe += diff * diff;
                ++this._numcnt;
                ++c;
            }
            assert (c == ((GLRMModel.GLRMOutput)gm._output)._nnums);
            return preds;
        }

        public void reduce(ModelMetrics.MetricBuilder mb) {
            GLRMModelMetrics mm = (GLRMModelMetrics)mb;
            super.reduce((ModelMetrics.MetricBuilder)mm);
            this._miscls += mm._miscls;
            this._numcnt += mm._numcnt;
            this._catcnt += mm._catcnt;
        }

        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            return m._output.addModelMetrics((ModelMetrics)new ModelMetricsGLRM(m, f, this._sumsqe, this._miscls, this._numcnt, this._catcnt));
        }
    }
}

