/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.genmodel.GenModel;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import water.Key;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class Score
extends MRTask<Score> {
    final SharedTree _bldr;
    final boolean _is_train;
    final boolean _oob;
    final Key<Vec> _kresp;
    final ModelCategory _mcat;
    ModelMetrics.MetricBuilder _mb;
    final boolean _computeGainsLift;

    public Score(SharedTree bldr, boolean is_train, boolean oob, Key<Vec> kresp, ModelCategory mcat, boolean computeGainsLift) {
        this._bldr = bldr;
        this._is_train = is_train;
        this._oob = oob;
        this._kresp = kresp;
        this._mcat = mcat;
        this._computeGainsLift = computeGainsLift;
    }

    public void map(Chunk[] chks) {
        Chunk ys = this._bldr.chk_resp(chks);
        Object m = this._bldr._model;
        C0DChunk weightsChunk = ((Model)m)._output.hasWeights() ? chks[((Model)m)._output.weightsIdx()] : new C0DChunk(1.0, chks[0]._len);
        C0DChunk offsetChunk = ((Model)m)._output.hasOffset() ? chks[((Model)m)._output.offsetIdx()] : new C0DChunk(0.0, chks[0]._len);
        int nclass = this._bldr.nclasses();
        String[] domain = ((Vec)this._kresp.get()).domain();
        int oobColIdx = this._bldr.idx_oobt();
        this._mb = m.makeMetricBuilder(domain);
        double[] cdists = this._mb._work;
        double[] tmp = (double[])(this._is_train && this._bldr._ntrees > 0 ? null : new double[this._bldr._ncols]);
        float[] val = new float[1];
        for (int row = 0; row < ys._len; ++row) {
            double weight;
            if (ys.isNA(row) || this._oob && chks[oobColIdx].at8(row) == 0L || (weight = weightsChunk.atd(row)) == 0.0) continue;
            double offset = offsetChunk.atd(row);
            if (this._is_train) {
                this._bldr.score2(chks, weight, offset, cdists, row);
            } else {
                m.score0(chks, weight, offset, row, tmp, cdists);
            }
            if (this._is_train && this._bldr._ntrees == 0) {
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = chks[i].atd(row);
                }
            }
            if (nclass > 1) {
                cdists[0] = GenModel.getPrediction((double[])cdists, (double[])((Model)m)._output._priorClassDist, (double[])tmp, (double)m.defaultThreshold());
            }
            val[0] = (float)ys.atd(row);
            this._mb.perRow(cdists, val, weight, offset, m);
        }
    }

    public void reduce(Score t) {
        this._mb.reduce(t._mb);
    }

    ModelMetricsSupervised makeModelMetrics(SharedTreeModel model, Frame fr) {
        Frame preds = model._output.nclasses() == 2 && this._computeGainsLift ? model.score(fr) : null;
        ModelMetricsSupervised mms = (ModelMetricsSupervised)this._mb.makeModelMetrics((Model)model, fr, null, preds);
        if (preds != null) {
            preds.remove();
        }
        return mms;
    }
}

