/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.C8DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class DataInfo
extends Keyed<DataInfo> {
    public int[] _activeCols;
    public Frame _adaptedFrame;
    public int _responses;
    public int _outpus;
    public TransformType _predictor_transform;
    public TransformType _response_transform;
    public boolean _useAllFactorLevels;
    public int _nums;
    public int _cats;
    public int[] _catOffsets;
    public boolean[] _catMissing;
    public int[] _catModes;
    public int[] _permutation;
    public double[] _normMul;
    public double[] _normSub;
    public double[] _normRespMul;
    public double[] _normRespSub;
    public double[] _numMeans;
    public boolean _intercept = true;
    public boolean _offset;
    public boolean _weights;
    public boolean _fold;
    public final boolean _skipMissing;
    public final boolean _imputeMissing;
    public boolean _valid;
    public final int[][] _catLvls;
    public String[] _coefNames;

    public Vec setWeights(String name, Vec vec) {
        if (this._weights) {
            return this._adaptedFrame.replace(this.weightChunkId(), vec);
        }
        this._adaptedFrame.insertVec(this.weightChunkId(), name, vec);
        this._weights = true;
        return null;
    }

    public void dropWeights() {
        if (!this._weights) {
            return;
        }
        this._adaptedFrame.remove(this.weightChunkId());
        this._weights = false;
    }

    public int[] activeCols() {
        if (this._activeCols != null) {
            return this._activeCols;
        }
        int[] res = new int[this.fullN() + 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i;
        }
        return res;
    }

    public void addResponse(String[] names, Vec[] vecs) {
        this._adaptedFrame.add(names, vecs);
        this._responses += vecs.length;
    }

    public int responseChunkId(int n) {
        return n + this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0);
    }

    public int foldChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0);
    }

    public int offsetChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0);
    }

    public int weightChunkId() {
        return this._cats + this._nums;
    }

    public int outputChunkId() {
        return this.outputChunkId(0);
    }

    public int outputChunkId(int n) {
        return n + this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0) + this._responses;
    }

    public void addOutput(String name, Vec v) {
        this._adaptedFrame.add(name, v);
    }

    public Vec getOutputVec(int i) {
        return this._adaptedFrame.vec(this.outputChunkId(i));
    }

    public void setResponse(String name, Vec v) {
        this.setResponse(name, v, 0);
    }

    public void setResponse(String name, Vec v, int n) {
        this._adaptedFrame.insertVec(this.responseChunkId(n), name, v);
    }

    private DataInfo() {
        this._catLvls = null;
        this._skipMissing = true;
        this._imputeMissing = false;
        this._valid = false;
        this._offset = false;
        this._weights = false;
        this._fold = false;
    }

    protected long checksum_impl() {
        throw H2O.unimpl();
    }

    public DataInfo deep_clone() {
        AutoBuffer ab = new AutoBuffer();
        this.write(ab);
        ab.flipForReading();
        return (DataInfo)new DataInfo().read(ab);
    }

    public DataInfo(Frame train, Frame valid, boolean useAllFactorLevels, TransformType predictor_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket) {
        this(train, valid, 0, useAllFactorLevels, predictor_transform, TransformType.NONE, skipMissing, imputeMissing, missingBucket, false, false, false, false);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold) {
        super(Key.make());
        int i;
        int i2;
        boolean bl = this._valid = valid != null;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._offset = offset;
        this._weights = weight;
        this._fold = fold;
        assert (!skipMissing || !imputeMissing) : "skipMissing and imputeMissing cannot both be true";
        this._skipMissing = skipMissing;
        this._imputeMissing = imputeMissing;
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._responses = nResponses;
        this._useAllFactorLevels = useAllFactorLevels;
        this._permutation = new int[train.numCols()];
        Vec[] tvecs = train.vecs();
        int n = tvecs.length - this._responses - (offset ? 1 : 0) - (weight ? 1 : 0) - (fold ? 1 : 0);
        int[] nums = MemoryManager.malloc4((int)n);
        int[] cats = MemoryManager.malloc4((int)n);
        int nnums = 0;
        int ncats = 0;
        for (i2 = 0; i2 < n; ++i2) {
            if (tvecs[i2].isCategorical()) {
                cats[ncats++] = i2;
                continue;
            }
            nums[nnums++] = i2;
        }
        this._nums = nnums;
        this._cats = ncats;
        this._catLvls = new int[this._cats][];
        for (i2 = 0; i2 < ncats; ++i2) {
            for (int j = i2 + 1; j < ncats; ++j) {
                if (tvecs[cats[i2]].domain().length >= tvecs[cats[j]].domain().length) continue;
                int x = cats[i2];
                cats[i2] = cats[j];
                cats[j] = x;
            }
        }
        String[] names = new String[train.numCols()];
        Vec[] tvecs2 = new Vec[train.numCols()];
        this._catModes = new int[this._cats];
        this._catOffsets = MemoryManager.malloc4((int)(ncats + 1));
        this._catMissing = new boolean[ncats];
        this._catOffsets[0] = 0;
        int len = 0;
        for (i = 0; i < ncats; ++i) {
            this._catModes[i] = DataInfo.imputeCat(train.vec(cats[i]));
            this._permutation[i] = cats[i];
            names[i] = train._names[cats[i]];
            Vec v = tvecs2[i] = tvecs[cats[i]];
            this._catMissing[i] = missingBucket;
            this._catOffsets[i + 1] = len += v.domain().length - (useAllFactorLevels ? 0 : 1) + (missingBucket ? 1 : 0);
        }
        this._numMeans = new double[this._nums];
        for (i = 0; i < this._nums; ++i) {
            names[i + this._cats] = train._names[nums[i]];
            tvecs2[i + this._cats] = train.vec(nums[i]);
            this._numMeans[i] = train.vec(nums[i]).mean();
            this._permutation[i + this._cats] = nums[i];
        }
        for (i = names.length - nResponses - (weight ? 1 : 0) - (offset ? 1 : 0) - (fold ? 1 : 0); i < names.length; ++i) {
            names[i] = train._names[i];
            tvecs2[i] = train.vec(i);
        }
        this._adaptedFrame = new Frame(names, tvecs2);
        train.restructure(names, tvecs2);
        if (valid != null) {
            valid.restructure(names, valid.vecs(names));
        }
        this.setPredictorTransform(predictor_transform);
        if (this._responses > 0) {
            this.setResponseTransform(response_transform);
        }
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold, boolean intercept) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, missingBucket, weight, offset, fold);
        this._intercept = intercept;
    }

    public DataInfo validDinfo(Frame valid) {
        DataInfo res = new DataInfo(this._adaptedFrame, null, 1, this._useAllFactorLevels, TransformType.NONE, TransformType.NONE, this._skipMissing, this._imputeMissing, !this._skipMissing && !this._imputeMissing, this._weights, this._offset, this._fold);
        res._adaptedFrame = new Frame(this._adaptedFrame.names(), valid.vecs(this._adaptedFrame.names()));
        res._valid = true;
        return res;
    }

    public DataInfo scoringInfo() {
        DataInfo res = new DataInfo(this._adaptedFrame, null, 1, this._useAllFactorLevels, TransformType.NONE, TransformType.NONE, this._skipMissing, this._imputeMissing, !this._skipMissing, this._weights, this._offset, this._fold);
        res._adaptedFrame = null;
        res._weights = false;
        res._offset = false;
        res._fold = false;
        res._responses = 0;
        res._valid = true;
        return res;
    }

    public double[] denormalizeBeta(double[] beta) {
        int N = this.fullN() + 1;
        assert (beta.length % N == 0) : "beta len = " + beta.length + " expected multiple of" + N;
        int nclasses = beta.length / N;
        beta = MemoryManager.arrayCopyOf((double[])beta, (int)beta.length);
        if (this._predictor_transform == TransformType.STANDARDIZE) {
            for (int c = 0; c < nclasses; ++c) {
                int numoff;
                int off = N * c;
                double norm = 0.0;
                for (int i = numoff = this.numStart(); i < N - 1; ++i) {
                    double b = beta[off + i] * this._normMul[i - numoff];
                    norm += b * this._normSub[i - numoff];
                    beta[off + i] = b;
                }
                int n = off + N - 1;
                beta[n] = beta[n] - norm;
            }
        }
        return beta;
    }

    private DataInfo(Frame fr, double[] normMul, double[] normSub, int[][] catLevels, int responses, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean weight, boolean offset, boolean fold) {
        int i;
        this._offset = offset;
        this._weights = weight;
        this._fold = fold;
        this._valid = false;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._skipMissing = skipMissing;
        this._imputeMissing = imputeMissing;
        this._adaptedFrame = fr;
        this._catOffsets = MemoryManager.malloc4((int)(catLevels.length + 1));
        this._catMissing = new boolean[catLevels.length];
        Arrays.fill(this._catMissing, !imputeMissing && !skipMissing);
        int s = 0;
        for (i = 0; i < catLevels.length; ++i) {
            this._catOffsets[i] = s;
            s += catLevels[i].length;
        }
        this._catLvls = catLevels;
        this._catOffsets[this._catOffsets.length - 1] = s;
        this._responses = responses;
        this._cats = catLevels.length;
        this._nums = fr.numCols() - this._cats - responses - (this._offset ? 1 : 0) - (this._weights ? 1 : 0) - (this._fold ? 1 : 0);
        this._useAllFactorLevels = true;
        this._catModes = new int[this._cats];
        this._numMeans = new double[this._nums];
        this._normMul = normMul;
        this._normSub = normSub;
        for (i = 0; i < this._cats; ++i) {
            this._catModes[i] = DataInfo.imputeCat(this._adaptedFrame.vec(i));
        }
        for (i = 0; i < this._nums; ++i) {
            this._numMeans[i] = this._adaptedFrame.vec(this._cats + i).mean();
        }
    }

    public static int imputeCat(Vec v) {
        if (v.isCategorical()) {
            return v.mode();
        }
        return (int)Math.round(v.mean());
    }

    public DataInfo filterExpandedColumns(int[] cols) {
        int k;
        int hasIcpt;
        assert (this._predictor_transform != null);
        assert (this._response_transform != null);
        int n = hasIcpt = cols.length > 0 && cols[cols.length - 1] == this.fullN() ? 1 : 0;
        if (cols == null) {
            return this.deep_clone();
        }
        int i = 0;
        int j = 0;
        int ignoredCnt = 0;
        int[][] catLvls = new int[this._cats][];
        int[] ignoredCols = MemoryManager.malloc4((int)(this._nums + this._cats));
        if (this._catOffsets != null) {
            int coff;
            int n2 = coff = this._useAllFactorLevels ? 0 : 1;
            while (i < cols.length && cols[i] < this._catOffsets[this._catOffsets.length - 1]) {
                int[] levels = MemoryManager.malloc4((int)(this._catOffsets[j + 1] - this._catOffsets[j]));
                int k2 = 0;
                while (i < cols.length && cols[i] < this._catOffsets[j + 1]) {
                    levels[k2++] = cols[i++] - this._catOffsets[j] + coff;
                }
                if (k2 > 0) {
                    catLvls[j] = Arrays.copyOf(levels, k2);
                }
                ++j;
            }
        }
        for (int k3 = 0; k3 < catLvls.length; ++k3) {
            if (catLvls[k3] != null) continue;
            ignoredCols[ignoredCnt++] = k3;
        }
        if (ignoredCnt > 0) {
            int[][] c = new int[this._cats - ignoredCnt][];
            int y = 0;
            for (int[] catLvl : catLvls) {
                if (catLvl == null) continue;
                c[y++] = catLvl;
            }
            assert (y == c.length);
            catLvls = c;
        }
        j = 0;
        int prev = 0;
        while (i < cols.length) {
            for (int k4 = prev; k4 < cols[i] - this.numStart(); ++k4) {
                ignoredCols[ignoredCnt++] = k4 + this._cats;
                ++j;
            }
            prev = ++j;
            ++i;
        }
        for (int k5 = prev; k5 < this._nums; ++k5) {
            ignoredCols[ignoredCnt++] = k5 + this._cats;
        }
        Frame f = new Frame((String[])this._adaptedFrame.names().clone(), (Vec[])this._adaptedFrame.vecs().clone());
        if (ignoredCnt > 0) {
            f.remove(Arrays.copyOf(ignoredCols, ignoredCnt));
        }
        assert (catLvls.length < f.numCols()) : "cats = " + catLvls.length + " numcols = " + f.numCols();
        double[] normSub = null;
        double[] normMul = null;
        int id = Arrays.binarySearch(cols, this.numStart());
        if (id < 0) {
            id = -id - 1;
        }
        int nnums = cols.length - id - hasIcpt;
        int off = this.numStart();
        if (this._normSub != null) {
            normSub = new double[nnums];
            for (k = id; k < id + nnums; ++k) {
                normSub[k - id] = this._normSub[cols[k] - off];
            }
        }
        if (this._normMul != null) {
            normMul = new double[nnums];
            for (k = id; k < id + nnums; ++k) {
                normMul[k - id] = this._normMul[cols[k] - off];
            }
        }
        DataInfo dinfo = new DataInfo(f, normMul, normSub, catLvls, this._responses, this._predictor_transform, this._response_transform, this._skipMissing, this._imputeMissing, this._weights, this._offset, this._fold);
        dinfo._activeCols = cols;
        return dinfo;
    }

    public void updateWeightedSigmaAndMean(double[] sigmas, double[] mean) {
        if (this._predictor_transform.isSigmaScaled()) {
            if (sigmas.length != this._normMul.length) {
                throw new IllegalArgumentException("Length of sigmas does not match number of scaled columns.");
            }
            for (int i = 0; i < sigmas.length; ++i) {
                this._normMul[i] = sigmas[i] != 0.0 ? 1.0 / sigmas[i] : 1.0;
            }
        }
        if (this._predictor_transform.isMeanAdjusted()) {
            if (mean.length != this._normSub.length) {
                throw new IllegalArgumentException("Length of means does not match number of scaled columns.");
            }
            System.arraycopy(mean, 0, this._normSub, 0, mean.length);
        }
    }

    public void updateWeightedSigmaAndMeanForResponse(double[] sigmas, double[] mean) {
        if (this._response_transform.isSigmaScaled()) {
            if (sigmas.length != this._normRespMul.length) {
                throw new IllegalArgumentException("Length of sigmas does not match number of scaled columns.");
            }
            for (int i = 0; i < sigmas.length; ++i) {
                this._normRespMul[i] = sigmas[i] != 0.0 ? 1.0 / sigmas[i] : 1.0;
            }
        }
        if (this._response_transform.isMeanAdjusted()) {
            if (mean.length != this._normRespSub.length) {
                throw new IllegalArgumentException("Length of means does not match number of scaled columns.");
            }
            System.arraycopy(mean, 0, this._normRespSub, 0, mean.length);
        }
    }

    private void setTransform(TransformType t, double[] normMul, double[] normSub, int vecStart, int n) {
        for (int i = 0; i < n; ++i) {
            Vec v = this._adaptedFrame.vec(vecStart + i);
            switch (t) {
                case STANDARDIZE: {
                    normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    normSub[i] = v.mean();
                    break;
                }
                case NORMALIZE: {
                    normMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                    normSub[i] = v.mean();
                    break;
                }
                case DEMEAN: {
                    normMul[i] = 1.0;
                    normSub[i] = v.mean();
                    break;
                }
                case DESCALE: {
                    normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    normSub[i] = 0.0;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            assert (!Double.isNaN(normMul[i]));
            assert (!Double.isNaN(normSub[i]));
        }
    }

    public void setPredictorTransform(TransformType t) {
        this._predictor_transform = t;
        if (t == TransformType.NONE) {
            this._normMul = null;
            this._normSub = null;
        } else {
            this._normMul = MemoryManager.malloc8d((int)this._nums);
            this._normSub = MemoryManager.malloc8d((int)this._nums);
            this.setTransform(t, this._normMul, this._normSub, this._cats, this._nums);
        }
    }

    public void setResponseTransform(TransformType t) {
        this._response_transform = t;
        if (t == TransformType.NONE) {
            this._normRespMul = null;
            this._normRespSub = null;
        } else {
            this._normRespMul = MemoryManager.malloc8d((int)this._responses);
            this._normRespSub = MemoryManager.malloc8d((int)this._responses);
            this.setTransform(t, this._normRespMul, this._normRespSub, this._adaptedFrame.numCols() - this._responses, this._responses);
        }
    }

    public final int fullN() {
        return this._nums + this._catOffsets[this._cats];
    }

    public final int largestCat() {
        return this._cats > 0 ? this._catOffsets[1] : 0;
    }

    public final int numStart() {
        return this._catOffsets[this._cats];
    }

    public final String[] coefNames() {
        if (this._coefNames != null) {
            return this._coefNames;
        }
        int k = 0;
        int n = this.fullN();
        String[] res = new String[n];
        Vec[] vecs = this._adaptedFrame.vecs();
        for (int i = 0; i < this._cats; ++i) {
            int j;
            int n2 = j = this._useAllFactorLevels ? 0 : 1;
            while (j < vecs[i].domain().length) {
                int jj = this.getCategoricalId(i, j);
                if (jj >= 0) {
                    res[k++] = this._adaptedFrame._names[i] + "." + vecs[i].domain()[j];
                }
                ++j;
            }
            if (!this._catMissing[i] || this.getCategoricalId(i, vecs[i].domain().length) < 0) continue;
            res[k++] = this._adaptedFrame._names[i] + ".missing(NA)";
        }
        int nums = n - k;
        System.arraycopy(this._adaptedFrame._names, this._cats, res, k, nums);
        this._coefNames = res;
        return res;
    }

    public int[] mapNames(String[] names) {
        assert (names.length == this._adaptedFrame._names.length) : "Names must be the same length!";
        int[] idx = new int[names.length];
        Arrays.fill(idx, -1);
        block0: for (int i = 0; i < this._adaptedFrame._names.length; ++i) {
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equals(this._adaptedFrame.name(i))) continue;
                idx[i] = j;
                continue block0;
            }
        }
        return idx;
    }

    public final void unScaleNumericals(double[] in, double[] out) {
        if (this._nums == 0) {
            return;
        }
        assert (in.length == out.length);
        assert (in.length == this.fullN());
        for (int k = this.numStart(); k < this.fullN(); ++k) {
            double m = this._normMul == null ? 1.0 : this._normMul[k - this.numStart()];
            double s = this._normSub == null ? 0.0 : this._normSub[k - this.numStart()];
            out[k] = in[k] / m + s;
        }
    }

    public final int getCategoricalId(int cid, int val) {
        int c = this._catLvls[cid] != null ? Arrays.binarySearch(this._catLvls[cid], val) : val - (this._useAllFactorLevels ? 0 : 1);
        if (c < 0) {
            return -1;
        }
        int v = c + this._catOffsets[cid];
        if (v >= this._catOffsets[cid + 1]) {
            assert (this._valid) : "categorical value out of bounds, got " + v + ", next cat starts at " + this._catOffsets[cid + 1];
            return this._catMissing[cid] ? this._catOffsets[cid + 1] - 1 : -2;
        }
        return v;
    }

    public final Row extractDenseRow(double[] vals, Row row) {
        int off;
        row.bad = false;
        row.rid = 0L;
        row.cid = 0;
        if (row.weight == 0.0) {
            return row;
        }
        if (this._skipMissing) {
            for (double d : vals) {
                if (!Double.isNaN(d)) continue;
                row.bad = true;
                return row;
            }
        }
        int nbins = 0;
        for (int i = 0; i < this._cats; ++i) {
            int c;
            if (Double.isNaN(vals[i])) {
                if (this._imputeMissing) {
                    c = this.getCategoricalId(i, this._catModes[i]);
                    if (c < 0) continue;
                    row.binIds[nbins++] = c;
                    continue;
                }
                if (!this._catMissing[i]) continue;
                row.binIds[nbins++] = this._catOffsets[i + 1] - 1;
                continue;
            }
            c = this.getCategoricalId(i, (int)vals[i]);
            if (c < 0) continue;
            row.binIds[nbins++] = c;
        }
        row.nBins = nbins;
        int n = this._nums;
        for (int i = 0; i < n; ++i) {
            double d;
            d = vals[this._cats + i];
            if (Double.isNaN(d)) {
                d = this._numMeans[i];
            }
            if (this._normMul != null && this._normSub != null) {
                d = (d - this._normSub[i]) * this._normMul[i];
            }
            row.numVals[i] = d;
        }
        for (int i = off = this.responseChunkId(0); i < Math.min(vals.length, off + this._responses); ++i) {
            try {
                row.response[i] = vals[this.responseChunkId(i)];
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (this._normRespMul != null) {
                row.response[i] = (row.response[i] - this._normRespSub[i]) * this._normRespMul[i];
            }
            if (!Double.isNaN(row.response[i])) continue;
            row.bad = true;
            return row;
        }
        return row;
    }

    public final Row extractDenseRow(Chunk[] chunks, int rid, Row row) {
        int i;
        int i2;
        row.bad = false;
        row.rid = (long)rid + chunks[0].start();
        row.cid = rid;
        if (this._weights) {
            row.weight = chunks[this.weightChunkId()].atd(rid);
        }
        if (row.weight == 0.0) {
            return row;
        }
        if (this._skipMissing) {
            int N = this._cats + this._nums;
            for (i2 = 0; i2 < N; ++i2) {
                if (!chunks[i2].isNA(rid)) continue;
                row.bad = true;
                return row;
            }
        }
        int nbins = 0;
        for (i2 = 0; i2 < this._cats; ++i2) {
            int c;
            if (chunks[i2].isNA(rid)) {
                if (this._imputeMissing) {
                    c = this.getCategoricalId(i2, this._catModes[i2]);
                    if (c < 0) continue;
                    row.binIds[nbins++] = c;
                    continue;
                }
                if (!this._catMissing[i2]) continue;
                row.binIds[nbins++] = this._catOffsets[i2 + 1] - 1;
                continue;
            }
            c = this.getCategoricalId(i2, (int)chunks[i2].at8(rid));
            if (c < 0) continue;
            row.binIds[nbins++] = c;
        }
        row.nBins = nbins;
        int n = this._nums;
        for (i = 0; i < n; ++i) {
            double d = chunks[this._cats + i].atd(rid);
            if (Double.isNaN(d)) {
                d = this._numMeans[i];
            }
            if (this._normMul != null && this._normSub != null) {
                d = (d - this._normSub[i]) * this._normMul[i];
            }
            row.numVals[i] = d;
        }
        for (i = 0; i < this._responses; ++i) {
            try {
                row.response[i] = chunks[this.responseChunkId(i)].atd(rid);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (this._normRespMul != null) {
                row.response[i] = (row.response[i] - this._normRespSub[i]) * this._normRespMul[i];
            }
            if (!Double.isNaN(row.response[i])) continue;
            row.bad = true;
            return row;
        }
        if (this._offset) {
            row.offset = chunks[this.offsetChunkId()].atd(rid);
        }
        return row;
    }

    public Vec getWeightsVec() {
        return this._adaptedFrame.vec(this.weightChunkId());
    }

    public Vec getOffsetVec() {
        return this._adaptedFrame.vec(this.offsetChunkId());
    }

    public Row newDenseRow() {
        return new Row(false, this._nums, this._cats, this._responses, 0, 0L);
    }

    public Row newDenseRow(double[] numVals, long start) {
        return new Row(false, numVals, null, null, 0, start);
    }

    public Rows rows(Chunk[] chks) {
        int cnt = 0;
        for (Chunk c : chks) {
            if (!c.isSparseZero()) continue;
            ++cnt;
        }
        return this.rows(chks, cnt > chks.length >> 1);
    }

    public Rows rows(Chunk[] chks, boolean sparse) {
        return new Rows(chks, sparse);
    }

    public final Row[] extractSparseRows(Chunk[] chunks) {
        Row row;
        int r;
        int i;
        Row[] rows = new Row[chunks[0]._len];
        long startOff = chunks[0].start();
        for (i = 0; i < rows.length; ++i) {
            rows[i] = new Row(true, Math.min(this._nums, 16), this._cats, this._responses, i, startOff);
            rows[i].rid = chunks[0].start() + (long)i;
            if (this._offset) {
                rows[i].offset = chunks[this.offsetChunkId()].atd(i);
                if (Double.isNaN(rows[i].offset)) {
                    rows[i].bad = true;
                }
            }
            if (!this._weights) continue;
            rows[i].weight = chunks[this.weightChunkId()].atd(i);
            if (!Double.isNaN(rows[i].weight)) continue;
            rows[i].bad = true;
        }
        for (i = 0; i < this._cats; ++i) {
            for (int r2 = 0; r2 < chunks[0]._len; ++r2) {
                Row row2 = rows[r2];
                if (row2.bad) continue;
                if (chunks[i].isNA(r2)) {
                    if (this._skipMissing) {
                        row2.bad = true;
                        continue;
                    }
                    row2.binIds[row2.nBins++] = this._catOffsets[i + 1] - 1;
                    continue;
                }
                int c = this.getCategoricalId(i, (int)chunks[i].at8(r2));
                if (c < 0) continue;
                row2.binIds[row2.nBins++] = c;
            }
        }
        int numStart = this.numStart();
        for (int cid = 0; cid < this._nums; ++cid) {
            Chunk c = chunks[this._cats + cid];
            int oldRow = -1;
            r = c.nextNZ(-1);
            while (r < c._len) {
                if (c.atd(r) != 0.0) {
                    assert (r > oldRow);
                    oldRow = r;
                    row = rows[r];
                    if (!row.bad) {
                        double d;
                        if (c.isNA(r)) {
                            row.bad = this._skipMissing;
                        }
                        if (Double.isNaN(d = c.atd(r))) {
                            d = this._numMeans[cid];
                        }
                        if (this._normMul != null) {
                            d *= this._normMul[cid];
                        }
                        row.addNum(cid + numStart, d);
                    }
                }
                r = c.nextNZ(r);
            }
        }
        for (int i2 = 1; i2 <= this._responses; ++i2) {
            int rid = this.responseChunkId(i2 - 1);
            Chunk rChunk = chunks[rid];
            for (r = 0; r < chunks[0]._len; ++r) {
                row = rows[r];
                if (row.bad) continue;
                row.response[i2 - 1] = rChunk.atd(r);
                if (this._normRespMul != null) {
                    row.response[i2 - 1] = (row.response[i2 - 1] - this._normRespSub[i2 - 1]) * this._normRespMul[i2 - 1];
                }
                if (!Double.isNaN(row.response[row.response.length - i2])) continue;
                row.bad = true;
            }
        }
        return rows;
    }

    public final class Rows {
        public final int _nrows;
        private final Row _denseRow;
        private final Row[] _sparseRows;
        public final boolean _sparse;
        private final Chunk[] _chks;

        private Rows(Chunk[] chks, boolean sparse) {
            this._nrows = chks[0]._len;
            this._sparse = sparse;
            long start = chks[0].start();
            if (sparse) {
                this._denseRow = null;
                this._chks = null;
                this._sparseRows = DataInfo.this.extractSparseRows(chks);
            } else {
                this._denseRow = DataInfo.this.newDenseRow();
                this._chks = chks;
                this._sparseRows = null;
            }
        }

        public Row row(int i) {
            return this._sparse ? this._sparseRows[i] : DataInfo.this.extractDenseRow(this._chks, i, this._denseRow);
        }
    }

    public final class Row
    extends Iced {
        public boolean bad;
        public double[] numVals;
        public double[] response;
        public int[] numIds;
        public int[] binIds;
        public long rid;
        public int cid;
        public int nBins;
        public int nNums;
        public int nOutpus;
        public double offset = 0.0;
        public double weight = 1.0;
        private C8DChunk[] _outputs;

        public void setOutput(int i, double v) {
            this._outputs[i].set8D(this.cid, v);
        }

        public double getOutput(int i) {
            return this._outputs[i].get8D(this.cid);
        }

        public final boolean isSparse() {
            return this.numIds != null;
        }

        public Row(boolean sparse, int nNums, int nBins, int nresponses, int i, long start) {
            this.binIds = MemoryManager.malloc4((int)nBins);
            this.numVals = MemoryManager.malloc8d((int)nNums);
            this.response = MemoryManager.malloc8d((int)nresponses);
            if (sparse) {
                this.numIds = MemoryManager.malloc4((int)nNums);
            }
            this.nNums = sparse ? 0 : nNums;
            this.cid = i;
            this.rid = start + (long)i;
        }

        public Row(boolean sparse, double[] numVals, int[] binIds, double[] response, int i, long start) {
            int nNums = numVals == null ? 0 : numVals.length;
            this.numVals = numVals;
            if (sparse) {
                this.numIds = MemoryManager.malloc4((int)nNums);
            }
            this.nNums = sparse ? 0 : nNums;
            this.nBins = binIds == null ? 0 : binIds.length;
            this.binIds = binIds;
            this.response = response;
            this.cid = i;
            this.rid = start + (long)i;
        }

        public Row(double[] nums) {
            this.numVals = nums;
            this.nNums = nums.length;
        }

        public double response(int i) {
            return this.response[i];
        }

        public double get(int i) {
            int off = DataInfo.this.numStart();
            if (i >= off) {
                if (this.numIds == null) {
                    return this.numVals[i - off];
                }
                int j = Arrays.binarySearch(this.numIds, 0, this.nNums, i);
                return j >= 0 ? this.numVals[j] : 0.0;
            }
            int j = Arrays.binarySearch(this.binIds, 0, this.nBins, i);
            return j >= 0 ? 1.0 : 0.0;
        }

        public void addNum(int id, double val) {
            if (this.numIds.length == this.nNums) {
                int newSz = Math.max(4, this.numIds.length + (this.numIds.length >> 1));
                this.numIds = Arrays.copyOf(this.numIds, newSz);
                this.numVals = Arrays.copyOf(this.numVals, newSz);
            }
            int i = this.nNums++;
            this.numIds[i] = id;
            this.numVals[i] = val;
        }

        public final double innerProduct(double[] vec) {
            int i;
            double res = 0.0;
            int numStart = DataInfo.this.numStart();
            for (i = 0; i < this.nBins; ++i) {
                res += vec[this.binIds[i]];
            }
            if (this.numIds == null || vec.length == this.nBins + this.nNums + 1) {
                for (i = 0; i < this.numVals.length; ++i) {
                    res += this.numVals[i] * vec[numStart + i];
                }
            } else {
                for (i = 0; i < this.nNums; ++i) {
                    res += this.numVals[i] * vec[this.numIds[i]];
                }
            }
            if (DataInfo.this._intercept) {
                res += vec[vec.length - 1];
            }
            return res;
        }

        public double[] expandCats() {
            int i;
            if (this.isSparse() || DataInfo.this._responses > 0) {
                throw H2O.unimpl();
            }
            int N = DataInfo.this.fullN();
            int numStart = DataInfo.this.numStart();
            double[] res = new double[N + (DataInfo.this._intercept ? 1 : 0)];
            for (i = 0; i < this.nBins; ++i) {
                res[this.binIds[i]] = 1.0;
            }
            if (this.numIds == null) {
                System.arraycopy(this.numVals, 0, res, numStart, this.numVals.length);
            } else {
                for (i = 0; i < this.nNums; ++i) {
                    res[this.numIds[i]] = this.numVals[i];
                }
            }
            if (DataInfo.this._intercept) {
                res[res.length - 1] = 1.0;
            }
            return res;
        }

        public String toString() {
            return this.rid + Arrays.toString(Arrays.copyOf(this.binIds, this.nBins)) + ", " + Arrays.toString(this.numVals);
        }

        public void setResponse(int i, double z) {
            this.response[i] = z;
        }
    }

    public static enum TransformType {
        NONE,
        STANDARDIZE,
        NORMALIZE,
        DEMEAN,
        DESCALE;


        public boolean isMeanAdjusted() {
            switch (this) {
                case NONE: 
                case DESCALE: 
                case NORMALIZE: {
                    return false;
                }
                case STANDARDIZE: 
                case DEMEAN: {
                    return true;
                }
            }
            throw H2O.unimpl();
        }

        public boolean isSigmaScaled() {
            switch (this) {
                case NONE: 
                case NORMALIZE: 
                case DEMEAN: {
                    return false;
                }
                case DESCALE: 
                case STANDARDIZE: {
                    return true;
                }
            }
            throw H2O.unimpl();
        }
    }
}

