/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.FrameTask2;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.gram.Gram;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.util.ArrayUtils;
import water.util.MathUtils;

public abstract class GLMTask {
    static double computeMultinomialEtas(DataInfo.Row row, double[][] beta, double[] etas, double[] etaOffsets, double[] exps) {
        double maxRow = 0.0;
        for (int c = 0; c < beta.length; ++c) {
            double e = etaOffsets[c] + row.innerProduct(beta[c]);
            if (e > maxRow) {
                maxRow = e;
            }
            etas[c] = e;
        }
        double sumExp = 0.0;
        for (int c = 0; c < beta.length; ++c) {
            double x = Math.exp(etas[c] - maxRow);
            sumExp += x;
            exps[c + 1] = x;
        }
        double reg = 1.0 / sumExp;
        for (int c = 0; c < etas.length; ++c) {
            int n = c + 1;
            exps[n] = exps[n] * reg;
        }
        exps[0] = 0.0;
        exps[0] = ArrayUtils.maxIndex((double[])exps) - 1;
        return Math.log(sumExp) + maxRow;
    }

    public static class ComputeSETsk
    extends FrameTask2<ComputeSETsk> {
        final double[] _betaNew;
        double _sumsqe;
        double _wsum;
        transient double _sparseOffsetOld = 0.0;
        transient double _sparseOffsetNew = 0.0;
        final GLMModel.GLMWeightsFun _glmf;
        transient GLMModel.GLMWeights _glmw;

        public ComputeSETsk(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] betaNew, GLMModel.GLMParameters parms) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
            this._betaNew = betaNew;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffsetNew = GLM.sparseOffset(this._betaNew, this._dinfo);
            }
            this._glmw = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            double z = r.response(0) - r.offset;
            double w = r.weight;
            if (this._glmf._family != GLMModel.GLMParameters.Family.gaussian) {
                double etaOld = r.innerProduct(this._betaNew) + this._sparseOffsetNew;
                this._glmf.computeWeights(r.response(0), etaOld, r.offset, r.weight, this._glmw);
                z = this._glmw.z;
                w = this._glmw.w;
            }
            double eta = r.innerProduct(this._betaNew) + this._sparseOffsetNew;
            this._sumsqe += w * (eta - z) * (eta - z);
            this._wsum += Math.sqrt(w);
        }

        public void reduce(ComputeSETsk c) {
            this._sumsqe += c._sumsqe;
            this._wsum += c._wsum;
        }
    }

    public static class GLMGenerateWeightsTask
    extends MRTask<GLMGenerateWeightsTask> {
        final GLMModel.GLMParameters _params;
        final double[] _betaw;
        double[] denums;
        double wsum;
        double wsumu;
        DataInfo _dinfo;
        double _likelihood;

        public GLMGenerateWeightsTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters glm, double[] betaw) {
            this._params = glm;
            this._betaw = betaw;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            Chunk wChunk = chunks[chunks.length - 3];
            Chunk zChunk = chunks[chunks.length - 2];
            Chunk zTilda = chunks[chunks.length - 1];
            chunks = Arrays.copyOf(chunks, chunks.length - 3);
            this.denums = new double[this._dinfo.fullN() + 1];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                int j;
                double mu;
                double z;
                double w;
                this._dinfo.extractDenseRow(chunks, i, r);
                if (r.bad || r.weight == 0.0) {
                    wChunk.set(i, 0L);
                    zChunk.set(i, 0L);
                    zTilda.set(i, 0L);
                    continue;
                }
                double y = r.response(0);
                assert (this._params._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
                assert (this._params._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
                int numStart = this._dinfo.numStart();
                double d = 1.0;
                double eta = r.innerProduct(this._betaw);
                if (this._params._family == GLMModel.GLMParameters.Family.gaussian && this._params._link == GLMModel.GLMParameters.Link.identity) {
                    w = r.weight;
                    z = y - r.offset;
                    mu = 0.0;
                } else {
                    mu = this._params.linkInv(eta + r.offset);
                    double var = Math.max(1.0E-6, this._params.variance(mu));
                    d = this._params.linkDeriv(mu);
                    z = eta + (y - mu) * d;
                    w = r.weight / (var * d * d);
                }
                this._likelihood += this._params.likelihood(y, mu);
                zTilda.set(i, eta - this._betaw[this._betaw.length - 1]);
                assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
                wChunk.set(i, w);
                zChunk.set(i, z);
                this.wsum += w;
                this.wsumu += r.weight;
                for (j = 0; j < r.nBins; ++j) {
                    int n = r.binIds[j];
                    this.denums[n] = this.denums[n] + w;
                }
                for (j = 0; j < r.nNums; ++j) {
                    int id;
                    int n = id = r.numIds == null ? j + numStart : r.numIds[j];
                    this.denums[n] = this.denums[n] + w * r.get(id) * r.get(id);
                }
            }
        }

        public void reduce(GLMGenerateWeightsTask git) {
            ArrayUtils.add((double[])this.denums, (double[])git.denums);
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqIntercept
    extends MRTask<GLMCoordinateDescentTaskSeqIntercept> {
        final double[] _betaold;
        public double _temp;
        DataInfo _dinfo;

        public GLMCoordinateDescentTaskSeqIntercept(double[] betaold, DataInfo dinfo) {
            this._betaold = betaold;
            this._dinfo = dinfo;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk filterChunk = chunks[cnt++];
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int i = 0; i < chunks[0]._len; ++i) {
                if (filterChunk.atd(i) == 1.0) continue;
                this._dinfo.extractDenseRow(chunks, i, r);
                this._temp = (double)wChunk.at8(i) * (zChunk.atd(i) - r.innerProduct(this._betaold));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqIntercept git) {
            this._temp += git._temp;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMCoordinateDescentTaskSeqNaive
    extends MRTask<GLMCoordinateDescentTaskSeqNaive> {
        public double[] _normMulold;
        public double[] _normSubold;
        public double[] _normMulnew;
        public double[] _normSubnew;
        final double[] _betaold;
        final double[] _betanew;
        final int[] _catLvls_new;
        final int[] _catLvls_old;
        public double[] _temp;
        boolean _skipFirst;
        long _nobs;
        int _cat_num;
        boolean _interceptnew;
        boolean _interceptold;

        public GLMCoordinateDescentTaskSeqNaive(boolean interceptold, boolean interceptnew, int cat_num, double[] betaold, double[] betanew, int[] catLvlsold, int[] catLvlsnew, double[] normMulold, double[] normSubold, double[] normMulnew, double[] normSubnew, boolean skipFirst) {
            this._normMulold = normMulold;
            this._normSubold = normSubold;
            this._normMulnew = normMulnew;
            this._normSubnew = normSubnew;
            this._cat_num = cat_num;
            this._betaold = betaold;
            this._betanew = betanew;
            this._interceptold = interceptold;
            this._interceptnew = interceptnew;
            this._catLvls_old = catLvlsold;
            this._catLvls_new = catLvlsnew;
            this._skipFirst = skipFirst;
        }

        public void map(Chunk[] chunks) {
            int cnt = 0;
            Chunk wChunk = chunks[cnt++];
            Chunk zChunk = chunks[cnt++];
            Chunk ztildaChunk = chunks[cnt++];
            Chunk xpChunk = null;
            Chunk xChunk = null;
            this._temp = new double[this._betaold.length];
            if (this._interceptnew) {
                xChunk = new C0DChunk(1.0, chunks[0]._len);
                xpChunk = chunks[cnt++];
            } else if (this._interceptold) {
                xChunk = chunks[cnt++];
                xpChunk = new C0DChunk(1.0, chunks[0]._len);
            } else {
                xChunk = chunks[cnt++];
                xpChunk = chunks[cnt++];
            }
            for (int i = 0; i < chunks[0]._len; ++i) {
                double betanew = 0.0;
                double betaold = 0.0;
                double w = wChunk.atd(i);
                if (w == 0.0) continue;
                ++this._nobs;
                int observation_level = 0;
                int observation_level_p = 0;
                double val = 1.0;
                double valp = 1.0;
                if (this._cat_num == 1) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                        --observation_level_p;
                    }
                } else if (this._cat_num == 2) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    observation_level_p = (int)xpChunk.at8(i);
                    if (this._catLvls_new != null) {
                        observation_level_p = Arrays.binarySearch(this._catLvls_new, observation_level_p);
                    }
                    if (this._skipFirst) {
                        --observation_level_p;
                    }
                } else if (this._cat_num == 3) {
                    val = xChunk.atd(i);
                    if (this._normMulold != null && this._normSubold != null) {
                        val = (val - this._normSubold[0]) * this._normMulold[0];
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                } else if (this._cat_num == 4) {
                    observation_level = (int)xChunk.at8(i);
                    if (this._catLvls_old != null) {
                        observation_level = Arrays.binarySearch(this._catLvls_old, observation_level);
                    }
                    if (this._skipFirst) {
                        --observation_level;
                    }
                    valp = xpChunk.atd(i);
                    if (this._normMulnew != null && this._normSubnew != null) {
                        valp = (valp - this._normSubnew[0]) * this._normMulnew[0];
                    }
                }
                if (observation_level >= 0) {
                    betaold = this._betaold[observation_level];
                }
                if (observation_level_p >= 0) {
                    betanew = this._betanew[observation_level_p];
                }
                if (this._interceptnew) {
                    ztildaChunk.set(i, ztildaChunk.atd(i) - betaold + valp * betanew);
                    this._temp[0] = this._temp[0] + w * (zChunk.atd(i) - ztildaChunk.atd(i));
                    continue;
                }
                ztildaChunk.set(i, ztildaChunk.atd(i) - val * betaold + valp * betanew);
                if (observation_level < 0) continue;
                int n = observation_level;
                this._temp[n] = this._temp[n] + w * val * (zChunk.atd(i) - ztildaChunk.atd(i));
            }
        }

        public void reduce(GLMCoordinateDescentTaskSeqNaive git) {
            ArrayUtils.add((double[])this._temp, (double[])git._temp);
            this._nobs += git._nobs;
            super.reduce((MRTask)git);
        }
    }

    public static class GLMIterationTask
    extends FrameTask2<GLMIterationTask> {
        final GLMModel.GLMWeightsFun _glmf;
        double[][] _beta_multinomial;
        double[] _beta;
        protected Gram _gram;
        double[] _xy;
        final double[] _ymu;
        long _nobs;
        public double _likelihood;
        private transient GLMModel.GLMWeights _w;
        double wsum;
        double wsumu;
        double _sumsqe;
        int _c = -1;
        private transient double _sparseOffset;

        public GLMIterationTask(Key jobKey, DataInfo dinfo, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._ymu = null;
            this._glmf = glmw;
        }

        public GLMIterationTask(Key jobKey, DataInfo dinfo, GLMModel.GLMWeightsFun glmw, double[] beta, int c) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._ymu = null;
            this._glmf = glmw;
            this._c = c;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
            this._w = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double w;
            double wz;
            if (r.bad || r.weight == 0.0) {
                return;
            }
            ++this._nobs;
            double y = r.response(0);
            int numStart = this._dinfo.numStart();
            if (this._glmf._family == GLMModel.GLMParameters.Family.multinomial) {
                y = y == (double)this._c ? 1.0 : 0.0;
                double mu = r.response(1);
                double eta = r.response(2);
                double d = mu * (1.0 - mu);
                wz = r.weight * (eta * d + (y - mu));
                w = r.weight * d;
            } else if (this._beta != null) {
                this._glmf.computeWeights(y, r.innerProduct(this._beta) + this._sparseOffset, r.offset, r.weight, this._w);
                w = this._w.w;
                wz = w * this._w.z;
            } else {
                w = r.weight;
                wz = w * (y - r.offset);
            }
            this.wsum += w;
            this.wsumu += r.weight;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        public void reduce(GLMIterationTask git) {
            ArrayUtils.add((double[])this._xy, (double[])git._xy);
            this._gram.add(git._gram);
            this._nobs += git._nobs;
            this.wsum += git.wsum;
            this.wsumu += git.wsumu;
            this._likelihood += git._likelihood;
            this._sumsqe += git._sumsqe;
            super.reduce((MRTask)git);
        }

        protected void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
        }

        public boolean hasNaNsOrInf() {
            return ArrayUtils.hasNaNsOrInfs((double[])this._xy) || this._gram.hasNaNsOrInfs();
        }
    }

    public static class GLMMultinomialUpdate
    extends FrameTask2<GLMMultinomialUpdate> {
        private final double[][] _beta;
        private final int _c;
        private transient double[] _sparseOffsets;
        private transient double[] _etas;
        private transient Chunk _sumExpChunk;
        private transient Chunk _maxRowChunk;

        public GLMMultinomialUpdate(DataInfo dinfo, Key jobKey, double[] beta, int c) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix((double[])beta, (int)(dinfo.fullN() + 1));
            this._c = c;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d((int)this._beta.length);
            this._etas = MemoryManager.malloc8d((int)this._beta.length);
            if (this._sparse) {
                for (int i = 0; i < this._beta.length; ++i) {
                    this._sparseOffsets[i] = GLM.sparseOffset(this._beta[i], this._dinfo);
                }
            }
        }

        @Override
        public void map(Chunk[] chks) {
            this._sumExpChunk = chks[chks.length - 2];
            this._maxRowChunk = chks[chks.length - 1];
            super.map(chks);
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            double maxrow = 0.0;
            for (int i = 0; i < this._beta.length; ++i) {
                this._etas[i] = r.innerProduct(this._beta[i]) + this._sparseOffsets[i];
                if (!(this._etas[i] > maxrow)) continue;
                maxrow = this._etas[i];
            }
            double sumExp = 0.0;
            for (int i = 0; i < this._beta.length; ++i) {
                sumExp += Math.exp(this._etas[i] - maxrow);
            }
            this._maxRowChunk.set(r.cid, this._etas[this._c]);
            this._sumExpChunk.set(r.cid, Math.exp(this._etas[this._c] - maxrow) / sumExp);
        }
    }

    public static class GLMIterationTaskMultinomial
    extends FrameTask2<GLMIterationTaskMultinomial> {
        final int _c;
        final double[] _beta;
        double[] _xy;
        Gram _gram;
        transient double _sparseOffset;

        public GLMIterationTaskMultinomial(DataInfo dinfo, Key jobKey, double[] beta, int c) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._c = c;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double mu;
            double y = r.response(0);
            double sumExp = r.response(1);
            double maxRow = r.response(2);
            int numStart = this._dinfo.numStart();
            y = y == (double)this._c ? 1.0 : 0.0;
            double eta = r.innerProduct(this._beta) + this._sparseOffset;
            if (eta > maxRow) {
                maxRow = eta;
            }
            double etaExp = Math.exp(eta - maxRow);
            double d = mu = etaExp == Double.POSITIVE_INFINITY ? 1.0 : etaExp / (sumExp += etaExp);
            if (mu < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d2 = mu * (1.0 - mu);
            double wz = r.weight * (eta * d2 + (y - mu));
            double w = r.weight * d2;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        public void reduce(GLMIterationTaskMultinomial glmt) {
            ArrayUtils.add((double[])this._xy, (double[])glmt._xy);
            this._gram.add(glmt._gram);
        }
    }

    public static class GLMMultinomialWLSTask
    extends LSTask {
        final GLMModel.GLMWeightsFun _glmw;
        final double[] _beta;
        double _sparseOffset;
        private transient GLMModel.GLMWeights _ws;

        public GLMMultinomialWLSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(cmp, dinfo, jobKey);
            this._glmw = glmw;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ws = new GLMModel.GLMWeights();
        }

        @Override
        public void processRow(DataInfo.Row r) {
            double eta = r.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(r.response(0), eta, r.weight, r.offset, this._ws);
            r.weight = this._ws.w;
            r.offset = 0.0;
            r.setResponse(0, this._ws.z);
            super.processRow(r);
        }
    }

    public static class GLMWLSTask
    extends LSTask {
        final GLMModel.GLMWeightsFun _glmw;
        final double[] _beta;
        double _sparseOffset;
        private transient GLMModel.GLMWeights _ws;

        public GLMWLSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, GLMModel.GLMWeightsFun glmw, double[] beta) {
            super(cmp, dinfo, jobKey);
            this._glmw = glmw;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            super.chunkInit();
            this._ws = new GLMModel.GLMWeights();
        }

        @Override
        public void processRow(DataInfo.Row r) {
            double eta = r.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(r.response(0), eta, r.weight, r.offset, this._ws);
            r.weight = this._ws.w;
            r.offset = 0.0;
            r.setResponse(0, this._ws.z);
            super.processRow(r);
        }
    }

    public static class LSTask
    extends FrameTask2<LSTask> {
        public double[] _xy;
        public Gram _gram;
        final int numStart;

        public LSTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this.numStart = this._dinfo.numStart();
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int i;
            double wz = r.weight * (r.response(0) - r.offset);
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + this.numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, r.weight);
        }

        public void reduce(LSTask lst) {
            ArrayUtils.add((double[])this._xy, (double[])lst._xy);
            this._gram.add(lst._gram);
        }

        public void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
        }
    }

    static class GLMMultinomialGradientTask
    extends FrameTask2<GLMMultinomialGradientTask> {
        final double[][] _beta;
        final transient double _currentLambda;
        final transient double _reg;
        double[] _gradient;
        double _likelihood;
        private transient double[] _etas;
        private transient double[] _exps;
        private transient double[] _etaOffsets;

        public GLMMultinomialGradientTask(Key jobKey, DataInfo dinfo, double lambda, double[][] beta, double reg, boolean validate, H2O.H2OCountedCompleter cmp) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._currentLambda = lambda;
            this._reg = reg;
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            this._gradient = new double[this._beta.length * this._beta[0].length];
            this._etas = new double[this._beta.length];
            this._exps = new double[this._beta.length + 1];
            this._etaOffsets = new double[this._beta.length];
            if (this._sparse) {
                for (int i = 0; i < this._etaOffsets.length; ++i) {
                    this._etaOffsets[i] = GLM.sparseOffset(this._beta[i], this._dinfo);
                }
            }
        }

        @Override
        protected final void processRow(DataInfo.Row row) {
            int y = (int)row.response(0);
            assert ((double)y == row.response(0));
            double logSumExp = GLMTask.computeMultinomialEtas(row, this._beta, this._etas, this._etaOffsets, this._exps);
            int P = this._beta[0].length;
            this._likelihood -= row.weight * (this._etas[(int)row.response(0)] - logSumExp);
            int numOff = this._dinfo.numStart();
            for (int c = 0; c < this._beta.length; ++c) {
                int j;
                double val = row.weight * (this._exps[c + 1] - (double)(y == c ? 1 : 0));
                for (j = 0; j < row.nBins; ++j) {
                    int n = c * P + row.binIds[j];
                    this._gradient[n] = this._gradient[n] + val;
                }
                for (j = 0; j < row.nNums; ++j) {
                    int n = c * P + (row.numIds == null ? j + numOff : row.numIds[j]);
                    this._gradient[n] = this._gradient[n] + row.numVals[j] * val;
                }
                int n = (c + 1) * P - 1;
                this._gradient[n] = this._gradient[n] + val;
            }
        }

        public void reduce(GLMMultinomialGradientTask gmgt) {
            ArrayUtils.add((double[])this._gradient, (double[])gmgt._gradient);
            this._likelihood += gmgt._likelihood;
        }

        public void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int off = this._dinfo.numStart();
                int P = this._beta[0].length;
                for (int c = 0; c < this._beta.length; ++c) {
                    double val = this._gradient[(c + 1) * P - 1];
                    for (int i = 0; i < this._dinfo._nums; ++i) {
                        int n = c * P + off + i;
                        this._gradient[n] = this._gradient[n] - val * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    }
                }
            }
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            int P = this._beta[0].length;
            for (int c = 0; c < this._beta.length; ++c) {
                for (int j = 0; j < P - 1; ++j) {
                    int n = c * P + j;
                    this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[c][j];
                }
            }
        }
    }

    static class GLMGaussianGradientTask
    extends GLMGradientTask {
        public GLMGaussianGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            assert (parms._family == GLMModel.GLMParameters.Family.gaussian && parms._link == GLMModel.GLMParameters.Link.identity);
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double[] g = this._gradient;
            double[] b = this._beta;
            double y = row.response(0);
            double eta = row.innerProduct(b) + this._sparseOffset + row.offset;
            double diff = y - eta;
            this._likelihood += row.weight * diff * diff;
            double gval = row.weight * (eta - y);
            for (int i = 0; i < row.nBins; ++i) {
                int n = row.binIds[i];
                g[n] = g[n] + gval;
            }
            int off = this._dinfo.numStart();
            for (int j = 0; j < row.nNums; ++j) {
                int n = row.numIds == null ? j + off : row.numIds[j];
                this._gradient[n] = this._gradient[n] + row.numVals[j] * gval;
            }
            int n = g.length - 1;
            g[n] = g[n] + gval;
        }
    }

    static class GLMBinomialGradientTask
    extends GLMGradientTask {
        public GLMBinomialGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            assert (parms._family == GLMModel.GLMParameters.Family.binomial && parms._link == GLMModel.GLMParameters.Link.logit);
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double[] g = this._gradient;
            double[] b = this._beta;
            double y = -1.0 + 2.0 * row.response(0);
            double eta = row.innerProduct(b) + this._sparseOffset + row.offset;
            double d = 1.0 + Math.exp(-y * eta);
            this._likelihood += row.weight * Math.log(d);
            double gval = row.weight * -y * (1.0 - 1.0 / d);
            for (int i = 0; i < row.nBins; ++i) {
                int n = row.binIds[i];
                g[n] = g[n] + gval;
            }
            int off = this._dinfo.numStart();
            for (int j = 0; j < row.nNums; ++j) {
                int n = row.numIds == null ? j + off : row.numIds[j];
                this._gradient[n] = this._gradient[n] + row.numVals[j] * gval;
            }
            int n = g.length - 1;
            g[n] = g[n] + gval;
        }
    }

    static class GLMGenericGradientTask
    extends GLMGradientTask {
        private final GLMModel.GLMWeightsFun _glmf;

        public GLMGenericGradientTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double lambda, double[] beta) {
            super(jobKey, dinfo, parms._obj_reg, lambda, beta);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double eta = row.innerProduct(this._beta) + this._sparseOffset + row.offset;
            double mu = this._glmf.linkInv(eta);
            double[] g = this._gradient;
            this._likelihood += row.weight * this._glmf.likelihood(row.response(0), mu);
            double var = this._glmf.variance(mu);
            if (var < 1.0E-6) {
                var = 1.0E-6;
            }
            double gval = row.weight * (mu - row.response(0)) / (var * this._glmf.linkDeriv(mu));
            for (int i = 0; i < row.nBins; ++i) {
                int n = row.binIds[i];
                g[n] = g[n] + gval;
            }
            int off = this._dinfo.numStart();
            for (int j = 0; j < this._dinfo._nums; ++j) {
                int n = j + off;
                g[n] = g[n] + row.numVals[j] * gval;
            }
            if (this._dinfo._intercept) {
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }
    }

    static abstract class GLMGradientTask
    extends FrameTask2<GLMGradientTask> {
        final double[] _beta;
        public double[] _gradient;
        public double _likelihood;
        final transient double _currentLambda;
        final transient double _reg;
        protected transient double _sparseOffset;

        protected GLMGradientTask(Key jobKey, DataInfo dinfo, double reg, double lambda, double[] beta) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._reg = reg;
            this._currentLambda = lambda;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public final void chunkInit() {
            int icptId = this._dinfo.fullN();
            this._gradient = MemoryManager.malloc8d((int)(icptId + 1));
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        public final void reduce(GLMGradientTask gmgt) {
            ArrayUtils.add((double[])this._gradient, (double[])gmgt._gradient);
            this._likelihood += gmgt._likelihood;
        }

        public final void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int numStart = this._dinfo.numStart();
                for (int i = 0; i < this._dinfo._normSub.length; ++i) {
                    double d = this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    int n = numStart + i;
                    this._gradient[n] = this._gradient[n] - d * this._gradient[this._gradient.length - 1];
                }
            }
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            for (int j = 0; j < this._beta.length - 1; ++j) {
                int n = j;
                this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[j];
            }
        }
    }

    static class GLMBinomialWeightsTask
    extends FrameTask2<GLMGenericWeightsTask> {
        final double[] _beta;
        double _sparseOffset;
        double _likelihood;

        public GLMBinomialWeightsTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] beta) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double y = row.response(0);
            double eta = row.innerProduct(this._beta) + this._sparseOffset;
            double mu = 1.0 / (Math.exp(-eta) + 1.0);
            if (mu < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d = mu * (1.0 - mu);
            row.setOutput(0, row.weight * d);
            row.setOutput(1, eta + (y - mu) / d);
            this._likelihood += row.weight * (MathUtils.y_log_y((double)y, (double)mu) + MathUtils.y_log_y((double)(1.0 - y), (double)(1.0 - mu)));
        }

        public void reduce(GLMGenericWeightsTask gwt) {
            this._likelihood += gwt._likelihood;
        }
    }

    static class GLMMultinomialWeightsTask
    extends FrameTask2<GLMGenericWeightsTask> {
        final double[] _beta;
        double _sparseOffset;
        double _likelihood;
        final int classId;

        public GLMMultinomialWeightsTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] beta, int cid) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this.classId = cid;
        }

        @Override
        public void chunkInit() {
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double sumExp;
            double etaExp;
            double mu;
            double y = row.response(0);
            double maxRow = row.getOutput(2);
            double etaY = row.getOutput(3);
            double eta = row.innerProduct(this._beta) + this._sparseOffset;
            if ((double)this.classId == y) {
                etaY = eta;
                row.setOutput(3, eta);
            }
            if (eta > maxRow) {
                maxRow = eta;
                row.setOutput(2, eta);
            }
            if ((mu = (etaExp = Math.exp(eta - maxRow)) / (sumExp = row.getOutput(4) + etaExp)) < 1.0E-16) {
                mu = 1.0E-16;
            }
            double d = mu * (1.0 - mu);
            row.setOutput(0, row.weight * d);
            row.setOutput(1, eta + (y - mu) / d);
            this._likelihood += row.weight * (etaY - Math.log(sumExp) - maxRow);
        }

        public void reduce(GLMGenericWeightsTask gwt) {
            this._likelihood += gwt._likelihood;
        }
    }

    static class GLMGenericWeightsTask
    extends FrameTask2<GLMGenericWeightsTask> {
        final double[] _beta;
        double _sparseOffset;
        private final GLMModel.GLMWeightsFun _glmw;
        private transient GLMModel.GLMWeights _ws;
        double _likelihood;

        public GLMGenericWeightsTask(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key jobKey, double[] beta, GLMModel.GLMWeightsFun glmw) {
            super(cmp, dinfo, (Key<Job>)jobKey);
            this._beta = beta;
            this._glmw = glmw;
            assert (this._glmw._family != GLMModel.GLMParameters.Family.multinomial) : "Generic glm weights task does not work for family multinomial";
        }

        @Override
        public void chunkInit() {
            this._ws = new GLMModel.GLMWeights();
            if (this._sparse) {
                this._sparseOffset = GLM.sparseOffset(this._beta, this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            double eta = row.innerProduct(this._beta) + this._sparseOffset;
            this._glmw.computeWeights(row.response(0), eta, row.offset, row.weight, this._ws);
            row.setOutput(0, this._ws.w);
            row.setOutput(1, this._ws.z);
            this._likelihood += this._ws.l;
        }

        public void reduce(GLMGenericWeightsTask gwt) {
            this._likelihood += gwt._likelihood;
        }
    }

    public static class YMUTask
    extends MRTask<YMUTask> {
        double _yMin = Double.POSITIVE_INFINITY;
        double _yMax = Double.NEGATIVE_INFINITY;
        long _nobs;
        public double _wsum;
        final int _responseId;
        final int _weightId;
        final int _offsetId;
        final int _nums;
        final int _numOff;
        final boolean _computeWeightedSigma;
        final boolean _skipNAs;
        final boolean _computeWeightedMeanSigmaResponse;
        public MathUtils.BasicStats _basicStats;
        public MathUtils.BasicStats _basicStatsResponse;
        double[] _yMu;
        double[] _means;
        final int _nClasses;

        public YMUTask(DataInfo dinfo, int nclasses, boolean computeWeightedSigma, boolean computeWeightedMeanSigmaResponse, boolean skipNAs, boolean haveResponse) {
            this._nums = dinfo._nums;
            this._numOff = dinfo._cats;
            this._responseId = haveResponse ? dinfo.responseChunkId(0) : -1;
            this._weightId = dinfo._weights ? dinfo.weightChunkId() : -1;
            this._offsetId = dinfo._offset ? dinfo.offsetChunkId() : -1;
            this._nClasses = nclasses;
            this._computeWeightedSigma = computeWeightedSigma;
            this._computeWeightedMeanSigmaResponse = computeWeightedMeanSigmaResponse;
            this._skipNAs = skipNAs;
            this._means = dinfo._numMeans;
        }

        public void setupLocal() {
        }

        public void map(Chunk[] chunks) {
            this._yMu = new double[this._nClasses];
            C0DChunk weight = this._weightId == -1 ? new C0DChunk(1.0, chunks[0]._len) : chunks[this._weightId];
            boolean[] skip = MemoryManager.mallocZ((int)chunks[0]._len);
            for (int i = 0; i < chunks.length; ++i) {
                int r = chunks[i].nextNZ(-1);
                while (r < chunks[i]._len) {
                    if (!skip[r] && (skip[r] = this._skipNAs && chunks[i].isNA(r)) && this._weightId != -1) {
                        weight.set(r, 0L);
                    }
                    r = chunks[i].nextNZ(r);
                }
            }
            Chunk response = this._responseId < 0 ? null : chunks[this._responseId];
            double[] nums = null;
            double[] numsResponse = null;
            if (this._computeWeightedSigma) {
                this._basicStats = new MathUtils.BasicStats(this._nums);
                nums = MemoryManager.malloc8d((int)this._nums);
            }
            if (this._computeWeightedMeanSigmaResponse) {
                this._basicStatsResponse = new MathUtils.BasicStats(this._nClasses);
                numsResponse = MemoryManager.malloc8d((int)this._nClasses);
            }
            if (response == null) {
                return;
            }
            for (int r = 0; r < response._len; ++r) {
                double d;
                int i;
                double w;
                if (skip[r] || (w = weight.atd(r)) == 0.0) continue;
                if (this._computeWeightedSigma) {
                    for (i = 0; i < this._nums; ++i) {
                        nums[i] = chunks[i + this._numOff].atd(r);
                        if (!Double.isNaN(nums[i])) continue;
                        nums[i] = this._means[i];
                    }
                    this._basicStats.add(nums, w);
                }
                if (this._computeWeightedMeanSigmaResponse) {
                    for (i = 0; i < this._nClasses; ++i) {
                        numsResponse[i] = chunks[chunks.length - this._nClasses + i].atd(r);
                    }
                    this._basicStatsResponse.add(numsResponse, w);
                }
                if (Double.isNaN(d = response.atd(r))) continue;
                assert (!Double.isNaN(d));
                if (this._nClasses > 2) {
                    int n = (int)d;
                    this._yMu[n] = this._yMu[n] + w;
                } else {
                    this._yMu[0] = this._yMu[0] + w * d;
                }
                if (d < this._yMin) {
                    this._yMin = d;
                }
                if (d > this._yMax) {
                    this._yMax = d;
                }
                ++this._nobs;
                this._wsum += w;
            }
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._yMu, (double)(1.0 / this._wsum));
        }

        public void reduce(YMUTask ymt) {
            if (this._nobs > 0L && ymt._nobs > 0L) {
                ArrayUtils.add((double[])this._yMu, (double[])ymt._yMu);
                this._nobs += ymt._nobs;
                this._wsum += ymt._wsum;
                if (this._yMin > ymt._yMin) {
                    this._yMin = ymt._yMin;
                }
                if (this._yMax < ymt._yMax) {
                    this._yMax = ymt._yMax;
                }
                if (this._computeWeightedSigma) {
                    this._basicStats.reduce(ymt._basicStats);
                }
                if (this._computeWeightedMeanSigmaResponse) {
                    this._basicStatsResponse.reduce(ymt._basicStatsResponse);
                }
            } else if (this._nobs == 0L) {
                this._yMu = ymt._yMu;
                this._nobs = ymt._nobs;
                this._wsum = ymt._wsum;
                this._yMin = ymt._yMin;
                this._yMax = ymt._yMax;
                this._basicStats = ymt._basicStats;
                this._basicStatsResponse = ymt._basicStatsResponse;
            }
        }
    }

    static class GLMResDevTaskMultinomial
    extends FrameTask2<GLMResDevTaskMultinomial> {
        final double[][] _beta;
        double _likelihood;
        final int _nclasses;
        private transient double[] _sparseOffsets;

        public GLMResDevTaskMultinomial(Key jobKey, DataInfo dinfo, double[] beta, int nclasses) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._beta = ArrayUtils.convertTo2DMatrix((double[])beta, (int)(beta.length / nclasses));
            this._nclasses = nclasses;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._sparseOffsets = MemoryManager.malloc8d((int)this._nclasses);
            for (int c = 0; c < this._nclasses; ++c) {
                this._sparseOffsets[c] = GLM.sparseOffset(this._beta[c], this._dinfo);
            }
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            int c;
            double sumExp = 0.0;
            for (c = 0; c < this._nclasses; ++c) {
                sumExp += Math.exp(r.innerProduct(this._beta[c]) + this._sparseOffsets[c]);
            }
            c = (int)r.response(0);
            this._likelihood -= r.weight * (r.innerProduct(this._beta[c]) + this._sparseOffsets[c] - Math.log(sumExp));
        }

        public void reduce(GLMResDevTaskMultinomial gt) {
            this._likelihood += gt._likelihood;
        }
    }

    static class GLMResDevTask
    extends FrameTask2<GLMResDevTask> {
        final GLMModel.GLMWeightsFun _glmf;
        final double[] _beta;
        double _resDev = 0.0;
        double _likelihood;
        private transient GLMModel.GLMWeights _glmw;
        private final double _sparseOffset;

        public GLMResDevTask(Key jobKey, DataInfo dinfo, GLMModel.GLMParameters parms, double[] beta) {
            super(null, dinfo, (Key<Job>)jobKey);
            this._glmf = new GLMModel.GLMWeightsFun(parms);
            this._beta = beta;
            this._sparseOffset = this._sparse ? GLM.sparseOffset(this._beta, this._dinfo) : 0.0;
        }

        @Override
        public boolean handlesSparseData() {
            return true;
        }

        @Override
        public void chunkInit() {
            this._glmw = new GLMModel.GLMWeights();
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            this._glmf.computeWeights(r.response(0), r.innerProduct(this._beta) + this._sparseOffset, r.offset, r.weight, this._glmw);
            this._resDev += this._glmw.dev;
            this._likelihood += this._glmw.l;
        }

        public void reduce(GLMResDevTask gt) {
            this._resDev += gt._resDev;
            this._likelihood += gt._likelihood;
        }
    }

    static class NullDevTask
    extends MRTask<NullDevTask> {
        double _nullDev;
        final double[] _ymu;
        final GLMModel.GLMWeightsFun _glmf;
        final boolean _hasWeights;
        final boolean _hasOffset;

        public NullDevTask(GLMModel.GLMWeightsFun glmf, double[] ymu, boolean hasWeights, boolean hasOffset) {
            this._glmf = glmf;
            this._ymu = ymu;
            this._hasWeights = hasWeights;
            this._hasOffset = hasOffset;
        }

        public void map(Chunk[] chks) {
            int i = 0;
            int len = chks[0]._len;
            C0DChunk w = this._hasWeights ? chks[i++] : new C0DChunk(1.0, len);
            C0DChunk o = this._hasOffset ? chks[i++] : new C0DChunk(0.0, len);
            Chunk r = chks[i];
            if (this._glmf._family != GLMModel.GLMParameters.Family.multinomial) {
                double ymu = this._glmf.link(this._ymu[0]);
                for (int j = 0; j < len; ++j) {
                    this._nullDev += w.atd(j) * this._glmf.deviance(r.atd(j), this._glmf.linkInv(ymu + o.atd(j)));
                }
            } else {
                throw H2O.unimpl();
            }
        }

        public void reduce(NullDevTask ndt) {
            this._nullDev += ndt._nullDev;
        }
    }
}

