/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.tree.DHistogram;
import hex.tree.DTree;
import water.H2O;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.util.AtomicUtils;

public class ScoreBuildHistogram
extends MRTask<ScoreBuildHistogram> {
    final int _k;
    final int _ncols;
    final int _nbins;
    final int _nbins_cats;
    final DTree _tree;
    final int _leaf;
    final DHistogram[][] _hcs;
    final Distribution.Family _family;
    public static final int DECIDED_ROW = -1;
    public static final int OUT_OF_BAG = -2;

    public ScoreBuildHistogram(H2O.H2OCountedCompleter cc, int k, int ncols, int nbins, int nbins_cats, DTree tree, int leaf, DHistogram[][] hcs, Distribution.Family family) {
        super(cc);
        this._k = k;
        this._ncols = ncols;
        this._nbins = nbins;
        this._nbins_cats = nbins_cats;
        this._tree = tree;
        this._leaf = leaf;
        this._hcs = hcs;
        this._family = family;
    }

    public static boolean isOOBRow(int nid) {
        return nid <= -2;
    }

    public static boolean isDecidedRow(int nid) {
        return nid == -1;
    }

    public static int oob2Nid(int oobNid) {
        return -oobNid + -2;
    }

    public static int nid2Oob(int nid) {
        return -nid + -2;
    }

    public void setupLocal() {
        this._tree.init_tree();
        for (int l = this._leaf; l < this._tree._len; ++l) {
            DTree.UndecidedNode udn = this._tree.undecided(l);
            DHistogram[] hs = this._hcs[l - this._leaf];
            int[] sCols = udn._scoreCols;
            if (sCols != null) {
                for (int col : sCols) {
                    hs[col].init();
                }
                continue;
            }
            for (int j = 0; j < this._ncols; ++j) {
                if (hs[j] == null) continue;
                hs[j].init();
            }
        }
    }

    public void map(Chunk[] chks) {
        Chunk wrks = chks[this._ncols + 2];
        Chunk nids = chks[this._ncols + 3];
        C0DChunk weight = chks.length >= this._ncols + 5 ? chks[this._ncols + 4] : new C0DChunk(1.0, chks[0].len());
        int[] nnids = new int[nids._len];
        if (this._leaf > 0) {
            this.score_decide(chks, nids, nnids);
        } else {
            for (int row = 0; row < nids._len; ++row) {
                if (!ScoreBuildHistogram.isDecidedRow((int)nids.atd(row))) continue;
                nnids[row] = -1;
            }
        }
        this.accum_all(chks, wrks, (Chunk)weight, nnids);
    }

    public void reduce(ScoreBuildHistogram sbh) {
        if (sbh._hcs == this._hcs) {
            return;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            DHistogram[] hs1 = this._hcs[i];
            DHistogram[] hs2 = sbh._hcs[i];
            if (hs1 == null) {
                this._hcs[i] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            for (int j = 0; j < hs1.length; ++j) {
                if (hs1[j] == null) {
                    hs1[j] = hs2[j];
                    continue;
                }
                if (hs2[j] == null) continue;
                hs1[j].add(hs2[j]);
            }
        }
    }

    private void score_decide(Chunk[] chks, Chunk nids, int[] nnids) {
        for (int row = 0; row < nids._len; ++row) {
            int nid = (int)nids.at8(row);
            if (ScoreBuildHistogram.isDecidedRow(nid)) {
                nnids[row] = nid - this._leaf;
                continue;
            }
            boolean oob = ScoreBuildHistogram.isOOBRow(nid);
            if (oob) {
                nid = ScoreBuildHistogram.oob2Nid(nid);
            }
            DTree.DecidedNode dn = this._tree.decided(nid);
            if (dn._split._col == -1) {
                if (DTree.isRootNode(dn)) {
                    nnids[row] = nid - this._leaf;
                    continue;
                }
                nid = dn._pid;
                int xnid = oob ? ScoreBuildHistogram.nid2Oob(nid) : nid;
                nids.set(row, (long)xnid);
                nnids[row] = xnid - this._leaf;
                dn = this._tree.decided(nid);
            }
            assert (!ScoreBuildHistogram.isDecidedRow(nid));
            nid = dn.ns(chks, row);
            if (!ScoreBuildHistogram.isDecidedRow(nid)) {
                if (oob) {
                    nid = ScoreBuildHistogram.nid2Oob(nid);
                }
                nids.set(row, (long)nid);
            }
            nnids[row] = nid - this._leaf;
        }
    }

    private void accum_subset(Chunk[] chks, Chunk wrks, Chunk weight, int[] nnids) {
        for (int row = 0; row < nnids.length; ++row) {
            double w;
            int nid = nnids[row];
            if (nid < 0 || (w = weight.atd(row)) == 0.0) continue;
            double resp = wrks.atd(row);
            assert (!Double.isNaN(wrks.atd(row)));
            DHistogram[] nhs = this._hcs[nid];
            int[] sCols = this._tree.undecided((int)(nid + this._leaf))._scoreCols;
            if (sCols == null) {
                for (int col = 0; col < nhs.length; ++col) {
                    if (nhs[col] == null) continue;
                    nhs[col].incr(chks[col].atd(row), resp, w);
                }
                continue;
            }
            for (int col : sCols) {
                nhs[col].incr(chks[col].atd(row), resp, w);
            }
        }
    }

    private void accum_all(Chunk[] chks, Chunk wrks, Chunk weight, int[] nnids) {
        int[] nh = new int[this._hcs.length + 1];
        for (int i : nnids) {
            if (i < 0) continue;
            int n = i + 1;
            nh[n] = nh[n] + 1;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            int n = i + 1;
            nh[n] = nh[n] + nh[i];
        }
        int[] rows = new int[nnids.length];
        for (int row = 0; row < nnids.length; ++row) {
            if (nnids[row] < 0) continue;
            int n = nnids[row];
            int n2 = nh[n];
            nh[n] = n2 + 1;
            rows[n2] = row;
        }
        DHistogram[][] hcs = this._hcs;
        if (hcs.length == 0) {
            return;
        }
        double[] bins = new double[Math.max(this._nbins, this._nbins_cats)];
        double[] sums = new double[Math.max(this._nbins, this._nbins_cats)];
        double[] ssqs = new double[Math.max(this._nbins, this._nbins_cats)];
        int binslen = bins.length;
        int cols = this._ncols;
        int hcslen = hcs.length;
        for (int n = 0; n < hcslen; ++n) {
            int[] sCols = this._tree.undecided((int)(n + this._leaf))._scoreCols;
            if (sCols == null) {
                for (int c = 0; c < cols; ++c) {
                    ScoreBuildHistogram.overAllRows(chks, wrks, weight, nh, rows, hcs, c, n, bins, sums, ssqs, binslen);
                }
                continue;
            }
            for (int c : sCols) {
                ScoreBuildHistogram.overAllRows(chks, wrks, weight, nh, rows, hcs, c, n, bins, sums, ssqs, binslen);
            }
        }
    }

    private static void overAllRows(Chunk[] chks, Chunk wrks, Chunk weight, int[] nh, int[] rows, DHistogram[][] hcs, int c, int n, double[] bins, double[] sums, double[] ssqs, int binslen) {
        Chunk chk = chks[c];
        DHistogram rh = hcs[n][c];
        if (rh == null) {
            return;
        }
        double[] rhbins = rh._bins;
        int rhbinslen = rhbins.length;
        int lo = n == 0 ? 0 : nh[n - 1];
        int hi = nh[n];
        double min = rh._min2;
        double max = rh._maxIn;
        if (rhbinslen >= binslen) {
            bins = new double[rhbinslen];
            sums = new double[rhbinslen];
            ssqs = new double[rhbinslen];
        }
        for (int xrow = lo; xrow < hi; ++xrow) {
            int row = rows[xrow];
            double w = weight.atd(row);
            if (w == 0.0) continue;
            double col_data = chk.atd(row);
            if (col_data < min) {
                min = col_data;
            }
            if (col_data > max) {
                max = col_data;
            }
            int b = rh.bin(col_data);
            double resp = wrks.atd(row);
            double wy = w * resp;
            int n2 = b;
            bins[n2] = bins[n2] + w;
            int n3 = b;
            sums[n3] = sums[n3] + wy;
            int n4 = b;
            ssqs[n4] = ssqs[n4] + wy * resp;
        }
        rh.setMin(min);
        rh.setMax(max);
        int len = rhbinslen;
        for (int b = 0; b < len; ++b) {
            if (bins[b] != 0.0) {
                AtomicUtils.DoubleArray.add((double[])rhbins, (int)b, (double)bins[b]);
                bins[b] = 0.0;
            }
            if (sums[b] == 0.0) continue;
            rh.incr1(b, sums[b], ssqs[b]);
            ssqs[b] = 0.0;
            sums[b] = 0.0;
        }
    }
}

