/*
 * Decompiled with CFR 0.152.
 */
package hex.api;

import hex.DataInfo;
import hex.glm.GLMModel;
import hex.schemas.DataInfoFrameV3;
import hex.schemas.GLMModelV3;
import hex.schemas.MakeGLMModelV3;
import java.util.Arrays;
import java.util.HashMap;
import water.DKV;
import water.Iced;
import water.Key;
import water.MRTask;
import water.api.Handler;
import water.api.KeyV3;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class MakeGLMModelHandler
extends Handler {
    public GLMModelV3 make_model(int version, MakeGLMModelV3 args) {
        GLMModel model = (GLMModel)DKV.getGet((Key)args.model.key());
        if (model == null) {
            throw new IllegalArgumentException("missing source model " + args.model);
        }
        String[] names = ((GLMModel.GLMOutput)model._output).coefficientNames();
        HashMap<String, Double> coefs = model.coefficients();
        for (int i = 0; i < args.names.length; ++i) {
            coefs.put(args.names[i], args.beta[i]);
        }
        double[] beta = (double[])model.beta().clone();
        for (int i = 0; i < beta.length; ++i) {
            beta[i] = (Double)coefs.get(names[i]);
        }
        GLMModel m = new GLMModel(args.dest != null ? args.dest.key() : Key.make(), (GLMModel.GLMParameters)model._parms, null, new double[]{0.5}, Double.NaN, Double.NaN, -1L);
        DataInfo dinfo = model.dinfo();
        dinfo.setPredictorTransform(DataInfo.TransformType.NONE);
        m._output = new GLMModel.GLMOutput(model.dinfo(), ((GLMModel.GLMOutput)model._output)._names, ((GLMModel.GLMOutput)model._output)._domains, ((GLMModel.GLMOutput)model._output).coefficientNames(), ((GLMModel.GLMOutput)model._output)._binomial, beta);
        DKV.put((Key)m._key, (Iced)m);
        GLMModelV3 res = new GLMModelV3();
        res.fillFromImpl(m);
        return res;
    }

    public DataInfoFrameV3 getDataInfoFrame(int version, DataInfoFrameV3 args) {
        Frame fr = (Frame)DKV.getGet((Key)args.frame.key());
        if (null == fr) {
            throw new IllegalArgumentException("no frame found");
        }
        args.result = new KeyV3.FrameKeyV3(MakeGLMModelHandler.oneHot((Frame)fr, (String[])args.interactions, (boolean)args.use_all, (boolean)args.standardize, (boolean)args.interactions_only, (boolean)true)._key);
        return args;
    }

    public static Frame oneHot(Frame fr, String[] interactions, boolean useAll, boolean standardize, boolean interactionsOnly, final boolean skipMissing) {
        Frame res;
        final DataInfo dinfo = new DataInfo(fr, null, 1, useAll, standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, skipMissing, false, false, false, false, false, interactions);
        if (interactionsOnly) {
            if (null == dinfo._interactionVecs) {
                throw new IllegalArgumentException("no interactions");
            }
            int noutputs = 0;
            final int[] colIds = new int[dinfo._interactionVecs.length];
            final int[] offsetIds = new int[dinfo._interactionVecs.length];
            int idx = 0;
            String[] coefNames = dinfo.coefNames();
            for (int i : dinfo._interactionVecs) {
                int n = idx++;
                int n2 = ((InteractionWrappedVec)dinfo._adaptedFrame.vec(i)).expandedLength();
                offsetIds[n] = n2;
                noutputs += n2;
            }
            String[] names = new String[noutputs];
            idx = 0;
            int offset = 0;
            int namesIdx = 0;
            for (int i = 0; i < dinfo._adaptedFrame.numCols(); ++i) {
                Vec v = dinfo._adaptedFrame.vec(i);
                if (v instanceof InteractionWrappedVec) {
                    colIds[idx] = offset;
                    for (int nid = 0; nid < offsetIds[idx]; ++nid) {
                        names[namesIdx++] = coefNames[offset++];
                    }
                    if (++idx <= dinfo._interactionVecs.length) continue;
                    break;
                }
                if (v.isCategorical()) {
                    offset += v.domain().length - (useAll ? 0 : 1);
                    continue;
                }
                ++offset;
            }
            res = new MRTask(){

                public void map(Chunk[] cs, NewChunk[] ncs) {
                    DataInfo.Row r = dinfo.newDenseRow();
                    for (int i = 0; i < cs[0]._len; ++i) {
                        r = dinfo.extractDenseRow(cs, i, r);
                        if (skipMissing && r.bad) continue;
                        int newChkIdx = 0;
                        for (int idx = 0; idx < colIds.length; ++idx) {
                            int startOffset;
                            for (int start = startOffset = colIds[idx]; start < startOffset + offsetIds[idx]; ++start) {
                                ncs[newChkIdx++].addNum(r.get(start));
                            }
                        }
                    }
                }
            }.doAll(noutputs, (byte)3, dinfo._adaptedFrame).outputFrame(Key.make(), names, (String[][])null);
        } else {
            byte[] types = new byte[dinfo.fullN()];
            Arrays.fill(types, (byte)3);
            res = new MRTask(){

                public void map(Chunk[] cs, NewChunk[] ncs) {
                    DataInfo.Row r = dinfo.newDenseRow();
                    for (int i = 0; i < cs[0]._len; ++i) {
                        r = dinfo.extractDenseRow(cs, i, r);
                        if (skipMissing && r.bad) continue;
                        for (int n = 0; n < ncs.length; ++n) {
                            ncs[n].addNum(r.get(n));
                        }
                    }
                }
            }.doAll(types, dinfo._adaptedFrame.vecs()).outputFrame(Key.make((String)("OneHot" + Key.make().toString())), dinfo.coefNames(), (String[][])null);
        }
        dinfo.dropInteractions();
        dinfo.remove();
        return res;
    }
}

