/*
 * Decompiled with CFR 0.152.
 */
package hex.api;

import hex.ModelBuilder;
import hex.api.MakeGLMModelHandler;
import hex.deeplearning.DeepLearning;
import hex.glm.GLM;
import hex.glrm.GLRM;
import hex.kmeans.KMeans;
import hex.naivebayes.NaiveBayes;
import hex.pca.PCA;
import hex.svd.SVD;
import hex.tree.drf.DRF;
import hex.tree.gbm.GBM;
import water.H2O;
import water.api.AbstractRegister;
import water.api.GridSearchHandler;
import water.api.ModelBuilderHandler;

public class Register
extends AbstractRegister {
    public void register(String relativeResourcePath) throws ClassNotFoundException {
        ModelBuilder[] algos;
        for (ModelBuilder algo : algos = new ModelBuilder[]{new DeepLearning(true), new GLM(true), new GLRM(true), new KMeans(true), new NaiveBayes(true), new PCA(true), new SVD(true), new DRF(true), new GBM(true)}) {
            String base = algo.getClass().getSimpleName();
            String lbase = base.toLowerCase();
            Class<ModelBuilderHandler> bh_clz = ModelBuilderHandler.class;
            int version = 3;
            if (base.equals("SVD")) {
                version = 99;
            }
            H2O.registerPOST((String)("/" + version + "/ModelBuilders/" + lbase), bh_clz, (String)"train", (String)("Train a " + base + " model."));
            H2O.registerPOST((String)("/" + version + "/ModelBuilders/" + lbase + "/parameters"), bh_clz, (String)"validate_parameters", (String)("Validate a set of " + base + " model builder parameters."));
            H2O.registerPOST((String)("/99/Grid/" + lbase), GridSearchHandler.class, (String)"train", (String)("Run grid search for " + base + " model."));
        }
        H2O.registerPOST((String)"/3/MakeGLMModel", MakeGLMModelHandler.class, (String)"make_model", (String)"make a new GLM model based on existing one");
        H2O.registerPOST((String)"/3/DataInfoFrame", MakeGLMModelHandler.class, (String)"getDataInfoFrame", (String)"test only");
    }
}

