/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.schemas.ModelBuilderSchema;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import water.api.API;
import water.api.ModelParametersSchema;

public class SharedTreeV3<B extends SharedTree, S extends SharedTreeV3<B, S, P>, P extends SharedTreeParametersV3>
extends ModelBuilderSchema<B, S, P> {

    public static class SharedTreeParametersV3<P extends SharedTreeModel.SharedTreeParameters, S extends SharedTreeParametersV3<P, S>>
    extends ModelParametersSchema<P, S> {
        @API(help="Balance training data class counts via over/under-sampling (for imbalanced data).", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public boolean balance_classes;
        @API(help="Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes.", level=API.Level.expert, direction=API.Direction.INOUT, gridable=true)
        public float[] class_sampling_factors;
        @API(help="Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes.", level=API.Level.expert, direction=API.Direction.INOUT, gridable=true)
        public float max_after_balance_size;
        @API(help="Maximum size (# classes) for confusion matrices to be printed in the Logs", level=API.Level.secondary, direction=API.Direction.INOUT)
        public int max_confusion_matrix_size;
        @API(help="Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public int max_hit_ratio_k;
        @API(help="Number of trees.", gridable=true)
        public int ntrees;
        @API(help="Maximum tree depth.", gridable=true)
        public int max_depth;
        @API(help="Fewest allowed (weighted) observations in a leaf (in R called 'nodesize').", gridable=true)
        public double min_rows;
        @API(help="For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the best point", gridable=true)
        public int nbins;
        @API(help="For numerical columns (real/int), build a histogram of (at most) this many bins at the root level, then decrease by factor of two per level", level=API.Level.expert, gridable=true)
        public int nbins_top_level;
        @API(help="For categorical columns (factors), build a histogram of this many bins, then split at the best point. Higher values can lead to more overfitting.", gridable=true)
        public int nbins_cats;
        @API(help="Stop making trees when the R^2 metric equals or exceeds this", level=API.Level.secondary, gridable=true)
        public double r2_stopping;
        @API(help="Seed for pseudo random number generator (if applicable)", gridable=true)
        public long seed;
        @API(help="Run on one node only; no network overhead but fewer cpus used.  Suitable for small datasets.", level=API.Level.secondary)
        public boolean build_tree_one_node;
        @API(help="Row sample rate per tree (from 0.0 to 1.0)", gridable=true)
        public float sample_rate;
        @API(help="Row sample rate per tree per class (from 0.0 to 1.0)", gridable=true)
        public float[] sample_rate_per_class;
        @API(help="Column sample rate per tree (from 0.0 to 1.0)", gridable=true)
        public float col_sample_rate_per_tree;
        @API(help="Score the model after every so many trees. Disabled if set to 0.", level=API.Level.secondary, gridable=false)
        public int score_tree_interval;
        @API(help="Minimum relative improvement in squared error reduction for a split to happen.", level=API.Level.secondary, gridable=true)
        public double min_split_improvement;
    }
}

