/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.SharedTreeModel;
import hex.tree.TreeVisitor;
import java.util.Arrays;
import java.util.Random;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Keyed;
import water.util.IcedBitSet;
import water.util.SB;

public class CompressedTree
extends Keyed {
    final byte[] _bits;
    final int _nclass;
    final long _seed;

    public CompressedTree(byte[] bits, int nclass, long seed, int tid, int cls) {
        super(CompressedTree.makeTreeKey(tid, cls));
        this._bits = bits;
        this._nclass = nclass;
        this._seed = seed;
    }

    public double score(double[] row) {
        return this.score(row, false);
    }

    public double score(double[] row, boolean computeLeafAssignment) {
        int lmask;
        AutoBuffer ab = new AutoBuffer(this._bits);
        IcedBitSet ibs = null;
        long bitsRight = 0L;
        int level = 0;
        do {
            int nodeType = ab.get1U();
            char colId = ab.get2();
            if (colId == '\uffff') {
                return this.scoreLeaf(ab);
            }
            int equal = (nodeType & 0xC) >> 2;
            assert (equal >= 0 && equal <= 3) : "illegal equal value " + equal + " at " + ab + " in bitpile " + Arrays.toString(this._bits);
            float splitVal = -1.0f;
            if (equal == 0 || equal == 1) {
                splitVal = ab.get4f();
            } else {
                if (ibs == null) {
                    ibs = new IcedBitSet(0);
                }
                if (equal == 2) {
                    ibs.fill2(this._bits, ab);
                } else {
                    ibs.fill3(this._bits, ab);
                }
            }
            lmask = nodeType & 0x33;
            int rmask = (nodeType & 0xC0) >> 2;
            int skip = 0;
            switch (lmask) {
                case 0: {
                    skip = ab.get1U();
                    break;
                }
                case 1: {
                    skip = ab.get2();
                    break;
                }
                case 2: {
                    skip = ab.get3();
                    break;
                }
                case 3: {
                    skip = ab.get4();
                    break;
                }
                case 16: {
                    skip = this._nclass < 256 ? 1 : 2;
                    break;
                }
                case 48: {
                    skip = 4;
                    break;
                }
                default: {
                    assert (false) : "illegal lmask value " + lmask + " at " + ab + " in bitpile " + Arrays.toString(this._bits);
                    break;
                }
            }
            double d = row[colId];
            if (Double.isNaN(d) || equal == 0 && d >= (double)splitVal || equal == 1 && d == (double)splitVal || (equal == 2 || equal == 3) && ibs.contains((int)d)) {
                ab.skip(skip);
                if (computeLeafAssignment && level < 64) {
                    bitsRight |= (long)(1 << level);
                }
                lmask = rmask;
            } else assert (!Double.isNaN(d));
            ++level;
        } while ((lmask & 0x10) != 16);
        if (computeLeafAssignment) {
            return Double.longBitsToDouble(bitsRight |= (long)(1 << level));
        }
        return this.scoreLeaf(ab);
    }

    public String getDecisionPath(double[] row) {
        double d = this.score(row, true);
        long l = Double.doubleToRawLongBits(d);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (int i = 0; i < 64; ++i) {
            long right = l >> i & 1L;
            sb.append(right == 1L ? "R" : "L");
            if (right != 1L) continue;
            pos = i;
        }
        return sb.substring(0, pos);
    }

    private float scoreLeaf(AutoBuffer ab) {
        return ab.get4f();
    }

    public Random rngForChunk(int cidx) {
        Random rand = new Random(this._seed);
        for (int i = 0; i < cidx; ++i) {
            rand.nextLong();
        }
        long seed = rand.nextLong();
        return new Random(seed);
    }

    protected long checksum_impl() {
        throw H2O.fail();
    }

    public String toString(SharedTreeModel.SharedTreeOutput tm) {
        final String[] names = tm._names;
        final SB sb = new SB();
        new TreeVisitor<RuntimeException>(this){

            @Override
            protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal) {
                if (equal == 1) {
                    sb.p("!Double.isNaN(" + sb.i().p(names[col]).p(") && "));
                }
                sb.i().p(names[col]).p(' ');
                if (equal == 0) {
                    sb.p("< ").p(fcmp);
                } else if (equal == 1) {
                    sb.p("!=").p(fcmp);
                } else {
                    sb.p("in ").p(gcmp);
                }
                sb.ii(1).nl();
            }

            @Override
            protected void post(int col, float fcmp, int equal) {
                sb.di(1);
            }

            @Override
            protected void leaf(float pred) {
                sb.i().p("return ").p(pred).nl();
            }
        }.visit();
        return sb.toString();
    }

    public static Key<CompressedTree> makeTreeKey(int treeId, int clazz) {
        return Key.makeSystem((String)("tree_" + treeId + "_" + clazz + "_" + Key.rand()));
    }
}

