/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.tree.DHistogram;
import hex.tree.DTree;
import water.H2O;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.util.ArrayUtils;
import water.util.AtomicUtils;

public class ScoreBuildHistogram
extends MRTask<ScoreBuildHistogram> {
    final int _k;
    final int _ncols;
    final int _nbins;
    final int _nbins_cats;
    final DTree _tree;
    final int _leaf;
    final DHistogram[][] _hcs;
    final Distribution.Family _family;
    public static final int DECIDED_ROW = -1;
    public static final int OUT_OF_BAG = -2;

    public ScoreBuildHistogram(H2O.H2OCountedCompleter cc, int k, int ncols, int nbins, int nbins_cats, DTree tree, int leaf, DHistogram[][] hcs, Distribution.Family family) {
        super(cc);
        this._k = k;
        this._ncols = ncols;
        this._nbins = nbins;
        this._nbins_cats = nbins_cats;
        this._tree = tree;
        this._leaf = leaf;
        this._hcs = hcs;
        this._family = family;
    }

    public static boolean isOOBRow(int nid) {
        return nid <= -2;
    }

    public static boolean isDecidedRow(int nid) {
        return nid == -1;
    }

    public static int oob2Nid(int oobNid) {
        return -oobNid + -2;
    }

    public static int nid2Oob(int nid) {
        return -nid + -2;
    }

    public void setupLocal() {
        this._tree.init_tree();
        for (int l = this._leaf; l < this._tree._len; ++l) {
            DTree.UndecidedNode udn = this._tree.undecided(l);
            DHistogram[] hs = this._hcs[l - this._leaf];
            int[] sCols = udn._scoreCols;
            if (sCols != null) {
                for (int col : sCols) {
                    hs[col].init();
                }
                continue;
            }
            for (int j = 0; j < this._ncols; ++j) {
                if (hs[j] == null) continue;
                hs[j].init();
            }
        }
    }

    public final void map(Chunk[] chks) {
        Chunk wrks = chks[this._ncols + 2];
        Chunk nids = chks[this._ncols + 3];
        C0DChunk weight = chks.length >= this._ncols + 5 ? chks[this._ncols + 4] : new C0DChunk(1.0, chks[0].len());
        int[] nnids = new int[nids._len];
        if (this._leaf > 0) {
            this.score_decide(chks, nids, nnids);
        } else {
            for (int row = 0; row < nids._len; ++row) {
                if (!ScoreBuildHistogram.isDecidedRow((int)nids.atd(row))) continue;
                nnids[row] = -1;
            }
        }
        this.accum_all(chks, wrks, (Chunk)weight, nnids);
    }

    public void reduce(ScoreBuildHistogram sbh) {
        if (sbh._hcs == this._hcs) {
            return;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            DHistogram[] hs1 = this._hcs[i];
            DHistogram[] hs2 = sbh._hcs[i];
            if (hs1 == null) {
                this._hcs[i] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            for (int j = 0; j < hs1.length; ++j) {
                if (hs1[j] == null) {
                    hs1[j] = hs2[j];
                    continue;
                }
                if (hs2[j] == null) continue;
                hs1[j].add(hs2[j]);
            }
        }
    }

    private void score_decide(Chunk[] chks, Chunk nids, int[] nnids) {
        for (int row = 0; row < nids._len; ++row) {
            int nid = (int)nids.at8(row);
            if (ScoreBuildHistogram.isDecidedRow(nid)) {
                nnids[row] = nid - this._leaf;
                continue;
            }
            boolean oob = ScoreBuildHistogram.isOOBRow(nid);
            if (oob) {
                nid = ScoreBuildHistogram.oob2Nid(nid);
            }
            DTree.DecidedNode dn = this._tree.decided(nid);
            if (dn._split._col == -1) {
                if (DTree.isRootNode(dn)) {
                    nnids[row] = nid - this._leaf;
                    continue;
                }
                nid = dn._pid;
                int xnid = oob ? ScoreBuildHistogram.nid2Oob(nid) : nid;
                nids.set(row, (long)xnid);
                nnids[row] = xnid - this._leaf;
                dn = this._tree.decided(nid);
            }
            assert (!ScoreBuildHistogram.isDecidedRow(nid));
            nid = dn.ns(chks, row);
            if (!ScoreBuildHistogram.isDecidedRow(nid)) {
                if (oob) {
                    nid = ScoreBuildHistogram.nid2Oob(nid);
                }
                nids.set(row, (long)nid);
            }
            nnids[row] = nid - this._leaf;
        }
    }

    private void accum_subset(Chunk[] chks, Chunk wrks, Chunk weight, int[] nnids) {
        for (int row = 0; row < nnids.length; ++row) {
            double w;
            int nid = nnids[row];
            if (nid < 0 || (w = weight.atd(row)) == 0.0) continue;
            double resp = wrks.atd(row);
            assert (!Double.isNaN(wrks.atd(row)));
            DHistogram[] nhs = this._hcs[nid];
            int[] sCols = this._tree.undecided((int)(nid + this._leaf))._scoreCols;
            if (sCols == null) {
                for (int col = 0; col < nhs.length; ++col) {
                    if (nhs[col] == null) continue;
                    nhs[col].incr(chks[col].atd(row), resp, w);
                }
                continue;
            }
            for (int col : sCols) {
                nhs[col].incr(chks[col].atd(row), resp, w);
            }
        }
    }

    private void accum_all(Chunk[] chks, Chunk wrks, Chunk weight, int[] nnids) {
        int[] nh = new int[this._hcs.length + 1];
        for (int i : nnids) {
            if (i < 0) continue;
            int n = i + 1;
            nh[n] = nh[n] + 1;
        }
        for (int i = 0; i < this._hcs.length; ++i) {
            int n = i + 1;
            nh[n] = nh[n] + nh[i];
        }
        int[] rows = new int[nnids.length];
        for (int row = 0; row < nnids.length; ++row) {
            if (nnids[row] < 0) continue;
            int n = nnids[row];
            int n2 = nh[n];
            nh[n] = n2 + 1;
            rows[n2] = row;
        }
        DHistogram[][] hcs = this._hcs;
        if (hcs.length == 0) {
            return;
        }
        double[] bins = new double[Math.max(this._nbins, this._nbins_cats)];
        double[] sums = new double[Math.max(this._nbins, this._nbins_cats)];
        double[] ssqs = new double[Math.max(this._nbins, this._nbins_cats)];
        int cols = this._ncols;
        int hcslen = hcs.length;
        double[] ws = new double[chks[0]._len];
        double[] cs = new double[chks[0]._len];
        double[] ys = new double[chks[0]._len];
        weight.getDoubles(ws, 0, ws.length);
        wrks.getDoubles(ys, 0, ys.length);
        for (int c = 0; c < cols; ++c) {
            boolean extracted = false;
            for (int n = 0; n < hcslen; ++n) {
                int[] sCols = this._tree.undecided((int)(n + this._leaf))._scoreCols;
                if (sCols != null && ArrayUtils.find((int[])sCols, (int)c) < 0) continue;
                if (!extracted) {
                    chks[c].getDoubles(cs, 0, cs.length);
                    extracted = true;
                }
                ScoreBuildHistogram.overAllRows(cs, ys, ws, rows, hcs[n][c], n == 0 ? 0 : nh[n - 1], nh[n], bins, sums, ssqs);
            }
        }
    }

    private static void overAllRows(double[] cs, double[] ys, double[] ws, int[] rows, DHistogram rh, int lo, int hi, double[] bins, double[] sums, double[] ssqs) {
        if (rh == null) {
            return;
        }
        int rhbinslen = rh._bins.length;
        if (rhbinslen > bins.length) {
            bins = new double[rhbinslen];
            sums = new double[rhbinslen];
            ssqs = new double[rhbinslen];
        }
        ScoreBuildHistogram.fillLocalHistoForNode(bins, sums, ssqs, ws, cs, ys, rh, rows, hi, lo);
        ScoreBuildHistogram.bumpSharedHisto(bins, sums, ssqs, rh);
    }

    static void bumpSharedHisto(double[] bins, double[] sums, double[] ssqs, DHistogram rh) {
        int b;
        int len = rh._bins.length;
        for (b = 0; b < len; ++b) {
            if (bins[b] == 0.0) continue;
            AtomicUtils.DoubleArray.add((double[])rh._bins, (int)b, (double)bins[b]);
            bins[b] = 0.0;
        }
        for (b = 0; b < len; ++b) {
            if (sums[b] == 0.0 && ssqs[b] == 0.0) continue;
            rh.incr1(b, sums[b], ssqs[b]);
            ssqs[b] = 0.0;
            sums[b] = 0.0;
        }
    }

    private static void fillLocalHistoForNode(double[] bins, double[] sums, double[] ssqs, double[] ws, double[] cs, double[] ys, DHistogram rh, int[] rows, int hi, int lo) {
        double[] minmax = new double[]{rh._min2, rh._maxIn};
        for (int r = lo; r < hi; ++r) {
            int k = rows[r];
            double w = ws[k];
            if (w == 0.0) continue;
            double col_data = cs[k];
            if (col_data < minmax[0]) {
                minmax[0] = col_data;
            }
            if (col_data > minmax[1]) {
                minmax[1] = col_data;
            }
            int b = rh.bin(col_data);
            double resp = ys[k];
            double wy = w * resp;
            int n = b;
            bins[n] = bins[n] + w;
            int n2 = b;
            sums[n2] = sums[n2] + wy;
            int n3 = b;
            ssqs[n3] = ssqs[n3] + wy * resp;
        }
        rh.setMin(minmax[0]);
        rh.setMax(minmax[1]);
    }
}

