/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.ScoreKeeper;
import hex.VarImp;
import hex.genmodel.GenModel;
import hex.tree.CompressedTree;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.ReconstructTreeState;
import hex.tree.Score;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTreeModel;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.Timer;
import water.util.TwoDimTable;

public abstract class SharedTree<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends ModelBuilder<M, P, O> {
    protected int _mtry;
    protected int _mtry_per_tree;
    public static final int MAX_NTREES = 100000;
    protected int _ntrees;
    protected M _model;
    protected int _ncols;
    protected double _initialPrediction;
    private transient float[] _improvPerVar;
    protected Random _rand;
    transient long _timeLastScoreStart;
    transient long _timeLastScoreEnd;
    transient long _firstScore;
    static int counter = 0;

    public SharedTree(P parms) {
        super(parms);
    }

    public SharedTree(P parms, Key<M> key) {
        super(parms, key);
    }

    public SharedTree(P parms, Job job) {
        super(parms, job);
    }

    public SharedTree(P parms, boolean startup_once) {
        super(parms, startup_once);
    }

    public boolean isSupervised() {
        return true;
    }

    protected boolean computePriorClassDistribution() {
        return true;
    }

    public void init(boolean expensive) {
        double sumWeights;
        Value cv;
        super.init(expensive);
        if (expensive && ((SharedTreeModel.SharedTreeParameters)this._parms)._seed == -1L) {
            ((SharedTreeModel.SharedTreeParameters)this._parms)._seed = RandomUtils.getRNG((long[])new long[]{System.nanoTime()}).nextLong();
        }
        if (H2O.ARGS.client && ((SharedTreeModel.SharedTreeParameters)this._parms)._build_tree_one_node) {
            this.error("_build_tree_one_node", "Cannot run on a single node in client mode.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows < 0.0) {
            this.error("_min_rows", "Requested min_rows must be greater than 0");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < 0 || ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees > 100000) {
            this.error("_ntrees", "Requested ntrees must be between 1 and 100000");
        }
        this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees;
        if (((SharedTreeModel.SharedTreeParameters)this._parms).hasCheckpoint() && (cv = DKV.get((Key)((SharedTreeModel.SharedTreeParameters)this._parms)._checkpoint)) != null) {
            SharedTreeModel checkpointModel = (SharedTreeModel)cv.get();
            try {
                ((SharedTreeModel.SharedTreeParameters)this._parms).validateWithCheckpoint((SharedTreeModel.SharedTreeParameters)checkpointModel._parms);
                if (this.isClassifier() != ((SharedTreeModel.SharedTreeOutput)checkpointModel._output).isClassifier()) {
                    throw new IllegalArgumentException("Response type must be the same as for the checkpointed model.");
                }
                if (!Arrays.equals(this._train.names(), ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._names)) {
                    throw new IllegalArgumentException("The columns of the training data must be the same as for the checkpointed model");
                }
                if (!Arrays.deepEquals((Object[])this._train.domains(), (Object[])((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._domains)) {
                    throw new IllegalArgumentException("Categorical factor levels of the training data must be the same as for the checkpointed model");
                }
            }
            catch (H2OIllegalArgumentException e) {
                this.error(e.values.get((Object)"argument").toString(), e.values.get((Object)"value").toString());
            }
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees + 1) {
                this.error("_ntrees", "If checkpoint is specified then requested ntrees must be higher than " + (((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees + 1));
            }
            this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees - ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees;
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins <= 1) {
            this.error("_nbins", "nbins must be > 1.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins >= 65536) {
            this.error("_nbins", "nbins must be < 65536");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_cats <= 1) {
            this.error("_nbins_cats", "nbins_cats must be > 1.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_cats >= 65536) {
            this.error("_nbins_cats", "nbins_cats must be < 65536");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_top_level < ((SharedTreeModel.SharedTreeParameters)this._parms)._nbins) {
            this.error("_nbins_top_level", "nbins_top_level must be >= nbins (" + ((SharedTreeModel.SharedTreeParameters)this._parms)._nbins + ").");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_top_level >= 65536) {
            this.error("_nbins_top_level", "nbins_top_level must be < 65536");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._max_depth <= 0) {
            this.error("_max_depth", "_max_depth must be > 0.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows <= 0.0) {
            this.error("_min_rows", "_min_rows must be > 0.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval < 0 || ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval > ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees) {
            this.error("_score_tree_interval", "_score_tree_interval must be >= 0 and <= _ntrees.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class != null) {
            this.warn("_sample_rate", "_sample_rate is ignored if _sample_rate_per_class is specified.");
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class.length != this.nclasses()) {
                this.error("_sample_rate_per_class", "_sample_rate_per_class must have " + this.nclasses() + " values (one per class).");
            }
            for (int i = 0; i < ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class.length; ++i) {
                if (0.0 < (double)((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class[i] && (double)((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class[i] <= 1.0) continue;
                this.error("_sample_rate_per_class", "sample_rate_per_class for class " + this.response().domain()[i] + " should be in interval ]0,1] but it is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class[i] + ".");
            }
        }
        if (!(0.0 < (double)((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate) || !((double)((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate <= 1.0)) {
            this.error("_sample_rate", "sample_rate should be in interval ]0,1] but it is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate + ".");
        }
        if (!(0.0 < (double)((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_per_tree) || !((double)((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_per_tree <= 1.0)) {
            this.error("_col_sample_rate_per_tree", "col_sample_rate_per_tree should be in interval ]0,1] but it is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_per_tree + ".");
        }
        if (this._train != null && (sumWeights = (double)this._train.numRows() * (this.hasWeightCol() ? this._train.vec(((SharedTreeModel.SharedTreeParameters)this._parms)._weights_column).mean() : 1.0)) < 2.0 * ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows) {
            this.error("_min_rows", "The dataset size is too small to split for min_rows=" + ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows + ": must have at least " + 2.0 * ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows + " (weighted) rows, but have only " + sumWeights + ".");
        }
        if (this._train != null) {
            this._ncols = this._train.numCols() - 1 - this.numSpecialCols();
        }
    }

    protected DHistogram[][][] buildLayer(Frame fr, int nbins, int nbins_cats, DTree[] ktrees, int[] leafs, DHistogram[][][] hcs, boolean subset, boolean build_tree_one_node) {
        ScoreBuildOneTree[] sb1ts = new ScoreBuildOneTree[this._nclass];
        Vec[] vecs = fr.vecs();
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            Frame fr2 = new Frame(Arrays.copyOf(fr._names, this._ncols + 1), Arrays.copyOf(vecs, this._ncols + 1));
            fr2.add(fr._names[this.idx_tree(k)], vecs[this.idx_tree(k)]);
            fr2.add(fr._names[this.idx_work(k)], vecs[this.idx_work(k)]);
            fr2.add(fr._names[this.idx_nids(k)], vecs[this.idx_nids(k)]);
            if (this.idx_weight() >= 0) {
                fr2.add(fr._names[this.idx_weight()], vecs[this.idx_weight()]);
            }
            sb1ts[k] = new ScoreBuildOneTree(this, k, nbins, nbins_cats, tree, leafs, hcs, fr2, subset, build_tree_one_node, this._improvPerVar, ((SharedTreeModel.SharedTreeParameters)((SharedTreeModel)((Object)this._model))._parms)._distribution);
            H2O.submitTask((H2O.H2OCountedCompleter)sb1ts[k]);
        }
        boolean did_split = false;
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            sb1ts[k].join();
            if (!sb1ts[k]._did_split) continue;
            did_split = true;
        }
        return did_split ? hcs : (DHistogram[][][])null;
    }

    protected int idx_weight() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).weightsIdx();
    }

    protected int idx_offset() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).offsetIdx();
    }

    protected int idx_resp() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).responseIdx();
    }

    protected int idx_tree(int c) {
        return this._ncols + 1 + c + this.numSpecialCols();
    }

    protected int idx_work(int c) {
        return this.idx_tree(c) + this._nclass;
    }

    protected int idx_nids(int c) {
        return this.idx_work(c) + this._nclass;
    }

    protected int idx_oobt() {
        return this.idx_nids(0) + this._nclass;
    }

    protected Chunk chk_weight(Chunk[] chks) {
        return chks[this.idx_weight()];
    }

    protected Chunk chk_offset(Chunk[] chks) {
        return chks[this.idx_offset()];
    }

    protected Chunk chk_resp(Chunk[] chks) {
        return chks[this.idx_resp()];
    }

    protected Chunk chk_tree(Chunk[] chks, int c) {
        return chks[this.idx_tree(c)];
    }

    protected Chunk chk_work(Chunk[] chks, int c) {
        return chks[this.idx_work(c)];
    }

    protected Chunk chk_nids(Chunk[] chks, int c) {
        return chks[this.idx_nids(c)];
    }

    protected Chunk chk_oobt(Chunk[] chks) {
        return chks[this.idx_oobt()];
    }

    protected final Vec vec_nids(Frame fr, int c) {
        return fr.vecs()[this.idx_nids(c)];
    }

    protected final Vec vec_resp(Frame fr) {
        return fr.vecs()[this.idx_resp()];
    }

    protected final Vec vec_tree(Frame fr, int c) {
        return fr.vecs()[this.idx_tree(c)];
    }

    protected double[] data_row(Chunk[] chks, int row, double[] data) {
        assert (data.length == this._ncols);
        for (int f = 0; f < this._ncols; ++f) {
            data[f] = chks[f].atd(row);
        }
        return data;
    }

    protected DTree.DecidedNode makeDecided(DTree.UndecidedNode udn, DHistogram[] hs) {
        return new DTree.DecidedNode(udn, hs);
    }

    protected abstract double score1(Chunk[] var1, double var2, double var4, double[] var6, int var7);

    void score2(Chunk[] chks, double weight, double offset, double[] fs, int row) {
        double sum = this.score1(chks, weight, offset, fs, row);
        if (this.isClassifier()) {
            if (!Double.isInfinite(sum) && sum > 0.0 && sum != 1.0) {
                ArrayUtils.div((double[])fs, (double)sum);
            }
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._balance_classes) {
                GenModel.correctProbabilities((double[])fs, (double[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._priorClassDist, (double[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._modelClassDist);
            }
        }
    }

    protected final double doScoringAndSaveModel(boolean finalScoring, boolean oob, boolean build_tree_one_node) {
        boolean manualInterval;
        double training_r2 = Double.NaN;
        long now = System.currentTimeMillis();
        if (this._firstScore == 0L) {
            this._firstScore = now;
        }
        long sinceLastScore = now - this._timeLastScoreStart;
        boolean updated = false;
        this._job.update(0L, "Built " + ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees + " trees so far (out of " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + ").");
        boolean timeToScore = now - this._firstScore < (long)((SharedTreeModel.SharedTreeParameters)this._parms)._initial_score_interval || sinceLastScore > (long)((SharedTreeModel.SharedTreeParameters)this._parms)._score_interval && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1;
        boolean bl = manualInterval = ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval > 0 && ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees % ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval == 0;
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration || finalScoring || timeToScore && ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval == 0 || manualInterval) {
            this.checkMemoryFootPrint();
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            this._model.update(this._job);
            updated = true;
            Log.info((Object[])new Object[]{"============================================================== "});
            SharedTreeModel.SharedTreeOutput out = (SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output;
            this._timeLastScoreStart = now;
            boolean printout = ((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration || finalScoring || sinceLastScore > (long)((SharedTreeModel.SharedTreeParameters)this._parms)._score_interval;
            boolean computeGainsLift = true;
            this._job.update(0L, "Scoring the model.");
            Score sc = (Score)new Score(this, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees > 0, oob, (Key<Vec>)this.response()._key, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).getModelCategory(), true).doAll(this.train(), build_tree_one_node);
            ModelMetricsSupervised mm = sc.makeModelMetrics((SharedTreeModel)((Object)this._model), ((SharedTreeModel.SharedTreeParameters)this._parms).train());
            out._training_metrics = mm;
            training_r2 = mm.r2();
            if (oob) {
                out._training_metrics._description = "Metrics reported on Out-Of-Bag training samples";
            }
            out._scored_train[out._ntrees].fillFrom((ModelMetrics)mm);
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._valid != null) {
                Score scv = (Score)new Score(this, false, false, (Key<Vec>)this.vresponse()._key, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).getModelCategory(), true).doAll(this.valid(), build_tree_one_node);
                ModelMetricsSupervised mmv = scv.makeModelMetrics((SharedTreeModel)((Object)this._model), ((SharedTreeModel.SharedTreeParameters)this._parms).valid());
                out._validation_metrics = mmv;
                out._scored_valid[out._ntrees].fillFrom((ModelMetrics)mmv);
            }
            out._model_summary = this.createModelSummaryTable(out);
            out._scoring_history = this.createScoringHistoryTable(out);
            if (out._ntrees > 0) {
                out._varimp = new VarImp(this._improvPerVar, out._names);
                out._variable_importances = ModelMetrics.calcVarImp((VarImp)out._varimp);
            }
            if (printout) {
                Log.info((Object[])new Object[]{this._model.toString()});
            }
            this._timeLastScoreEnd = System.currentTimeMillis();
        }
        if (updated) {
            this._model.update(this._job);
        }
        return training_r2;
    }

    protected static void printGenerateTrees(DTree[] trees) {
        for (DTree dtree : trees) {
            if (dtree == null) continue;
            try {
                PrintWriter writer = new PrintWriter("/tmp/h2o-3.tree" + ++counter + ".txt", "UTF-8");
                writer.println(dtree.root().toString2(new StringBuilder(), 0));
                writer.close();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println(dtree.root().toString2(new StringBuilder(), 0));
        }
    }

    private TwoDimTable createScoringHistoryTable(SharedTreeModel.SharedTreeOutput _output) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Training MSE");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (_output.getModelCategory() == ModelCategory.Regression) {
            colHeaders.add("Training Deviance");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output.isClassifier()) {
            colHeaders.add("Training LogLoss");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output.getModelCategory() == ModelCategory.Binomial) {
            colHeaders.add("Training AUC");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Training Lift");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output.getModelCategory() == ModelCategory.Binomial || _output.getModelCategory() == ModelCategory.Multinomial) {
            colHeaders.add("Training Classification Error");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (this.valid() != null) {
            colHeaders.add("Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (_output.getModelCategory() == ModelCategory.Regression) {
                colHeaders.add("Validation Deviance");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (_output.isClassifier()) {
                colHeaders.add("Validation LogLoss");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (_output.getModelCategory() == ModelCategory.Binomial) {
                colHeaders.add("Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
                colHeaders.add("Validation Lift");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (_output.isClassifier()) {
                colHeaders.add("Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        }
        int rows = 0;
        for (int i = 0; i < _output._scored_train.length; ++i) {
            if (i != 0 && Double.isNaN(_output._scored_train[i]._mse)) continue;
            ++rows;
        }
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 0; i < _output._scored_train.length; ++i) {
            if (i != 0 && Double.isNaN(_output._scored_train[i]._mse)) continue;
            int col = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(_output._training_time_ms[i]));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)(_output._training_time_ms[i] - this._job.start_time()), (boolean)true));
            table.set(row, col++, (Object)i);
            ScoreKeeper st = _output._scored_train[i];
            table.set(row, col++, (Object)st._mse);
            if (_output.getModelCategory() == ModelCategory.Regression) {
                table.set(row, col++, (Object)st._mean_residual_deviance);
            }
            if (_output.isClassifier()) {
                table.set(row, col++, (Object)st._logloss);
            }
            if (_output.getModelCategory() == ModelCategory.Binomial) {
                table.set(row, col++, (Object)st._AUC);
                table.set(row, col++, (Object)st._lift);
            }
            if (_output.isClassifier()) {
                table.set(row, col++, (Object)st._classError);
            }
            if (this._valid != null) {
                st = _output._scored_valid[i];
                table.set(row, col++, (Object)st._mse);
                if (_output.getModelCategory() == ModelCategory.Regression) {
                    table.set(row, col++, (Object)st._mean_residual_deviance);
                }
                if (_output.isClassifier()) {
                    table.set(row, col++, (Object)st._logloss);
                }
                if (_output.getModelCategory() == ModelCategory.Binomial) {
                    table.set(row, col++, (Object)st._AUC);
                    table.set(row, col++, (Object)st._lift);
                }
                if (_output.isClassifier()) {
                    table.set(row, col++, (Object)st._classError);
                }
            }
            ++row;
        }
        return table;
    }

    private TwoDimTable createModelSummaryTable(SharedTreeModel.SharedTreeOutput _output) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Model Size in Bytes");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Min. Depth");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Depth");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Depth");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Min. Leaves");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Leaves");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Leaves");
        colTypes.add("double");
        colFormat.add("%.5f");
        boolean rows = true;
        TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        int col = 0;
        table.set(row, col++, (Object)_output._treeStats._num_trees);
        table.set(row, col++, (Object)_output._treeStats._byte_size);
        table.set(row, col++, (Object)_output._treeStats._min_depth);
        table.set(row, col++, (Object)_output._treeStats._max_depth);
        table.set(row, col++, (Object)Float.valueOf(_output._treeStats._mean_depth));
        table.set(row, col++, (Object)_output._treeStats._min_leaves);
        table.set(row, col++, (Object)_output._treeStats._max_leaves);
        table.set(row, col++, (Object)Float.valueOf(_output._treeStats._mean_leaves));
        return table;
    }

    protected void checkMemoryFootPrint() {
        long model_mem_size;
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees == 0) {
            return;
        }
        int trees_so_far = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees;
        ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeStats._byte_size = model_mem_size = ((ComputeModelSize)new ComputeModelSize((int)trees_so_far, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeKeys).doAllNodes())._model_mem_size;
        double avg_tree_mem_size = (double)model_mem_size / (double)trees_so_far;
        Log.debug((Object[])new Object[]{"Average tree size (for all classes): " + PrettyPrint.bytes((long)((long)avg_tree_mem_size))});
        long max_mem = H2O.SELF._heartbeat.get_free_mem();
        if ((double)((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees * avg_tree_mem_size > (double)max_mem) {
            String msg = "The tree model will not fit in the driver node's memory (" + PrettyPrint.bytes((long)((long)avg_tree_mem_size)) + " per tree x " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + " > " + PrettyPrint.bytes((long)max_mem) + ") - try decreasing ntrees and/or max_depth or increasing min_rows!";
            this.error("_ntrees", msg);
        }
    }

    protected double getInitialValue() {
        return ((InitialValue)new InitialValue(this._parms).doAll(new Vec[]{this._response, this.hasWeightCol() ? this._weights : this._response.makeCon(1.0), this.hasOffsetCol() ? this._offset : this._response.makeCon(0.0)})).initialValue();
    }

    public void modifyParmsForCrossValidationMainModel(ModelBuilder<M, P, O>[] cvModelBuilders) {
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._stopping_rounds == 0 && ((SharedTreeModel.SharedTreeParameters)this._parms)._max_runtime_secs == 0.0) {
            return;
        }
        ((SharedTreeModel.SharedTreeParameters)this._parms)._stopping_rounds = 0;
        ((SharedTreeModel.SharedTreeParameters)this._parms)._max_runtime_secs = 0.0;
        int sum = 0;
        for (int i = 0; i < cvModelBuilders.length; ++i) {
            sum += ((SharedTreeModel.SharedTreeOutput)((Model)DKV.getGet((Key)cvModelBuilders[i].dest()))._output)._ntrees;
        }
        ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees = (int)((double)sum / (double)cvModelBuilders.length);
        this.warn("_ntrees", "Setting optimal _ntrees to " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + " for cross-validation main model based on early stopping of cross-validation models.");
        this.warn("_stopping_rounds", "Disabling convergence-based early stopping for cross-validation main model.");
        this.warn("_max_runtime_secs", "Disabling maximum allowed runtime for cross-validation main model.");
    }

    static /* synthetic */ float[] access$3502(SharedTree x0, float[] x1) {
        x0._improvPerVar = x1;
        return x1;
    }

    private static class InitialValue
    extends MRTask<InitialValue> {
        private final Distribution _dist;
        private double _num;
        private double _denom;

        public InitialValue(Model.Parameters parms) {
            this._dist = new Distribution(parms);
        }

        public double initialValue() {
            if (this._dist.distribution == Distribution.Family.multinomial) {
                return -0.5 * new Distribution(Distribution.Family.bernoulli).link(this._num / this._denom);
            }
            return this._dist.link(this._num / this._denom);
        }

        public void map(Chunk response, Chunk weight, Chunk offset) {
            for (int i = 0; i < response._len; ++i) {
                double w;
                if (response.isNA(i) || (w = weight.atd(i)) == 0.0) continue;
                double y = response.atd(i);
                double o = offset.atd(i);
                this._num += this._dist.initFNum(w, o, y);
                this._denom += this._dist.initFDenom(w, o);
            }
        }

        public void reduce(InitialValue mrt) {
            this._num += mrt._num;
            this._denom += mrt._denom;
        }
    }

    private static class ComputeModelSize
    extends MRTask<ComputeModelSize> {
        long _model_mem_size;
        final int trees_so_far;
        public final Key<CompressedTree>[][] _treeKeys;

        public ComputeModelSize(int trees_so_far, Key<CompressedTree>[][] _treeKeys) {
            this.trees_so_far = trees_so_far;
            this._treeKeys = _treeKeys;
        }

        protected void setupLocal() {
            this._model_mem_size = 0L;
            for (int i = 0; i < this.trees_so_far; ++i) {
                Key<CompressedTree>[] per_class = this._treeKeys[i];
                for (int j = 0; j < per_class.length; ++j) {
                    if (per_class[j] == null || !per_class[j].home()) continue;
                    this._model_mem_size += (long)DKV.get(per_class[j])._max;
                }
            }
        }

        public void reduce(ComputeModelSize cms) {
            if (cms != null) {
                this._model_mem_size += cms._model_mem_size;
            }
        }
    }

    class ExcludeNAResponse
    extends MRTask<ExcludeNAResponse> {
        ExcludeNAResponse() {
        }

        public void map(Chunk[] chks) {
            Chunk ys = SharedTree.this.chk_resp(chks);
            for (int row = 0; row < ys._len; ++row) {
                if (!ys.isNA(row)) continue;
                for (int t = 0; t < SharedTree.this._nclass; ++t) {
                    SharedTree.this.chk_nids(chks, t).set(row, -1L);
                }
            }
        }
    }

    private static class ScoreBuildOneTree
    extends H2O.H2OCountedCompleter {
        final SharedTree _st;
        final int _k;
        final int _nbins;
        final int _nbins_cats;
        final DTree _tree;
        final int[] _leafs;
        final DHistogram[][][] _hcs;
        final Frame _fr2;
        final boolean _subset;
        final boolean _build_tree_one_node;
        float[] _improvPerVar;
        Distribution.Family _family;
        boolean _did_split;

        ScoreBuildOneTree(SharedTree st, int k, int nbins, int nbins_cats, DTree tree, int[] leafs, DHistogram[][][] hcs, Frame fr2, boolean subset, boolean build_tree_one_node, float[] improvPerVar, Distribution.Family family) {
            this._st = st;
            this._k = k;
            this._nbins = nbins;
            this._nbins_cats = nbins_cats;
            this._tree = tree;
            this._leafs = leafs;
            this._hcs = hcs;
            this._fr2 = fr2;
            this._subset = subset;
            this._build_tree_one_node = build_tree_one_node;
            this._improvPerVar = improvPerVar;
            this._family = family;
        }

        public void compute2() {
            new ScoreBuildHistogram(this, this._k, this._st._ncols, this._nbins, this._nbins_cats, this._tree, this._leafs[this._k], this._hcs[this._k], this._family).dfork(null, this._fr2, this._build_tree_one_node);
        }

        public void onCompletion(CountedCompleter caller) {
            ScoreBuildHistogram sbh = (ScoreBuildHistogram)caller;
            int leafk = this._leafs[this._k];
            int tmax = this._tree.len();
            for (int leaf = leafk; leaf < tmax; ++leaf) {
                DTree.UndecidedNode udn = this._tree.undecided(leaf);
                DTree.DecidedNode dn = this._st.makeDecided(udn, sbh._hcs[leaf - leafk]);
                if (dn._split._col == -1) {
                    udn.do_not_split();
                    continue;
                }
                this._did_split = true;
                DTree.Split s = dn._split;
                AtomicUtils.FloatArray.add((float[])this._improvPerVar, (int)s.col(), (float)((float)(s.pre_split_se() - s.se())));
            }
            this._leafs[this._k] = tmax;
            int new_leafs = this._tree.len() - tmax;
            this._hcs[this._k] = new DHistogram[new_leafs][];
            for (int nl = tmax; nl < this._tree.len(); ++nl) {
                this._hcs[this._k][nl - tmax] = this._tree.undecided((int)nl)._hs;
            }
            if (this._did_split) {
                ++this._tree._depth;
            }
        }
    }

    protected abstract class Driver
    extends ModelBuilder.Driver {
        protected Driver() {
            super((ModelBuilder)SharedTree.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compute2() {
            Key[] keyArray;
            SharedTree.this._model = null;
            try {
                int i;
                Scope.enter();
                SharedTree.this.init(true);
                ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_lock_frames(SharedTree.this._job);
                if (SharedTree.this.error_count() > 0) {
                    throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)SharedTree.this);
                }
                if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).hasCheckpoint()) {
                    SharedTree.this._model = ((SharedTreeModel)DKV.get((Key)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._checkpoint).get()).deepClone(SharedTree.this._result);
                    ((SharedTreeModel)((Object)SharedTree.this._model))._parms = SharedTree.this._parms;
                    SharedTree.this._model.delete_and_lock(SharedTree.this._job);
                } else {
                    SharedTree.this._model = this.makeModel(SharedTree.this.dest(), (Object)((Object)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)));
                    SharedTree.this._model.delete_and_lock(SharedTree.this._job);
                    ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._init_f = SharedTree.this._initialPrediction;
                }
                String[] domain = SharedTree.this._response.domain();
                assert (SharedTree.this._nclass > 1 && domain != null || SharedTree.this._nclass == 1 && domain == null);
                if (SharedTree.this._nclass == 1) {
                    domain = new String[]{"r"};
                }
                if (SharedTree.this._nclass > 1) {
                    if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).isClassifier() && ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._balance_classes) {
                        Frame stratified;
                        float[] trainSamplingFactors = new float[SharedTree.this._train.lastVec().domain().length];
                        if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors != null) {
                            if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors.length != SharedTree.this._train.lastVec().domain().length) {
                                throw new IllegalArgumentException("class_sampling_factors must have " + SharedTree.this._train.lastVec().domain().length + " elements");
                            }
                            trainSamplingFactors = (float[])((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors.clone();
                        }
                        if ((stratified = MRUtils.sampleFrameStratified((Frame)SharedTree.this._train, (Vec)SharedTree.this._train.lastVec(), (Vec)SharedTree.this._train.vec(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).weightsName()), (float[])trainSamplingFactors, (long)((long)(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._max_after_balance_size * (float)SharedTree.this._train.numRows())), (long)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed, (boolean)true, (boolean)false)) != SharedTree.this._train) {
                            SharedTree.this._train = stratified;
                            SharedTree.this._response = stratified.vec(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._response_column);
                            SharedTree.this._weights = stratified.vec(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._weights_column);
                            MRUtils.ClassDist cdmt2 = SharedTree.this._weights != null ? (MRUtils.ClassDist)new MRUtils.ClassDist(SharedTree.this._nclass).doAll(new Vec[]{SharedTree.this._response, SharedTree.this._weights}) : (MRUtils.ClassDist)new MRUtils.ClassDist(SharedTree.this._nclass).doAll(new Vec[]{SharedTree.this._response});
                            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution = cdmt2.dist();
                            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist = cdmt2.rel_dist();
                        }
                    }
                    Log.info((Object[])new Object[]{"Prior class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._priorClassDist)});
                    Log.info((Object[])new Object[]{"Model class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist)});
                    if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._sample_rate_per_class != null) {
                        Log.info((Object[])new Object[]{"Sample rates per tree (this affects the distribution of probabilities):"});
                        for (int i2 = 0; i2 < SharedTree.this.nclasses(); ++i2) {
                            Log.info((Object[])new Object[]{" sample rate for class '" + SharedTree.this.response().domain()[i2] + "' : " + ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._sample_rate_per_class[i2]});
                        }
                    }
                }
                for (i = 0; i < SharedTree.this._nclass; ++i) {
                    SharedTree.this._train.add("Tree_" + domain[i], SharedTree.this._response.makeZero());
                }
                for (i = 0; i < SharedTree.this._nclass; ++i) {
                    SharedTree.this._train.add("Work_" + domain[i], SharedTree.this._response.makeZero());
                }
                for (i = 0; i < SharedTree.this._nclass; ++i) {
                    SharedTree.this._train.add("NIDs_" + domain[i], SharedTree.this._response.makeCon(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution == null ? 0.0 : (double)(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution[i] == 0.0 ? -1 : 0)));
                }
                SharedTree.this._train.add("OUT_BAG_TREES", SharedTree.this._response.makeZero());
                new ExcludeNAResponse().doAll(SharedTree.this._train);
                SharedTree.access$3502(SharedTree.this, new float[SharedTree.this._ncols]);
                SharedTree.this._rand = RandomUtils.getRNG((long[])new long[]{((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed});
                this.initializeModelSpecifics();
                this.resumeFromCheckpoint();
                this.scoreAndBuildTrees(this.doOOBScoring());
            }
            catch (Throwable throwable) {
                Key[] keyArray2;
                ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_unlock_frames(SharedTree.this._job);
                if (SharedTree.this._model != null) {
                    SharedTree.this._model.unlock(SharedTree.this._job);
                }
                if (SharedTree.this._model == null) {
                    keyArray2 = null;
                } else {
                    Key[] keyArray3 = new Key[3];
                    keyArray3[0] = ((SharedTreeModel)((Object)SharedTree.this._model))._key;
                    keyArray3[1] = ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).train());
                    keyArray2 = keyArray3;
                    keyArray3[2] = ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).valid());
                }
                Scope.exit(keyArray2);
                throw throwable;
            }
            ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_unlock_frames(SharedTree.this._job);
            if (SharedTree.this._model != null) {
                SharedTree.this._model.unlock(SharedTree.this._job);
            }
            if (SharedTree.this._model == null) {
                keyArray = null;
            } else {
                Key[] keyArray4 = new Key[3];
                keyArray4[0] = ((SharedTreeModel)((Object)SharedTree.this._model))._key;
                keyArray4[1] = ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).train());
                keyArray = keyArray4;
                keyArray4[2] = ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).valid());
            }
            Scope.exit(keyArray);
            this.tryComplete();
        }

        protected abstract M makeModel(Key var1, P var2);

        protected abstract boolean doOOBScoring();

        protected abstract void buildNextKTrees();

        protected abstract void initializeModelSpecifics();

        protected final void resumeFromCheckpoint() {
            if (!((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).hasCheckpoint()) {
                return;
            }
            Timer t = new Timer();
            int ntreesFromCheckpoint = ((SharedTreeModel.SharedTreeParameters)((Model)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._checkpoint.get())._parms)._ntrees;
            new ReconstructTreeState(SharedTree.this._ncols, SharedTree.this._nclass, SharedTree.this.numSpecialCols(), ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._sample_rate, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._treeKeys, this.doOOBScoring()).doAll(SharedTree.this._train, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
            for (int i = 0; i < ntreesFromCheckpoint; ++i) {
                SharedTree.this._rand.nextLong();
            }
            Log.info((Object[])new Object[]{"Reconstructing OOB stats from checkpoint took " + t});
        }

        protected final void scoreAndBuildTrees(boolean oob) {
            for (int tid = 0; tid < SharedTree.this._ntrees; ++tid) {
                if (tid != 0 || !((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).hasCheckpoint()) {
                    double training_r2 = SharedTree.this.doScoringAndSaveModel(false, oob, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
                    if (training_r2 >= ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._r2_stopping) {
                        SharedTree.this.doScoringAndSaveModel(true, oob, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
                        SharedTree.this._job.update((long)(SharedTree.this._ntrees - ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._ntrees));
                        return;
                    }
                    if (!Double.isNaN(training_r2) && ScoreKeeper.stopEarly((ScoreKeeper[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).scoreKeepers(), (int)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_rounds, (SharedTree.this._nclass > 1 ? 1 : 0) != 0, (ScoreKeeper.StoppingMetric)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_metric, (double)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_tolerance, (String)"model's last")) {
                        SharedTree.this.doScoringAndSaveModel(true, oob, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
                        SharedTree.this._job.update((long)(SharedTree.this._ntrees - ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._ntrees));
                        return;
                    }
                }
                Timer kb_timer = new Timer();
                this.buildNextKTrees();
                Log.info((Object[])new Object[]{tid + 1 + ". tree was built in " + kb_timer.toString()});
                SharedTree.this._job.update(1L);
                if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._treeStats._max_depth == 0) {
                    Log.warn((Object[])new Object[]{"Nothing to split on: Check that response and distribution are meaningful (e.g., you are not using laplace/quantile regression with a binary response)."});
                }
                if (SharedTree.this.timeout()) break;
                if (!SharedTree.this.stop_requested()) continue;
                throw new Job.JobCancelledException();
            }
            SharedTree.this.doScoringAndSaveModel(true, oob, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
        }
    }
}

