/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.ModelBuilder;
import hex.api.DeepLearningBuilderHandler;
import hex.api.ExampleBuilderHandler;
import hex.api.GBMBuilderHandler;
import hex.api.GLMBuilderHandler;
import hex.api.KMeansBuilderHandler;
import hex.api.Word2VecBuilderHandler;
import hex.deeplearning.DeepLearning;
import hex.example.Example;
import hex.glm.GLM;
import hex.kmeans.KMeans;
import hex.schemas.DeepLearningHandler;
import hex.schemas.ExampleHandler;
import hex.schemas.GBMHandler;
import hex.schemas.GLMHandler;
import hex.schemas.KMeansHandler;
import hex.schemas.SynonymsHandler;
import hex.schemas.Word2VecHandler;
import hex.tree.gbm.GBM;
import hex.word2vec.Word2Vec;
import java.io.File;
import water.H2O;

public class H2OApp {
    public static void main2(String relpath) {
        H2OApp.driver(new String[0], relpath);
    }

    public static void main(String[] args) {
        H2OApp.driver(args, System.getProperty("user.dir"));
    }

    private static void driver(String[] args, String relpath) {
        H2O.main((String[])args);
        H2OApp.register(relpath);
    }

    static void register(String relpath) {
        H2O.registerResourceRoot((File)new File(relpath + File.separator + "h2o-web/src/main/resources/www"));
        H2O.registerResourceRoot((File)new File(relpath + File.separator + "h2o-core/src/main/resources/www"));
        H2O.registerGET((String)"/Example", ExampleHandler.class, (String)"train", (String)"/Example", (String)"Example", (String)"Model", (String)"Train an Example model on the specified Frame.");
        H2O.registerGET((String)"/DeepLearning", DeepLearningHandler.class, (String)"train", (String)"/DeepLearning", (String)"Deep Learning", (String)"Model", (String)"Train a Deep Learning model on the specified Frame.");
        H2O.registerGET((String)"/GLM", GLMHandler.class, (String)"train", (String)"/GLM", (String)"GLM", (String)"Model", (String)"Train a GLM model on the specified Frame.");
        H2O.registerGET((String)"/KMeans", KMeansHandler.class, (String)"train", (String)"/KMeans", (String)"KMeans", (String)"Model", (String)"Train a KMeans model on the specified Frame.");
        H2O.registerGET((String)"/GBM", GBMHandler.class, (String)"train", (String)"/GBM", (String)"GBM", (String)"Model", (String)"Train a GBM model on the specified Frame.");
        H2O.registerGET((String)"/Word2Vec", Word2VecHandler.class, (String)"train", (String)"/Word2Vec", (String)"Word2Vec", (String)"Model", (String)"Train a Word2Vec model on the specified Frame.");
        H2O.registerGET((String)"/Synonyms", SynonymsHandler.class, (String)"findSynonyms", (String)"/Synonyms", (String)"Synonyms", (String)"Synonyms", (String)"Return the synonyms.");
        ModelBuilder.registerModelBuilder((String)"gbm", GBM.class);
        H2O.registerPOST((String)"/2/ModelBuilders/gbm", GBMBuilderHandler.class, (String)"train", (String)"Train a GBM model on the specified Frame.");
        H2O.registerPOST((String)"/2/ModelBuilders/gbm/parameters", GBMBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of GBM model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"kmeans", KMeans.class);
        H2O.registerPOST((String)"/2/ModelBuilders/kmeans", KMeansBuilderHandler.class, (String)"train", (String)"Train a KMeans model on the specified Frame.");
        H2O.registerPOST((String)"/2/ModelBuilders/kmeans/parameters", KMeansBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of KMeans model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"deeplearning", DeepLearning.class);
        H2O.registerPOST((String)"/2/ModelBuilders/deeplearning", DeepLearningBuilderHandler.class, (String)"train", (String)"Train a Deep Learning model on the specified Frame.");
        H2O.registerPOST((String)"/2/ModelBuilders/deeplearning/parameters", DeepLearningBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Deep Learning model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"glm", GLM.class);
        H2O.registerPOST((String)"/2/ModelBuilders/glm", GLMBuilderHandler.class, (String)"train", (String)"Train a GLM model on the specified Frame.");
        ModelBuilder.registerModelBuilder((String)"word2vec", Word2Vec.class);
        H2O.registerPOST((String)"/2/ModelBuilders/word2vec", Word2VecBuilderHandler.class, (String)"train", (String)"Train a Word2Vec model on the specified Frame.");
        H2O.registerPOST((String)"/2/ModelBuilders/word2vec/parameters", Word2VecBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Word2Vec model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"example", Example.class);
        H2O.registerPOST((String)"/2/ModelBuilders/example", ExampleBuilderHandler.class, (String)"train", (String)"Train an Example model on the specified Frame.");
        H2O.finalizeRequest();
    }
}

