/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.ModelBuilder;
import hex.api.DeepLearningBuilderHandler;
import hex.api.ExampleBuilderHandler;
import hex.api.GBMBuilderHandler;
import hex.api.GLMBuilderHandler;
import hex.api.GrepBuilderHandler;
import hex.api.KMeansBuilderHandler;
import hex.api.QuantileBuilderHandler;
import hex.api.Word2VecBuilderHandler;
import hex.deeplearning.DeepLearning;
import hex.example.Example;
import hex.glm.GLM;
import hex.grep.Grep;
import hex.kmeans.KMeans;
import hex.quantile.Quantile;
import hex.tree.gbm.GBM;
import hex.word2vec.Word2Vec;
import java.io.File;
import water.H2O;

public class H2OApp {
    public static void main2(String relpath) {
        H2OApp.driver(new String[0], relpath);
    }

    public static void main(String[] args) {
        H2OApp.driver(args, System.getProperty("user.dir"));
    }

    private static void driver(String[] args, String relpath) {
        H2O.main((String[])args);
        H2OApp.register(relpath);
    }

    static void register(String relpath) {
        H2O.registerResourceRoot((File)new File(relpath + File.separator + "h2o-web/src/main/resources/www"));
        H2O.registerResourceRoot((File)new File(relpath + File.separator + "h2o-core/src/main/resources/www"));
        ModelBuilder.registerModelBuilder((String)"gbm", GBM.class);
        H2O.registerPOST((String)"/3/ModelBuilders/gbm", GBMBuilderHandler.class, (String)"train", (String)"Train a GBM model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/gbm/parameters", GBMBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of GBM model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"kmeans", KMeans.class);
        H2O.registerPOST((String)"/3/ModelBuilders/kmeans", KMeansBuilderHandler.class, (String)"train", (String)"Train a KMeans model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/kmeans/parameters", KMeansBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of KMeans model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"deeplearning", DeepLearning.class);
        H2O.registerPOST((String)"/3/ModelBuilders/deeplearning", DeepLearningBuilderHandler.class, (String)"train", (String)"Train a Deep Learning model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/deeplearning/parameters", DeepLearningBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Deep Learning model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"glm", GLM.class);
        H2O.registerPOST((String)"/3/ModelBuilders/glm", GLMBuilderHandler.class, (String)"train", (String)"Train a GLM model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/glm/parameters", GLMBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of GLM model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"word2vec", Word2Vec.class);
        H2O.registerPOST((String)"/3/ModelBuilders/word2vec", Word2VecBuilderHandler.class, (String)"train", (String)"Train a Word2Vec model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/word2vec/parameters", Word2VecBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Word2Vec model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"example", Example.class);
        H2O.registerPOST((String)"/3/ModelBuilders/example", ExampleBuilderHandler.class, (String)"train", (String)"Train an Example model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/example/parameters", ExampleBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Example model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"quantile", Quantile.class);
        H2O.registerPOST((String)"/3/ModelBuilders/quantile", QuantileBuilderHandler.class, (String)"train", (String)"Train a Quantile model on the specified Frame.");
        H2O.registerPOST((String)"/3/ModelBuilders/quantile/parameters", QuantileBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Quantile model builder parameters.");
        ModelBuilder.registerModelBuilder((String)"grep", Grep.class);
        H2O.registerPOST((String)"/3/ModelBuilders/grep", GrepBuilderHandler.class, (String)"train", (String)"Search a raw text file for matches");
        H2O.registerPOST((String)"/3/ModelBuilders/grep/parameters", GrepBuilderHandler.class, (String)"validate_parameters", (String)"Validate a set of Grep parameters.");
        H2O.finalizeRegistration();
    }
}

