/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.Leaderboard;
import ai.h2o.automl.UserFeedbackEvent;
import hex.Model;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import water.util.Log;

public class EckoClient {
    private static int numEvents = 0;
    private static Map<String, ProjectStatus> statuses = new HashMap<String, ProjectStatus>();
    private static final int eckoTimeout = 10000;
    private static final String eckoHelpMessage = "Ecko server is NOT enabled for user feedback updates.  To use Ecko, start a server on localhost:55555 before you run your AutoML-enabled h2o.";
    private static final String eckoFailedMessage = "Ecko server failed.  Disabling.";
    private static final String eckoExceptionMessage = "Caught exception trying to communicate with the Ecko server: ";
    private static final String eckoHost = "http://localhost:55555/";
    private static boolean eckoEnabled = true;
    private static boolean eckoInitialized = false;
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String feedbackCellStyle = "-font-size 0.8em";
    private static final String feedbackRowStyle = " set Feedback Timestamp -font-size 0.8em set Feedback Level -font-size 0.8em set Feedback Stage -font-size 0.8em set Feedback Message -font-size 0.8em";
    private static final String feedbackTableStyle = " set \"User Feedback\" -font-weight 120";
    private static final String projectPageDefs = "at %s def Feedback Timestamp Level Stage Message add Leaderboard in table add \"User Feedback\" as map of Feedback set \"User Feedback\" -font-weight 120 set Feedback Timestamp -font-size 0.8em set Feedback Level -font-size 0.8em set Feedback Stage -font-size 0.8em set Feedback Message -font-size 0.8em";
    private static final String projectTableStyle = " set Projects -font-weight 120";
    private static final String homePageDefs = "at / def BuildStatus Project Message PercentDone Leader add Projects as map of BuildStatus set Projects -font-weight 120";

    private static void initializeEcko() {
        int httpStatus = -1;
        try {
            httpStatus = Request.Put((String)eckoHost).connectTimeout(10000).socketTimeout(10000).bodyString(homePageDefs, ContentType.TEXT_PLAIN).execute().returnResponse().getStatusLine().getStatusCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (httpStatus == 200) {
            Log.info((Object[])new Object[]{"Ecko server is enabled for user feedback updates.  Open http://localhost:55555 in your browser."});
            eckoInitialized = true;
        } else {
            eckoEnabled = false;
        }
        if (!eckoEnabled) {
            Log.info((Object[])new Object[]{eckoHelpMessage});
        }
    }

    private static void initializeProjectPage(String project) {
        if (!eckoEnabled || statuses.containsKey(project)) {
            return;
        }
        int httpStatus = -1;
        statuses.put(project, new ProjectStatus(project));
        try {
            httpStatus = Request.Put((String)eckoHost).connectTimeout(10000).socketTimeout(10000).bodyString(String.format(projectPageDefs, project), ContentType.TEXT_PLAIN).execute().returnResponse().getStatusLine().getStatusCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (httpStatus != 200) {
            eckoEnabled = false;
        }
        if (!eckoEnabled) {
            Log.info((Object[])new Object[]{eckoFailedMessage});
        }
    }

    public static final void addEvent(UserFeedbackEvent event) {
        if (eckoEnabled && !eckoInitialized) {
            EckoClient.initializeEcko();
        }
        if (eckoEnabled) {
            AutoML autoML = event.getAutoML();
            String project = autoML.projectName();
            EckoClient.initializeProjectPage(project);
            ProjectStatus status = statuses.get(statuses.get(event.getAutoML().projectName()));
            status.lastEvent = event;
            int httpStatus = -1;
            try {
                httpStatus = Request.Put((String)eckoHost).connectTimeout(10000).socketTimeout(10000).bodyString(String.format(project, new Object[0]) + String.format("%1$05d", numEvents++) + " " + timestampFormat.format(new Date(event.getTimestamp())) + " " + (Object)((Object)event.getLevel()) + " " + (Object)((Object)event.getStage()) + " " + "\"" + event.getMessage() + "\"", ContentType.TEXT_PLAIN).execute().returnResponse().getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                Log.info((Object[])new Object[]{eckoExceptionMessage + e});
            }
            if (httpStatus != 200) {
                eckoEnabled = false;
                Log.info((Object[])new Object[]{eckoFailedMessage});
            }
            EckoClient.updateHomePage(status);
        }
    }

    public static final void updateLeaderboard(Leaderboard leaderboard) {
        if (eckoEnabled && !eckoInitialized) {
            EckoClient.initializeEcko();
        }
        if (eckoEnabled) {
            String project = leaderboard.getProject();
            EckoClient.initializeProjectPage(project);
            ProjectStatus status = statuses.get(project);
            status.leaderboard = leaderboard;
            status.leader = leaderboard.getLeader();
            status.leaderError = Leaderboard.defaultMetricForModel(status.leader)[0];
            status.leaderMetric = Leaderboard.defaultMetricNameForModel(status.leader)[0];
            String leaderboardTsv = Leaderboard.toString(project, leaderboard.getModels(), "\\t", "\\n", false, true);
            String rankTsv = leaderboard.rankTsv();
            String timeTsv = leaderboard.timeTsv();
            int httpStatus = -1;
            try {
                httpStatus = Request.Put((String)eckoHost).connectTimeout(10000).socketTimeout(10000).bodyString(String.format(project, new Object[0]) + leaderboardTsv + "\"" + "", ContentType.TEXT_PLAIN).execute().returnResponse().getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                Log.info((Object[])new Object[]{eckoExceptionMessage + e});
            }
            if (httpStatus != 200) {
                eckoEnabled = false;
                Log.info((Object[])new Object[]{eckoFailedMessage});
            }
            EckoClient.updateHomePage(status);
        }
    }

    public static final void updateProgress(AutoML autoML) {
        double progress;
        ProjectStatus status = statuses.get(autoML.projectName());
        status.progress = progress = autoML.job() == null ? 0.0 : (double)autoML.job().progress();
        EckoClient.updateHomePage(status);
    }

    public static final void updateHomePage(ProjectStatus status) {
        if (eckoEnabled && !eckoInitialized) {
            EckoClient.initializeEcko();
        }
        String project = status.project;
        if (eckoEnabled) {
            int httpStatus = -1;
            try {
                httpStatus = Request.Put((String)eckoHost).connectTimeout(10000).socketTimeout(10000).bodyString(String.format(project, new Object[0]) + "", ContentType.TEXT_PLAIN).execute().returnResponse().getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                Log.info((Object[])new Object[]{eckoExceptionMessage + e});
            }
            if (httpStatus != 200) {
                eckoEnabled = false;
                Log.info((Object[])new Object[]{eckoFailedMessage});
            }
        }
    }

    private static final class ProjectStatus {
        final String project;
        public UserFeedbackEvent lastEvent;
        public double progress;
        public Leaderboard leaderboard;
        public Model leader;
        public String leaderMetric;
        public double leaderError;

        public ProjectStatus(String project) {
            this.project = project;
        }
    }
}

