/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.EckoClient;
import ai.h2o.automl.UserFeedbackEvent;
import water.DKV;
import water.Key;
import water.Keyed;
import water.util.TwoDimTable;

public class UserFeedback
extends Keyed<UserFeedback> {
    public transient AutoML autoML;
    public UserFeedbackEvent[] feedbackEvents;

    public UserFeedback(AutoML autoML) {
        this._key = Key.make((String)UserFeedback.idForRun((Key<AutoML>)autoML._key));
        this.autoML = autoML;
        UserFeedback old = (UserFeedback)DKV.getGet((Key)this._key);
        if (null == old) {
            this.feedbackEvents = new UserFeedbackEvent[0];
            DKV.put((Keyed)this);
        }
    }

    private UserFeedback() {
    }

    public static String idForRun(Key<AutoML> runKey) {
        return "AutoML_Feedback_" + runKey.toString();
    }

    public void debug(UserFeedbackEvent.Stage stage, String message) {
        this.addEvent(new UserFeedbackEvent(this.autoML, UserFeedbackEvent.Level.Debug, stage, message));
    }

    public void info(UserFeedbackEvent.Stage stage, String message) {
        this.addEvent(new UserFeedbackEvent(this.autoML, UserFeedbackEvent.Level.Info, stage, message));
    }

    public void warn(UserFeedbackEvent.Stage stage, String message) {
        this.addEvent(new UserFeedbackEvent(this.autoML, UserFeedbackEvent.Level.Warn, stage, message));
    }

    public void addEvent(UserFeedbackEvent.Level level, UserFeedbackEvent.Stage stage, String message) {
        this.addEvent(new UserFeedbackEvent(this.autoML, level, stage, message));
    }

    public void addEvent(UserFeedbackEvent event) {
        UserFeedbackEvent[] oldEvents = this.feedbackEvents;
        this.feedbackEvents = new UserFeedbackEvent[this.feedbackEvents.length + 1];
        System.arraycopy(oldEvents, 0, this.feedbackEvents, 0, oldEvents.length);
        this.feedbackEvents[oldEvents.length] = event;
        EckoClient.addEvent(event);
    }

    public void delete() {
        this.feedbackEvents = new UserFeedbackEvent[0];
        this.remove();
    }

    public TwoDimTable toTwoDimTable() {
        return this.toTwoDimTable("User Feedback");
    }

    public TwoDimTable toTwoDimTable(String tableHeader) {
        TwoDimTable table = UserFeedbackEvent.makeTwoDimTable(tableHeader, this.feedbackEvents.length);
        for (int i = 0; i < this.feedbackEvents.length; ++i) {
            this.feedbackEvents[i].addTwoDimTableRow(table, i);
        }
        return table;
    }

    public String toString(String tableHeader) {
        return this.toTwoDimTable(tableHeader).toString();
    }

    public String toString() {
        return this.toTwoDimTable().toString();
    }
}

