/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.Leaderboard;
import water.DKV;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.automl.api.schemas3.LeaderboardV99;
import water.automl.api.schemas3.LeaderboardsV99;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;

public class LeaderboardsHandler
extends Handler {
    public LeaderboardsV99 list(int version, LeaderboardsV99 s) {
        Leaderboards m = (Leaderboards)s.createAndFillImpl();
        m.leaderboards = Leaderboards.fetchAll();
        return (LeaderboardsV99)s.fillFromImpl(m);
    }

    public LeaderboardV99 fetch(int version, LeaderboardsV99 s) {
        if (null == s.project_name) {
            throw new H2OKeyNotFoundArgumentException("Client must specify a project_name.");
        }
        return (LeaderboardV99)new LeaderboardV99().fillFromImpl((Iced)LeaderboardsHandler.getFromDKV("project_name", Leaderboard.idForProject(s.project_name)));
    }

    public static Leaderboard getFromDKV(String param_name, String key_str) {
        return LeaderboardsHandler.getFromDKV(param_name, Key.make((String)key_str));
    }

    public static Leaderboard getFromDKV(String param_name, Key key) {
        if (key == null) {
            throw new H2OIllegalArgumentException(param_name, "Leaderboard.getFromDKV()", null);
        }
        Value v = DKV.get((Key)key);
        if (v == null) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Iced ice = v.get();
        if (!(ice instanceof Leaderboard)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, (Object)key.toString(), Leaderboard.class, ice.getClass());
        }
        return (Leaderboard)ice;
    }

    public static final class Leaderboards
    extends Iced {
        public Leaderboard[] leaderboards;

        public static Leaderboard[] fetchAll() {
            Key[] leaderboardKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

                public boolean filter(KeySnapshot.KeyInfo k) {
                    return Value.isSubclassOf((int)k._type, Leaderboard.class);
                }
            }).keys();
            Leaderboard[] leaderboards = new Leaderboard[leaderboardKeys.length];
            for (int i = 0; i < leaderboardKeys.length; ++i) {
                Leaderboard leaderboard;
                leaderboards[i] = leaderboard = LeaderboardsHandler.getFromDKV("(none)", leaderboardKeys[i]);
            }
            return leaderboards;
        }
    }
}

