/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.AutoML;
import water.DKV;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.automl.api.schemas3.AutoMLV99;
import water.automl.api.schemas3.AutoMLsV99;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;

public class AutoMLHandler
extends Handler {
    public AutoMLV99 fetch(int version, AutoMLV99 autoMLV99) {
        AutoML autoML = (AutoML)DKV.getGet((String)autoMLV99.automl_id.name);
        return autoMLV99.fillFromImpl(autoML);
    }

    public AutoMLsV99 list(int version, AutoMLsV99 s) {
        AutoMLs m = (AutoMLs)s.createAndFillImpl();
        m.auto_ml_runs = AutoMLs.fetchAll();
        return (AutoMLsV99)s.fillFromImpl(m);
    }

    public static AutoML getFromDKV(String param_name, String key_str) {
        return AutoMLHandler.getFromDKV(param_name, Key.make((String)key_str));
    }

    public static AutoML getFromDKV(String param_name, Key key) {
        if (key == null) {
            throw new H2OIllegalArgumentException(param_name, "AutoML.getFromDKV()", null);
        }
        Value v = DKV.get((Key)key);
        if (v == null) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Iced ice = v.get();
        if (!(ice instanceof AutoML)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, (Object)key.toString(), AutoML.class, ice.getClass());
        }
        return (AutoML)ice;
    }

    public static final class AutoMLs
    extends Iced {
        public AutoML[] auto_ml_runs;

        public static AutoML[] fetchAll() {
            Key[] autoMLKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

                public boolean filter(KeySnapshot.KeyInfo k) {
                    return Value.isSubclassOf((int)k._type, AutoML.class);
                }
            }).keys();
            AutoML[] autoMLs = new AutoML[autoMLKeys.length];
            for (int i = 0; i < autoMLKeys.length; ++i) {
                AutoML autoML;
                autoMLs[i] = autoML = AutoMLHandler.getFromDKV("(none)", autoMLKeys[i]);
            }
            return autoMLs;
        }
    }
}

