/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.colmeta;

import hex.tree.DHistogram;
import java.util.HashMap;
import water.Iced;
import water.fvec.Vec;

public class ColMeta
extends Iced {
    public static final String[] METAVALUES = new String[]{"idFrame", "ColumnName", "ColumnType", "Min", "Max", "Mean", "Median", "Variance", "Cardinality", "Kurtosis", "Skew", "VIF", "FractionNA", "TimeToMRTaskMillis"};
    private static transient String[] _guessers;
    public final Vec _v;
    public byte _nameType;
    public final String _name;
    public final int _idx;
    public boolean _ignored;
    public boolean _response;
    public double _percentNA;
    public double _variance;
    public double _sigma;
    public boolean _stratify;
    public double[] _dist;
    public double[] _weightMult;
    public boolean _isNumeric;
    public boolean _isCategorical;
    public static final double SQLNAN = -99999.0;
    public boolean _isClass;
    public DHistogram _histo;
    public long _MRTaskMillis;
    public double _thirdMoment;
    public double _fourthMoment;
    public double _kurtosis;
    public double _skew;
    public int _cardinality;
    public double _vif;
    public long _numUniques;
    public double _avgUniquesPerChunk;
    public boolean _chunksMonotonicallyIncreasing;
    public double[] _chunkBoundaries;
    public double _median;
    public boolean _isRowBasedId;
    public boolean _isNonIidId;
    public boolean _isDate;

    public boolean isClassification() {
        if (this._response) {
            return this._isClass;
        }
        throw new IllegalArgumentException("Cannot ask non-response metadata if problem is classification");
    }

    public ColMeta(Vec v, String colname, int idx, boolean response, boolean ignored) {
        this._v = v;
        this._name = colname;
        this._ignored = ignored;
        this._idx = idx;
        this._response = response;
        this._percentNA = (double)v.naCnt() / (double)v.length();
        this._sigma = v.sigma();
        this._variance = this._sigma * this._sigma;
        this._vif = -1.0;
        this._isNumeric = v.isNumeric() && !ignored && !response;
        this._isCategorical = v.isCategorical() && !ignored && !response;
    }

    public ColMeta(Vec v, String colname, int idx, boolean response) {
        this(v, colname, idx, response, false);
    }

    public static HashMap<String, Object> makeEmptyColMeta() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        for (String key : METAVALUES) {
            hm.put(key, null);
        }
        return hm;
    }

    public String selectBasicTransform() {
        if (this._ignored) {
            return "ignored";
        }
        if (this._v.isBinary()) {
            return "none";
        }
        if (this._v.isTime() || this._isDate) {
            return "time";
        }
        if (this._v.max() - this._v.min() > 10000.0) {
            return "log";
        }
        if (this._v.isNumeric() && !this._v.isInt()) {
            return "recip";
        }
        return "none";
    }

    public void fillColMeta(HashMap<String, Object> cm, int idFrame) {
        cm.put("idFrame", idFrame);
        cm.put("ColumnName", this._name);
        cm.put("ColumnType", this._v.get_type_str());
        if (!this._v.isNumeric()) {
            cm.put("Min", -99999.0);
            cm.put("Max", -99999.0);
            cm.put("Mean", -99999.0);
            cm.put("Median", -99999.0);
            cm.put("Variance", -99999.0);
            cm.put("Cardinality", this._v.cardinality());
            cm.put("Kurtosis", -99999.0);
            cm.put("Skew", -99999.0);
            cm.put("VIF", -99999.0);
        } else {
            cm.put("Min", this._v.min());
            cm.put("Max", this._v.max());
            cm.put("Mean", this._v.mean());
            cm.put("Median", this._v.pctiles()[8]);
            cm.put("Variance", this._v.sigma() * this._v.sigma());
            cm.put("Cardinality", -99999.0);
            cm.put("Kurtosis", this._kurtosis);
            cm.put("Skew", this._skew);
            cm.put("VIF", this._vif);
        }
        cm.put("FractionNA", (double)this._v.naCnt() / (double)this._v.length());
        cm.put("TimeToMRTaskMillis", this._MRTaskMillis);
    }
}

