/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import hex.ScoreKeeper;
import hex.grid.HyperSpaceSearchCriteria;
import hex.schemas.GridSearchSchema;
import water.Iced;
import water.Key;
import water.api.schemas3.ImportFilesV3;
import water.api.schemas3.JobV3;
import water.fvec.Frame;
import water.parser.ParseSetup;

public class AutoMLBuildSpec
extends Iced {
    public AutoMLBuildControl build_control;
    public AutoMLInput input_spec = new AutoMLInput();
    public AutoMLFeatureEngineering feature_engineering;
    public AutoMLBuildModels build_models;
    public AutoMLEnsembleParameters ensemble_parameters;
    public JobV3 job;
    private transient String project_cached = null;

    public AutoMLBuildSpec() {
        this.build_control = new AutoMLBuildControl();
        this.feature_engineering = new AutoMLFeatureEngineering();
        this.build_models = new AutoMLBuildModels();
        this.ensemble_parameters = new AutoMLEnsembleParameters();
    }

    public String project() {
        if (null != this.project_cached) {
            return this.project_cached;
        }
        if (null != this.build_control.project_name) {
            this.project_cached = this.build_control.project_name;
            return this.project_cached;
        }
        String specified = this.input_spec.training_path != null ? this.input_spec.training_path.path : this.input_spec.training_frame.toString();
        String[] path = specified.split("/");
        this.project_cached = path[path.length - 1].replace(".hex", "").replace(".CSV", "").replace(".ZIP", "").replace(".GZ", "").replace(".TXT", "").replace(".XLS", "").replace(".XSLX", "").replace(".SVM", "").replace(".SVMLight", "").replace(".ORC", "").replace(".ARFF", "").replace(".csv", "").replace(".zip", "").replace(".gz", "").replace(".txt", "").replace(".xls", "").replace(".xslx", "").replace(".svmlight", "").replace(".svm", "").replace(".orc", "").replace(".arff", "");
        this.project_cached = "automl_" + this.project_cached;
        return this.project_cached;
    }

    public static final class AutoMLEnsembleParameters
    extends Iced {
    }

    public static final class AutoMLBuildModels
    extends Iced {
        public AutoML.algo[] exclude_algos;
        public GridSearchSchema[] model_searches;
    }

    public static final class AutoMLFeatureEngineering
    extends Iced {
        public boolean try_mutations = false;
    }

    public static final class AutoMLInput
    extends Iced {
        public ImportFilesV3.ImportFiles training_path;
        public ImportFilesV3.ImportFiles validation_path;
        public ImportFilesV3.ImportFiles leaderboard_path;
        public ParseSetup parse_setup;
        public Key<Frame> training_frame;
        public Key<Frame> validation_frame;
        public Key<Frame> leaderboard_frame;
        public String response_column;
        public String fold_column;
        public String weights_column;
        public String[] ignored_columns;
    }

    public static final class AutoMLBuildControl
    extends Iced {
        public String project_name = null;
        public String loss = "AUTO";
        public HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria stopping_criteria = new HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria();
        public int nfolds = 5;

        public AutoMLBuildControl() {
            this.stopping_criteria.set_max_runtime_secs(3600.0);
            this.stopping_criteria.set_stopping_rounds(3);
            this.stopping_criteria.set_stopping_tolerance(0.001);
            this.stopping_criteria.set_stopping_metric(ScoreKeeper.StoppingMetric.AUTO);
        }
    }
}

